/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.gui.components;

import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import se.ericsson.cello.emt.moproperties.MoPropLog;

public abstract class OE_Attr_TextArea
extends JTextArea {
    private static final long serialVersionUID = 5893707823067915912L;
    protected boolean initiated = false;
    private Border loweredbevel = BorderFactory.createLoweredBevelBorder();

    protected abstract boolean verifyInput(String var1);

    public OE_Attr_TextArea() {
        this.setLineWrap(true);
        this.initiated = false;
        this.setBorder(this.loweredbevel);
    }

    public OE_Attr_TextArea(String s) {
        super(s);
        this.setLineWrap(true);
        this.initiated = true;
        this.setBorder(this.loweredbevel);
    }

    public OE_Attr_TextArea(String s, int len) {
        super(s, 0, len);
        this.setLineWrap(true);
        this.initiated = true;
        this.setBorder(this.loweredbevel);
    }

    public void setText(String s) {
        super.setText(s);
        this.initiated = true;
    }

    protected Document createDefaultModel() {
        return new OE_Document();
    }

    protected class OE_Document
    extends PlainDocument {
        private static final long serialVersionUID = -310324775882092374L;

        protected OE_Document() {
        }

        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String current = this.getText(0, this.getLength());
            String beforeOffs = current.substring(0, offs);
            String afterOffs = current.substring(offs, current.length());
            if (!OE_Attr_TextArea.this.initiated || OE_Attr_TextArea.this.verifyInput(beforeOffs + str + afterOffs)) {
                try {
                    super.insertString(offs, str, a);
                }
                catch (Exception e) {
                    MoPropLog.logger().fine("Bad string value:" + str + " " + e);
                }
            }
        }

        public void remove(int offs, int len) throws BadLocationException {
            String current = this.getText(0, this.getLength());
            String beforeOffs = current.substring(0, offs);
            String afterOffs = current.substring(len + offs, current.length());
            if (!OE_Attr_TextArea.this.initiated || OE_Attr_TextArea.this.verifyInput(beforeOffs + afterOffs)) {
                super.remove(offs, len);
            }
        }
    }
}

