/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.gui.components;

import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.AccessControlException;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import se.ericsson.cello.emt.moti.LdnSelectionListener;
import se.ericsson.cello.emt.moti.LdnSelector;
import se.ericsson.cello.emt.motools.common.gui.components.DataTypeGUI;
import se.ericsson.cello.emt.motools.common.gui.components.GUI_Container;
import se.ericsson.cello.emt.motools.common.gui.components.LdnProvider;
import se.ericsson.cello.emt.motools.common.gui.components.OE_Attr_TextField;
import se.ericsson.cello.emt.motools.common.gui.components.PopupGotoGui;
import se.ericsson.cello.emt.motools.common.gui.components.StringGUIDocumentListener;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.ClassTypeValue;
import se.ericsson.cello.emt.motools.common.toolservices.StartFailureException;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;
import se.ericsson.cello.emt.utils.guihelper.MessageDialogFactory;
import se.ericsson.cello.neal.cm.Mo;

public class ObjectRefGUI
extends DataTypeGUI
implements LdnProvider {
    private static final long serialVersionUID = 1820920266041029999L;
    private RefTextField valueT = null;
    private String status = null;
    private JLabel statusL = null;
    private JPanel panel1;
    private JPopupMenu popup = null;
    private JMenuItem pasteItem = null;
    private JButton gotoBtn = new JButton("Go to");
    private JPanel gotoPanel = null;
    private JButton searchBtn = new JButton("Search");
    private String initialValue;
    private LdnSelector myMoSearchLdnSelector = null;
    private ClassTypeValue myClassTypeValue = null;
    private boolean readOnly = true;
    private String myTargetClass = null;
    private ActionListener searchActionListener = new ActionListener(){

        public void actionPerformed(ActionEvent e) {
            String strClass = ObjectRefGUI.this.myClassTypeValue.getMomClass().getName();
            if (strClass.equals("ManagedObject")) {
                String theLdn = ObjectRefGUI.this.valueT.getText();
                Mo theLdnAsMo = ObjectRefGUI.this.myClassTypeValue.getCmServices().getMo(theLdn);
                strClass = theLdnAsMo.exists() ? theLdnAsMo.getType() : null;
            }
            try {
                ObjectRefGUI.this.myMoSearchLdnSelector = ObjectRefGUI.this.myToolServices.startMoSearchTool(ObjectRefGUI.this.myClassTypeValue.getCmServices().getRootMo().getLdn(), strClass);
                ObjectRefGUI.this.myMoSearchLdnSelector.setLdnSelectionListener(new ObjRefLdnSelectionListener());
            }
            catch (StartFailureException e1) {
                MessageDialogFactory.createMessageDialog((String)"Failed to start Search tool.", (Exception)e1, (boolean)false, null).setVisible(true);
            }
        }
    };
    private boolean enableGotoButton = true;

    public ObjectRefGUI(ClassTypeValue aClassTypeValue, boolean isReadOnly, GUI_Container container, boolean supportNullValue, ToolServices aToolServices) {
        super(aClassTypeValue, container, aToolServices);
        boolean noGoTo;
        this.fullName = aClassTypeValue.getName();
        this.myClassTypeValue = aClassTypeValue;
        this.readOnly = isReadOnly;
        this.panel1 = this.getPanel();
        this.panel1.setOpaque(false);
        this.panel1.setName(aClassTypeValue.getName() + "_Value");
        String value = null;
        if (this.myClassTypeValue.isValueDefined()) {
            value = aClassTypeValue.getValueAsString();
        } else {
            value = "";
            this.status = "Value is not defined";
        }
        this.myTargetClass = this.myClassTypeValue.getMomClass().getName();
        if (this.myTargetClass == null) {
            this.myTargetClass = "Not Specified";
        }
        this.valueT = new RefTextField(value, this.myTargetClass, this.readOnly);
        this.valueT.getDocument().addDocumentListener(new StringGUIDocumentListener(this));
        this.valueT.setName("valueField");
        this.panel1.add(this.valueT);
        if (!supportNullValue && !this.myClassTypeValue.isValueDefined()) {
            this.statusL = new JLabel(this.status);
            this.panel1.add(this.statusL);
        }
        this.gotoPanel = this.buildGotoPanelGui();
        if (value.length() == 0) {
            this.gotoBtn.setEnabled(false);
        }
        if (noGoTo = false) {
            this.gotoBtn.setVisible(false);
        }
        if (this.readOnly) {
            this.searchBtn.setVisible(false);
        }
        this.panel1.add(this.gotoPanel);
        JPanel containerPanel = new JPanel(new FlowLayout(0, 5, 0));
        this.searchBtn.setToolTipText("Search MO(s)");
        containerPanel.add(this.searchBtn);
        this.panel1.add(containerPanel);
        this.searchBtn.addActionListener(this.searchActionListener);
        this.popup = new JPopupMenu();
        this.pasteItem = new JMenuItem("Paste DN");
        this.pasteItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Clipboard cb = ObjectRefGUI.this.getClipboard();
                Transferable content = cb.getContents(this);
                try {
                    String s = (String)content.getTransferData(DataFlavor.stringFlavor);
                    ObjectRefGUI.this.valueT.setText(s);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        });
        this.pasteItem.setEnabled(!this.readOnly);
        this.popup.add(this.pasteItem);
    }

    public void enableValueField(boolean enabled) {
        this.valueT.setVisible(enabled);
    }

    public void enableGotoButton(boolean enabled) {
        this.enableGotoButton = enabled;
        this.gotoBtn.setVisible(this.enableGotoButton);
    }

    public String getValue() {
        return this.valueT.getText();
    }

    public void setModified(boolean changed) {
        super.setModified(changed);
        if (this.container != null) {
            this.container.updateNeeded();
        }
        if (this.getValue() == null || this.getValue().length() == 0) {
            this.gotoBtn.setEnabled(false);
        } else {
            this.gotoBtn.setEnabled(true);
        }
    }

    public void setValue(String value) {
        this.valueT.setValue(value);
        this.valueT.invalidate();
    }

    public void setGUIEditable(boolean editable) {
        this.valueT.setEditable(editable);
        if (editable) {
            this.valueT.setOpaque(true);
        } else {
            this.valueT.setOpaque(false);
        }
    }

    public void setLDNforReference(String LDN) {
        this.setValue(LDN);
        this.setModified(true);
    }

    public Clipboard getClipboard() {
        Clipboard myClipboard = null;
        try {
            myClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        }
        catch (AccessControlException sex) {
            try {
                myClipboard = new Clipboard("MoPropToolClipboard");
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        return myClipboard;
    }

    private JPanel buildGotoPanelGui() {
        JPanel containerPanel = new JPanel(new FlowLayout(0, 5, 0));
        PopupGotoGui myPopupGotoGui = new PopupGotoGui(this, this.myToolServices);
        this.gotoBtn = myPopupGotoGui.getGotoB();
        containerPanel.add(this.gotoBtn);
        return containerPanel;
    }

    public String getLdn() {
        String ldn = "";
        if (this.valueT != null) {
            ldn = this.valueT.getText();
        }
        return ldn;
    }

    class RefTextField
    extends OE_Attr_TextField {
        private static final long serialVersionUID = -7869270474139557439L;
        private final int MIN_WIDTH_RO = 80;
        private final int MIN_WIDTH_RW = 150;
        private String targetClass;

        RefTextField(String value, String targetCls, boolean readOnly) {
            super(value);
            this.MIN_WIDTH_RO = 80;
            this.MIN_WIDTH_RW = 150;
            this.targetClass = "";
            this.setFont(ObjectRefGUI.this.getGUIFont());
            ObjectRefGUI.this.initialValue = value;
            this.targetClass = targetCls;
            this.setEditable(!readOnly);
            if (readOnly) {
                this.setOpaque(false);
                this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 1));
                if (value.length() > 0) {
                    this.setToolTipText(value);
                }
            } else {
                this.setOpaque(true);
                this.setToolTipText("Object Reference as LDN: Class=" + this.targetClass);
            }
        }

        public Dimension getPreferredSize() {
            FontMetrics fm = this.getFontMetrics(this.getFont());
            int width = fm.stringWidth(this.getText()) + 2 * fm.getMaxAdvance();
            width = this.isEditable() ? Math.max(width, 150) : Math.max(width, 80);
            return new Dimension(width, super.getPreferredSize().height);
        }

        public String getTargetClass() {
            return this.targetClass;
        }

        public void setValue(String value) {
            this.setText(value);
            ObjectRefGUI.this.initialValue = value;
            ObjectRefGUI.this.setModified(false);
        }

        public boolean verifyInput(String attemptedValue) {
            boolean accept = true;
            if (attemptedValue.equals(ObjectRefGUI.this.initialValue)) {
                // empty if block
            }
            this.invalidate();
            this.requestFocus();
            return accept;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ObjRefLdnSelectionListener
    implements LdnSelectionListener {
        private ObjRefLdnSelectionListener() {
        }

        @Override
        public void ldnSelected(List<String> ldns) {
            if (ldns == null || ldns.size() == 0) {
                return;
            }
            String ldn = ldns.get(0);
            if (ldn != null) {
                ObjectRefGUI.this.valueT.setText(ldn);
            }
        }
    }
}

