/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.gui.components;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import se.ericsson.cello.emt.motools.common.gui.components.DataTypeGUI;
import se.ericsson.cello.emt.motools.common.gui.components.GUI_Container;
import se.ericsson.cello.emt.motools.common.gui.components.OE_Attr_TextArea;
import se.ericsson.cello.emt.motools.common.gui.components.OE_Attr_TextField;
import se.ericsson.cello.emt.motools.common.gui.components.StringGUIDocumentListener;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.StringTypeValue;
import se.ericsson.cello.emt.motools.common.toolservices.ToolServices;

public class StringGUI
extends DataTypeGUI {
    private static final long serialVersionUID = -4437237320268672982L;
    private JTextComponent valueT = null;
    private JPanel panel;
    private int maxLength;
    private int minLength;
    private boolean isValidInput = true;
    private String toolTip = null;
    private boolean readOnly = true;
    private StringTypeValue myStringTypeValue = null;
    private JTextField hiddenTextField = null;

    public StringGUI(StringTypeValue aStringTypeValue, boolean isReadOnly, GUI_Container container, boolean supportNullValue, ToolServices aToolServices) {
        super(aStringTypeValue, container, aToolServices);
        this.myStringTypeValue = aStringTypeValue;
        this.panel = this.getPanel();
        this.myStringTypeValue = aStringTypeValue;
        this.readOnly = isReadOnly;
        String theMinValueAsString = this.myStringTypeValue.getMinAsStringValue();
        String theMaxValueAsString = this.myStringTypeValue.getMaxAsStringValue();
        try {
            this.minLength = Integer.parseInt(theMinValueAsString);
        }
        catch (NumberFormatException e) {
            this.minLength = 0;
        }
        try {
            this.maxLength = Integer.parseInt(theMaxValueAsString);
        }
        catch (NumberFormatException e) {
            this.maxLength = Integer.MAX_VALUE;
        }
        String theName = this.myStringTypeValue.getName();
        String value = "";
        if (aStringTypeValue.isValueDefined()) {
            value = this.myStringTypeValue.getValueAsString();
        }
        if (theName != null && theName.toLowerCase().indexOf("password") != -1) {
            this.valueT = new JPasswordField(value, 10);
            if (this.toolTip == null) {
                String toolTipType = "Password";
                this.valueT.setToolTipText(toolTipType + ": Min length=" + this.minLength + ", Max length=" + this.maxLength);
                this.valueT.setEditable(!this.readOnly);
                if (this.readOnly) {
                    this.valueT.setOpaque(false);
                } else {
                    this.valueT.setOpaque(true);
                }
            } else {
                this.valueT.setToolTipText(this.toolTip);
            }
        } else {
            this.valueT = this.readOnly ? new SmartTextArea(value, this.readOnly, this.toolTip) : new SmartTextField(value, this.readOnly, this.toolTip);
        }
        this.valueT.getDocument().addDocumentListener(new StringGUIDocumentListener(this));
        this.valueT.setName("valueField");
        this.panel.add(this.valueT);
        if (!supportNullValue && !aStringTypeValue.isValueDefined()) {
            JLabel statusL = new JLabel("Value is not defined");
            this.panel.add(statusL);
        }
        this.hiddenTextField = new JTextField();
    }

    public String getValue() {
        String result = this.valueT.getText();
        if (result != null) {
            result = result.trim();
        }
        return result;
    }

    public void setModified(boolean value) {
        super.setModified(value);
        if (this.container != null) {
            this.container.updateNeeded();
        }
    }

    public void setValue(String value) {
        if (this.valueT.getClass().getName().equals("oe.client.ui.components.StringGUI.SmartTextField")) {
            ((SmartTextArea)this.valueT).setValue(value);
        } else {
            this.valueT.setText(value);
        }
        this.valueT.invalidate();
        this.setModified(false);
    }

    public void setGUIEditable(boolean editable) {
        this.valueT.setEditable(editable);
        if (editable) {
            this.valueT.setOpaque(true);
        } else {
            this.valueT.setOpaque(false);
        }
    }

    public boolean faultyValueEntered() {
        return !this.isValidInput;
    }

    public StringTypeValue getStringTypeValue() {
        return this.myStringTypeValue;
    }

    class SmartTextArea
    extends OE_Attr_TextArea {
        private static final long serialVersionUID = -7922582143138084170L;
        private final int MAX_WIDTH = 500;
        private final int MIN_WIDTH_RO = 150;
        private final int MIN_WIDTH_RW = 150;
        Color errorColor;
        Color errorForegroundColor;

        SmartTextArea(String value, boolean readOnly, String toolTip) {
            super(value);
            this.MAX_WIDTH = 500;
            this.MIN_WIDTH_RO = 150;
            this.MIN_WIDTH_RW = 150;
            this.errorColor = new Color(255, 200, 200);
            this.errorForegroundColor = new Color(204, 0, 0);
            this.setFont(StringGUI.this.getGUIFont());
            this.setBorder(BorderFactory.createEmptyBorder(2, 1, 2, 1));
            this.setEditable(!readOnly);
            if (readOnly) {
                this.setOpaque(false);
            } else {
                this.setOpaque(true);
            }
            if (toolTip == null) {
                String toolTipType = StringGUI.this.getTypeCode();
                if (StringGUI.this.minLength == Integer.MIN_VALUE) {
                    StringGUI.this.minLength = 0;
                }
                if (StringGUI.this.maxLength != Integer.MAX_VALUE || StringGUI.this.minLength != 0) {
                    String max_length = "," + StringGUI.this.maxLength;
                    if (StringGUI.this.maxLength == Integer.MAX_VALUE) {
                        max_length = "";
                    }
                    if (StringGUI.this.minLength == StringGUI.this.maxLength) {
                        this.setToolTipText(toolTipType + ": [" + StringGUI.this.minLength + "]");
                    } else {
                        this.setToolTipText(toolTipType + ": [" + StringGUI.this.minLength + ",..." + max_length + "]");
                    }
                } else {
                    this.setToolTipText(toolTipType);
                }
            } else {
                this.setToolTipText(toolTip);
            }
        }

        public Dimension getPreferredSize() {
            FontMetrics fm = this.getFontMetrics(StringGUI.this.getGUIFont());
            int width = fm.stringWidth(this.getText()) + 2 * fm.getMaxAdvance();
            width = this.isEditable() ? Math.max(width, 150) : Math.max(width, 150);
            width = Math.min(width, 500);
            return new Dimension(width, super.getPreferredSize().height);
        }

        public void setValue(String value) {
            this.setText(value);
            StringGUI.this.setModified(false);
        }

        public boolean verifyInput(String attemptedValue) {
            boolean okValue = true;
            okValue = attemptedValue.length() >= StringGUI.this.minLength && attemptedValue.length() <= StringGUI.this.maxLength;
            this.setOpaque(true);
            if (okValue) {
                this.setForeground(StringGUI.this.hiddenTextField.getForeground());
            } else {
                this.setForeground(this.errorForegroundColor);
            }
            this.invalidate();
            StringGUI.this.isValidInput = okValue;
            this.requestFocus();
            return true;
        }
    }

    class SmartTextField
    extends OE_Attr_TextField {
        private static final long serialVersionUID = 4478109693826607698L;
        private final int MAX_WIDTH = 500;
        private final int MIN_WIDTH_RO = 250;
        private final int MIN_WIDTH_RW = 250;
        Color errorColor;
        Color errorForegroundColor;

        SmartTextField(String value, boolean readOnly, String toolTip) {
            super(value);
            this.MAX_WIDTH = 500;
            this.MIN_WIDTH_RO = 250;
            this.MIN_WIDTH_RW = 250;
            this.errorColor = new Color(255, 200, 200);
            this.errorForegroundColor = new Color(204, 0, 0);
            this.setFont(StringGUI.this.getGUIFont());
            this.setEditable(!readOnly);
            if (readOnly) {
                this.setOpaque(false);
            } else {
                this.setOpaque(true);
            }
            if (toolTip == null) {
                String toolTipType = StringGUI.this.getTypeCode();
                if (StringGUI.this.minLength == Integer.MIN_VALUE) {
                    StringGUI.this.minLength = 0;
                }
                if (StringGUI.this.maxLength != Integer.MAX_VALUE || StringGUI.this.minLength != 0) {
                    String max_length = "," + StringGUI.this.maxLength;
                    if (StringGUI.this.maxLength == Integer.MAX_VALUE) {
                        max_length = "";
                    }
                    if (StringGUI.this.minLength == StringGUI.this.maxLength) {
                        this.setToolTipText(toolTipType + ": [" + StringGUI.this.minLength + "]");
                    } else {
                        this.setToolTipText(toolTipType + ": [" + StringGUI.this.minLength + ",..." + max_length + "]");
                    }
                } else {
                    this.setToolTipText(toolTipType);
                }
            } else {
                this.setToolTipText(toolTip);
            }
        }

        public Dimension getPreferredSize() {
            FontMetrics fm = this.getFontMetrics(StringGUI.this.getGUIFont());
            int width = fm.stringWidth(this.getText()) + 2 * fm.getMaxAdvance();
            width = this.isEditable() ? Math.max(width, 250) : Math.max(width, 250);
            width = Math.min(width, 500);
            return new Dimension(width, super.getPreferredSize().height);
        }

        public void setValue(String value) {
            this.setText(value);
            StringGUI.this.setModified(false);
        }

        public boolean verifyInput(String attemptedValue) {
            boolean okValue = true;
            okValue = attemptedValue.length() >= StringGUI.this.minLength && attemptedValue.length() <= StringGUI.this.maxLength;
            this.setOpaque(true);
            if (okValue) {
                this.setForeground(StringGUI.this.hiddenTextField.getForeground());
            } else {
                this.setForeground(this.errorForegroundColor);
            }
            this.invalidate();
            StringGUI.this.isValidInput = okValue;
            this.requestFocus();
            return true;
        }
    }
}

