/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.emt.motools.common.momodel;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import se.ericsson.cello.emt.moproperties.MoPropLog;
import se.ericsson.cello.emt.motools.common.momodel.ActionModel;
import se.ericsson.cello.emt.motools.common.momodel.ParameterModel;
import se.ericsson.cello.emt.motools.common.momodel.ParameterModelImpl;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValue;
import se.ericsson.cello.emt.motools.common.momodel.typevalue.TypeValueFactory;
import se.ericsson.cello.mimparser.MoRef;
import se.ericsson.cello.mimparser.MomAction;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.cello.mimparser.MomCorbaTypeAttribute;
import se.ericsson.cello.mimparser.MomEntity;
import se.ericsson.cello.mimparser.MomEnumRef;
import se.ericsson.cello.mimparser.MomParameter;
import se.ericsson.cello.mimparser.MomSequence;
import se.ericsson.cello.mimparser.MomStruct;
import se.ericsson.cello.mimparser.MomStructRef;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.NameValueFactory;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.cello.neal.cm.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActionModelImpl
implements ActionModel {
    protected MomAction myMomAction = null;
    protected List<ParameterModel> myParameterModelList = null;
    protected Mo myMo = null;
    private static final int TRANSACTION_TIME = 3600000;

    public ActionModelImpl(MomAction aMomAction, Mo actionOwningMo) {
        this.myMomAction = aMomAction;
        this.myMo = actionOwningMo;
        if (this.myMomAction == null) {
            throw new RuntimeException("myMomAction is null, this obj has no reason to live.");
        }
        if (this.myMo == null) {
            throw new RuntimeException("myMo is null, this obj has no reason to live.");
        }
        this.myParameterModelList = this.getParameterModels();
        if (this.myParameterModelList == null) {
            throw new RuntimeException("myParameterModelList is null, this obj has no reason to live.");
        }
    }

    @Override
    public TypeValue execute() {
        MoPropLog.logger().log(Level.INFO, "Action name()=" + this.getName());
        NameValue[] parametersAsNvArray = null;
        if (this.myParameterModelList.size() > 0) {
            parametersAsNvArray = new NameValue[this.myParameterModelList.size()];
            for (int i = 0; i < parametersAsNvArray.length; ++i) {
                NameValue nameValeInSideParam = this.myParameterModelList.get(i).getTypeValue().getNameValue();
                if (nameValeInSideParam == null) {
                    throw new RuntimeException("Execute action error: The value of parameter '" + this.myParameterModelList.get(i).getName() + "' is not set.");
                }
                parametersAsNvArray[i] = nameValeInSideParam;
            }
        }
        Value resultValue = null;
        Transaction tx = this.myMo.getNode().getCmService().createTransaction(3600000);
        try {
            MoPropLog.logger().log(Level.INFO, "before myMo.action(...)");
            resultValue = this.myMo.action(this.getName(), parametersAsNvArray, tx);
            MoPropLog.logger().log(Level.INFO, "after myMo.action(...)");
            tx.commit();
        }
        catch (Exception e) {
            MoPropLog.logger().log(Level.SEVERE, "Executing the action '" + this.getName() + "' failed. An exception is thrown. e" + e.getMessage());
            try {
                tx.rollback();
            }
            catch (CmException cmEx) {
                MoPropLog.logger().log(Level.INFO, " not possible to perform transaction rollback");
            }
            throw new RuntimeException(e);
        }
        if (resultValue == null || resultValue.getType() == 0) {
            return null;
        }
        MomEntity returnMomEntity = this.myMomAction.getReturnType();
        if (returnMomEntity == null) {
            return null;
        }
        NameValue returnTypeAsNameValue = this.convertValueToNameValue(resultValue, returnMomEntity);
        TypeValue newTypeValue = TypeValueFactory.createTypeValue(returnMomEntity, returnTypeAsNameValue, this.myMo.getNode().getCmService());
        return newTypeValue;
    }

    @Override
    public MomAction getMomAction() {
        return this.myMomAction;
    }

    @Override
    public String getName() {
        return this.myMomAction.getName();
    }

    @Override
    public boolean isVoidAction() {
        MomEntity resultValueMomEntity = this.getMomAction().getReturnType();
        return resultValueMomEntity == null;
    }

    @Override
    public String getDescription() {
        return this.myMomAction.getDescription();
    }

    @Override
    public int getNumberOfParameters() {
        return this.myParameterModelList.size();
    }

    @Override
    public ParameterModel getParameterModelAt(int n) {
        return this.myParameterModelList.get(n);
    }

    @Override
    public List<ParameterModel> getParameterModels() {
        if (this.myParameterModelList != null) {
            return this.myParameterModelList;
        }
        this.myParameterModelList = new LinkedList<ParameterModel>();
        Iterator momParamIter = this.myMomAction.getParameters();
        if (momParamIter == null) {
            return this.myParameterModelList;
        }
        while (momParamIter.hasNext()) {
            MomParameter currentMomParam = (MomParameter)momParamIter.next();
            String directionKind = currentMomParam.getKind();
            if (directionKind == null || !directionKind.equalsIgnoreCase("in") && !directionKind.equalsIgnoreCase("inout")) continue;
            TypeValue newTypeValue = TypeValueFactory.createTypeValue((MomEntity)currentMomParam, null, this.myMo.getNode().getCmService());
            ParameterModelImpl newParameterModel = new ParameterModelImpl(currentMomParam, newTypeValue);
            this.myParameterModelList.add(newParameterModel);
        }
        return this.myParameterModelList;
    }

    private NameValue convertValueToNameValue(Value aValue, MomEntity valueMomEnity) {
        MoPropLog.logger().fine("valueMomEntity:" + valueMomEnity);
        MoPropLog.logger().fine("aValue:" + aValue);
        NameValue resultNameValue = null;
        NameValueFactory nvf = this.myMo.getNode().getCmService().getNameValueFactory();
        if (valueMomEnity instanceof MomEnumRef) {
            resultNameValue = nvf.create("dummy name", aValue.getIntValue());
        } else {
            if (valueMomEnity instanceof MomSequence) {
                return this.convertSequenceValueToNameValue(aValue, ((MomSequence)valueMomEnity).getType());
            }
            if (valueMomEnity instanceof MomStruct) {
                resultNameValue = nvf.create("dummy name", aValue.getStructValue());
            } else if (valueMomEnity instanceof MomClass) {
                resultNameValue = nvf.create("dummy name", aValue.getMoValue());
            } else if (valueMomEnity instanceof MomCorbaTypeAttribute) {
                MomCorbaTypeAttribute aMomCorbaTypeAttribute = (MomCorbaTypeAttribute)valueMomEnity;
                if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("string") || aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("wstring")) {
                    resultNameValue = nvf.create("dummy name", aValue.getStringValue());
                } else if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("long")) {
                    resultNameValue = nvf.create("dummy name", aValue.getIntValue());
                } else if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("longlong")) {
                    resultNameValue = nvf.create("dummy name", aValue.getLongValue());
                } else if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("float") || aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("double")) {
                    resultNameValue = nvf.create("dummy name", aValue.getFloatValue());
                } else if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("boolean")) {
                    resultNameValue = nvf.create("dummy name", aValue.getBooleanValue());
                }
            } else {
                boolean foundNewMimParserType = false;
                try {
                    if (valueMomEnity instanceof MomStructRef) {
                        resultNameValue = nvf.create("dummy name", aValue.getStructValue());
                        foundNewMimParserType = true;
                    } else if (valueMomEnity instanceof MoRef) {
                        resultNameValue = nvf.create("dummy name", aValue.getMoValue());
                        foundNewMimParserType = true;
                    }
                }
                catch (NoClassDefFoundError noClassErr) {
                    MoPropLog.logger().info("This seems to be a Mimparser that does not support MOM DTD Rev. D. The MomEntity: " + valueMomEnity);
                }
                if (!foundNewMimParserType) {
                    MoPropLog.logger().log(Level.SEVERE, "The action return type '" + valueMomEnity.getXmlType() + "' is not supported yet.");
                    throw new RuntimeException("The action return type '" + valueMomEnity.getXmlType() + "' is not supported yet.");
                }
            }
        }
        return resultNameValue;
    }

    private NameValue convertSequenceValueToNameValue(Value aElementValue, MomEntity elementValueMomEnity) {
        MoPropLog.logger().fine("elementValueMomEnity:" + elementValueMomEnity);
        MoPropLog.logger().fine("aElementValue:" + aElementValue);
        NameValue resultNameValue = null;
        NameValueFactory nvf = this.myMo.getNode().getCmService().getNameValueFactory();
        if (elementValueMomEnity instanceof MomEnumRef) {
            resultNameValue = nvf.create("element dumnmy name", aElementValue.getIntArrayValue());
        } else if (elementValueMomEnity instanceof MomStruct) {
            resultNameValue = nvf.create("element dumnmy name", aElementValue.getStructArrayValue());
        } else if (elementValueMomEnity instanceof MomClass) {
            resultNameValue = nvf.create("element dumnmy name", aElementValue.getMoArrayValue());
        } else if (elementValueMomEnity instanceof MomCorbaTypeAttribute) {
            MomCorbaTypeAttribute aMomCorbaTypeAttribute = (MomCorbaTypeAttribute)elementValueMomEnity;
            if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("string") || aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("wstring")) {
                resultNameValue = nvf.create("element dumnmy name", aElementValue.getStringArrayValue());
            } else if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("long")) {
                resultNameValue = nvf.create("element dumnmy name", aElementValue.getIntArrayValue());
            } else if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("longlong")) {
                resultNameValue = nvf.create("element dumnmy name", aElementValue.getLongArrayValue());
            } else if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("float") || aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("double")) {
                resultNameValue = nvf.create("element dumnmy name", aElementValue.getFloatArrayValue());
            } else if (aMomCorbaTypeAttribute.getXmlType().equalsIgnoreCase("boolean")) {
                resultNameValue = nvf.create("element dumnmy name", aElementValue.getBooleanArrayValue());
            }
        } else {
            boolean foundNewMimParserType = false;
            try {
                if (elementValueMomEnity instanceof MomStructRef) {
                    resultNameValue = nvf.create("element dumnmy name", aElementValue.getStructArrayValue());
                    foundNewMimParserType = true;
                } else if (elementValueMomEnity instanceof MoRef) {
                    resultNameValue = nvf.create("element dumnmy name", aElementValue.getMoArrayValue());
                    foundNewMimParserType = true;
                }
            }
            catch (NoClassDefFoundError noClassErr) {
                MoPropLog.logger().info("This seems to be a Mimparser that does not support MOM DTD Rev. D. The MomEntity: " + elementValueMomEnity);
            }
            if (!foundNewMimParserType) {
                MoPropLog.logger().log(Level.SEVERE, "The action return type Sequence, with an element type ='" + elementValueMomEnity.getXmlType() + "' is not supported.");
                throw new RuntimeException("The action return type Sequence, with an element type ='" + elementValueMomEnity.getXmlType() + "' is not supported.");
            }
        }
        return resultNameValue;
    }
}

