/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Key;
import java.util.Observable;
import java.util.jar.JarInputStream;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.ExportManager;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.MomDecrypterDefinitions;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactory;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;
import se.ericsson.wcdma.rbs.bem.common.util.GitHelper;
import sun.misc.BASE64Decoder;

public class MomDecrypter
extends Observable
implements MomDecrypterDefinitions {
    public static final BASE64Decoder decoder = new BASE64Decoder();
    public static final int NO_OF_READ_BYTES_DTD = 1024;
    public static final int NO_OF_READ_BYTES_XML = 1024;
    private static final String COMPLETEMOM_XML_TARGET = "/cello/oe/xml/RbsNodeComplete.xml.jar!/RbsNodeComplete.xml";
    private static final String COMPLETEMOM_DTD_TARGET = "/cello/oe/xml/RbsNodeComplete.xml.jar!/mp.dtd";
    private static final String COMPLETEMOM_XML_VOB = GitHelper.getGitPath() + "rbs/sw/rbsswrose/rbsnode_mom/RbsNodeComplete.xml";
    private static final String COMPLETEMOM_DTD_VOB = GitHelper.getGitPath() + "rbs/sw/rbsswrose/rbsnode_mom/mp.dtd";
    private static final String CODING_ALGHORITM = "PBEWithMD5AndDES";
    private static final String KEY_SPEC = "efMi/obrf4wtlog&D0nThaxX&mh=ERo1hjClwrSgngS0eN3{hg";
    private static final String TRANSFORMATION = "PBEWithMD5AndDES/CBC/PKCS5Padding";
    private static final byte[] SALT = new byte[]{63, -72, 125, -63, 71, -56, 50, -89};
    private static final int ITERATION_COUNT = 20;
    private static final String DTD_FILE = "mp.dtd";
    private static final String TEMP_FILE1 = "bsm1";
    private static final String TEMP_FILE2 = "bsm2";
    private static final String ERROR_TEXT = "File handling error";
    private static final String PREFIX_JAR = "jar:http://";
    private static final int TOTAL_NO_PROGRESS_REPORTS = 800;
    private Cipher decrypter;
    private ExportManager exportManager;
    private String xmlTargetPath;
    private String dtdTargetPath;
    private String xmlPath;
    private String dtdPath;

    public MomDecrypter(ExportManager exportManager) throws Exception {
        this.exportManager = exportManager;
        PBEParameterSpec pBEParameterSpec = new PBEParameterSpec(SALT, 20);
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(CODING_ALGHORITM);
        SecretKey secretKey = secretKeyFactory.generateSecret(new PBEKeySpec(KEY_SPEC.toCharArray()));
        this.decrypter = Cipher.getInstance(TRANSFORMATION);
        this.decrypter.init(2, (Key)secretKey, pBEParameterSpec);
    }

    public int getTotalNumberOfProgressReports() throws Exception {
        int n = 800;
        return n;
    }

    private void decrypt() throws Exception {
        File file = this.decryptCompleteMomFile();
        this.xmlPath = file.getAbsolutePath();
        InputStream inputStream = this.getDtdFromNode();
        byte[] byArray = new byte[1024];
        String string = file.getParent();
        File file2 = new File(string + File.separator + DTD_FILE);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        this.dtdPath = file2.getAbsolutePath();
        int n = 0;
        while ((n = inputStream.read(byArray)) >= 0) {
            fileOutputStream.write(byArray, 0, n);
        }
        fileOutputStream.close();
    }

    private File decryptCompleteMomFile() throws FileNotFoundException, IOException, Exception {
        File file = null;
        File file2 = null;
        try {
            this.exportManager.updateProgress(10);
            InputStream inputStream = this.getMomFromNode();
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            byte[] byArray = new byte[bufferedInputStream.available()];
            bufferedInputStream.read(byArray);
            bufferedInputStream.close();
            byte[] byArray2 = this.decrypter.doFinal(byArray);
            file = File.createTempFile(TEMP_FILE1, "");
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            fileOutputStream.write(byArray2);
            fileOutputStream.close();
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));
            jarInputStream.getNextEntry();
            file2 = File.createTempFile(TEMP_FILE2, "");
            file2.deleteOnExit();
            FileOutputStream fileOutputStream2 = new FileOutputStream(file2);
            PrintStream printStream = new PrintStream(fileOutputStream2);
            int n = 0;
            byte[] byArray3 = new byte[1024];
            while ((n = jarInputStream.read(byArray3)) > 0) {
                printStream.print(new String(byArray3, 0, n));
            }
            printStream.close();
            jarInputStream.close();
            return file2;
        }
        catch (Exception exception) {
            boolean bl;
            if (file != null && file.exists() && !(bl = file.delete())) {
                Nal.getLog().nalTrace(2, this.getClass(), "Failed to delete jar file " + file.getAbsolutePath());
            }
            if (file2 != null && file2.exists() && !(bl = file2.delete())) {
                Nal.getLog().nalTrace(2, this.getClass(), "Failed to delete mom file " + file2.getAbsolutePath());
            }
            throw exception;
        }
    }

    private InputStream getMomFromNode() throws MalformedURLException, IOException, ClassNotFoundException {
        URL uRL = new URL(this.xmlTargetPath);
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        return inputStream;
    }

    private InputStream getDtdFromNode() throws MalformedURLException, IOException {
        URL uRL = new URL(this.dtdTargetPath);
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        return inputStream;
    }

    public InputStream getMomFromNode(String string) throws MalformedURLException, IOException, ClassNotFoundException {
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        return inputStream;
    }

    public InputStream getDtdFromNode(String string) throws MalformedURLException, IOException {
        URL uRL = new URL(string);
        URLConnection uRLConnection = uRL.openConnection();
        InputStream inputStream = uRLConnection.getInputStream();
        return inputStream;
    }

    public void decryptCompleteMom() throws Exception {
        File file;
        this.setupPaths();
        int n = BemLanguageHelp.getEnvironment();
        if (n == 2) {
            this.decrypt();
        }
        if (!(file = new File(this.xmlPath)).exists()) {
            throw new Exception(ERROR_TEXT);
        }
        file = new File(this.dtdPath);
        if (!file.exists()) {
            throw new Exception(ERROR_TEXT);
        }
    }

    private void setupPaths() throws Exception {
        int n = BemLanguageHelp.getEnvironment();
        if (n == 2) {
            NalFactory nalFactory = Nal.getFactory();
            String string = nalFactory.getHost();
            this.xmlTargetPath = PREFIX_JAR + string + COMPLETEMOM_XML_TARGET;
            this.dtdTargetPath = PREFIX_JAR + string + COMPLETEMOM_DTD_TARGET;
        } else if (n == 1) {
            this.xmlPath = COMPLETEMOM_XML_VOB;
            this.dtdPath = COMPLETEMOM_DTD_VOB;
        }
    }

    public void removeTempFiles() {
        int n = BemLanguageHelp.getEnvironment();
        if (n == 2 && this.xmlPath != null) {
            boolean bl;
            File file = new File(this.xmlPath);
            if (file.exists() && !(bl = file.delete())) {
                Nal.getLog().nalTrace(2, this.getClass(), "Failed to delete xml file " + file.getAbsolutePath());
            }
            if ((file = new File(this.dtdPath)).exists() && !(bl = file.delete())) {
                Nal.getLog().nalTrace(2, this.getClass(), "Failed to delete dtd file " + file.getAbsolutePath());
            }
        }
    }

    public String getXmlPath() {
        return this.xmlPath;
    }

    public String getDtdPath() {
        return this.dtdPath;
    }
}

