/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.hwtest.model;

import java.util.Hashtable;
import se.ericsson.wcdma.rbs.bem.application.applications.hwtest.model.Board;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.trace.BEMTrace;

class BoardData
implements Board {
    private static Hashtable myDeviceGroups = new Hashtable();
    private static Hashtable myAuTypes;
    private static Hashtable myLogicalBoards;
    private BemMo myPiuOrAuxPiu;
    private BemMo myPiuDevice = null;
    private BemMo myDeviceGroup;
    private String myBoardName;
    private int myHwTestResult;
    private int myAdminState;
    private NalStruct myProductData;
    private String myProductNumber = null;
    private String myProductRevision = null;
    private String myPiuOrAuxType = null;
    private String mySubrackName = null;
    private String myBoardLdn = null;

    BoardData(BemMo bemMo, BemMo bemMo2, String string) throws Exception {
        this(bemMo, bemMo2, string, null);
    }

    BoardData(BemMo bemMo, BemMo bemMo2, String string, String string2) throws Exception {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardData.class, "BoardData(BemMo, BemMo, String)", bemMo, bemMo2, string);
        }
        this.myDeviceGroup = bemMo2;
        this.myPiuOrAuxPiu = bemMo;
        this.myPiuOrAuxType = bemMo.getType();
        String string3 = this.myDeviceGroup.getType();
        String string4 = this.myDeviceGroup.getId();
        String string5 = null;
        String string6 = "";
        if (this.myPiuOrAuxType.equals("PlugInUnit")) {
            BemMo bemMo3 = bemMo.getParent();
            if (bemMo3.getType().equals("Slot")) {
                this.myProductData = (NalStruct)bemMo3.getAttribute("productData");
            }
        } else {
            this.myProductNumber = (String)this.myPiuOrAuxPiu.getAttribute("productNumber");
            this.myProductRevision = (String)this.myPiuOrAuxPiu.getAttribute("productRevision");
            string6 = ((Integer)this.myPiuOrAuxPiu.getAttribute("auType")).toString();
            if (string3.equals(MimDeviceGroup.MOTYPENAME)) {
                string4 = this.myPiuOrAuxPiu.getId();
            }
        }
        string5 = myAuTypes.get(string6) != null ? (String)myAuTypes.get(string6) : (String)myDeviceGroups.get(string3);
        this.myAdminState = (Integer)bemMo.getAttribute("administrativeState");
        if (bemMo2.getParent().getType().equals("PiuDevice")) {
            this.myPiuDevice = bemMo2.getParent();
            string4 = (String)this.myPiuDevice.getAttribute("PiuDeviceId");
            string5 = (String)myLogicalBoards.get(string3);
            if (string5 != null && string5.equals("DeviceGroup")) {
                string5 = (String)this.myDeviceGroup.getAttribute("DeviceGroupId");
            }
            if (string5 != null) {
                string5 = string5 + "L-";
            }
            this.myAdminState = (Integer)this.myPiuDevice.getAttribute("administrativeState");
        }
        this.myBoardName = string2 == null ? string + string5 + string4 : string2;
        this.myHwTestResult = (Integer)bemMo2.getAttribute("hwTestResult");
        this.myBoardLdn = this.myDeviceGroup.getDN();
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardData.class, "BoardData(MOProxy, MOProxy, String)");
        }
    }

    static boolean isDeviceGroup(String string) {
        return myDeviceGroups.containsKey(string);
    }

    BemMo getPiuOrAuxPiu() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardData.class, "getPiuOrAuxPiu()");
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardData.class, "getPiuOrAuxPiu()", this.myPiuOrAuxPiu);
        }
        return this.myPiuOrAuxPiu;
    }

    BemMo getPiuDevice() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardData.class, "getPiuDevice()");
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardData.class, "getPiuDevice()", this.myPiuDevice);
        }
        return this.myPiuDevice;
    }

    BemMo getDeviceGroup() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardData.class, "getDeviceGroup()");
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardData.class, "getDeviceGroup()", this.myDeviceGroup);
        }
        return this.myDeviceGroup;
    }

    void setHwTestResult(int n) {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardData.class, "setHwTestResult(int)", n);
        }
        this.myHwTestResult = n;
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardData.class, "setHwTestResult(int)");
        }
    }

    void setAdminState(int n) {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardData.class, "setAdminState(int)", n);
        }
        this.myAdminState = n;
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardData.class, "setAdminState(int)");
        }
    }

    void setProductData(NalStruct nalStruct) {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardData.class, "setProductData(Struct)", nalStruct);
        }
        this.myProductData = nalStruct;
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardData.class, "setProductData(Struct)");
        }
    }

    void setProductData(String string, String string2) {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardData.class, "setProductData(String, String)", string, string2);
        }
        this.myProductNumber = string;
        this.myProductRevision = string2;
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardData.class, "setProductData(String, String)");
        }
    }

    public int getAdminState() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardData.class, "getAdminState()");
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardData.class, "getAdminState()", this.myAdminState);
        }
        return this.myAdminState;
    }

    public String getProductNumber() throws Exception {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardData.class, "getProductNumber()");
        }
        String string = null;
        string = this.myPiuOrAuxType.equals("PlugInUnit") ? (String)this.myProductData.getMember("productNumber").getValue() : this.myProductNumber;
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardData.class, "getProductNumber()", string);
        }
        return string;
    }

    public String getProductRev() throws Exception {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardData.class, "getProductRev()");
        }
        String string = null;
        string = this.myPiuOrAuxType.equals("PlugInUnit") ? (String)this.myProductData.getMember("productRevision").getValue() : this.myProductRevision;
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardData.class, "getProductRev()", string);
        }
        return string;
    }

    public String getBoardName() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardData.class, "getBoardName()");
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardData.class, "getBoardName()", this.myBoardName);
        }
        return this.myBoardName;
    }

    public int getHwTestResult() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardData.class, "getHwTestResult()");
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardData.class, "getHwTestResult()", this.myHwTestResult);
        }
        return this.myHwTestResult;
    }

    public String getSubrackName() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardData.class, "getSubrackName()");
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardData.class, "getSubrackName()", "mySubrackName");
        }
        return this.mySubrackName;
    }

    public String getBoardLdn() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(BoardData.class, "getBoardLdn()");
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(BoardData.class, "getBoardLdn()", "myBoardLdn");
        }
        return this.myBoardLdn;
    }

    public String toString() {
        return this.myBoardName;
    }

    static {
        myDeviceGroups.put("AiuDeviceGroup", "AIUB-");
        myDeviceGroups.put("RaxDeviceGroup", "RAXB-");
        myDeviceGroups.put("RfifDeviceGroup", "RFIFB-");
        myDeviceGroups.put("TrxDeviceGroup", "TRXB-");
        myDeviceGroups.put("TuDeviceGroup", "TUB-");
        myDeviceGroups.put("TxDeviceGroup", "TXB-");
        myDeviceGroups.put("StrxDeviceGroup", "STRXB-");
        myDeviceGroups.put("ObifDeviceGroup", "OBIFB-");
        myDeviceGroups.put("RuifDeviceGroup", "RUIFB-");
        myDeviceGroups.put("McpaDeviceGroup", "MCPA-");
        myDeviceGroups.put("RetuDeviceGroup", "");
        myDeviceGroups.put("AscDeviceGroup", "ASC-");
        myDeviceGroups.put("CuDeviceGroup", "CU-");
        myDeviceGroups.put("PcuDeviceGroup", "PCU-");
        myDeviceGroups.put("XalmDeviceGroup", "XALM-");
        myDeviceGroups.put("FanDeviceGroup", "-");
        myDeviceGroups.put("RruDeviceGroup", "");
        myDeviceGroups.put("FuDeviceGroup", "FU-");
        myDeviceGroups.put("RuDeviceGroup", "RU-");
        myDeviceGroups.put("PsuDeviceGroup", "PSU-");
        myDeviceGroups.put("BfuDeviceGroup", "BFU-");
        myDeviceGroups.put("FcuDeviceGroup", "FCU-");
        myDeviceGroups.put("CluDeviceGroup", "CLU-");
        myDeviceGroups.put("DeviceGroup", "");
        myAuTypes = new Hashtable();
        myAuTypes.put(Integer.valueOf(10).toString(), "RRU-");
        myAuTypes.put(Integer.valueOf(7).toString(), "RETU-");
        myAuTypes.put(Integer.valueOf(17).toString(), "ATMAU-");
        myAuTypes.put(Integer.valueOf(18).toString(), "ARETU-");
        myAuTypes.put(Integer.valueOf(19).toString(), "RUW-");
        myAuTypes.put(Integer.valueOf(20).toString(), "RRUW-");
        myLogicalBoards = new Hashtable();
        myLogicalBoards.put("RaxDeviceGroup", "RAX");
        myLogicalBoards.put("TxDeviceGroup", "TX");
        myLogicalBoards.put("DeviceGroup", "DeviceGroup");
    }
}

