/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.convert.Converter;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.data.Attribute;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.filter.AttributeFilter;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.filter.Filterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MoAttributes
implements Filterable {
    private final String moType;
    private List<Attribute> listOfAttributes;
    private final List<AttributeFilter> listOfAttributeFilters;
    private final Converter converter;
    private List<Attribute> listOfFilteredAttributes;
    private List<String> listOfFilteredAttributeNames;

    public MoAttributes(String string, Attribute attribute) {
        this.moType = string;
        this.listOfAttributes = new ArrayList<Attribute>();
        this.listOfAttributes.add(attribute);
        this.listOfAttributeFilters = new ArrayList<AttributeFilter>();
        this.converter = null;
    }

    public MoAttributes(MimModel mimModel, String string, AttributeFilter attributeFilter, Converter converter) {
        this.moType = string;
        this.listOfAttributeFilters = new ArrayList<AttributeFilter>();
        this.listOfAttributeFilters.add(attributeFilter);
        this.converter = converter;
        this.createAllAttributes(mimModel);
    }

    public MoAttributes(MimModel mimModel, String string, List<AttributeFilter> list, Converter converter) {
        this.moType = string;
        this.listOfAttributeFilters = list;
        this.converter = converter;
        this.createAllAttributes(mimModel);
    }

    public void addAttribute(Attribute attribute) {
        this.listOfAttributes.add(attribute);
    }

    public Attribute getAttribute(String string) {
        for (Attribute attribute : this.listOfAttributes) {
            if (attribute == null || !attribute.getAttributeName().equals(string)) continue;
            return attribute;
        }
        return null;
    }

    public List<Attribute> getAttributes() {
        return this.listOfAttributes;
    }

    public List<String> getFilteredAttributeNames() {
        return this.listOfFilteredAttributeNames;
    }

    public List<Attribute> getFilteredAttributes() {
        return this.listOfFilteredAttributes;
    }

    private void createAllAttributes(MimModel mimModel) {
        this.listOfAttributes = new ArrayList<Attribute>();
        MomClass momClass = mimModel.getClass(this.moType);
        Iterator iterator = momClass.getAttributes();
        while (iterator.hasNext()) {
            MomAttribute momAttribute = (MomAttribute)iterator.next();
            String string = momAttribute.getName();
            Attribute attribute = new Attribute(this.moType, string, this.listOfAttributeFilters, this.converter);
            this.listOfAttributes.add(attribute);
        }
    }

    @Override
    public Object filtrate(MimModel mimModel) {
        this.listOfFilteredAttributes = new ArrayList<Attribute>();
        this.listOfFilteredAttributeNames = new ArrayList<String>();
        for (Attribute attribute : this.listOfAttributes) {
            attribute.filtrate(mimModel);
            String string = attribute.getFilteredAttributeName();
            if (string == null) continue;
            this.listOfFilteredAttributes.add(attribute);
            this.listOfFilteredAttributeNames.add(string);
        }
        return this.listOfFilteredAttributes;
    }
}

