/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.client.clients.cli.function;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.phase.Phase;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.TransactionHelper;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.util.ExceptionUtil;

public class WizardUtil {
    public static void unInstall(Rbs rbs) throws BemException {
        rbs.checkConsistency();
        List list = rbs.getRIsToUninstall();
        int n = list.size();
        for (Phase phase : rbs.getUninstallationPhases()) {
            for (int i = 0; i < n; ++i) {
                ResourceItem resourceItem = (ResourceItem)list.get(i);
                resourceItem.uninstall(phase.getName());
            }
        }
    }

    public static void install(Rbs rbs) throws BemException {
        rbs.checkConsistency();
        ArrayList arrayList = rbs.getRIsToInstall();
        int n = arrayList.size();
        Phase[] phaseArray = rbs.getInstallationPhases();
        int n2 = phaseArray.length;
        MoHandler moHandler = rbs.getMoHandler();
        TransactionHelper transactionHelper = TransactionHelper.getInstance(moHandler);
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            Phase phase = phaseArray[i];
            String string = phase.getName();
            try {
                bl = transactionHelper.setPhase(string);
            }
            catch (MoHandlerException moHandlerException) {
                if (ExceptionUtil.isCausedByCorbaConnectionLost(moHandlerException)) {
                    bl = true;
                    Nal.getLog().nalTrace(6, WizardUtil.class, "Connection lost during commit of transaction (timing related, expected behaviour when changing nodeInterfaceName).");
                }
                throw new BemException(moHandlerException);
            }
            if (bl) continue;
            for (int j = 0; j < n; ++j) {
                ResourceItem resourceItem = (ResourceItem)arrayList.get(j);
                if ("StartUseLargeTransactionPhase".equals(string)) {
                    moHandler.setUseLargeTransactions(true);
                }
                resourceItem.install(string);
                if (!"EndUseLargeTransactionPhase".equals(string)) continue;
                moHandler.setUseLargeTransactions(false);
            }
        }
    }
}

