/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EcPortInfo;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcBus;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEcPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExternalNode;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;

public class ExternalNodeRI
extends AbstractResourceItem {
    public static final String name = "EXTERNAL_NODE";
    private static final String[] myInstallationPhases = new String[]{"ExternalNodeCreationPhase", "EcPortCreationPhase"};
    private String ldn = null;
    private String unitNumber;

    public ExternalNodeRI(Rbs rbs, String string) throws BemException {
        super(name, rbs, myInstallationPhases);
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(rbs.getEquipmentMoi(), MimExternalNode.MOTYPENAME, string);
        this.ldn = fixedRdnMoi.getLdn();
        this.unitNumber = string;
    }

    public void install(String string) throws BemException {
        CustomerParameter customerParameter;
        if (!super.containsPhase(this.getInstallationPhases(), string)) {
            return;
        }
        if (this.rbs.isParameterSupported("supportSystemControl") && this.rbs.getRbsData().isRbs6000() && (customerParameter = this.rbs.getCustomerParameterObject("supportSystemControl")).getValue().equalsIgnoreCase("TRUE")) {
            if (string.equals("ExternalNodeCreationPhase")) {
                if (this.hasEcPortsChanged()) {
                    super.createMoIfNotExisting(this.ldn);
                }
            } else if (string.equals("EcPortCreationPhase")) {
                this.installEcPort();
            }
        }
    }

    private void installEcPort() throws BemException {
        EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)this.rbs.getProvider(EcPortCustomerParameterProvider.class);
        EcPortInfo[] ecPortInfoArray = ecPortCustomerParameterProvider.getEcPortCustomerParameters("EXTNODE", this.unitNumber);
        for (int i = 0; i < ecPortInfoArray.length; ++i) {
            Object object;
            String string;
            EcPortInfo ecPortInfo = ecPortInfoArray[i];
            Enumeration enumeration = ecPortInfo.getHubPositionParameter();
            Enumeration enumeration2 = ecPortInfo.getCascadingOrderParameter();
            Enumeration enumeration3 = ecPortInfo.getPortNumberParameter();
            Enumeration enumeration4 = ecPortInfo.getReferredCabinetNumberParameter();
            if (!enumeration.hasValueChanged() && !enumeration2.hasValueChanged() && !enumeration4.hasValueChanged()) continue;
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.rbs.getEquipmentMoi(), MimExternalNode.MOTYPENAME, this.unitNumber);
            FixedRdnMoi fixedRdnMoi2 = new FixedRdnMoi(fixedRdnMoi, MimEcPort.MOTYPENAME, String.valueOf(enumeration3.getValue()));
            String string2 = fixedRdnMoi2.getLdn();
            BemMo bemMo = super.getMo(string2);
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("hubPosition", enumeration.getValueMom()));
            vector.add(Nal.getFactory().getNameValue("cascadingOrder", enumeration2.getValueMom()));
            MoInstance moInstance = this.rbs.getMoiRefs().getEquipmentMoi();
            String string3 = String.valueOf(1);
            FixedRdnMoi fixedRdnMoi3 = new FixedRdnMoi(moInstance, MimEcBus.MOTYPENAME, string3);
            if (!enumeration4.getValue().equals("##UNDEFINED")) {
                string = enumeration4.getValue();
                object = PrefixUtil.getCabinetPrefix(string);
                string3 = this.rbs.getCustomerParameter((String)object + "ecBusNumber");
            }
            if (!string3.equals("##UNDEFINED")) {
                fixedRdnMoi3 = new FixedRdnMoi(moInstance, MimEcBus.MOTYPENAME, string3);
            }
            string = fixedRdnMoi3.getLdn();
            object = this.rbs.getMoHandler().getMo(string);
            vector.add(Nal.getFactory().getNameValue("ecBusRef", object));
            if (super.isExisting(bemMo)) {
                super.setAttributes(bemMo, vector);
                continue;
            }
            super.createMoIfNotExisting(string2, vector);
        }
    }

    private boolean hasEcPortsChanged() throws BemException {
        boolean bl = false;
        EcPortCustomerParameterProvider ecPortCustomerParameterProvider = (EcPortCustomerParameterProvider)this.rbs.getProvider(EcPortCustomerParameterProvider.class);
        EcPortInfo[] ecPortInfoArray = ecPortCustomerParameterProvider.getEcPortCustomerParameters("EXTNODE", this.unitNumber);
        for (int i = 0; i < ecPortInfoArray.length; ++i) {
            EcPortInfo ecPortInfo = ecPortInfoArray[i];
            Enumeration enumeration = ecPortInfo.getHubPositionParameter();
            if (!enumeration.hasValueChanged()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public String getDisplayName() {
        return "EXTERNAL_NODE: " + this.getLdn();
    }

    public String getLdn() {
        return this.ldn;
    }
}

