/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic;

import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimGeneralProcessorUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimMediumAccessUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;

public class MediumAccessUnitRI
extends AbstractResourceItem
implements ResourceItem {
    private static final String[] myInstallationPhases = new String[]{"MediumAccessUnitCreationPhase"};
    private static String name = "MEDIUM_ACCESS_UNIT";
    private String cpUnit;
    private String parentLdn;
    private int slotPos;
    private String mediumAccessUnitLdn;

    public MediumAccessUnitRI(Rbs rbs, MoInstance moInstance, String string, int n) throws BemException {
        super(name, rbs, myInstallationPhases);
        this.cpUnit = string;
        this.slotPos = n;
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(moInstance, MimSlot.MOTYPENAME, String.valueOf(this.slotPos));
        SingleChildMoi singleChildMoi = new SingleChildMoi(fixedRdnMoi, MimPlugInUnit.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(singleChildMoi, this.cpUnit, "1");
        SingleChildMoi singleChildMoi3 = new SingleChildMoi(singleChildMoi2, MimGeneralProcessorUnit.MOTYPENAME, "1");
        SingleChildMoi singleChildMoi4 = new SingleChildMoi(singleChildMoi3, MimMediumAccessUnit.MOTYPENAME, "1");
        this.parentLdn = singleChildMoi3.getLdn();
        this.mediumAccessUnitLdn = singleChildMoi4.getLdn();
    }

    public void install(String string) throws BemException {
        try {
            if (myInstallationPhases[0].equals(string)) {
                this.createMediumAccessUnitIfNotExisting();
            }
        }
        catch (Exception exception) {
            String string2 = "install()";
            String string3 = exception.toString();
            throw new BemException(string2, "install()", name, string3, exception);
        }
    }

    private void createMediumAccessUnitIfNotExisting() throws BemException {
        boolean bl = super.isExisting(this.parentLdn);
        if (bl) {
            super.createMoIfNotExisting(this.mediumAccessUnitLdn);
        }
    }

    public boolean isInstalled() throws BemException {
        boolean bl = super.isExisting(this.mediumAccessUnitLdn);
        return bl;
    }

    public String getDisplayName() {
        return name;
    }

    public String getLdn() {
        return this.mediumAccessUnitLdn;
    }
}

