/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.CellAndCarrierCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class SectorInfo {
    private static final boolean VALUE_TRUE = true;
    private static final boolean VALUE_FALSE = false;
    private CellAndCarrierCI cellAndCarrierCi;
    public int sectorNumber;
    public int numberOfcarrierAllocated = 0;
    protected boolean sectorIsEquippedOnNode = false;
    private boolean currentSectorIsEquipped = false;
    private int currentEquippedCarriers = 0;
    protected int carrierNumberEquippedOnNode = 0;
    private boolean carrierToBeAdded = false;
    private boolean sectorToBeAdded = false;
    private boolean sectorToBeDeleted = false;
    private boolean carrierToBeDeleted;

    public SectorInfo(CellAndCarrierCI cellAndCarrierCI, int n, RadioEquipmentProvider radioEquipmentProvider) throws BemException {
        this.cellAndCarrierCi = cellAndCarrierCI;
        this.sectorNumber = n;
        this.initiateSectorEquipmentStatus(radioEquipmentProvider);
    }

    private void initiateSectorEquipmentStatus(RadioEquipmentProvider radioEquipmentProvider) throws BemException {
        int[] nArray = radioEquipmentProvider.getEquippedSectors();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != this.sectorNumber) continue;
            this.setCurrentSectorIsEquipped(true);
            this.sectorIsEquippedOnNode = this.currentSectorIsEquipped;
            this.currentEquippedCarriers = this.cellAndCarrierCi.getNumberOfCarriersInUse(this.sectorNumber);
            if (this.currentEquippedCarriers == 0) {
                this.currentEquippedCarriers = radioEquipmentProvider.getMaxNumberOfCarriers(this.sectorNumber);
            }
            this.carrierNumberEquippedOnNode = this.currentEquippedCarriers;
            break;
        }
    }

    public boolean carrierAvailable() {
        boolean bl = false;
        if (this.currentEquippedCarriers - this.numberOfcarrierAllocated > 0) {
            bl = true;
        }
        return bl;
    }

    public void setCurrentSectorIsEquipped(boolean bl) {
        this.currentSectorIsEquipped = bl;
    }

    public boolean sectorIsEquipped() {
        boolean bl = this.currentSectorIsEquipped;
        return bl;
    }

    public boolean sectorToBeAdded() {
        boolean bl = this.sectorToBeAdded;
        return bl;
    }

    public void setSectorToBeAdded(boolean bl) {
        this.sectorToBeAdded = bl;
    }

    public boolean sectorToBeDeleted() {
        boolean bl = this.sectorToBeDeleted;
        return bl;
    }

    public void setSectorToBeDeleted(boolean bl) {
        this.sectorToBeDeleted = bl;
    }

    public void updateSectorInfo(RadioEquipmentProvider radioEquipmentProvider) throws BemException {
        int n;
        int[] nArray = radioEquipmentProvider.getEquippedSectors();
        boolean bl = false;
        if (nArray != null) {
            for (n = 0; n < nArray.length; ++n) {
                if (nArray[n] != this.sectorNumber) continue;
                bl = true;
                if (this.sectorIsEquippedOnNode) continue;
                this.setCurrentSectorIsEquipped(true);
                this.setSectorToBeAdded(true);
                this.setSectorToBeDeleted(false);
                break;
            }
            if (!bl) {
                this.setCurrentSectorIsEquipped(false);
                this.setSectorToBeAdded(false);
                this.setCarrierToBeAdded(false);
                this.setEquippedCarriers(0);
            }
            if (!bl && this.sectorIsEquippedOnNode) {
                this.setSectorToBeDeleted(true);
                this.setSectorToBeAdded(false);
                this.setCurrentSectorIsEquipped(false);
            }
        }
        if (this.sectorIsEquipped()) {
            n = this.cellAndCarrierCi.getNumberOfCarriersInUse(this.sectorNumber);
            if (this.currentEquippedCarriers == 0) {
                n = radioEquipmentProvider.getMaxNumberOfCarriers(this.sectorNumber);
            }
            if (n > this.carrierNumberEquippedOnNode) {
                this.setCarrierToBeAdded(true);
                this.setCarrierToBeDeleted(false);
                this.setEquippedCarriers(n);
            } else if (n < this.carrierNumberEquippedOnNode) {
                this.setCarrierToBeDeleted(true);
                this.setCarrierToBeAdded(false);
                this.setEquippedCarriers(n);
            }
        }
    }

    private void setCarrierToBeDeleted(boolean bl) {
        this.carrierToBeDeleted = bl;
    }

    public void setCarrierToBeAdded(boolean bl) {
        this.carrierToBeAdded = bl;
    }

    public boolean carrierToBeAdded() {
        boolean bl = this.carrierToBeAdded;
        return bl;
    }

    public boolean carrierToBeDeleted() {
        boolean bl = false;
        bl = this.carrierToBeDeleted;
        return bl;
    }

    public int getEquippedCarriers() {
        int n = this.currentEquippedCarriers;
        return n;
    }

    public void setEquippedCarriers(int n) {
        this.currentEquippedCarriers = n;
    }
}

