/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.duwrbb;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.AddDuwBoardSlotCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.CellAndCarrierCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.CustomParaName;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.SectorAndCellNumber;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.SectorInfo;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam.BasebandPoolIdParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.duwrbb.SectorAndCellNumberDuwRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.resource.NodeBFunctionRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.custparam.CarrierAllocationModeConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.custparam.CarrierAllocationModeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDownlinkBaseBandPool;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceNameValue;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class CellAndCarrierDuwRbbCI
extends CellAndCarrierCI {
    public static final int MAX_NO_OF_CARRIERS_SINGLE_DUW_3_SECTORS = 2;
    public static final int MAX_NO_OF_CARRIERS_FLEXIBLE = 8;
    public static final int MAX_NO_OF_CARRIERS_SINGLE_DUW_6_SECTORS = 1;
    public static final int MAX_NO_OF_CARRIERS_DUAL_DUW_3_SECTORS = 4;
    public static final int MAX_NO_OF_CARRIERS_DUAL_DUW_6_SECTORS = 2;
    public static final int MAX_NO_OF_CARRIER_DUAL_DUW_ADVCONF_FIRST_3_SECTORS = 3;
    public static final int MAX_NO_OF_CARRIER_DUAL_DUW_ADVCONF_LAST_3_SECTORS = 2;
    private int MAX_NO_OF_CELLS_NO_INC_CC = 12;
    private int MAX_NO_OF_CELLS_ONE_INC_CC = 18;
    private int MAX_NO_OF_CELLS_TWO_INC_CC = 24;
    private CarrierAllocationModeParameter carrierAllocationMode;
    private static final String FLEXIBLE_CARRIER_ALLOCATION_RESTICTION_MSG = "only basic and advanced";
    private ParameterRestriction flexibleCarrierAllocationRestriction;
    private static final String SINGLE_DUW_CARRIER_ALLOCATION_RESTRICTION_MSG = "The chosen carrier allocation mode is not supported for single DUW.";
    private ParameterRestriction singleDuwCarrierAllocationRestriction;

    public CellAndCarrierDuwRbbCI(Rbs rbs) {
        this(rbs, 1);
    }

    public CellAndCarrierDuwRbbCI(Rbs rbs, int n) {
        super(rbs, n);
    }

    protected SectorAndCellNumber[][] createSectorAndCellNumber(int n, int n2) {
        SectorAndCellNumber[][] sectorAndCellNumberArray = new SectorAndCellNumber[this.maxNoOfSectors][this.maxNoOfCarriers];
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                sectorAndCellNumberArray[i][j] = new SectorAndCellNumberDuwRbb(SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber), j + 1, this.customerParameterNames);
            }
        }
        return sectorAndCellNumberArray;
    }

    public void checkConsistency() throws BemException {
        super.checkConsistency();
        boolean bl = this.carrierAllocationMode.getValue().equals("Flexible");
        if (bl) {
            this.checkFlexibleConfigurationDuwRbb();
            this.checkTxBranchConfiguredForFlexible();
            this.checkCellParametersForCombinedCell();
        } else {
            this.checkAdvancedConfigurationDuwRbb();
            this.configurationRuleDuwCheck();
            this.verifyThatNoCarrierHolesExist();
            this.checkTxBranchConfigured();
        }
    }

    public void checkAdvancedConfigurationDuwRbb() throws BemException {
        if (super.getRbs().getRbsData().getSupportsCarrierAllocationModes()) {
            int n = this.getMaxNoOfConfiguredSectors();
            int n2 = this.getLastConfiguredSector();
            int n3 = this.getMaxNoOfConfiguredCarriers();
            int n4 = this.getMinNoOfConfiguredCarriers();
            if (this.carrierAllocationMode.getValue().equals("Basic") && DuwUtil.hasDualDuws() && n3 == 2 && n <= 3 && n2 <= 3 && !this.rbs.isPantherHybridRbs()) {
                AddDuwBoardSlotCustomerParameter addDuwBoardSlotCustomerParameter = (AddDuwBoardSlotCustomerParameter)this.rbs.getCustomerParameterObject("AddDuwBoardslot");
                if (null != addDuwBoardSlotCustomerParameter && !addDuwBoardSlotCustomerParameter.getValue().equals("##UNDEFINED")) {
                    return;
                }
                throw new BemException("This configuration isn't supported in basic carrier allocation mode.");
            }
            if (this.carrierAllocationMode.getValue().equals("Advanced")) {
                String string = "This configuration isn't supported in advanced carrier allocation mode. \nCause: ";
                if (n3 > 2) {
                    boolean bl = true;
                    if (n > 3) {
                        for (int i = 3; i < n2; ++i) {
                            bl = bl && 1 == this.getConfiguredNumberOfCarriers(i);
                        }
                    }
                    if (n > 3 && !bl) {
                        throw new BemException(string + "Can't have more than three carriers in sector 1-3 and at the \n" + "same time have more than one carrier on one of sectors 4-6 when \n" + "using advanced configuration.");
                    }
                    if (n3 > 3) {
                        throw new BemException(string + "Can't have more than 3 carriers when using advanced configurations.");
                    }
                } else if (n <= 3 && n3 < 2 && n4 < 2 && n2 <= 3) {
                    throw new BemException(string + "Number of carriers cant be less then 2 when there are 3 or less sectors.");
                }
            }
        } else if (this.carrierAllocationMode.getValue().equals("Advanced")) {
            throw new BemException("This rbs doesn't support advanced carrier allocation mode.");
        }
    }

    public void checkConsistency(List list) throws CustomerParameterException, BemException {
        super.checkConsistency(list);
        this.verifyThatNoCarrierHolesExist();
        this.configurationRuleDuwCheck();
        this.checkAdvancedConfigurationDuwRbb();
    }

    private void verifyThatNoCarrierHolesExist() throws BemException {
        if (this.carrierAllocationMode.getValue().equals("Flexible")) {
            return;
        }
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            boolean bl = true;
            for (int j = 1; j <= this.maxNoOfCarriers; ++j) {
                boolean bl2 = this.isCarrierConfigured(n, j);
                if (bl2 && !bl) {
                    throw new BemException("Sector number=" + n + " carrierNumber=" + j + "  can not be used when the preceeding carrier is not used.");
                }
                bl = bl2;
            }
        }
    }

    public void checkFlexibleConfigurationDuwRbb() throws BemException {
        if (this.carrierAllocationMode.getValue().equals("Flexible") && !this.getRbs().getRbsStep().equals("STEP_CABINET")) {
            this.checkThatAllCarriersHasBbPoolForFlexible();
            this.checkNoOfCarriersPerBbPool();
        }
    }

    private void checkThatAllCarriersHasBbPoolForFlexible() throws BemException {
        int n = this.getMaxNoOfSectors();
        int n2 = this.getMaxNumberOfCarriers();
        for (int i = 0; i < n; ++i) {
            int n3 = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            for (int j = 1; j <= n2; ++j) {
                SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n3, j);
                if (!sectorAndCellNumber.useCellParameter.getValue().equals("YES") || sectorAndCellNumber.getBasebandPoolIdRef().isValidValue()) continue;
                throw new BemException("Sector number=" + n3 + " carrierNumber=" + j + "  basebandpoolId must be set when useCellParameter is true.");
            }
        }
    }

    private void checkCellParametersForCombinedCell() throws BemException {
        SectorAndCellNumber[] sectorAndCellNumberArray = this.getAllEquippedItems();
        Arrays.sort(sectorAndCellNumberArray, new Comparator(){

            public int compare(Object object, Object object2) {
                SectorAndCellNumber sectorAndCellNumber = (SectorAndCellNumber)object;
                SectorAndCellNumber sectorAndCellNumber2 = (SectorAndCellNumber)object2;
                return sectorAndCellNumber.cellIdentityParameter.getValue().compareTo(sectorAndCellNumber2.cellIdentityParameter.getValue());
            }
        });
        int n = 1;
        for (int i = 1; i < sectorAndCellNumberArray.length; ++i) {
            if (sectorAndCellNumberArray[i].cellIdentityParameter.getValue().equalsIgnoreCase(sectorAndCellNumberArray[i - 1].cellIdentityParameter.getValue())) {
                ++n;
                if (!sectorAndCellNumberArray[i].getBasebandPoolIdRef().getValue().equalsIgnoreCase(sectorAndCellNumberArray[i - 1].getBasebandPoolIdRef().getValue())) {
                    throw new BemException("BBpoolId should be same for combined cell portions, which put cell portions to same BB pool.");
                }
                if (sectorAndCellNumberArray[i].getCellNumber() != sectorAndCellNumberArray[i - 1].getCellNumber()) {
                    throw new BemException("CellNumber should be same for combined cell portions,which lock those cell portions to same frequency plane.");
                }
                if (this.rbs.getCustomerParameter("steeredHsAllocation").equals("TRUE") && !sectorAndCellNumberArray[i].hsCodeResourceIdParameter.getValue().equalsIgnoreCase(sectorAndCellNumberArray[i - 1].hsCodeResourceIdParameter.getValue())) {
                    throw new BemException("hsCodeResourceId of all cell portions should be configured with same value in a combined cell.");
                }
                if (!sectorAndCellNumberArray[i].getOperatingBandParameter().getValue().equalsIgnoreCase(sectorAndCellNumberArray[i - 1].getOperatingBandParameter().getValue())) {
                    throw new BemException("operatingBand value of all cell portions should be configured with same value in a combined cell.");
                }
                if (n <= 3) continue;
                throw new BemException("The number of combined cells with same cellIdentity is no more than 3.");
            }
            n = 1;
        }
    }

    protected void checkTxBranchConfiguredForFlexible() throws BemException {
        int n = this.getMaxNoOfSectors();
        int n2 = this.getMaxNumberOfCarriers();
        for (int i = 0; i < n; ++i) {
            int n3 = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            String string = MessageFormat.format("S{0}_", new Integer(n3)) + "radioBuildingBlock";
            String string2 = "";
            if (this.rbs.isParameterSupported(string)) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                string2 = customerParameter.getValue();
            }
            boolean bl = false;
            boolean bl2 = true;
            for (int j = 1; j <= n2; ++j) {
                SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n3, j);
                if (!sectorAndCellNumber.useCellParameter.getValue().equals("YES")) continue;
                if (this.radioEP.getNumberOfSupportedTxBranches(n3) == 1 && !sectorAndCellNumber.txBranchConfiguredParameter2.getValue().equals("S")) {
                    throw new BemException("Sector number=" + n3 + " Configuration unsupported: The TX branch could not be configured explicitly if the sector has only 1 TX branch.");
                }
                if (bl2) {
                    bl2 = false;
                    bl = !sectorAndCellNumber.txBranchConfiguredParameter.getValue().equals("S");
                } else if (!string2.equals("RBB22_1A") || sectorAndCellNumber.getNuOfTxBranchesPerCarrierParameter().getValueAsInt() != 1) {
                    boolean bl3;
                    boolean bl4 = bl3 = !sectorAndCellNumber.txBranchConfiguredParameter.getValue().equals("S");
                    if (bl != bl3) {
                        throw new BemException("Sector number=" + n3 + " Configuration unsupported: The carriers in the same sector could not be mixed with TX branch configured explicitly and TX branch configued implicitly.");
                    }
                }
                if (!sectorAndCellNumber.txBranchConfiguredParameter2.getValue().equals("S") && sectorAndCellNumber.getNuOfTxBranchesPerCarrierParameter().getValueAsInt() == 1 && this.rbs.getRbsStep().equals("STEP_EXPANSION")) {
                    sectorAndCellNumber.txBranchConfiguredParameter2.setValue("S");
                }
                if (!sectorAndCellNumber.txBranchConfiguredParameter2.getValue().equals("S") && sectorAndCellNumber.txBranchConfiguredParameter.getValue().equals("S")) {
                    throw new BemException("Sector number=" + n3 + " carrierNumber=" + j + " Configuration unsupported: The 2nd TX branch could not be configured explicitly if the 1st TX branch is not configured explicitly.");
                }
                if (!sectorAndCellNumber.txBranchConfiguredParameter2.getValue().equals("S") && sectorAndCellNumber.getNuOfTxBranchesPerCarrierParameter().getValueAsInt() == 1 && this.rbs.getRbsStep().equals("STEP_SITE")) {
                    throw new BemException("Sector number=" + n3 + " carrierNumber=" + j + " Configuration unsupported: The 2nd TX branch could not be configured explicitly if the carrier numberOfTxBranches is 1.");
                }
                if (!sectorAndCellNumber.txBranchConfiguredParameter.getValue().equals("S") && sectorAndCellNumber.txBranchConfiguredParameter2.getValue().equals("S") && sectorAndCellNumber.getNuOfTxBranchesPerCarrierParameter().getValueAsInt() == 2) {
                    throw new BemException("Sector number=" + n3 + " carrierNumber=" + j + " Configuration unsupported: The 2nd TX branch should be configured explicitly if the carrier numberOfTxBranches is 2 and the 1st TX branch has been configured explicitly.");
                }
                if (sectorAndCellNumber.txBranchConfiguredParameter.getValue().equals("S") || !sectorAndCellNumber.txBranchConfiguredParameter2.getValue().equals(sectorAndCellNumber.txBranchConfiguredParameter.getValue()) || sectorAndCellNumber.getNuOfTxBranchesPerCarrierParameter().getValueAsInt() != 2) continue;
                throw new BemException("Sector number=" + n3 + " carrierNumber=" + j + " Configuration unsupported: The TX braches could not use the same port if the TX branch configured explicitly.");
            }
        }
    }

    protected void checkTxBranchConfigured() throws BemException {
        int n = this.getMaxNoOfSectors();
        int n2 = this.getMaxNumberOfCarriers();
        for (int i = 0; i < n; ++i) {
            int n3 = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            for (int j = 1; j <= n2; ++j) {
                SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n3, j);
                if (!sectorAndCellNumber.useCellParameter.getValue().equals("YES") || sectorAndCellNumber.txBranchConfiguredParameter.getValue().equals("S") && sectorAndCellNumber.txBranchConfiguredParameter2.getValue().equals("S")) continue;
                throw new BemException("Configuration unsupported:Carrier allocation mode should be Flexible Carrier Mapping if any TX branch configured explicitly.");
            }
        }
    }

    private boolean isCarrierDeletedwhenModify(int n, int n2) {
        boolean bl = false;
        if (this.radioEP instanceof RadioEquipmentProviderWithRbb) {
            RadioEquipmentProviderWithRbb radioEquipmentProviderWithRbb = (RadioEquipmentProviderWithRbb)this.radioEP;
            bl = radioEquipmentProviderWithRbb.isLocalCellDeletedWhenModify(n, n2);
        }
        return bl;
    }

    private int countNumberOfCarriers(String string) {
        int n = 0;
        int n2 = this.getMaxNoOfSectors();
        int n3 = this.getMaxNumberOfCarriers();
        for (int i = 0; i < n2; ++i) {
            int n4 = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            for (int j = 1; j <= n3; ++j) {
                SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n4, j);
                if (!sectorAndCellNumber.useCellParameter.getValue().equals("YES") || !this.isBbRefUsed(sectorAndCellNumber, string)) continue;
                ++n;
                if (!this.isCarrierDeletedwhenModify(n4, j)) continue;
                --n;
            }
        }
        return n;
    }

    private void checkNoOfCarriersPerBbPool() throws BemException {
        int n = this.countNumberOfCarriers("1");
        int n2 = this.countNumberOfCarriers("2");
        int n3 = this.countNumberOfCarriers("3");
        int n4 = this.countNumberOfCarriers("4");
        this.checkNumberOfCarriers(n, "1");
        this.checkNumberOfCarriers(n2, "2");
        this.checkNumberOfCarriers(n3, "3");
        this.checkNumberOfCarriers(n4, "4");
        int n5 = n + n2 + n3 + n4;
        if (n3 > 0 && !DuwUtil.isPriDuwSupport12CC()) {
            throw new BemException("Not possible to have carriers on basebandpool 3 for primary DUW without increase CC support");
        }
        if (n4 > 0 && !DuwUtil.isSecDuwSupport12CC()) {
            throw new BemException("Not possible to have carriers on basebandpool 4 for secondary DUW without increase CC support");
        }
        if (!(DuwUtil.hasDualDuws() || n2 <= 0 && n4 <= 0)) {
            throw new BemException("Not possible to have carriers on basebandpool 2 or 4 for single DUW");
        }
        if (!DuwUtil.hasDualDuws() && n5 > this.MAX_NO_OF_CELLS_NO_INC_CC) {
            throw new BemException("The total number of Cells = " + n5 + " is more than the maximum = " + this.MAX_NO_OF_CELLS_NO_INC_CC);
        }
        if (DuwUtil.hasDualDuws()) {
            if (DuwUtil.isPriDuwSupport12CC() && DuwUtil.isSecDuwSupport12CC() && n5 > this.MAX_NO_OF_CELLS_TWO_INC_CC) {
                throw new BemException("Dual DUW support increased CC, but the total number of Cells = " + n5 + " is more than the maximum = " + this.MAX_NO_OF_CELLS_TWO_INC_CC);
            }
            if (DuwUtil.isPriDuwSupport12CC() && !DuwUtil.isSecDuwSupport12CC() && n5 > this.MAX_NO_OF_CELLS_ONE_INC_CC) {
                throw new BemException("Primary DUW support increased CC in dual DUW, but the total number of Cells = " + n5 + " is more than the maximum = " + this.MAX_NO_OF_CELLS_TWO_INC_CC);
            }
            if (!DuwUtil.isPriDuwSupport12CC() && DuwUtil.isSecDuwSupport12CC() && n4 > 0) {
                throw new BemException("Not allowed configuration: priamry DUW does not support Increased CC, but secondary DUW support increased CC.");
            }
            if (!DuwUtil.isPriDuwSupport12CC() && !DuwUtil.isSecDuwSupport12CC() && n5 > this.MAX_NO_OF_CELLS_NO_INC_CC) {
                throw new BemException("None of dual DUW support increased CC. The total number of Cells = " + n5 + " is more than the maximum = " + this.MAX_NO_OF_CELLS_NO_INC_CC);
            }
        }
    }

    private void checkNumberOfCarriers(int n, String string) throws BemException {
        if (n > 6) {
            throw new BemException("Number of carriers is more than 6 in baseband pool " + string);
        }
    }

    private boolean isBbRefUsed(SectorAndCellNumber sectorAndCellNumber, String string) {
        BasebandPoolIdParameter basebandPoolIdParameter = sectorAndCellNumber.getBasebandPoolIdRef();
        if (basebandPoolIdParameter.isValidValue()) {
            return sectorAndCellNumber.getBasebandPoolIdRef().getValue().equals(string);
        }
        return false;
    }

    private int getMaxNumberOfCarriersDuw(int n) throws BemException {
        int n2 = 0;
        int n3 = 0;
        if (this.carrierAllocationMode.getValue().equals("Flexible")) {
            return 8;
        }
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            boolean bl = this.sectorInfo[i].sectorIsEquipped();
            if (!bl || n3 >= this.sectorInfo[i].sectorNumber) continue;
            n3 = this.sectorInfo[i].sectorNumber;
        }
        n2 = DuwUtil.hasDualDuws() && !this.rbs.isPantherHybridRbs() ? (n3 > 3 ? (this.carrierAllocationMode.getValue().equals("Advanced") ? (n < 3 ? 3 : 2) : (this.carrierAllocationMode.getValue().equals("Basic") ? 2 : (this.carrierAllocationMode.getValue().equals("Flexible") ? 4 : 0))) : (n3 <= 3 ? 4 : 0)) : (n3 >= 3 + this.startingSectorNumber ? 1 : (n3 < 3 + this.startingSectorNumber ? 2 : 0));
        return n2;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        super.setCustomerParameters(serviceValue);
        if (serviceValue.getValue("carrierAllocationMode") != null) {
            String string;
            this.setCustomerParametersFromSV(new String[]{"carrierAllocationMode"}, serviceValue);
            if (!this.getRbs().getRbsStep().equals("STEP_CABINET") && this.carrierAllocationMode != null && this.flexibleCarrierAllocationRestriction != null && (string = serviceValue.getValue("carrierAllocationMode")) != null && string.equals("Flexible")) {
                this.flexibleCarrierAllocationRestriction.setActive(false);
            }
            this.setBaseBandPoolId4CarrierAllocationMode();
        }
        this.rejectModifyCarrierAllocationModeForModifySector(serviceValue);
        this.setCustomerParametersForcarrierAllocationModeFromSV(serviceValue);
    }

    private void setBaseBandPoolId4CarrierAllocationMode() throws BemException {
        if (this.isCarrierAllocationModeModifiedToFlexible()) {
            for (int i = 0; i < this.maxNoOfSectors; ++i) {
                if (!this.sectorInfo[i].sectorIsEquipped()) continue;
                for (int j = 0; j < this.maxNoOfCarriers; ++j) {
                    int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
                    int n2 = j + 1;
                    String string = this.customerParameterNames.getBasebandPoolIdPseudoName(n, n2);
                    SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumberByIndex(i, j);
                    BasebandPoolIdParameter basebandPoolIdParameter = sectorAndCellNumber.getBasebandPoolIdRef();
                    if (null != basebandPoolIdParameter && basebandPoolIdParameter.hasValueChanged() || !sectorAndCellNumber.carrierRI.isInstalled()) continue;
                    String string2 = "";
                    if (this.carrierAllocationMode.getLoadedValue().equals("Basic")) {
                        string2 = !DuwUtil.hasDualDuws() ? "1" : (n2 % 2 == 0 ? "2" : "1");
                    } else {
                        String string3 = sectorAndCellNumber.carrierRI.getDownlinkBaseBandPoolRef();
                        string2 = BemUtil.extractRdnId(string3, MimDownlinkBaseBandPool.MOTYPENAME);
                    }
                    this.setCustomerParameter(string, string2);
                }
            }
        }
    }

    public List getRIsToUninstall() throws BemException {
        List list;
        ArrayList<NodeBFunctionRI> arrayList = new ArrayList<NodeBFunctionRI>();
        if (this.isCarrierAllocationModeModifiedToFlexible() && SectorUtil.getExistingSectorMoNumber(this.getRbs()) > 0) {
            arrayList.add(this.nodeBFunctionRI);
        }
        if (null != (list = super.getRIsToUninstall())) {
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private boolean isCarrierAllocationModeModifiedToFlexible() {
        return this.rbs.isModifyWiz() && this.carrierAllocationMode != null && this.carrierAllocationMode.getValue().equals("Flexible") && this.carrierAllocationMode.hasValueChanged();
    }

    void setCustomerParametersForcarrierAllocationModeFromSV(ServiceValue serviceValue) throws BemException {
        String string = this.carrierAllocationMode.getValue();
        String string2 = null;
        Vector vector = serviceValue.getValues("AddSector");
        int n = SectorUtil.getExistingSectorMoNumber(this.getRbs());
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            if (!ModifyUtil.isScpmAttributeInNameValueVector(vector, i, "sectorNumber", this.startingSectorNumber)) continue;
            string2 = serviceValue.getValue(CustomParaName.getCarrierAllocationModePseudoNameArrayByIndex(i));
            if (string2 == null) {
                string2 = "Basic";
                continue;
            }
            if (n > 0 && string != null && !string2.equalsIgnoreCase(string)) {
                throw new BemException("Carrier Allocation Mode are not configured same in different sectors.");
            }
            if (n != 0) continue;
            string = string2;
        }
        if (string2 != null) {
            this.setCustomerParameter("carrierAllocationMode", string);
        }
    }

    private void rejectModifyCarrierAllocationModeForModifySector(ServiceValue serviceValue) throws BemException {
        Vector vector = serviceValue.getAllAttributesWithSimpleName("carrierAllocationMode");
        String string = this.carrierAllocationMode.getValue();
        for (int i = 0; i < vector.size(); ++i) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)vector.get(i);
            String string2 = serviceNameValue.getValue().toString();
            if (!serviceNameValue.getServiceName().equals("ModifySector") || string.equals(string2)) continue;
            throw new BemException(serviceNameValue.getName() + " is not as same as " + "carrierAllocationMode" + ".");
        }
    }

    protected void setParameterRestriction() throws BemException {
        super.setParameterRestriction();
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            SectorInfo[] sectorInfoArray = super.getSectorInfo();
            int n = sectorInfoArray[i].getEquippedCarriers();
            this.updateRestrictionOnRequiredCell(i, this.getCellNumberToUpdateRestriction());
            for (int j = 0; j < n; ++j) {
                if (this.carrierAllocationMode.getValue().equals("Flexible")) continue;
                this.updateRestrictionOnRequiredCell(i, j + 1);
            }
        }
    }

    protected int getMaxNumberOfAllowedCarriers(int n) throws BemException {
        int n2 = this.getMaxNumberOfCarriersDuw(n);
        int n3 = this.radioEP.getMaxNumberOfCarriers(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber));
        if (n3 < n2) {
            n2 = n3;
        }
        return n2;
    }

    private String getCellCreatedPseudoName(int n, int n2) {
        String string = null;
        String string2 = "S{0}_C{1}_";
        String string3 = "" + n;
        String string4 = MessageFormat.format(string2, string3, String.valueOf(n2));
        string = string4 + "cellCreated";
        return string;
    }

    private boolean isCarrierConfigured(int n, int n2) throws BemException {
        CustomerParameter customerParameter;
        String string;
        boolean bl = false;
        String string2 = this.getCellCreatedPseudoName(n, n2);
        boolean bl2 = this.getRbs().isParameterSupported(string2);
        if (bl2 && "YES".equals(string = (customerParameter = this.getRbs().getCustomerParameterObject(string2)).getValue())) {
            bl = true;
        }
        return bl;
    }

    public void setRadioEquipmentProvider(RadioEquipmentProvider radioEquipmentProvider) {
        this.radioEP = radioEquipmentProvider;
    }

    protected void configurationRuleDuwCheck() throws BemException {
        boolean bl = DuwUtil.hasDualDuws();
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            int n = this.getMaxNumberOfAllowedCarriers(i);
            int n2 = this.getConfiguredNumberOfCarriers(i);
            if (n2 <= n) continue;
            if (bl && !this.rbs.isPantherHybridRbs()) {
                throw new BemException("The cell is not supposed to be used or created. \nMaximum number of carriers already allocated. \n\n2 DUW can have maximum 4 carriers if number of sectors less or equals than 3 \nand maximum 2 carrier if number of sectors greater than 3.\nCurrently " + n2 + " number of carriers is configured.");
            }
            throw new BemException("The cell is not supposed to be used or created. \nMaximum number of carriers already allocated. \n\n1 DUW can have maximum 2 carriers if number of sectors less or equals than 3 \nand maximum 1 carrier if number of sectors greater than 3 .\nCurrently " + n2 + " number of carriers is configured.");
        }
    }

    protected int getConfiguredNumberOfCarriers(int n) {
        int n2 = 0;
        SectorInfo[] sectorInfoArray = super.getSectorInfo();
        if (sectorInfoArray[n].sectorIsEquipped()) {
            for (int i = 0; i < this.getMaxNumberOfCarriers(); ++i) {
                int n3 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
                int n4 = i + 1;
                SectorAndCellNumber sectorAndCellNumber = this.getSectorAndCellNumber(n3, n4);
                if (!sectorAndCellNumber.useCellParameter.getValue().equals("YES")) continue;
                ++n2;
            }
        }
        return n2;
    }

    protected void registerRadioEquipmentListener(RadioEquipmentProvider radioEquipmentProvider) throws BemException {
        CellAndCarrierCI.SectorChangedListener sectorChangedListener = null;
        sectorChangedListener = radioEquipmentProvider instanceof RadioEquipmentProviderWithRbb ? new RbbRadioEquipmentListener(this, radioEquipmentProvider) : new CellAndCarrierCI.SectorChangedListener();
        this.addRadioEquipmentListener(sectorChangedListener);
    }

    protected void updateSectorEquipped(RadioEquipmentProvider radioEquipmentProvider) {
        SectorInfo[] sectorInfoArray = this.getSectorInfo();
        int[] nArray = radioEquipmentProvider.getEquippedSectors();
        for (int i = 0; i < this.getMaxNoOfSectors(); ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            boolean bl = BemUtil.isIntInArray(n, nArray);
            sectorInfoArray[i].setCurrentSectorIsEquipped(bl);
        }
    }

    protected void updateCarrierRestrictions(int n) throws BemException {
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n2 = this.maxNoOfCarriers;
            int n3 = 0;
            try {
                n3 = this.getMaxNumberOfAllowedCarriers(i);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
            int n4 = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            for (int j = 0; j < n2; ++j) {
                int n5 = j + 1;
                SectorAndCellNumberDuwRbb sectorAndCellNumberDuwRbb = (SectorAndCellNumberDuwRbb)this.getSectorAndCellNumber(n4, n5);
                if (j < n3) {
                    sectorAndCellNumberDuwRbb.setCarrierIsInSupportedRange(true);
                } else {
                    sectorAndCellNumberDuwRbb.setCarrierIsInSupportedRange(false);
                }
                sectorAndCellNumberDuwRbb.updateNoTxBranchesRestriction();
            }
        }
    }

    public void updateLoadedValues() throws BemException {
        super.updateLoadedValues();
        this.updateCarrierAllocationModeValues();
    }

    private void updateCarrierAllocationModeValues() throws BemException {
        if (this.rbs.isPantherHybridRbs()) {
            this.carrierAllocationMode.setLoadedValue("Basic");
        } else {
            String string = this.getCarrierAllocationMode();
            this.carrierAllocationMode.setLoadedValue(string);
            if (string.equals(String.valueOf(3))) {
                super.updateBaseBandPoolIds();
            }
        }
    }

    private String getCarrierAllocationMode() throws BemException {
        String string = "0";
        SectorInfo[] sectorInfoArray = super.getSectorInfo();
        block0: for (int i = 0; i < sectorInfoArray.length; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            int n2 = this.maxNoOfCarriers;
            for (int j = 1; j <= n2; ++j) {
                SectorAndCellNumberDuwRbb sectorAndCellNumberDuwRbb = (SectorAndCellNumberDuwRbb)this.getSectorAndCellNumber(n, j);
                if (!sectorAndCellNumberDuwRbb.useCellParameter.getValue().equals("YES")) continue;
                string = this.getCarrierAllocationModeFromSectorAndCell(sectorAndCellNumberDuwRbb);
                break block0;
            }
        }
        return string;
    }

    private String getCarrierAllocationModeFromSectorAndCell(SectorAndCellNumberDuwRbb sectorAndCellNumberDuwRbb) throws BemException {
        boolean bl = false;
        boolean bl2 = false;
        int[] nArray = sectorAndCellNumberDuwRbb.carrierRI.getSectorConfiguration();
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == 3) {
                bl2 = true;
                continue;
            }
            if (nArray[i] != 2) continue;
            bl = true;
        }
        String string = bl2 ? String.valueOf(3) : (bl ? String.valueOf(2) : "0");
        return string;
    }

    private int getMaxNoOfConfiguredSectors() {
        int n = 0;
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n2 = this.getConfiguredNumberOfCarriers(i);
            if (n2 <= 0) continue;
            ++n;
        }
        return n;
    }

    private int getLastConfiguredSector() {
        int n = 0;
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n2 = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            int n3 = this.getConfiguredNumberOfCarriers(i);
            if (n3 <= 0) continue;
            n = n2;
        }
        return n;
    }

    private int getMaxNoOfConfiguredCarriers() {
        int n = Integer.MIN_VALUE;
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n2 = this.getConfiguredNumberOfCarriers(i);
            if (n2 <= 0) continue;
            n = n < n2 ? n2 : n;
        }
        return n;
    }

    private int getMinNoOfConfiguredCarriers() {
        int n = Integer.MAX_VALUE;
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n2 = this.getConfiguredNumberOfCarriers(i);
            if (n2 <= 0) continue;
            n = n > n2 ? n2 : n;
        }
        return n;
    }

    private void updateRestrictionOnRequiredCell(int n, int n2) throws BemException {
        if (n2 == 0) {
            return;
        }
        int n3 = this.getMaxNumberOfAllowedCarriers(n);
        int n4 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
        SectorAndCellNumberDuwRbb sectorAndCellNumberDuwRbb = (SectorAndCellNumberDuwRbb)this.getSectorAndCellNumber(n4, n2);
        boolean bl = n2 <= n3;
        sectorAndCellNumberDuwRbb.setCellIsNotUsed(this.rbs.isPantherHybridRbs(), !bl);
        if (!bl) {
            sectorAndCellNumberDuwRbb.useCellParameter.setValue("NO");
        }
    }

    private int getCellNumberToUpdateRestriction() {
        int n = 0;
        String string = this.carrierAllocationMode.getValue();
        if (this.getMaxNoOfConfiguredSectors() > 3 && (string.equals("Advanced") || string.equals("Basic"))) {
            n = 3;
        }
        return n;
    }

    protected void requestUnInitiateSectorIfAddedCarriers(int n) {
        int n2 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
        super.requestUninitiateSector(n2, this);
        super.requestInitiateSector(n2, this);
    }

    public void createCustomerParameters() throws BemException {
        super.createCustomerParameters();
        if (this.rbs.isPantherHybridRbs() && this.rbs.getCustomerParameterObject("carrierAllocationMode") != null) {
            this.carrierAllocationMode = (CarrierAllocationModeParameter)this.rbs.getCustomerParameterObject("carrierAllocationMode");
        } else {
            this.carrierAllocationMode = new CarrierAllocationModeParameter("carrierAllocationMode", this.getRbs());
            this.flexibleCarrierAllocationRestriction = new ParameterRestriction(FLEXIBLE_CARRIER_ALLOCATION_RESTICTION_MSG, new EnumeratedRange("Flexible"), false);
            this.flexibleCarrierAllocationRestriction.setActive(true);
            this.carrierAllocationMode.addRestriction(this.flexibleCarrierAllocationRestriction);
            this.singleDuwCarrierAllocationRestriction = new ParameterRestriction(SINGLE_DUW_CARRIER_ALLOCATION_RESTRICTION_MSG, new EnumeratedRange(new String[]{"Basic", "Flexible"}), true);
            this.singleDuwCarrierAllocationRestriction.setActive(!DuwUtil.hasDualDuws());
            this.carrierAllocationMode.addRestriction(this.singleDuwCarrierAllocationRestriction);
            this.carrierAllocationMode.setMomConverter(new CarrierAllocationModeConversion());
            this.carrierAllocationMode.addCustomerParameterListener(this.radioEP.getCarrierAllocationModeListener());
            this.carrierAllocationMode.addCustomerParameterListener(new CarrierAllocationModeListener());
            this.addParameter(this.carrierAllocationMode);
        }
    }

    private class CarrierAllocationModeListener
    implements CustomerParameterListener {
        private CarrierAllocationModeListener() {
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            try {
                CellAndCarrierDuwRbbCI.this.setParameterRestriction();
                if (CellAndCarrierDuwRbbCI.this.isOpen()) {
                    CellAndCarrierDuwRbbCI.this.updateNumHsCodeResources();
                }
            }
            catch (BemException bemException) {
                Nal.getLog().nalTrace(1, this.getClass(), "Failed to set parameter restriction", bemException);
            }
        }
    }

    private class RbbRadioEquipmentListener
    extends CellAndCarrierCI.SectorChangedListener {
        CellAndCarrierDuwRbbCI ci;
        RadioEquipmentProvider radioEP;

        public RbbRadioEquipmentListener(CellAndCarrierDuwRbbCI cellAndCarrierDuwRbbCI2, RadioEquipmentProvider radioEquipmentProvider) {
            this.ci = cellAndCarrierDuwRbbCI2;
            this.radioEP = radioEquipmentProvider;
        }

        public void update(int n) {
            this.ci.updateSectorEquipped(this.radioEP);
            super.update(n);
            try {
                this.ci.updateCarrierRestrictions(n);
            }
            catch (Exception exception) {
                Nal.getLog().nalTrace(1, this.getClass(), "Failed to update carrier restrictions", exception);
            }
        }
    }
}

