/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.AbstractPowerSystemCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.BatteryManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ClimateManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerDistributionManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerSupplyManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.SupportSystemManager;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public abstract class AbstractPowerSupplyRbs6KDuwCI
extends AbstractPowerSystemCI {
    private int numOfExternalNodesIfSecondary;
    private boolean isSupportSystemAvailable;
    private boolean hasClu;
    private boolean isConfigureSupportSystemMandatory;
    private boolean isBatteryBackupSupported;
    private boolean isPowerSupplySupported;
    private boolean isPowerDistributionSupported;
    private boolean hasScu;
    private boolean hasSup;
    private int[] psu_position;
    private int[] pdu_position;
    private int[] bfu_position;
    private EnumeratedRange climateSystemRange;
    private EnumeratedRange climateRegulationSystemRange;
    private IntegerRange psu_range;
    private IntegerRange pdu_range;
    private IntegerRange bfu_range;

    public AbstractPowerSupplyRbs6KDuwCI(Rbs rbs) {
        super(rbs);
        if (this.apcConfigurationData4Rbs != null) {
            this.numOfExternalNodesIfSecondary = this.apcConfigurationData4Rbs.getNumOfExternalNodesIfSecondary();
            this.isSupportSystemAvailable = this.apcConfigurationData4Rbs.isSupportSystemAvailable();
            this.hasClu = this.apcConfigurationData4Rbs.hasClu();
            this.isConfigureSupportSystemMandatory = this.apcConfigurationData4Rbs.isConfigureSupportSystemMandatory();
            this.isBatteryBackupSupported = this.apcConfigurationData4Rbs.isBatteryBackupSupported();
            this.isPowerSupplySupported = this.apcConfigurationData4Rbs.isPowerSupplySupported();
            this.isPowerDistributionSupported = this.apcConfigurationData4Rbs.isPowerDistributionSupported();
            this.hasScu = this.apcConfigurationData4Rbs.hasScu();
            this.hasSup = this.apcConfigurationData4Rbs.hasSup();
            this.psu_position = this.apcConfigurationData4Rbs.getPsuPosition();
            this.pdu_position = this.apcConfigurationData4Rbs.getPduPosition();
            this.bfu_position = this.apcConfigurationData4Rbs.getBfuPosition();
            this.climateSystemRange = this.apcConfigurationData4Rbs.getClimateSystemRange();
            this.climateRegulationSystemRange = this.apcConfigurationData4Rbs.getClimateRegulationSystemRange();
            this.psu_range = this.apcConfigurationData4Rbs.getPsuRange();
            this.pdu_range = this.apcConfigurationData4Rbs.getPduRange();
            this.bfu_range = this.apcConfigurationData4Rbs.getBfuRange();
        }
    }

    public SupportSystemManager getSupportSystemManager() {
        SupportSystemManager supportSystemManager = new SupportSystemManager(this.rbs, this.isSupportSystemAvailable, this.isConfigureSupportSystemMandatory, this.numOfExternalNodesIfSecondary);
        return supportSystemManager;
    }

    public PowerSupplyManager getPowerSupplyManager() {
        PowerSupplyManager powerSupplyManager = new PowerSupplyManager(this.rbs, this.psu_position, this.psu_range, this.isPowerSupplySupported);
        return powerSupplyManager;
    }

    public PowerDistributionManager getPowerDistributionManager() {
        PowerDistributionManager powerDistributionManager = new PowerDistributionManager(this.rbs, this.pdu_position, this.pdu_range, this.isPowerDistributionSupported);
        return powerDistributionManager;
    }

    public BatteryManager getBatteryManager() {
        BatteryManager batteryManager = new BatteryManager(this.rbs, this.bfu_position, this.bfu_range, this.isBatteryBackupSupported);
        return batteryManager;
    }

    public ClimateManager getClimateManager() throws BemException {
        ClimateManager climateManager = new ClimateManager(this.rbs, this.hasClu, this.hasScu, this.hasSup, this.climateSystemRange, this.climateRegulationSystemRange);
        return climateManager;
    }
}

