/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ApcHubPort;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ApcHubPortManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.PduRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.PowerDistributionRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.help.RDNHelper;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipmentSupportFunction;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;

public class PowerDistributionManager {
    private static final String HW_UNIT_TYPE = "PDU";
    private Rbs rbs;
    private MoInstance equipmentMoi;
    private MoInstance equipmentSupportFunctionMoi;
    private int[] pduPositions = new int[0];
    private IntegerRange pduRange;
    private TreeMap pduRIs = new TreeMap();
    private PowerDistributionRI powerDistributionRI;
    private boolean createPowerDistribution = true;
    private boolean powerDistributionSupported;
    private int cabinetNumber;
    private String cabinetType;

    public PowerDistributionManager(Rbs rbs, int[] nArray, IntegerRange integerRange, boolean bl) {
        this(rbs, nArray, integerRange, bl, 1, null);
    }

    public PowerDistributionManager(Rbs rbs, int[] nArray, IntegerRange integerRange, boolean bl, int n, String string) {
        this.rbs = rbs;
        this.pduRange = integerRange;
        this.pduPositions = nArray;
        this.powerDistributionSupported = bl;
        this.equipmentMoi = rbs.getEquipmentMoi();
        this.equipmentSupportFunctionMoi = new SingleChildMoi(rbs.getRootMoi(), MimEquipmentSupportFunction.MOTYPENAME, "1");
        this.cabinetNumber = n;
        this.cabinetType = string;
    }

    public int[] getPduPositions() {
        return this.pduPositions;
    }

    public IntegerRange getPduRange() {
        return this.pduRange;
    }

    public void updateBoards(String string) throws BemException {
        for (int i = 0; i < this.pduPositions.length; ++i) {
            PduRI pduRI = (PduRI)this.pduRIs.get(new Integer(this.pduPositions[i]));
            if (pduRI == null) continue;
            String string2 = pduRI.getHubPosition();
            String string3 = this.lookupHubPos(string, string2, i + 1);
            pduRI.setHubPosition(string3);
        }
        this.updateMoi();
    }

    protected void updateMoi() throws BemException {
        for (int i = 0; i < this.pduPositions.length; ++i) {
            PduRI pduRI = (PduRI)this.pduRIs.get(new Integer(this.pduPositions[i]));
            if (pduRI == null) continue;
            pduRI.updateMoi(this.equipmentMoi);
        }
    }

    public String lookupHubPos(String string, String string2, int n) {
        ApcHubPort apcHubPort;
        String string3 = string2;
        if (string.equals(HW_UNIT_TYPE) && n > 0 && (apcHubPort = ApcHubPortManager.getInstance().getApcPortValue(this.cabinetType, HW_UNIT_TYPE, n)) != null) {
            string3 = apcHubPort.getHubPosition();
        }
        return string3;
    }

    public void createAllRIs() throws BemException {
        this.createPowerDistributionRI(this.equipmentSupportFunctionMoi);
    }

    public ArrayList getRIsToBeInstalled(boolean bl, int n, List list) throws BemException {
        ArrayList arrayList = new ArrayList();
        Collections.sort(list);
        if (this.isPowerDistributionSupported()) {
            ArrayList arrayList2 = this.getNeededPowerDistributionRIs(bl);
            arrayList.addAll(arrayList2);
            arrayList2 = this.getNeededPduRIs(bl, n, list);
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public ArrayList getRIsToUninstall(int n, List list) throws BemException {
        ArrayList arrayList = new ArrayList();
        Collections.sort(list);
        int n2 = list.size();
        int n3 = n2 - n;
        if (n3 > 0) {
            arrayList = this.getPduRIsToBeUnInstalled(n3, list);
        }
        return arrayList;
    }

    public boolean isPowerDistributionSupported() {
        return this.powerDistributionSupported;
    }

    public int getNumberOfPdus() {
        return this.pduPositions.length;
    }

    public int getNumberOfInstalledPdus() throws BemException {
        return this.countInstalledPdus(this.pduRIs);
    }

    protected ArrayList getNeededPduRIs(boolean bl, int n, List list) throws BemException {
        ArrayList<PduRI> arrayList = new ArrayList<PduRI>();
        TreeMap treeMap = null;
        if (bl) {
            this.createPduRIs(n, list);
            treeMap = this.pduRIs;
            Set set = treeMap.entrySet();
            Iterator iterator = set.iterator();
            for (int i = 0; i < n; ++i) {
                if (!iterator.hasNext()) continue;
                Map.Entry entry = iterator.next();
                PduRI pduRI = (PduRI)entry.getValue();
                arrayList.add(pduRI);
            }
        }
        return arrayList;
    }

    protected ArrayList getNeededPowerDistributionRIs(boolean bl) {
        ArrayList<PowerDistributionRI> arrayList = new ArrayList<PowerDistributionRI>();
        if (bl && this.createPowerDistribution) {
            arrayList.add(this.powerDistributionRI);
        }
        return arrayList;
    }

    protected boolean isPowerDistributionInstalled() throws BemException {
        return this.powerDistributionRI.isInstalled();
    }

    private int countInstalledPdus(TreeMap treeMap) throws BemException {
        int n = 0;
        Set set = treeMap.entrySet();
        for (Map.Entry entry : set) {
            PduRI pduRI = (PduRI)entry.getValue();
            boolean bl = pduRI.isInstalled();
            if (!bl) continue;
            ++n;
        }
        return n;
    }

    private void createPowerDistributionRI(MoInstance moInstance) throws BemException {
        this.powerDistributionRI = new PowerDistributionRI(this.rbs, moInstance, this.cabinetNumber);
    }

    private void createPduRIs(int n, List list) throws BemException {
        String string;
        String string2;
        Integer n2;
        PduRI pduRI;
        int n3;
        RDNHelper rDNHelper = RDNHelper.getInstance();
        for (n3 = 0; n3 < list.size(); ++n3) {
            pduRI = new PduRI(this.rbs, Integer.valueOf(list.get(n3).toString()), this.equipmentMoi);
            n2 = new Integer(this.pduPositions[n3]);
            string2 = pduRI.getHubPosition();
            string = this.lookupHubPos(HW_UNIT_TYPE, string2, n3 + 1);
            pduRI.setHubPosition(string);
            this.pduRIs.put(n2, pduRI);
        }
        if (n > list.size()) {
            for (n3 = 0; n3 < n - list.size(); ++n3) {
                pduRI = new PduRI(this.rbs, rDNHelper.getPostfix(rDNHelper.getPduRdnList()), this.equipmentMoi);
                n2 = new Integer(this.pduPositions[list.size() + n3]);
                string2 = pduRI.getHubPosition();
                string = this.lookupHubPos(HW_UNIT_TYPE, string2, list.size() + n3 + 1);
                pduRI.setHubPosition(string);
                this.pduRIs.put(n2, pduRI);
            }
        }
    }

    private ArrayList getPduRIsToBeUnInstalled(int n, List list) throws BemException {
        int n2;
        ArrayList<PduRI> arrayList = new ArrayList<PduRI>();
        this.createPduRIs(n, list);
        Set set = this.pduRIs.keySet();
        Object[] objectArray = set.toArray();
        for (int i = n2 = objectArray.length - 1; i > 0; --i) {
            PduRI pduRI = (PduRI)this.pduRIs.get(objectArray[i]);
            if (n <= 0 || !pduRI.isInstalled()) continue;
            arrayList.add(pduRI);
            --n;
        }
        return arrayList;
    }

    void setPduRi(TreeMap treeMap) throws BemException {
        this.pduRIs.putAll(treeMap);
    }

    void setPowerDistributionRi(PowerDistributionRI powerDistributionRI) {
        this.powerDistributionRI = powerDistributionRI;
    }

    void setPowerDistributionSupported(boolean bl) {
        this.powerDistributionSupported = bl;
    }
}

