/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.resource;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.EthernetSwitchEtxSlotConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.custparam.EthernetSwitchVlanConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EthernetSwitchProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.AccessLevel;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.MomConverter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEthernetSwitch;
import se.ericsson.wcdma.rbs.bem.common.mim.MimInternalEthernetPort;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.ParentMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class EthernetSwitchRI
extends AbstractResourceItem {
    public static final String name = "EthernetSwitchRI";
    private static final String[] phases = new String[]{"EthernetSwitchCreationPhase"};
    private final List pseudoList = new ArrayList();
    private final List pseudoListSlot = new ArrayList();
    private final List vlanMembershipPseudoList = new ArrayList();
    private final EthernetSwitchProvider ethernetSwitchProvider = (EthernetSwitchProvider)this.rbs.getProvider(EthernetSwitchProvider.class);
    private MoInstance ethernetSwitchMoi;
    private MoInstance internalEthernetPortMoi;
    private MoInstance slotMoi;

    public EthernetSwitchRI(Rbs rbs) {
        super(name, rbs, phases);
    }

    public List createCustomerParameters() throws BemException {
        ArrayList<CustomerParameterImpl> arrayList = new ArrayList<CustomerParameterImpl>();
        this.pseudoList.add("EthernetSwitchvlan");
        CustomerParameterImpl customerParameterImpl = new TrueFalseCustomerParameter("EthernetSwitchvlan");
        MomConverter momConverter = new EthernetSwitchVlanConversion();
        customerParameterImpl.setMomConverter(momConverter);
        customerParameterImpl.setDefaultValue(MimEthernetSwitch.DEFAULT_ENABLEVLAN.toString().toUpperCase());
        arrayList.add(customerParameterImpl);
        this.registerCustomerParameter(customerParameterImpl);
        this.pseudoListSlot.add("EthernetSwitchetxSlot");
        customerParameterImpl = new IntegerParameter("EthernetSwitchetxSlot", new IntegerRange(MimSlot.MIN_SLOTNUMBER, MimSlot.MAX_SLOTNUMBER));
        momConverter = new EthernetSwitchEtxSlotConversion();
        customerParameterImpl.setMomConverter(momConverter);
        customerParameterImpl.setDefaultValue(new Integer(0).toString());
        arrayList.add(customerParameterImpl);
        this.registerCustomerParameter(customerParameterImpl);
        return arrayList;
    }

    public void initiateCPWithNodeValues() throws BemException {
        boolean bl = this.isExisting(this.ethernetSwitchMoi.getLdn());
        if (bl) {
            CustomerParameterServer customerParameterServer;
            BemMo bemMo = this.getMo(this.slotMoi.getLdn());
            String[] stringArray = new String[this.pseudoListSlot.size()];
            CustomerParameterServer[] customerParameterServerArray = new CustomerParameterServer[this.pseudoListSlot.size()];
            Iterator iterator = this.pseudoListSlot.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                customerParameterServer = this.getCustomerParameterServer(string);
                stringArray[n] = customerParameterServer.getAttributeName();
                customerParameterServerArray[n] = customerParameterServer;
                ++n;
            }
            Object[] objectArray = this.getAttributes(bemMo, stringArray);
            for (int i = 0; customerParameterServerArray.length > i; ++i) {
                customerParameterServerArray[i].setLoadedValue(objectArray[i]);
            }
            bemMo = this.getMo(this.ethernetSwitchMoi.getLdn());
            stringArray = new String[this.pseudoList.size() + 1];
            customerParameterServerArray = new CustomerParameterServer[this.pseudoList.size()];
            iterator = this.pseudoList.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                customerParameterServer = this.getCustomerParameterServer(string);
                stringArray[n2] = customerParameterServer.getAttributeName();
                customerParameterServerArray[n2] = customerParameterServer;
                ++n2;
            }
            stringArray[customerParameterServerArray.length] = "vlanMembership";
            Object[] objectArray2 = this.getAttributes(bemMo, stringArray);
            for (int i = 0; customerParameterServerArray.length > i; ++i) {
                customerParameterServerArray[i].setLoadedValue(objectArray2[i]);
            }
            NalStruct[] nalStructArray = (NalStruct[])objectArray2[customerParameterServerArray.length];
            for (int i = 0; i < nalStructArray.length && nalStructArray[0] != null; ++i) {
                NalStruct nalStruct = nalStructArray[i];
                NalNameValue nalNameValue = nalStruct.getMember("egressUntag");
                NalNameValue nalNameValue2 = nalStruct.getMember("vid");
                Integer n3 = (Integer)nalNameValue2.getValue();
                Boolean bl2 = (Boolean)nalNameValue.getValue();
                if (n3 == 0) break;
                CustomerParameterImpl customerParameterImpl = (CustomerParameterImpl)this.ethernetSwitchProvider.createCP("EthernetSwitchVlanMembership_" + n3 + "_vid", n3.toString());
                customerParameterImpl.setLoadedValue(n3);
                CustomerParameterImpl customerParameterImpl2 = (CustomerParameterImpl)this.ethernetSwitchProvider.createCP("EthernetSwitchVlanMembership_" + n3 + "_egressUntag", bl2.toString().toUpperCase());
                customerParameterImpl2.setLoadedValue(bl2);
                CustomerParameterImpl customerParameterImpl3 = (CustomerParameterImpl)this.ethernetSwitchProvider.createCP("EthernetSwitchVlanMembership_" + n3 + "_action", "ADD_MODIFY");
                customerParameterImpl3.setLoadedValue("ADD_MODIFY");
            }
        }
    }

    public boolean isInstalled() throws BemException {
        boolean bl = false;
        if (this.ethernetSwitchMoi != null && this.ethernetSwitchMoi.getLdn() != null) {
            BemMo bemMo = this.getMo(this.ethernetSwitchMoi.getLdn());
            bl = this.isExisting(bemMo);
        }
        return bl;
    }

    public void install(String string) throws BemException {
        if (string.equals("EthernetSwitchCreationPhase")) {
            if (null == this.ethernetSwitchMoi.getLdn()) {
                throw new BemException("EthernetSwitchRIInstall(): There is no valid exchange terminal board associated with this EthernetSwitch. Was there any exchange terminal board that offers IP transport capabilities (ETMFX11 or ETMFX14) installed in Cabinet Wizard?");
            }
            this.installEthernetSwitch();
        }
    }

    private void installEthernetSwitch() throws BemException {
        BemMo bemMo = this.getMo(this.ethernetSwitchMoi.getLdn());
        boolean bl = this.isInstalled();
        if (!bl) {
            NalNameValue[] nalNameValueArray;
            Object object;
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            for (Object object2 : this.pseudoList) {
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject((String)object2);
                object = customerParameterServer.getAttributeName();
                nalNameValueArray = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue((String)object, nalNameValueArray));
            }
            if (this.vlanMembershipPseudoList.size() > 0) {
                Object object2;
                Collections.sort(this.vlanMembershipPseudoList);
                object2 = this.vlanMembershipPseudoList.iterator();
                object = new ArrayList();
                while (object2.hasNext()) {
                    AccessLevel accessLevel;
                    String string;
                    nalNameValueArray = new NalNameValue[2];
                    boolean bl2 = false;
                    if (object2.hasNext()) {
                        string = (String)object2.next();
                        accessLevel = this.rbs.getCustomerParameterObject(string);
                        bl2 = accessLevel.getValue().equals("DELETE");
                    }
                    if (object2.hasNext()) {
                        string = (String)object2.next();
                        accessLevel = this.rbs.getCustomerParameterServerObject(string);
                        nalNameValueArray[0] = Nal.getFactory().getNameValue("egressUntag", accessLevel.getValueMom());
                    }
                    if (object2.hasNext()) {
                        string = (String)object2.next();
                        accessLevel = this.rbs.getCustomerParameterServerObject(string);
                        nalNameValueArray[1] = Nal.getFactory().getNameValue("vid", accessLevel.getValueMom());
                    }
                    if (bl2) continue;
                    object.add(Nal.getFactory().getStruct(nalNameValueArray));
                }
                if (object.size() > 0) {
                    vector.add(Nal.getFactory().getNameValue("vlanMembership", object.toArray(new NalStruct[1])));
                } else {
                    vector.add(Nal.getFactory().getNameValue("vlanMembership", new NalStruct[0]));
                }
            }
            this.create(bemMo, vector);
        } else if (!this.getRbs().getRbsStep().equals("STEP_CABINET")) {
            NalNameValue[] nalNameValueArray;
            Object object;
            Object object3;
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            for (String string : this.pseudoList) {
                object3 = this.rbs.getCustomerParameterServerObject(string);
                boolean bl3 = object3.hasValueChanged();
                if (!bl3) continue;
                object = object3.getAttributeName();
                nalNameValueArray = object3.getValueMom();
                vector.add(Nal.getFactory().getNameValue((String)object, nalNameValueArray));
            }
            boolean bl4 = false;
            if (this.vlanMembershipPseudoList.size() > 0) {
                Collections.sort(this.vlanMembershipPseudoList);
                object3 = this.vlanMembershipPseudoList.iterator();
                object = new ArrayList();
                while (object3.hasNext()) {
                    AccessLevel accessLevel;
                    String string;
                    nalNameValueArray = new NalNameValue[2];
                    boolean bl5 = false;
                    if (object3.hasNext()) {
                        string = (String)object3.next();
                        accessLevel = this.rbs.getCustomerParameterObject(string);
                        bl5 = accessLevel.getValue().equals("DELETE");
                    }
                    if (object3.hasNext()) {
                        string = (String)object3.next();
                        accessLevel = this.rbs.getCustomerParameterServerObject(string);
                        nalNameValueArray[0] = Nal.getFactory().getNameValue("egressUntag", accessLevel.getValueMom());
                        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                        boolean bl6 = customerParameter.hasValueChanged();
                        if (bl6) {
                            bl4 = bl6;
                        }
                    }
                    if (object3.hasNext()) {
                        string = (String)object3.next();
                        accessLevel = this.rbs.getCustomerParameterServerObject(string);
                        boolean bl7 = accessLevel.hasValueChanged();
                        if (bl7) {
                            bl4 = bl7;
                        }
                        nalNameValueArray[1] = Nal.getFactory().getNameValue("vid", accessLevel.getValueMom());
                    }
                    if (bl5) continue;
                    object.add(Nal.getFactory().getStruct(nalNameValueArray));
                }
                if (object.size() > 0) {
                    if (bl4) {
                        vector.add(Nal.getFactory().getNameValue("vlanMembership", object.toArray(new NalStruct[1])));
                    }
                } else {
                    nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("egressUntag", false), Nal.getFactory().getNameValue("vid", new Integer(0))};
                    object.add(Nal.getFactory().getStruct(nalNameValueArray));
                    vector.add(Nal.getFactory().getNameValue("vlanMembership", object.toArray(new NalStruct[1])));
                }
            }
            if (vector.size() > 0) {
                this.setAttributes(bemMo, vector);
            }
        }
    }

    public String getLdn() {
        if (this.ethernetSwitchMoi == null) {
            return null;
        }
        try {
            return this.ethernetSwitchMoi.getLdn();
        }
        catch (BemException bemException) {
            BemLog.log(2, this.getClass() + "getLdn()", bemException);
            return null;
        }
    }

    public String getDisplayName() {
        return name;
    }

    public void checkConsistency() {
    }

    public MoInstance getMoi() {
        return this.ethernetSwitchMoi;
    }

    public List getCustomerParameterNames() {
        return this.pseudoList;
    }

    public void addPseudo(String string) {
        this.vlanMembershipPseudoList.add(string);
    }

    public void removePseudo(String string) {
        this.vlanMembershipPseudoList.remove(string);
    }

    public MoInstance setEtmBoard(MoInstance moInstance) {
        if (moInstance != null) {
            ParentMoi parentMoi = new ParentMoi(moInstance);
            this.slotMoi = new ParentMoi(parentMoi);
            this.ethernetSwitchMoi = new SingleChildMoi(moInstance, MimEthernetSwitch.MOTYPENAME, "1");
            this.internalEthernetPortMoi = new SingleChildMoi(moInstance, MimInternalEthernetPort.MOTYPENAME, "1");
        } else {
            this.ethernetSwitchMoi = null;
            this.internalEthernetPortMoi = null;
            this.slotMoi = null;
        }
        return this.ethernetSwitchMoi;
    }

    public MoInstance getInternalEthernetPortMoi() {
        return this.internalEthernetPortMoi;
    }

    public boolean pseudoIsExisting(String string) {
        boolean bl = false;
        for (String string2 : this.vlanMembershipPseudoList) {
            if (!string2.equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }
}

