/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.iprouting;

import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;

public class DynamicRouteTypesCPManager
implements CustomerParameterListener {
    private Enumeration dynamicRouteTypesCP = null;
    public static final String DEFAULT_ATM_LINK = "Primary default route";
    public static final String REDUNDANT_ATM_LINK = "Secondary default route";
    public static final String SUMMARY_ROUTE = "Summary route";
    public static final String ANY_ROUTE = "Any route";
    private CustomerParameter destIp = null;
    private CustomerParameter subnetMask = null;
    private CustomerParameter nextHop = null;
    private CustomerParameter metric = null;
    private CustomerParameter redistribute = null;

    Enumeration createDynamicRouteTypesCP(String string) {
        String[] stringArray = new String[]{DEFAULT_ATM_LINK, REDUNDANT_ATM_LINK, SUMMARY_ROUTE, ANY_ROUTE};
        this.dynamicRouteTypesCP = new Enumeration(string + "getDefaultValuesFor", stringArray);
        return this.dynamicRouteTypesCP;
    }

    void activateListener(CustomerParameter customerParameter, CustomerParameter customerParameter2, CustomerParameter customerParameter3, CustomerParameter customerParameter4, CustomerParameter customerParameter5) {
        this.destIp = customerParameter;
        this.subnetMask = customerParameter2;
        this.nextHop = customerParameter3;
        this.metric = customerParameter4;
        this.redistribute = customerParameter5;
        this.dynamicRouteTypesCP.addCustomerParameterListener(this);
    }

    void deactivateListener() {
        this.dynamicRouteTypesCP.removeAllCustomerParameterListeners();
        this.destIp = null;
        this.subnetMask = null;
        this.nextHop = null;
        this.metric = null;
        this.redistribute = null;
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (parameterEvent.isValueChanged()) {
            String string = this.dynamicRouteTypesCP.getValue();
            try {
                if (string.equalsIgnoreCase(DEFAULT_ATM_LINK)) {
                    this.destIp.setValue("0.0.0.0");
                    this.subnetMask.setValue("0.0.0.0");
                    this.nextHop.setValue("");
                    this.metric.setValue("100");
                    this.redistribute.setValue("NO");
                } else if (string.equalsIgnoreCase(REDUNDANT_ATM_LINK)) {
                    this.destIp.setValue("0.0.0.0");
                    this.subnetMask.setValue("0.0.0.0");
                    this.nextHop.setValue("");
                    this.metric.setValue("150");
                    this.redistribute.setValue("NO");
                } else if (string.equalsIgnoreCase(SUMMARY_ROUTE)) {
                    this.destIp.setValue("");
                    this.subnetMask.setValue("");
                    this.nextHop.setValue("127.0.0.1");
                    this.metric.setValue("500");
                    this.redistribute.setValue("NO");
                } else if (string.equalsIgnoreCase(ANY_ROUTE)) {
                    this.destIp.setValue("");
                    this.subnetMask.setValue("");
                    this.nextHop.setValue("");
                    this.metric.setValue("");
                    this.redistribute.setValue("NO");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

