/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.iprouting;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.iprouting.RoutingTableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.DynamicCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public class IpRoutingCI
extends AbstractConfigurationItem
implements DynamicCustomerParameterProvider {
    public static final String name = "IpRoutingCI";
    public static final int DYNAMIC_CP_LIST_INDEX_FOR_GET_DEFAULT = 0;
    public static final int DYNAMIC_CP_LIST_INDEX_FOR_DESTINATION_IP = 1;
    public static final int DYNAMIC_CP_LIST_INDEX_FOR_SUBNET_MASK = 2;
    public static final int DYNAMIC_CP_LIST_INDEX_FOR_NEXT_HOP = 3;
    public static final int DYNAMIC_CP_LIST_INDEX_FOR_ROUTE_METRIC = 4;
    public static final int DYNAMIC_CP_LIST_INDEX_FOR_REDISTRIBUTE = 5;
    private boolean isOpen = false;
    RoutingTableRI routingTableRI;

    public IpRoutingCI(Rbs rbs) {
        super(rbs);
    }

    public boolean open() throws BemException {
        boolean bl = true;
        try {
            if (this.isOpen) {
                throw new BemException("IpRoutingCI.open(): Already open");
            }
            this.routingTableRI = new RoutingTableRI(this.getRbs(), this);
            this.isOpen = true;
        }
        catch (BemException bemException) {
            throw bemException;
        }
        catch (Exception exception) {
            throw new BemException("IpRoutingCI.open() got exception=" + exception.toString(), (Throwable)exception);
        }
        return bl;
    }

    public boolean open(ServiceValue serviceValue) throws BemException {
        boolean bl = true;
        try {
            this.open();
            this.setCustomerParameters(serviceValue);
            this.checkConsistency();
        }
        catch (BemException bemException) {
            throw bemException;
        }
        catch (Exception exception) {
            throw new BemException("IpRoutingCI.open(sv) got exception=" + exception.toString());
        }
        return bl;
    }

    public void checkConsistency() throws BemException {
        super.checkConsistency();
        this.routingTableRI.checkConsistency();
    }

    public String getName() {
        return name;
    }

    public ArrayList getNeededRIs() throws BemException {
        ArrayList arrayList = this.getRIsToBeInstalled();
        return arrayList;
    }

    public ArrayList getRIsToBeInstalled() throws BemException {
        ArrayList<RoutingTableRI> arrayList = new ArrayList<RoutingTableRI>();
        if (!this.isOpen) {
            throw new BemException("getRIsToBeInstalled : CI not open");
        }
        this.checkConsistency();
        if (this.routingTableRI.shouldRiBeInstalled()) {
            arrayList.add(this.routingTableRI);
        }
        return arrayList;
    }

    public List getRIsToUninstall() throws BemException {
        ArrayList<RoutingTableRI> arrayList = new ArrayList<RoutingTableRI>();
        if (!this.isOpen) {
            throw new BemException("getRIsToBeUnInstalled : CI not open");
        }
        this.checkConsistency();
        if (this.routingTableRI.shouldRiBeUnInstalled()) {
            arrayList.add(this.routingTableRI);
        }
        return arrayList;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        int n = 0;
        while (true) {
            Integer n2 = new Integer(++n);
            String string = MessageFormat.format("R_{0}_", n2);
            String string2 = serviceValue.getValue(string + "routeIpAddress");
            String string3 = serviceValue.getValue(string + "routeSubnetMask");
            String string4 = serviceValue.getValue(string + "hopIpAddress");
            String string5 = serviceValue.getValue(string + "routeMetric");
            String string6 = serviceValue.getValue(string + "redistribute");
            if (string2 == null || string3 == null || string4 == null || string5 == null || string6 == null) break;
            this.routingTableRI.removeRouteIfExisting(string2, string3, string4, string5, string6);
            List list = this.createCP();
            ((CustomerParameter)list.get(1)).setValue(string2);
            ((CustomerParameter)list.get(2)).setValue(string3);
            ((CustomerParameter)list.get(3)).setValue(string4);
            ((CustomerParameter)list.get(4)).setValue(string5);
            ((CustomerParameter)list.get(5)).setValue(string6);
            this.checkDynamicConsistency();
        }
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public ConfigurationCheckReport checkConfiguration() throws BemException {
        ConfigurationCheckReport configurationCheckReport = new ConfigurationCheckReport();
        return configurationCheckReport;
    }

    public List createCP() throws BemException {
        List list = this.routingTableRI.createCP();
        return list;
    }

    public List createCP(String string) throws BemException {
        List list = this.createCP();
        return list;
    }

    public String removeCP(List list) throws BemException {
        String string = this.routingTableRI.removeCP(list);
        return string;
    }

    public void checkDynamicConsistency() throws BemException {
        this.routingTableRI.checkDynamicConsistency();
    }
}

