/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractCableRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class DigitalCableRI
extends AbstractCableRI {
    private static final String name = "DigitalCable";
    private String objectALdn;
    private int objectAConnector;
    private String objectBLdn;
    private int objectBConnector;
    private int electricalDelay;
    private NalNameValue[] cableAttributes = null;
    private String ldn;

    public DigitalCableRI(Rbs rbs, String string, int n, String string2, int n2, int n3, String string3) throws BemException {
        super(rbs, name);
        this.objectALdn = string;
        this.objectAConnector = n;
        this.objectBLdn = string2;
        this.objectBConnector = n2;
        this.electricalDelay = n3;
        this.ldn = "ManagedElement=1,Equipment=1,DigitalCable=" + string3;
    }

    public static DigitalCableRI getDigitalCableRIForDelete(Rbs rbs, String string) throws BemException {
        DigitalCableRI digitalCableRI = new DigitalCableRI(rbs, string);
        return digitalCableRI;
    }

    private DigitalCableRI(Rbs rbs, String string) throws BemException {
        super(rbs, name);
        this.ldn = string;
    }

    public void install(String string) throws BemException {
        if (string.equals("CabinetCableCreationPhase")) {
            this.checkPreConditions(this.rbs);
            this.performInstall(this.rbs);
        }
    }

    private void checkPreConditions(Rbs rbs) throws BemException {
        Object object;
        boolean bl = false;
        boolean bl2 = false;
        try {
            object = rbs.getMoHandler();
            BemMo bemMo = object.getMo(this.objectALdn);
            BemMo bemMo2 = object.getMo(this.objectBLdn);
            bl = object.isExisting(bemMo);
            bl2 = object.isExisting(bemMo2);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("Could not access node: " + moHandlerException);
        }
        if (!bl || !bl2) {
            object = "B";
            if (!bl) {
                object = "A";
            }
            throw new BemException("Both boards must exist, Object" + (String)object + " does not exist.\n" + "Digital cable: " + this.ldn + " could not be created.\n" + "Object A ldn: " + this.objectALdn + "\n" + "Object B ldn: " + this.objectBLdn);
        }
    }

    private void performInstall(Rbs rbs) throws BemException {
        MoHandler moHandler = rbs.getMoHandler();
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        String string = this.getLdnWithoutDeviceGroup(this.objectALdn);
        BemMo bemMo = moHandler.getMo(string);
        nalNameValue = Nal.getFactory().getNameValue("connectedToObjectARef", bemMo);
        vector.add(nalNameValue);
        String string2 = this.getLdnWithoutDeviceGroup(this.objectBLdn);
        BemMo bemMo2 = moHandler.getMo(string2);
        nalNameValue = Nal.getFactory().getNameValue("connectedToObjectBRef", bemMo2);
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("objectAConnector", new Integer(this.objectAConnector));
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("objectBConnector", new Integer(this.objectBConnector));
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("electricalDelay", new Integer(this.electricalDelay));
        vector.add(nalNameValue);
        nalNameValue = Nal.getFactory().getNameValue("alarmStatus", new Integer(0));
        vector.add(nalNameValue);
        this.createMoIfNotExisting(this.ldn, vector);
        this.setAttributes();
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("CabinetCableDeletionPhase")) {
            this.deleteMoIfNotExisting(this.ldn);
        }
    }

    public String getDisplayName() {
        return "DigitalCable:" + this.ldn;
    }

    public String getLdn() {
        return this.ldn;
    }

    private String getLdnWithoutDeviceGroup(String string) {
        String string2 = string;
        if (!BemUtil.isLdnOfType(string, MimPlugInUnit.MOTYPENAME) && !BemUtil.isLdnOfType(string, MimAuxPlugInUnit.MOTYPENAME)) {
            int n = string.lastIndexOf(",");
            string2 = string.substring(0, n);
        }
        return string2;
    }

    public void setAttributes(NalNameValue[] nalNameValueArray) throws BemException {
        this.cableAttributes = nalNameValueArray;
    }

    private void setAttributes() throws BemException {
        if (this.cableAttributes == null) {
            return;
        }
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        BemMo bemMo = moHandlerImpl.getMo(this.ldn);
        try {
            if (bemMo.isExisting()) {
                moHandlerImpl.setAttributes(bemMo, this.cableAttributes);
            }
        }
        catch (Exception exception) {
            throw new BemException("DigitalCableRI.setAttributes()", "setAttributes()", this.ldn, null, exception);
        }
    }

    public boolean isInstalled() throws BemException {
        boolean bl = super.isInstalled();
        if (bl) {
            try {
                BemMo bemMo;
                MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
                BemMo bemMo2 = moHandlerImpl.getMo(this.ldn);
                BemMo bemMo3 = (BemMo)moHandlerImpl.getAttribute(bemMo2, "connectedToObjectARef");
                BemMo bemMo4 = bemMo = moHandlerImpl.getMo(this.objectALdn);
                if (!bemMo.getType().equals("PlugInUnit")) {
                    bemMo4 = bemMo.getParent();
                }
                boolean bl2 = ((Object)bemMo3).equals(bemMo4);
                BemMo bemMo5 = (BemMo)moHandlerImpl.getAttribute(bemMo2, "connectedToObjectBRef");
                BemMo bemMo6 = moHandlerImpl.getMo(this.objectBLdn);
                BemMo bemMo7 = bemMo6.getParent();
                boolean bl3 = ((Object)bemMo5).equals(bemMo7);
                Integer n = (Integer)moHandlerImpl.getAttribute(bemMo2, "objectAConnector");
                boolean bl4 = n == this.objectAConnector;
                Integer n2 = (Integer)moHandlerImpl.getAttribute(bemMo2, "objectBConnector");
                boolean bl5 = n2 == this.objectBConnector;
                bl = bl2 && bl3 && bl4 && bl5;
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException(moHandlerException.getAction(), moHandlerException.getLdn(), (Throwable)moHandlerException);
            }
        }
        return bl;
    }

    public Object[] getAttributes(String[] stringArray) throws BemException {
        Object[] objectArray;
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        BemMo bemMo = moHandlerImpl.getMo(this.ldn);
        try {
            objectArray = moHandlerImpl.getAttributes(bemMo, stringArray);
        }
        catch (Exception exception) {
            throw new BemException("DigitalCableRI.getAttributes()", "getAttributes()", this.ldn, null, exception);
        }
        return objectArray;
    }
}

