/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;

public class DuwPortUtil {
    static final String[] PRIMARY_PORT_IDS_DUAL_DUW = new String[]{"BU1_A", "BU1_B", "BU1_C", "BU2_A", "BU2_B", "BU2_C"};
    static final String[] PRIMARY_PORT_IDS_SINGLE_DUW = new String[]{"BU1_A", "BU1_B", "BU1_C", "BU1_D", "BU1_E", "BU1_F"};
    static final String[] SECONDARY_PORT_IDS_DUAL_DUW = new String[]{"BU2_A", "BU2_B", "BU2_C", "BU2_D", "BU2_E", "BU2_F"};
    static final String[] SECONDARY_PORT_IDS_SINGLE_DUW = new String[]{"BU1_D", "BU1_E", "BU1_F"};
    static final String[] SECONDARY_PORT_IDS_DUAL_DUW_DBB22 = new String[]{"BU2_A", "BU2_B", "BU2_C", "BU2_D", "BU2_F"};

    private static String formatPortId(String string, String string2) {
        return "BU" + string + "_" + string2;
    }

    public static String getPortIdFromConnectorName(String string, String string2) throws BemException {
        String string3 = "";
        if ("RI_A".equals(string)) {
            string3 = DuwPortUtil.formatPortId(string2, "A");
        } else if ("RI_B".equals(string)) {
            string3 = DuwPortUtil.formatPortId(string2, "B");
        } else if ("RI_C".equals(string)) {
            string3 = DuwPortUtil.formatPortId(string2, "C");
        } else if ("RI_D".equals(string)) {
            string3 = DuwPortUtil.formatPortId(string2, "D");
        } else if ("RI_E".equals(string)) {
            string3 = DuwPortUtil.formatPortId(string2, "E");
        } else if ("RI_F".equals(string)) {
            string3 = DuwPortUtil.formatPortId(string2, "F");
        } else {
            throw new BemException("getPortIdFromConnectorName() can not interprete connectorName. connectorName=" + string);
        }
        return string3;
    }

    public static String getDuwSlotNumberFromPortId(String string) throws BemException {
        String string2 = "";
        if (string.startsWith("BU1")) {
            string2 = "1";
        } else if (string.startsWith("BU2")) {
            string2 = "2";
        } else {
            throw new BemException("getDuwSlotFromPortId() portid can not be resolved. portId=" + string);
        }
        return string2;
    }

    public static String getPrimaryPortIdForRuw(int n, String string) {
        return DuwUtil.hasDualDuws() ? DuwPortUtil.getPrimaryPortIdForRuwDualDuw(n) : DuwPortUtil.getPrimaryPortIdForRuwSingleDuw(n, string);
    }

    private static String getPrimaryPortIdForRuwSingleDuw(int n, String string) {
        String string2 = null;
        if (n <= PRIMARY_PORT_IDS_SINGLE_DUW.length) {
            string2 = RbsInfo.RBS_6501W.NAME.equals(string) ? "BU1_C" : PRIMARY_PORT_IDS_SINGLE_DUW[n - 1];
        } else {
            Nal.getLog().nalTrace(2, DuwPortUtil.class, "Could not get primary port id for single duw, sectorNumber=" + n);
        }
        return string2;
    }

    private static String getPrimaryPortIdForRuwDualDuw(int n) {
        String string = null;
        if (n <= PRIMARY_PORT_IDS_DUAL_DUW.length) {
            string = PRIMARY_PORT_IDS_DUAL_DUW[n - 1];
        } else {
            Nal.getLog().nalTrace(2, DuwPortUtil.class, "Could not get primary port id for dual duw, sectorNumber=" + n);
        }
        return string;
    }

    public static String getCorrespondingDuwPiuLdn(String string) throws BemException {
        String string2 = null;
        if (string.startsWith("BU1")) {
            string2 = DuwUtil.getPrimaryDuwPiuLdn();
        } else if (string.startsWith("BU2")) {
            string2 = DuwUtil.getSecondaryDuwPiuLdn();
        } else {
            throw new BemException("getCorrespondingDuwPiuLdn can not obtain corresponding DUW PIU LDN");
        }
        return string2;
    }

    public static String getSecondaryPortIdForRuw(int n, String string, String string2) {
        String string3 = "";
        if (string.equals("RBB22_2B")) {
            int n2 = n - 1;
            boolean bl = string2.equals("DBB22");
            string3 = DuwUtil.hasDualDuws() ? (bl ? SECONDARY_PORT_IDS_DUAL_DUW_DBB22[n2] : SECONDARY_PORT_IDS_DUAL_DUW[n2]) : SECONDARY_PORT_IDS_SINGLE_DUW[n2];
        }
        return string3;
    }
}

