/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.api;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.Report;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;

public abstract class AbstractInformativeText {
    protected List cpList = new ArrayList();

    public abstract String getHeader();

    protected abstract String[] getContextPrefixes();

    protected abstract String getContextText(String var1);

    public List setCustomerParameters(List list) {
        ArrayList<NalNameValue> arrayList = new ArrayList<NalNameValue>();
        for (NalNameValue nalNameValue : list) {
            String string = nalNameValue.getName();
            boolean bl = this.belongsToThisContext(string);
            if (bl) {
                this.cpList.add(nalNameValue);
                continue;
            }
            arrayList.add(nalNameValue);
        }
        list = this.removeCustomerParameters(list, this.cpList);
        return arrayList;
    }

    public boolean hasData() {
        boolean bl = this.cpList.size() > 0;
        return bl;
    }

    public void appendReport(Report report) {
        Report report2 = this.getInformativeText();
        if (report2.hasData()) {
            report.addHeading(this.getHeader());
            report.addReport(report2);
        }
    }

    public Report getInformativeText() {
        Report report = new Report();
        if (this.cpList.size() > 0) {
            String[] stringArray = this.getContextPrefixes();
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                this.generateText(report, string);
            }
        }
        return report;
    }

    protected void generateText(Report report, String string) {
        Iterator iterator = this.cpList.iterator();
        String string2 = null;
        Report.Table table = null;
        while (iterator.hasNext()) {
            NalNameValue nalNameValue = (NalNameValue)iterator.next();
            String string3 = nalNameValue.getName();
            if (string3.indexOf(string) <= -1) continue;
            String string4 = this.extractPrefixNumber(string, string3);
            string3 = this.removePrefix(string3);
            if (table == null || !string4.equals(string2)) {
                String string5 = this.getContextText(string);
                if (string5 == null || string5.length() == 0) {
                    string5 = string;
                }
                table = report.addTable(string5 + " " + string4);
                string2 = string4;
            }
            table.addRow(string3, (String)nalNameValue.getValue());
        }
    }

    protected boolean belongsToThisContext(String string) {
        String[] stringArray = this.getContextPrefixes();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string.indexOf(string2) <= -1) continue;
            return true;
        }
        return false;
    }

    protected String removePrefix(String string) {
        int n = string.lastIndexOf("_");
        if (n > 0) {
            string = string.substring(n + 1);
        }
        return string;
    }

    protected String extractPrefixNumber(String string, String string2) {
        String string3 = "";
        if (string2.indexOf(string) > -1) {
            String string4 = string2.substring(string2.indexOf(string));
            int n = string4.lastIndexOf("_");
            string3 = string4.substring(string.length(), n);
        }
        return string3;
    }

    protected String formatHeader(String string) {
        StringBuffer stringBuffer = new StringBuffer(string);
        int n = string.length();
        stringBuffer.append("\n");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("=");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    private List removeCustomerParameters(List list, List list2) {
        for (Object e : list2) {
            list.remove(e);
        }
        return list;
    }
}

