/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.api;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.RbsEmPropertiesFileHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ApcConfigurationManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsSteps;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3018.rbs.Rbs3018;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3018duwxcu.rbs.Rbs3018DuwXcu;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3101.rbs.Rbs3101;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3104.rbs.Rbs3104;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3106.rbs.Rbs3106;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3106DuwPantherHybrid.rbs.Rbs3106DuwPantherHybrid;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3106duwxcu.rbs.Rbs3106DuwXcu;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3107.rbs.Rbs3107;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3116.rbs.Rbs3116;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3116duwxcu.rbs.Rbs3116DuwXcu;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3202.rbs.Rbs3202;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3206.rbs.Rbs3206;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3206DuwPantherHybrid.rbs.Rbs3206DuwPantherHybrid;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3206M.rbs.Rbs3206M;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3206Mduwxcu.rbs.Rbs3206MDuwXcu;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3206duwxcu.rbs.Rbs3206DuwXcu;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3216.rbs.Rbs3216;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3216duwxcu.rbs.Rbs3216DuwXcu;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3303.rbs.Rbs3303;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3303.rbs.Rbs3303Cbu;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3308.rbs.Rbs3308;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3402.rbs.Rbs3402;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3412.rbs.Rbs3412;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3418.rbs.Rbs3418;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3512.rbs.Rbs3512;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3518.rbs.Rbs3518;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3609.rbs.Rbs3609Cbu;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3922.rbs.Rbs3922;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3954.rbs.Rbs3954;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3964.rbs.Rbs3964;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3967.rbs.Rbs3967;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3976.rbs.Rbs3976;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3984.rbs.Rbs3984;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3986.rbs.Rbs3986;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6101duw.rbs.Rbs6101Duw;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6102.rbs.Rbs6102;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6102duw.rbs.Rbs6102Duw;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6110duw.rbs.Rbs6110Duw;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6120duw.rbs.Rbs6120Duw;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6131duw.rbs.Rbs6131Duw;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6201.rbs.Rbs6201;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6201duw.rbs.Rbs6201Duw;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6202duw.rbs.Rbs6202Duw;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6301duw.rbs.Rbs6301Duw;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6302duw.rbs.Rbs6302Duw;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6320duw.rbs.Rbs6320Duw;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6501duw.rbs.Rbs6501Duw;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6601duw.rbs.Rbs6601Duw;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.exception.ExceptionProperties;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCabinet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipment;
import se.ericsson.wcdma.rbs.bem.common.mim.MimNodeBFunction;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.moi.HubSubrackMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.BemServiceValue;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceNameValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;
import se.ericsson.wcdma.rbs.bem.common.util.RegressionTestInDesigntestUtils;

public class RbsFactory {
    private static boolean promptUser = true;
    private static final String SELECT_SUBRACK_PRODUCT_NUMBER = "The product number could not be read from the BB subrack (Hub).\nPlease select a product number for the subrack.\n";
    public static final String MP_TYPE_GPB = "GPB";
    public static final String MP_TYPE_CBU = "CBU";
    public static final String MP_TYPE_DUW = "DUW";

    public static Rbs getRbs(MoHandler moHandler, String string) throws BemException {
        return RbsFactory.getRbs(null, moHandler, string);
    }

    public static Rbs getRbs(MoHandler moHandler, String string, BemServiceValue bemServiceValue) throws BemException {
        return RbsFactory.getRbs(null, moHandler, string, bemServiceValue);
    }

    public static Rbs getRbs(MoHandler moHandler, String string, boolean bl) throws BemException {
        return RbsFactory.getRbs(null, moHandler, string, bl, null);
    }

    public static Rbs getRbs(MoHandler moHandler, String string, boolean bl, BemServiceValue bemServiceValue) throws BemException {
        return RbsFactory.getRbs(null, moHandler, string, bl, bemServiceValue);
    }

    public static Rbs getRbs(String string, MoHandler moHandler, String string2) throws BemException {
        return RbsFactory.getRbs(string, moHandler, string2, false, null);
    }

    public static Rbs getRbs(String string, MoHandler moHandler, String string2, BemServiceValue bemServiceValue) throws BemException {
        return RbsFactory.getRbs(string, moHandler, string2, false, bemServiceValue);
    }

    public static Rbs getRbs(String string, MoHandler moHandler, String string2, boolean bl) throws BemException {
        return RbsFactory.getRbs(string, moHandler, string2, bl, null);
    }

    public static Rbs getRbs(String string, MoHandler moHandler, String string2, boolean bl, BemServiceValue bemServiceValue) throws BemException {
        String string3 = string2;
        if (!RbsFactory.validateRbsStep(string3)) {
            throw new BemException("Rbs step=" + string3 + " is not valid.");
        }
        String string4 = RbsFactory.getRojNumber(string3);
        String string5 = string;
        if (string == null) {
            string5 = RbsFactory.getRbsName(string4, string3);
        }
        if (!RbsFactory.validateRbsName(string5)) {
            throw new BemException("Rbs name=" + string5 + " is not valid.");
        }
        string4 = BemUtil.getTrimString(string4);
        Rbs rbs = null;
        rbs = bl ? RbsFactory.getPantherHybridRbs(string5, moHandler, string3, string4) : RbsFactory.getRbs(string5, moHandler, string3, string4);
        RbsFactory.setBackplanePid(rbs, moHandler, string4);
        if (!RbsFactory.doesRbsMatchBackplaneInfo(rbs, string4)) {
            throw new BemException("Rbs does not match backplane info");
        }
        rbs.syncCabinetIdList(bemServiceValue);
        RbsFactory.updateCabinetType(rbs, bemServiceValue, rbs.getCabinetNumberList());
        return rbs;
    }

    private static void updateCabinetType(Rbs rbs, BemServiceValue bemServiceValue, List list) throws BemException {
        Object[] objectArray = list.toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            RbsFactory.createCabinetTypeCP(rbs, Integer.valueOf(objectArray[i].toString()));
        }
        RbsFactory.updateLoadedValue4CabinetType(rbs);
        if (bemServiceValue != null) {
            RbsFactory.updateConfiguredValue4CabinetType(rbs, bemServiceValue);
        }
        Iterator iterator = rbs.getCabinetNumberFromCascadingOrder().iterator();
        if (rbs.getRbsType().equals(RbsInfo.RBS_6601W.NAME)) {
            while (iterator.hasNext()) {
                String string;
                CustomerParameter customerParameter;
                String string2 = iterator.next().toString();
                if (Integer.parseInt(string2) <= 1 || !(customerParameter = rbs.getCustomerParameterObject((string = PrefixUtil.getCabinetPrefix(string2)) + "cabinetType")).getValue().equals("##UNDEFINED")) continue;
                customerParameter.setValue(BemUtil.getCabinetType(rbs.getRbsType()));
            }
        }
    }

    private static void createCabinetTypeCP(Rbs rbs, Integer n) {
        HashMap<Integer, Enumeration> hashMap = new HashMap<Integer, Enumeration>();
        hashMap.put(n, new Enumeration(PrefixUtil.getCabinetPrefix(String.valueOf(n)) + "cabinetType", new EnumeratedRange(ApcConfigurationManager.getApcConfigurationManager().getAllSupportedCabinetTypes())));
        ((Enumeration)hashMap.get(n)).setDefaultValue("##UNDEFINED");
        rbs.registerCustomerParameter((Enumeration)hashMap.get(n));
    }

    private static void updateLoadedValue4CabinetType(Rbs rbs) throws BemException {
        block7: {
            MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
            String string = "##UNDEFINED";
            try {
                BemMo[] bemMoArray = moHandlerImpl.getChildren(moHandlerImpl.getRoot(), 2, MimCabinet.MOTYPENAME, "");
                if (bemMoArray == null || bemMoArray.length <= 0) break block7;
                for (int i = 0; i < bemMoArray.length; ++i) {
                    String string2 = bemMoArray[i].getId();
                    if (Integer.parseInt(string2) == 1) continue;
                    String string3 = PrefixUtil.getCabinetPrefix(string2);
                    NalStruct nalStruct = (NalStruct)moHandlerImpl.getAttribute(bemMoArray[i], "productData");
                    if (nalStruct != null && nalStruct.getSize() > 0) {
                        String string4;
                        try {
                            string4 = (String)nalStruct.getMemberValue("productName");
                        }
                        catch (NoSuchFieldException noSuchFieldException) {
                            throw new BemException(noSuchFieldException);
                        }
                        string = RbsFactory.extractCabinetType(string4);
                    } else {
                        Nal.getLog().nalTrace(1, RbsFactory.class, "The productData does not contain the required attributes. Please check correct attributes is set under cabinet::productData");
                    }
                    CustomerParameterServer customerParameterServer = rbs.getCustomerParameterServerObject(string3 + "cabinetType");
                    customerParameterServer.setLoadedValue(string);
                }
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException(moHandlerException);
            }
        }
    }

    private static String extractCabinetType(String string) {
        String string2 = "##UNDEFINED";
        String[] stringArray = ApcConfigurationManager.getApcConfigurationManager().getAllSupportedCabinetTypes();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringBuffer stringBuffer = new StringBuffer("");
        while (stringTokenizer.hasMoreTokens()) {
            stringBuffer.append(stringTokenizer.nextToken());
        }
        string = stringBuffer.toString().toUpperCase();
        for (int i = 0; i < stringArray.length; ++i) {
            if (string.indexOf(stringArray[i]) == -1) continue;
            string2 = stringArray[i];
            break;
        }
        return string2;
    }

    private static void updateConfiguredValue4CabinetType(Rbs rbs, BemServiceValue bemServiceValue) throws BemException {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        if (bemServiceValue == null) {
            return;
        }
        Vector vector = bemServiceValue.getAttributesStartingWith("CAB");
        for (int i = 0; i < vector.size(); ++i) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)vector.get(i);
            if (!serviceNameValue.getSimpleName().equalsIgnoreCase("cabinetNumber")) continue;
            arrayList.add(new Integer(serviceNameValue.getValueAsString()));
        }
        String[] stringArray = new String[arrayList.size()];
        if (arrayList != null && arrayList.size() > 0) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Integer n = (Integer)arrayList.toArray()[i];
                if (n == 1) continue;
                stringArray[i] = "##UNDEFINED";
                int n2 = Integer.parseInt(arrayList.get(i).toString());
                String string = PrefixUtil.getCabinetPrefix(String.valueOf(n2));
                if (bemServiceValue.getValue(string + "cabinetType") != null) {
                    stringArray[i] = bemServiceValue.getValue(string + "cabinetType");
                }
                if (stringArray[i].equals("##UNDEFINED")) continue;
                rbs.setCustomerParameter(string + "cabinetType", stringArray[i]);
            }
        }
    }

    private static Rbs getPantherHybridRbs(String string, MoHandler moHandler, String string2, String string3) throws BemException {
        if (RbsInfo.RBS_3106.NAME.equalsIgnoreCase(string)) {
            return new Rbs3106DuwPantherHybrid(moHandler, string2);
        }
        if (RbsInfo.RBS_3206.NAME.equalsIgnoreCase(string)) {
            return new Rbs3206DuwPantherHybrid(moHandler, string2);
        }
        throw new BemException("Can not detect the PantherHybridRBS given name=" + string);
    }

    private static Rbs getRbs(String string, MoHandler moHandler, String string2, String string3) throws BemException {
        if (RbsInfo.RBS_3018.NAME.equalsIgnoreCase(string)) {
            if (DuwUtil.hasDuw()) {
                return new Rbs3018DuwXcu(moHandler, string2);
            }
            return new Rbs3018(moHandler, string2);
        }
        if (RbsInfo.RBS_3101.NAME.equalsIgnoreCase(string)) {
            if (string3 != null && BemUtil.getTrimString("ROJ 605 107/1").equalsIgnoreCase(string3)) {
                Rbs3101.setRbs2(true);
            } else {
                Rbs3101.setRbs2(false);
            }
            return new Rbs3101(moHandler, string2);
        }
        if (RbsInfo.RBS_3103.NAME.equalsIgnoreCase(string)) {
            throw new BemException("Can not detect the RBS given name=" + string);
        }
        if (RbsInfo.RBS_3104.NAME.equalsIgnoreCase(string)) {
            return new Rbs3104(moHandler, string2);
        }
        if (RbsInfo.RBS_3106.NAME.equalsIgnoreCase(string)) {
            if (DuwUtil.hasDuw()) {
                return new Rbs3106DuwXcu(moHandler, string2);
            }
            return new Rbs3106(moHandler, string2);
        }
        if (RbsInfo.RBS_3107.NAME.equalsIgnoreCase(string)) {
            return new Rbs3107(moHandler, string2);
        }
        if (RbsInfo.RBS_3116.NAME.equalsIgnoreCase(string)) {
            if (DuwUtil.hasDuw()) {
                return new Rbs3116DuwXcu(moHandler, string2);
            }
            return new Rbs3116(moHandler, string2);
        }
        if (RbsInfo.RBS_3202.NAME.equalsIgnoreCase(string)) {
            if (string3 != null && BemUtil.getTrimString("ROJ 605 107/1").equalsIgnoreCase(string3)) {
                Rbs3202.setRbs2(true);
            } else {
                Rbs3202.setRbs2(false);
            }
            return new Rbs3202(moHandler, string2);
        }
        if (RbsInfo.RBS_3206.NAME.equalsIgnoreCase(string)) {
            if (DuwUtil.hasDuw()) {
                return new Rbs3206DuwXcu(moHandler, string2);
            }
            return new Rbs3206(moHandler, string2);
        }
        if (RbsInfo.RBS_3206M.NAME.equalsIgnoreCase(string)) {
            if (DuwUtil.hasDuw()) {
                return new Rbs3206MDuwXcu(moHandler, string2);
            }
            return new Rbs3206M(moHandler, string2);
        }
        if (RbsInfo.RBS_3216.NAME.equalsIgnoreCase(string)) {
            if (DuwUtil.hasDuw()) {
                return new Rbs3216DuwXcu(moHandler, string2);
            }
            return new Rbs3216(moHandler, string2);
        }
        if (RbsInfo.RBS_3303.NAME.equalsIgnoreCase(string)) {
            if (string3 != null && BemUtil.getTrimString("ROJ 609 46/2").equalsIgnoreCase(string3)) {
                return new Rbs3303Cbu(moHandler, string2);
            }
            return new Rbs3303(moHandler, string2);
        }
        if (RbsInfo.RBS_3308.NAME.equalsIgnoreCase(string)) {
            return new Rbs3308(moHandler, string2);
        }
        if (RbsInfo.RBS_3402.NAME.equalsIgnoreCase(string)) {
            return new Rbs3402(moHandler, string2);
        }
        if (RbsInfo.RBS_3412.NAME.equalsIgnoreCase(string)) {
            return new Rbs3412(moHandler, string2);
        }
        if (RbsInfo.RBS_3418.NAME.equalsIgnoreCase(string)) {
            return new Rbs3418(moHandler, string2);
        }
        if (RbsInfo.RBS_3512.NAME.equalsIgnoreCase(string)) {
            return new Rbs3512(moHandler, string2);
        }
        if (RbsInfo.RBS_3518.NAME.equalsIgnoreCase(string)) {
            return new Rbs3518(moHandler, string2);
        }
        if (RbsInfo.RBS_3609.NAME.equalsIgnoreCase(string)) {
            return new Rbs3609Cbu(moHandler, string2);
        }
        if (RbsInfo.RBS_3922.NAME.equalsIgnoreCase(string)) {
            return new Rbs3922(moHandler, string2);
        }
        if (RbsInfo.RBS_3954.NAME.equalsIgnoreCase(string)) {
            return new Rbs3954(moHandler, string2);
        }
        if (RbsInfo.RBS_3964.NAME.equalsIgnoreCase(string)) {
            return new Rbs3964(moHandler, string2);
        }
        if (RbsInfo.RBS_3967.NAME.equalsIgnoreCase(string)) {
            return new Rbs3967(moHandler, string2);
        }
        if (RbsInfo.RBS_3976.NAME.equalsIgnoreCase(string)) {
            return new Rbs3976(moHandler, string2);
        }
        if (RbsInfo.RBS_3984.NAME.equalsIgnoreCase(string)) {
            return new Rbs3984(moHandler, string2);
        }
        if (RbsInfo.RBS_3986.NAME.equalsIgnoreCase(string)) {
            return new Rbs3986(moHandler, string2);
        }
        if (RbsInfo.RBS_6101W.NAME.equalsIgnoreCase(string)) {
            return new Rbs6101Duw(moHandler, string2);
        }
        if (RbsInfo.RBS_6102W.NAME.equalsIgnoreCase(string)) {
            if (DuwUtil.hasDuw()) {
                return new Rbs6102Duw(moHandler, string2);
            }
            if (string3 != null && BemUtil.getTrimString("ROJ 609 47/1").equalsIgnoreCase(string3)) {
                Rbs6102.setSemiSubrackHardware(true);
                Rbs6102.setMaxNumberOfSectors(3);
                Rbs6102.setMaxNumberOfCarriers(2);
                Rbs6102.setSlotsForCbu("1");
            } else {
                Rbs6102.setSemiSubrackHardware(false);
                Rbs6102.setMaxNumberOfSectors(6);
                Rbs6102.setMaxNumberOfCarriers(4);
                Rbs6102.setSlotsForCbu("1, 24");
            }
            return new Rbs6102(moHandler, string2);
        }
        if (RbsInfo.RBS_6110W.NAME.equalsIgnoreCase(string)) {
            return new Rbs6110Duw(moHandler, string2);
        }
        if (RbsInfo.RBS_6120W.NAME.equalsIgnoreCase(string)) {
            return new Rbs6120Duw(moHandler, string2);
        }
        if (RbsInfo.RBS_6131W.NAME.equalsIgnoreCase(string)) {
            return new Rbs6131Duw(moHandler, string2);
        }
        if (RbsInfo.RBS_6201W.NAME.equalsIgnoreCase(string)) {
            if (DuwUtil.hasDuw()) {
                return new Rbs6201Duw(moHandler, string2);
            }
            return new Rbs6201(moHandler, string2);
        }
        if (RbsInfo.RBS_6201V2W.NAME.equalsIgnoreCase(string)) {
            if (DuwUtil.hasDuw()) {
                return new Rbs6201Duw(moHandler, string2);
            }
            throw new BemException("Can not detect the RBS given name=" + string);
        }
        if (RbsInfo.RBS_6202W.NAME.equalsIgnoreCase(string)) {
            return new Rbs6202Duw(moHandler, string2);
        }
        if (RbsInfo.RBS_6301W.NAME.equalsIgnoreCase(string)) {
            return new Rbs6301Duw(moHandler, string2);
        }
        if (RbsInfo.RBS_6302W.NAME.equalsIgnoreCase(string)) {
            return new Rbs6302Duw(moHandler, string2);
        }
        if (RbsInfo.RBS_6320W.NAME.equalsIgnoreCase(string)) {
            return new Rbs6320Duw(moHandler, string2);
        }
        if (RbsInfo.RBS_6501W.NAME.equalsIgnoreCase(string)) {
            return new Rbs6501Duw(moHandler, string2);
        }
        if (RbsInfo.RBS_6601W.NAME.equalsIgnoreCase(string)) {
            return new Rbs6601Duw(moHandler, string2);
        }
        throw new BemException("Can not detect the RBS given name=" + string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String getRbsName(String string, String string2) throws BemException {
        String string3;
        String string4 = "";
        String string5 = RbsFactory.getRbsProductNameFromNode();
        if (string5.equals("")) {
            if (!string2.equals("STEP_CABINET") && !string2.equals("STEP_MIGRATE_RBS")) {
                if (!promptUser) throw new BemException("Product name could not be fetched from node.");
                string5 = RbsFactory.getRbsProductNameFromUser(string);
            } else {
                string5 = RbsFactory.getDefaultRbsName(string);
            }
        }
        if ((string3 = BemUtil.getTrimString(string5)) == null) throw new BemException("The product name set on the node cannot be handled: " + string5);
        if (!RbsInfo.getRbsProducts().containsKey(string3)) throw new BemException("The product name set on the node cannot be handled: " + string5);
        return string3;
    }

    private static String getRojNumber(String string) throws BemException {
        RbsEmPropertiesFileHandler rbsEmPropertiesFileHandler;
        String string2;
        String string3 = "";
        if (DuwUtil.hasDuw()) {
            string3 = "KDU127161/1";
            return string3;
        }
        if (!RbsFactory.isValidProductNumber(string3)) {
            string3 = RbsFactory.getProdNumberFromOperData();
        }
        if ((string2 = (rbsEmPropertiesFileHandler = RbsEmPropertiesFileHandler.getInstance()).getProperty("HUB_SUBRACK_BACKPLANE_PID")) != null) {
            string3 = string2;
        }
        if (!RbsFactory.isValidProductNumber(string3) && string != null && !string.equals("STEP_CABINET")) {
            string3 = RbsFactory.getProdNumberFromAdminData();
        }
        if (!RbsFactory.isValidProductNumber(string3)) {
            string3 = RbsFactory.getBackplanePid();
        }
        if (!RbsFactory.isValidProductNumber(string3)) {
            if (promptUser) {
                string3 = RbsFactory.getSubrackProductNameFromUser();
            } else {
                return null;
            }
        }
        return string3;
    }

    private static void handleBackplanePid(BemMo bemMo, MoHandler moHandler, String string) throws BemException {
        try {
            String string2 = (String)moHandler.getAttribute(bemMo, "backplanePid");
            string2 = BemUtil.getTrimString(string2);
            if (!string.equals(string2)) {
                moHandler.setAttribute(bemMo, "backplanePid", string);
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException.toString());
        }
    }

    private static void handleBackplanePidDuw(BemMo bemMo, MoHandler moHandler) throws BemException {
        try {
            String string = "DUW_NO_BACKPLANE";
            String string2 = (String)moHandler.getAttribute(bemMo, "backplanePid");
            if (!string.equals(string2)) {
                moHandler.setAttribute(bemMo, "backplanePid", string);
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException.toString());
        }
    }

    private static void setBackplanePid(Rbs rbs, MoHandler moHandler, String string) throws BemException {
        String string2 = rbs.getNodeBFunctionMoi().getLdn();
        BemMo bemMo = moHandler.getMo(string2);
        if (DuwUtil.hasDuw()) {
            RbsFactory.handleBackplanePidDuw(bemMo, moHandler);
        } else {
            RbsFactory.handleBackplanePid(bemMo, moHandler, string);
        }
    }

    private static String getBackplanePid() throws BemException {
        try {
            MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
            RootMoi rootMoi = new RootMoi();
            SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimNodeBFunction.MOTYPENAME, "1");
            BemMo bemMo = moHandlerImpl.getMo(singleChildMoi.getLdn());
            String string = (String)moHandlerImpl.getAttribute(bemMo, "backplanePid");
            string = BemUtil.getTrimString(string);
            return string;
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException.toString());
        }
    }

    private static boolean doesRbsMatchBackplaneInfo(Rbs rbs, String string) {
        boolean bl = false;
        String string2 = rbs.getRbsType();
        String[] stringArray = RbsFactory.getRbsTypesForBackplaneProductNumber(string);
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string2.equals(stringArray[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static String[] getRbsTypes() throws BemException {
        String string = RbsFactory.getRojNumber(null);
        String[] stringArray = RbsFactory.getRbsTypesForBackplaneProductNumber(string);
        return stringArray;
    }

    private static String[] getRbsTypesForBackplaneProductNumber(String string) {
        String[] stringArray = null;
        for (String string2 : RbsInfo.RBS_HW_VERSIONS.keySet()) {
            String string3 = BemUtil.getTrimString(string2);
            if (!string3.equalsIgnoreCase(BemUtil.getTrimString(string))) continue;
            stringArray = (String[])RbsInfo.RBS_HW_VERSIONS.get(string2);
            break;
        }
        return stringArray;
    }

    private static boolean validateRbsStep(String string) {
        boolean bl = false;
        String[] stringArray = RbsSteps.getRbsSteps();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static boolean validateRbsName(String string) {
        return RbsInfo.getRbsProducts().containsKey(string);
    }

    private static String getDefaultRbsName(String string) {
        String string2 = "";
        if (string != null) {
            Set set = RbsInfo.DEFAULT_RBS_HW_VERSIONS.keySet();
            for (String string3 : set) {
                String string4 = BemUtil.getTrimString(string3);
                if (!BemUtil.getTrimString(string).equals(string4)) continue;
                string2 = (String)RbsInfo.DEFAULT_RBS_HW_VERSIONS.get(string3);
                break;
            }
        }
        return string2;
    }

    private static String getProdNumberFromOperData() throws BemException {
        ExceptionProperties exceptionProperties = new ExceptionProperties();
        exceptionProperties.setProperty("Failing Method", "getProdNumberFromOperData()");
        try {
            RootMoi rootMoi = new RootMoi();
            SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimEquipment.MOTYPENAME, "1");
            HubSubrackMoi hubSubrackMoi = new HubSubrackMoi(singleChildMoi);
            String string = hubSubrackMoi.getLdn();
            MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
            Object object = moHandlerImpl.getAttribute(moHandlerImpl.getMo(string), "operationalProductData");
            NalStruct nalStruct = (NalStruct)object;
            NalNameValue[] nalNameValueArray = nalStruct.getNameValueArray();
            String string2 = "";
            if (nalNameValueArray != null && nalNameValueArray.length > 0) {
                NalNameValue nalNameValue = nalStruct.getMember("productNumber");
                string2 = (String)nalNameValue.getValue();
            }
            return string2;
        }
        catch (Exception exception) {
            throw new BemException("Failed in getProdNumberFromOperData", exceptionProperties, (Throwable)exception);
        }
    }

    private static String getProdNumberFromAdminData() throws BemException {
        ExceptionProperties exceptionProperties = new ExceptionProperties();
        exceptionProperties.setProperty("Failing Method", "getProdNumberFromAdminData()");
        try {
            RootMoi rootMoi = new RootMoi();
            SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimEquipment.MOTYPENAME, "1");
            HubSubrackMoi hubSubrackMoi = new HubSubrackMoi(singleChildMoi);
            String string = hubSubrackMoi.getLdn();
            MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
            Object object = moHandlerImpl.getAttribute(moHandlerImpl.getMo(string), "administrativeProductData");
            NalStruct nalStruct = (NalStruct)object;
            String string2 = "";
            NalNameValue[] nalNameValueArray = nalStruct.getNameValueArray();
            if (nalNameValueArray != null && nalNameValueArray.length > 0) {
                NalNameValue nalNameValue = nalStruct.getMember("productNumber");
                string2 = (String)nalNameValue.getValue();
            }
            return string2;
        }
        catch (Exception exception) {
            throw new BemException("Failed in getProdNumberFromAdminData", exceptionProperties, (Throwable)exception);
        }
    }

    private static boolean isValidProductNumber(String string) {
        if (string == null) {
            return false;
        }
        boolean bl = false;
        for (String string2 : RbsInfo.RBS_HW_VERSIONS.keySet()) {
            if (!(string2 = BemUtil.getTrimString(string2)).equalsIgnoreCase(BemUtil.getTrimString(string))) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private static String getRbsProductNameFromNode() throws BemException {
        String string = "";
        try {
            RootMoi rootMoi = new RootMoi();
            MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
            BemMo bemMo = moHandlerImpl.getMo(rootMoi.getLdn());
            string = (String)moHandlerImpl.getAttribute(bemMo, "productName");
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException.toString());
        }
        return string;
    }

    private static String getSubrackProductNameFromUser() throws BemException {
        Class[] classArray;
        Object object;
        Object object2;
        Object object3;
        if (!Nal.executesOnClient()) {
            throw new BemException("System.getProperty", "RbsFactory.getSubrackProductNameFromUser", null, "Subrack Production Name can not be fetched from node!", null);
        }
        TreeMap treeMap = RbsInfo.RBS_HW_VERSIONS_TEXT_GPB_CV;
        try {
            object3 = RbsFactory.getMpType();
            if (((String)object3).equals(MP_TYPE_CBU)) {
                treeMap = RbsInfo.RBS_HW_VERSIONS_TEXT_CBU_CV;
            }
        }
        catch (MoHandlerException moHandlerException) {
            // empty catch block
        }
        object3 = new HashMap(0);
        String[] stringArray = new String[treeMap.size()];
        Set set = treeMap.entrySet();
        Iterator iterator = set.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            object2 = iterator.next();
            object = (String)object2.getKey();
            classArray = (Class[])object2.getValue();
            ((HashMap)object3).put(classArray, object);
            stringArray[n++] = classArray;
        }
        try {
            object2 = Class.forName("javax.swing.Icon");
            object = Class.forName("java.awt.Component");
            classArray = new Class[]{object, Object.class, String.class, Integer.TYPE, object2, Object[].class, Object.class};
            Class<?> clazz = Class.forName("javax.swing.JOptionPane");
            Method method = clazz.getMethod("showInputDialog", classArray);
            Object[] objectArray = new Object[]{null, SELECT_SUBRACK_PRODUCT_NUMBER, "Subrack Product Number", new Integer(1), null, stringArray, null};
            String string = (String)method.invoke((Object)new RbsFactory(), objectArray);
            String string2 = (String)((HashMap)object3).get(string);
            return string2;
        }
        catch (Exception exception) {
            throw new BemException("showInputDialog", "RbsFactory.getSubrackProductNameFromUser", null, "Trying to use JOptionPane.showInputDialog", exception);
        }
    }

    public static String getMpType() throws MoHandlerException, BemException {
        String string = MP_TYPE_GPB;
        if (DuwUtil.hasDuw()) {
            string = MP_TYPE_DUW;
        } else {
            MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
            RootMoi rootMoi = new RootMoi();
            SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimEquipment.MOTYPENAME, "1");
            HubSubrackMoi hubSubrackMoi = new HubSubrackMoi(singleChildMoi);
            String string2 = hubSubrackMoi.getLdn();
            BemMo bemMo = moHandlerImpl.getMo(string2);
            BemMo[] bemMoArray = moHandlerImpl.getChildren(bemMo, 2, MimPlugInUnit.MOTYPENAME, "");
            if (bemMoArray != null && bemMoArray.length > 0) {
                for (int i = 0; i < bemMoArray.length; ++i) {
                    BemMo bemMo2 = bemMoArray[i];
                    BemMo bemMo3 = (BemMo)moHandlerImpl.getAttribute(bemMo2, "piuType");
                    NalStruct nalStruct = (NalStruct)moHandlerImpl.getAttribute(bemMo3, "productData");
                    try {
                        String string3 = (String)nalStruct.getMemberValue("productName");
                        if (!string3.startsWith(MP_TYPE_CBU)) continue;
                        string = MP_TYPE_CBU;
                        break;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
            }
        }
        return string;
    }

    private static String getRbsProductNameFromUser(String string) throws BemException {
        if (RegressionTestInDesigntestUtils.getRegressionTest() || !Nal.executesOnClient()) {
            throw new BemException("System.getProperty", "RbsFactory.getSubrackProductNameFromUser", null, "Product name could not be fetched from node.", null);
        }
        String[] stringArray = RbsFactory.getRbsTypesForBackplaneProductNumber(string);
        try {
            Class<?> clazz = Class.forName("javax.swing.Icon");
            Class<?> clazz2 = Class.forName("java.awt.Component");
            Class[] classArray = new Class[]{clazz2, Object.class, String.class, Integer.TYPE, clazz, Object[].class, Object.class};
            Class<?> clazz3 = Class.forName("javax.swing.JOptionPane");
            Method method = clazz3.getMethod("showInputDialog", classArray);
            Object[] objectArray = new Object[]{null, SELECT_SUBRACK_PRODUCT_NUMBER, "Subrack Product Number", new Integer(3), null, stringArray, null};
            String string2 = (String)method.invoke((Object)new RbsFactory(), objectArray);
            return string2;
        }
        catch (Exception exception) {
            throw new BemException("showInputDialog", "RbsFactory.getSubrackProductNameFromUser", null, "Trying to use JOptionPane.showInputDialog().", exception);
        }
    }

    public static void setPromptUser(boolean bl) {
        promptUser = bl;
    }
}

