/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.common;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AntennaSystemTmaCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.duwrbb.AntennaSystemDuwRbbCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.AtmAndPtCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.CellAndCarrierCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.duwrbb.CellAndCarrierDuwRbbCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.etmboard.EtmBoardDuwCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm.XalmCI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.common.AbstractRbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public abstract class AbstractPantherHybridRbs
extends AbstractRbs {
    public AbstractPantherHybridRbs(MoHandler moHandler, String string) {
        super(moHandler, string);
    }

    protected void createAllConfigurationItems() {
        this.registerConfigItem(new EtmBoardDuwCI(this), 0);
        this.registerConfigItem(new XalmCI(this, false, false), 0);
        this.registerConfigItem(new AtmAndPtCI(this), 0);
        this.registerConfigItem(new CellAndCarrierCI(this), 0);
        this.registerConfigItem(new CellAndCarrierDuwRbbCI((Rbs)this, 7), 1);
        this.registerConfigItem(new AntennaSystemTmaCI(this, false), 0);
        this.registerConfigItem(new AntennaSystemDuwRbbCI((Rbs)this, false, 7), 1);
    }

    public int getMaxNumberOfCarriers() {
        return 4;
    }

    public int getMaxNumberOfSectors() {
        return 12;
    }

    public String getSlotsForCbu() {
        return "";
    }

    public boolean isChoiceOfRadioIfTypeSupported() {
        return true;
    }

    public boolean isPantherHybridRbs() {
        return true;
    }

    public void checkConsistency(String string) throws BemException {
        super.checkConsistency(string, 0);
        if (super.isConfigurationItemSupported(string, 1)) {
            super.checkConsistency(string, 1);
        }
    }

    public void checkConsistency(String string, List list) throws BemException, CustomerParameterException {
        super.checkConsistency(string, list, 0);
        if (super.isConfigurationItemSupported(string, 1)) {
            super.checkConsistency(string, list, 1);
        }
    }

    public ArrayList getRIsToInstall() throws BemException {
        ArrayList arrayList = super.getRIsToInstall(0);
        ArrayList arrayList2 = super.getRIsToInstall(1);
        if (arrayList2 != null) {
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public List getRIsToUninstall() throws BemException {
        List list = super.getRIsToUninstall(0);
        List list2 = super.getRIsToUninstall(1);
        if (list2 != null) {
            list.addAll(list2);
        }
        return list;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        super.setCustomerParameters(serviceValue, 0);
        super.setCustomerParameters(serviceValue, 1);
    }

    public String[] getConfigurationCheckReport() throws BemException {
        String[] stringArray = super.getConfigurationCheckReport(0);
        String[] stringArray2 = super.getConfigurationCheckReport(1);
        if (stringArray != null && stringArray.length > 0 && stringArray2 == null) {
            return stringArray;
        }
        if (stringArray == null && stringArray2 != null && stringArray2.length > 0) {
            return stringArray2;
        }
        if (stringArray != null && stringArray2 != null) {
            int n = stringArray.length;
            int n2 = stringArray2.length;
            int n3 = n + n2;
            String[] stringArray3 = new String[n3];
            System.arraycopy(stringArray, 0, stringArray3, 0, n);
            System.arraycopy(stringArray2, 0, stringArray3, n, n2);
            return stringArray3;
        }
        return null;
    }
}

