/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.resource.util;

import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimHwUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;

public class UnlockAllPiusRI
extends AbstractResourceItem {
    private static final String name = "UNLOCK_ALL_PIU";
    private static final String[] myInstallationPhases = new String[]{"UnlockAllUnitsPhase"};
    private static final int PLUG_IN_UNIT_TRAVERSE_LEVEL = 3;
    private static final int AUX_PLUG_IN_UNIT_TRAVERSE_LEVEL = 3;
    private static final int HW_UNIT_TRAVERSE_LEVEL = 1;

    public UnlockAllPiusRI(Rbs rbs) {
        super(name, rbs, myInstallationPhases);
    }

    public void install(String string) throws BemException {
        try {
            if (string.equals(myInstallationPhases[0])) {
                this.unlockPlugInUnits();
                this.unlockAuxPlugInUnits();
                this.unlockHwUnits();
            }
        }
        catch (Exception exception) {
            String string2 = "install()";
            String string3 = exception.toString();
            throw new BemException(string2, "install()", name, string3, exception);
        }
    }

    private void unlockPlugInUnits() throws BemException {
        int n = 3;
        BemMo bemMo = this.getMo(BemLdn.LDN_EQUIPMENT);
        BemMo[] bemMoArray = this.getChildren(bemMo, n, MimPlugInUnit.MOTYPENAME, "");
        if (bemMoArray != null && bemMoArray.length > 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                this.unlock(bemMoArray[i], "administrativeState");
            }
        }
    }

    private void unlockAuxPlugInUnits() throws BemException {
        int n = 3;
        BemMo bemMo = this.getMo(BemLdn.LDN_EQUIPMENT);
        BemMo[] bemMoArray = this.getChildren(bemMo, n, MimAuxPlugInUnit.MOTYPENAME, "");
        if (bemMoArray != null && bemMoArray.length > 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                this.unlock(bemMoArray[i], "administrativeState");
            }
        }
    }

    private void unlockHwUnits() throws BemException {
        int n = 1;
        BemMo bemMo = this.getMo(BemLdn.LDN_EQUIPMENT);
        BemMo[] bemMoArray = this.getChildren(bemMo, n, MimHwUnit.MOTYPENAME, "");
        if (bemMoArray != null && bemMoArray.length > 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                this.unlock(bemMoArray[i], "administrativeState");
            }
        }
    }

    private void unlock(BemMo bemMo, String string) throws BemException {
        Integer n = (Integer)this.getAttribute(bemMo, string);
        if (n != null && n == 0) {
            this.setAttribute(bemMo, string, (Object)new Integer(1));
        }
    }

    public String getDisplayName() {
        return name;
    }

    public String getLdn() {
        return "";
    }
}

