/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ListParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ListRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComponent;

public class CustomerParameterComboBox
extends JComboBox
implements CustomerParameterListener,
CustomerParameterComponent {
    private final CustomerParameter customerParameter;
    private ActionListener listener;

    public CustomerParameterComboBox(Enumeration enumeration) {
        this.customerParameter = enumeration;
        this.setUpCombobox();
        this.listener = new InputListener();
        this.addActionListener(this.listener);
        enumeration.addCustomerParameterListener(this);
    }

    public CustomerParameterComboBox(ListParameter listParameter) {
        this.customerParameter = listParameter;
        this.setUpCombobox();
        listParameter.addCustomerParameterListener(this);
    }

    public CustomerParameter getCustomerParameter() {
        return this.customerParameter;
    }

    protected void setUpCombobox() {
        ListRange listRange;
        ParameterRange parameterRange;
        ParameterRange parameterRange2;
        Object object;
        if (this.customerParameter == null) {
            System.out.println("Error: Customer parameter not set for: " + this.getClass().getName());
            return;
        }
        Object[] objectArray = null;
        ParameterRange parameterRange3 = this.customerParameter.getEnabledValueRange();
        if (parameterRange3 instanceof EnumeratedRange) {
            object = ((EnumeratedRange)parameterRange3).getRangeValues();
            objectArray = object.toArray(new Object[0]);
        } else if (parameterRange3 instanceof ListRange && this.customerParameter instanceof ListParameter && (parameterRange2 = ((CustomerParameterImpl)(object = (ListParameter)this.customerParameter)).getEnabledValueRange()) instanceof ListRange && (parameterRange = (listRange = (ListRange)parameterRange2).getElementRange()) instanceof IntegerRange) {
            IntegerRange integerRange = (IntegerRange)parameterRange;
            Integer[] integerArray = integerRange.getMinValues();
            Integer[] integerArray2 = integerRange.getMaxValues();
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < integerArray.length; ++i) {
                for (int j = integerArray[i].intValue(); j <= integerArray2[i]; ++j) {
                    arrayList.add(String.valueOf(j));
                }
            }
            objectArray = arrayList.toArray(new Object[0]);
        }
        int n = this.customerParameter.getAccessLevel();
        if (n == 1) {
            objectArray = new String[]{"-"};
        } else if (n == 0) {
            super.setEnabled(false);
        }
        this.removeActionListener(this.listener);
        super.removeAllItems();
        for (int i = 0; i < objectArray.length; ++i) {
            super.addItem(objectArray[i]);
        }
        this.addActionListener(this.listener);
        String string = this.customerParameter.getValue();
        if (string != null) {
            this.setSelectedItem(string);
        }
    }

    protected void addListenerToCustomerParameters(Object[][] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < objectArray[i].length; ++j) {
                Object object = objectArray[i][j];
                if (!(object instanceof CustomerParameter)) continue;
                CustomerParameter customerParameter = (CustomerParameter)object;
                customerParameter.addCustomerParameterListener(this);
            }
        }
    }

    public void updateCpValue() {
        Object object = this.getSelectedItem();
        try {
            this.customerParameter.setValue((String)object);
        }
        catch (Exception exception) {
            System.out.println("Error: Update customer parameter not possible: " + this.getClass().getName());
        }
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        this.setUpCombobox();
        this.repaint();
    }

    private class InputListener
    implements ActionListener {
        private InputListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CustomerParameterComboBox.this.updateCpValue();
        }
    }
}

