/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterCheckbox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComponent;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterEditorFactory;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTableModel;
import se.ericsson.wcdma.rbs.bem.common.gui.TableFocusLostListener;

public class CustomerParameterTable
extends JTable
implements CustomerParameterListener,
TableFocusLostListener,
CustomerParameterComponent {
    private CustomerParameter customerParameter = null;
    private List focusListeners = new ArrayList();
    private boolean tableContainsRowNames = false;
    private boolean areAllCellsNotEditable = false;
    private HashMap editors = new HashMap();

    public CustomerParameterTable(CustomerParameterTableModel customerParameterTableModel) {
        this(customerParameterTableModel, false);
    }

    public CustomerParameterTable(CustomerParameterTableModel customerParameterTableModel, boolean bl) {
        super(customerParameterTableModel);
        this.areAllCellsNotEditable = bl;
        this.customerParameter = customerParameterTableModel.getCustomerParameter();
        if (this.customerParameter != null) {
            this.customerParameter.addCustomerParameterListener(this);
        }
        this.init();
    }

    public CustomerParameterTable(Vector vector, Vector vector2) {
        super(vector, vector2);
        this.addListenerToCustomerParameters(vector);
        this.init();
    }

    public CustomerParameterTable(Object[][] objectArray, String[] stringArray) {
        super(objectArray, stringArray);
        this.addListenerToCustomerParameters(objectArray);
        this.init();
    }

    public CustomerParameterTable(Object[][] objectArray, String[] stringArray, String[] stringArray2) {
        super(objectArray, stringArray2);
        this.updateTableData(objectArray, stringArray, stringArray2);
        this.addListenerToCustomerParameters(objectArray);
        this.init();
    }

    private void init() {
        this.setRowHeight(this.getFont().getSize() + 10);
        this.setPreferredScrollableViewportSize(this.calculatePreferredScrollableViewportSize());
        this.setSelectionMode(0);
        this.getTableHeader().setReorderingAllowed(false);
        this.setRowSelectionAllowed(false);
        this.setColumnSelectionAllowed(false);
        this.setHeaderColumnWidth();
        super.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
    }

    public void registerCellEditor(String string, TableCellEditor tableCellEditor) {
        this.editors.put(string, tableCellEditor);
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        this.notifyFocusListeners();
        Object object = this.getValueAt(n, n2);
        if (object != null && object instanceof CustomerParameter) {
            CustomerParameter customerParameter = (CustomerParameter)object;
            TableCellEditor tableCellEditor = (TableCellEditor)this.editors.get(customerParameter.getClass().getName());
            if (tableCellEditor == null) {
                tableCellEditor = CustomerParameterEditorFactory.getTableCellEditor(customerParameter);
            }
            return tableCellEditor;
        }
        return super.getCellEditor(n, n2);
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        Object object = this.getValueAt(n, n2);
        TableCellRenderer tableCellRenderer = new DefaultTableCellRenderer();
        if (this.tableContainsRowNames && n2 == 0) {
            JLabel jLabel = (JLabel)((Object)super.getCellRenderer(n, n2));
            jLabel.setHorizontalAlignment(0);
            tableCellRenderer = (TableCellRenderer)((Object)jLabel);
        } else if (object != null && object instanceof CustomerParameter) {
            CustomerParameter customerParameter = (CustomerParameter)object;
            tableCellRenderer = this.areAllCellsNotEditable ? CustomerParameterEditorFactory.getTableCellRenderer(customerParameter, this.areAllCellsNotEditable) : CustomerParameterEditorFactory.getTableCellRenderer(customerParameter);
        } else {
            return super.getCellRenderer(n, n2);
        }
        return tableCellRenderer;
    }

    public boolean isCellEditable(int n, int n2) {
        if (this.areAllCellsNotEditable) {
            return false;
        }
        boolean bl = true;
        if (this.tableContainsRowNames && n2 == 0) {
            bl = false;
        } else if (this.getValueAt(n, n2) == null) {
            bl = false;
        } else {
            TableModel tableModel = this.getModel();
            if (tableModel instanceof CustomerParameterTableModel) {
                return tableModel.isCellEditable(n, n2);
            }
        }
        return bl;
    }

    public void setCustomerParameter(CustomerParameter customerParameter) {
        this.customerParameter = customerParameter;
    }

    public CustomerParameter getCustomerParameter() {
        return this.customerParameter;
    }

    private void setHeaderColumnWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        TableColumn tableColumn = this.getColumn(this.getColumnName(0));
        int n = tableColumn.getWidth();
        for (int i = 0; i < this.getRowCount(); ++i) {
            String string = null;
            try {
                string = (String)this.getValueAt(i, 0);
                int n2 = fontMetrics.stringWidth(string);
                if (n2 <= n) continue;
                n = n2;
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        tableColumn.setMinWidth(n);
    }

    public Dimension calculatePreferredScrollableViewportSize(int n) {
        int n2 = this.getRowHeight();
        int n3 = this.getColumnCount();
        int n4 = n2 * n;
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            n5 += this.getColumn(this.getColumnName(0)).getWidth();
        }
        return new Dimension(n5, n4);
    }

    private Dimension calculatePreferredScrollableViewportSize() {
        return this.calculatePreferredScrollableViewportSize(this.getRowCount());
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        this.repaint();
    }

    protected void addListenerToCustomerParameters(Vector vector) {
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            Object e = enumeration.nextElement();
            if (!(e instanceof CustomerParameter)) continue;
            CustomerParameter customerParameter = (CustomerParameter)e;
            customerParameter.addCustomerParameterListener(this);
        }
    }

    protected void addListenerToCustomerParameters(Object[][] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            for (int j = 0; j < objectArray[i].length; ++j) {
                Object object = objectArray[i][j];
                if (!(object instanceof CustomerParameter)) continue;
                CustomerParameter customerParameter = (CustomerParameter)object;
                customerParameter.addCustomerParameterListener(this);
            }
        }
    }

    public void removeListeners(Object[][] objectArray) {
        if (objectArray != null && objectArray.length > 0 && objectArray[0].length > 0) {
            for (int i = 0; i < objectArray.length; ++i) {
                for (int j = 0; j < objectArray[i].length; ++j) {
                    Object object = objectArray[i][j];
                    if (!(object instanceof CustomerParameter)) continue;
                    CustomerParameter customerParameter = (CustomerParameter)object;
                    customerParameter.removeCustomerParameterListener(this);
                }
            }
        }
    }

    private void updateTableData(Object[][] objectArray, String[] stringArray, String[] stringArray2) {
        if (objectArray != null && stringArray != null && objectArray.length == stringArray.length) {
            int n = objectArray.length;
            this.tableContainsRowNames = true;
            Object[][] objectArray2 = new Object[n][objectArray[0].length + 1];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < objectArray2[i].length; ++j) {
                    objectArray2[i][j] = j == 0 ? stringArray[i] : objectArray[i][j - 1];
                }
            }
            if (stringArray2.length > 0 && stringArray2[0].equals("")) {
                stringArray2[0] = " ";
            }
            DefaultTableModel defaultTableModel = new DefaultTableModel(objectArray2, stringArray2);
            super.setModel(defaultTableModel);
        }
    }

    public void reArrangeTable(Object[][] objectArray, String[] stringArray, String[] stringArray2) {
        this.updateTableData(objectArray, stringArray, stringArray2);
        this.addListenerToCustomerParameters(objectArray);
        this.setPreferredScrollableViewportSize(this.calculatePreferredScrollableViewportSize());
    }

    public void setFocusOnCell(String string) {
        int n = this.getColumnCount();
        int n2 = this.getRowCount();
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                CustomerParameter customerParameter;
                String string2;
                Object object = super.getValueAt(j, i);
                if (!(object instanceof CustomerParameter) || !(string2 = (customerParameter = (CustomerParameter)object).getName()).equals(string)) continue;
                final int n3 = i;
                final int n4 = j;
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        CustomerParameterTable.this.requestFocus();
                        CustomerParameterTable.this.changeSelection(n4, n3, false, false);
                        CustomerParameterTable.this.editCellAt(n4, n3);
                        Component component = CustomerParameterTable.this.getEditorComponent();
                        if (component != null) {
                            component.requestFocus();
                        }
                    }
                });
                i = n;
                continue block0;
            }
        }
    }

    public String getRowAndColumnName(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.getColumnCount();
        int n2 = this.getRowCount();
        block0: for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                CustomerParameter customerParameter;
                String string2;
                Object object = super.getValueAt(j, i);
                if (!(object instanceof CustomerParameter) || !(string2 = (customerParameter = (CustomerParameter)object).getName()).equals(string)) continue;
                int n3 = j;
                Object object2 = this.columnModel.getColumn(i).getHeaderValue();
                String string3 = "";
                if (this.tableContainsRowNames) {
                    string3 = (String)this.getValueAt(n3, 0);
                }
                stringBuffer.append(string3).append(", ").append(object2.toString());
                i = n;
                continue block0;
            }
        }
        return stringBuffer.toString();
    }

    public boolean isParameterInTable(String string) {
        int n = this.getColumnCount();
        int n2 = this.getRowCount();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                CustomerParameter customerParameter;
                String string2;
                Object object = super.getValueAt(j, i);
                if (!(object instanceof CustomerParameter) || !(string2 = (customerParameter = (CustomerParameter)object).getName()).equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public void addFocusLostListener(TableFocusLostListener tableFocusLostListener) {
        this.focusListeners.add(tableFocusLostListener);
    }

    public void focusLost(CustomerParameterTable customerParameterTable) {
        this.editingStopped(new ChangeEvent(this));
    }

    public void notifyFocusListeners() {
        for (TableFocusLostListener tableFocusLostListener : this.focusListeners) {
            tableFocusLostListener.focusLost(this);
        }
    }

    public void addStopEditingListener(CustomerParameterCheckbox customerParameterCheckbox) {
        customerParameterCheckbox.addTableStopEditingListener(new StopEditingListener());
    }

    private class StopEditingListener
    implements CustomerParameterCheckbox.StopTableEditingListener {
        public void stopEdit() {
            CustomerParameterTable.this.editingStopped(new ChangeEvent(this));
        }
    }
}

