/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui.components;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JComboBox;
import se.ericsson.wcdma.rbs.bem.common.gui.components.AbstractGenLabelledField;
import se.ericsson.wcdma.support.gui.gengui.SyntaxException;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;

class GenComboBox
extends AbstractGenLabelledField
implements ItemListener {
    private JComboBox boxes = null;
    private int width = 0;
    private ActionListener al = null;
    private String aCommand = null;
    private String[] unsorted = null;
    private String[] sorted = null;
    private boolean sortingOn = true;

    public GenComboBox(String string, String string2, String[] stringArray, boolean bl) {
        super(string, string2);
        Log.traceFlow();
        this.sortingOn = bl;
        this.unsorted = stringArray;
        this.copyAndSort(stringArray);
        this.boxes = new JComboBox();
        for (int i = 0; i < this.sorted.length; ++i) {
            this.boxes.addItem(this.sorted[i]);
        }
        this.boxes.addItemListener(this);
        if (this.boxes.getItemCount() > 0) {
            this.boxes.setSelectedIndex(0);
        }
        this.add(this.boxes);
    }

    public GenComboBox(String string, String string2, String[] stringArray) {
        this(string, string2, stringArray, true);
    }

    public GenComboBox(String string, String[] stringArray, boolean bl) {
        super(string);
        Log.trace("Constructor()");
        this.sortingOn = bl;
        this.unsorted = stringArray;
        this.copyAndSort(stringArray);
        this.boxes = new JComboBox();
        for (int i = 0; i < this.sorted.length; ++i) {
            this.boxes.addItem(this.sorted[i]);
        }
        if (this.boxes.getItemCount() > 0) {
            this.boxes.setSelectedIndex(0);
        }
        this.boxes.addItemListener(this);
        this.add(this.boxes);
    }

    public GenComboBox(String string, String[] stringArray) {
        this(string, stringArray, true);
    }

    public void setActionListener(ActionListener actionListener, String string) {
        this.al = actionListener;
        this.aCommand = string;
    }

    public void setWidth(int n) {
        Dimension dimension = this.boxes.getPreferredSize();
        dimension.width = n;
        this.width = n;
        this.boxes.setPreferredSize(dimension);
    }

    public void removeAllItems() {
        if (this.boxes.getItemCount() > 0) {
            this.boxes.removeAllItems();
            this.unsorted = null;
            this.sorted = null;
        }
    }

    public void addItems(String[] stringArray) {
        int n;
        this.boxes.removeItemListener(this);
        if (this.unsorted == null) {
            this.unsorted = stringArray;
        } else {
            int n2;
            this.boxes.removeAllItems();
            n = stringArray.length + this.unsorted.length;
            String[] stringArray2 = this.unsorted;
            this.unsorted = new String[n];
            for (n2 = 0; n2 < stringArray2.length; ++n2) {
                this.unsorted[n2] = stringArray2[n2];
            }
            for (n2 = stringArray2.length; n2 < n; ++n2) {
                this.unsorted[n2] = stringArray[n2 - stringArray2.length];
            }
        }
        this.copyAndSort(this.unsorted);
        for (n = 0; n < this.sorted.length; ++n) {
            this.boxes.addItem(this.sorted[n]);
        }
        if (this.boxes.getSelectedIndex() == -1 && this.boxes.getItemCount() > 0) {
            this.boxes.setSelectedIndex(0);
        }
        if (this.width != 0) {
            this.setWidth(this.width);
        }
        this.boxes.addItemListener(this);
    }

    public void setValue(String string) throws SyntaxException {
        Log.trace("setValue()");
        boolean bl = false;
        this.boxes.removeItemListener(this);
        this.boxes.setSelectedItem(string);
        this.boxes.addItemListener(this);
        if (bl) {
            throw new SyntaxException();
        }
    }

    public String getValue() {
        Log.trace("getValue()");
        return (String)this.boxes.getSelectedItem();
    }

    public int getSelectedIndex() {
        String string = this.getValue();
        for (int i = 0; i < this.unsorted.length; ++i) {
            if (!this.unsorted[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public Object getFieldComponent() {
        Log.trace("getFieldComponent()");
        return this.boxes;
    }

    public void updateLocale(Locale locale) {
        super.updateLocale(locale);
        this.translateTooltip(locale);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1 && this.al != null) {
            this.al.actionPerformed(new ActionEvent(this, 0, this.aCommand));
        }
    }

    private void copyAndSort(String[] stringArray) {
        this.sorted = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            this.sorted[i] = stringArray[i];
        }
        if (this.sortingOn) {
            Arrays.sort(this.sorted, String.CASE_INSENSITIVE_ORDER);
        }
    }
}

