/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.io.xml;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Method;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.ParserAdapter;
import org.xml.sax.helpers.ParserFactory;
import se.ericsson.wcdma.rbs.bem.common.exception.BemXmlException;
import se.ericsson.wcdma.rbs.bem.common.io.xml.ServiceElement;
import se.ericsson.wcdma.rbs.bem.common.io.xml.XmlSource;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.service.DeprecationConverter;
import se.ericsson.wcdma.rbs.bem.common.service.ModifyConverter;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceCommon;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceNameValue;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.service.Source;
import se.ericsson.wcdma.rbs.bem.common.util.GitHelper;
import se.ericsson.wcdma.rbs.bem.common.util.RegressionTestInDesigntestUtils;

public class XmlFileHandler
extends DefaultHandler {
    private static XmlFileHandler theInstance;
    public static final String ATM = "atm";
    public static final String IPV4 = "ipV4";
    private static final String ERR_MSG_FILE_NOT_FOUND = "Cannot read Input file.\n\nRecommended action: \n - Please check file path, name and permissions for the input file\n\nAdditional information: \n- Input file:  {0}";
    private static final String ERR_MSG_SAX_EXCEPTION = "Faulty Input file.\n\nRecommended action: \n - Please check that the input file has been prepared using a supported DTD.\n\n Additional information: \n- Input file:  {0}\n- Service in progress: {1}. \n- Last parsed attribute was: {2} with value: {3}. \n- Message: {4}\n- Supported DTDs:  \n     {5}     Revision: {6}";
    private static final String ERR_MSG_SAX_PARSER_EXCEPTION = "Faulty Input file.\n\nRecommended action: \n - Please check that the input file has been prepared using a supported DTD.\n\n Additional information: \n- Input file:  {0}\n- Line number: {1}. \n- Message:  {4}\n- Supported DTDs:  \n      {5}     Revision: {6}";
    private static final String ERR_MSG_ILLEGAL_ARGUMENT = "Illegal argument(s).\n\n Recommended action: \n  - Please ensure that the input file name does not contain any non-supported\n    characters such as %.\n\n Additional information: \n- Message:  {0}\n- Supported DTDs:  \n      {1}     Revision: {2}";
    private static final String ERR_MSG_UNKNOWN_ERROR = "Unknown error! \n\nRecommended action: \n - Please check that the input file has been prepared using a supported DTD.\n\n Additional information: \n- Input file:  {0}\n- Service in progress: {1}. \n- Last parsed attribute was: {2} with value: {3}. \n- Message: {4}\n- Supported DTDs:\n     {5}     Revision: {6}";
    private static final String ERR_MSG_TOO_MANY_SYNCS_ERROR = "Too many Network Synchronizations in XML-file! \n\nRecommended action: \n - Please remove the ones that should not be used.\n- Maximum allowed elements of type NetworkSynch are=8\n\n Additional information: \n- Input file:  {0}\n- Service in progress: {1}. \n- Last parsed attribute was: {2} with value: {3}. \n- Message: {4}\n- Supported DTDs:\n     {5}     Revision: {6}";
    private static final String ERR_MSG_TOO_MANY_IKESATF_ERROR = "Too many Ikepeer allowed transforms!\n";
    private static final String ERR_MSG_TOO_MANY_IPSECTUNNLE_CHILDSATF_ERROR = "Too many IpSec Tunnel allowed transforms!\n";
    private String inputFileName;
    private String dtdFilePathName;
    private String dtdRevision;
    private ServiceValue serviceValues = new ServiceValue("XML");
    private ServiceElement currentService;
    private int noOfFirstOAMatmAttributes = 0;
    private Vector serviceNames;
    private String sectorCellPrefix;
    private String radioDotPrefix;
    private String userDataPrefix;
    private ServiceNameValue lastParsedItem;
    private ServiceElement lastParsedService;
    private static final String CABINET_ONE = "1";
    private String lastAlarmCab = "1";
    private static final String EMPTY_MSG = "-";
    private boolean useFlexibleDtdLocation = false;
    private String globalElementSectorNumber = null;
    private String globalElementCellNumber = null;
    private String globalEtbSlotNumber = null;
    private String globalIpEtbSlotNumber = null;
    private String globalElementCabinetNumber = null;
    private String globalElementCabinetIdentifier = null;
    private String globalElementEcbusNumber = null;
    private ConsistencyChecker consistencyChecker = null;
    private Locator xmlDocumentLocator;
    private int ipSyncRefCounter = 0;
    private int ecPortCounter = 0;
    private int positionConfigurationCounter = 0;
    private int hwGroupCounter = 0;
    private boolean subElementToEthernetSwitchPort = false;
    private boolean subElementToConnection = false;
    private String ethernetSwitchPortPrefix;
    private String oamAtmvalue;
    private String AretConfigurationPrefix = null;
    private String cabinetNoPrefix = "";
    private int currentSectorNumber = 0;
    private String ipsecConfigurationPrefix = null;
    private static final String VALUE_STRING_INVALID_CHARS_IN_FILENAME = "Filename {0} contains an invalid character. The invalid character is: ";
    private static final String INCORRECT_CHARS = "%\u00c5\u00c4\u00d6\u00e5\u00e4\u00f6,?[]\u00a3{}";

    private XmlFileHandler() {
    }

    public static XmlFileHandler getInstance() {
        Nal.getLog().nalTraceEnter(XmlFileHandler.class, "getInstance()");
        if (theInstance == null) {
            theInstance = new XmlFileHandler();
        }
        return theInstance;
    }

    public ServiceValue startParsing(InputStream inputStream, String string) throws BemXmlException {
        return this.parseXmlInput(new InputSource(inputStream), "input stream", string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceValue startParsing(String string, String string2) throws BemXmlException {
        Locale locale = Locale.getDefault();
        try {
            Locale.setDefault(Locale.ENGLISH);
            File file = new File(string);
            if (!file.isFile() || !file.canRead()) {
                String string3 = MessageFormat.format(ERR_MSG_FILE_NOT_FOUND, string + "   ");
                throw new BemXmlException(string3, null);
            }
            String[] stringArray = new String[]{string};
            String string4 = this.charsCorrect(string);
            if (string4 != null) {
                String string5 = MessageFormat.format(VALUE_STRING_INVALID_CHARS_IN_FILENAME, stringArray);
                String string6 = string5.concat(string4 + "");
                throw new BemXmlException(string6, null);
            }
            String string7 = new File(string).toURI().toString();
            if (!string7.equals(string)) {
                Nal.getLog().nalTrace(4, this.getClass(), "Fixed name of xml file!\n   From name : " + string + "\n   To name   : " + string7);
            }
            InputSource inputSource = new InputSource(string7);
            ServiceValue serviceValue = this.parseXmlInput(inputSource, string7, string2);
            return serviceValue;
        }
        finally {
            Locale.setDefault(locale);
        }
    }

    public ServiceValue startParsingXmlString(String string, String string2) throws BemXmlException {
        StringReader stringReader = new StringReader(string);
        return this.startParsing(stringReader, "", string2);
    }

    public ServiceValue startParsing(Reader reader, String string, String string2) throws BemXmlException {
        Nal.getLog().nalTraceEnter(this.getClass(), "startParsing()");
        InputSource inputSource = new InputSource(reader);
        inputSource.setSystemId(string2);
        Nal.getLog().nalTraceReturn(this.getClass(), "startParsing()");
        return this.parseXmlInput(inputSource, string, string2);
    }

    private ServiceValue parseXmlInput(InputSource inputSource, String string, String string2) throws BemXmlException {
        Object object;
        Nal.getLog().nalTraceEnter(this.getClass(), "parseXmlInput()");
        this.ecPortCounter = 0;
        this.serviceValues = new ServiceValue("XML");
        this.dtdFilePathName = string2;
        this.dtdRevision = this.extractDtdRevision(string2);
        this.consistencyChecker = new ConsistencyChecker();
        String string3 = null;
        this.serviceNames = ServiceCommon.getServiceNames();
        try {
            object = XmlFileHandler.getXMLReader();
            object.setContentHandler(this);
            object.setEntityResolver(this);
            object.setErrorHandler(this);
            Nal.getLog().nalTrace(5, object.getClass(), "xmlReader");
            object.parse(inputSource);
        }
        catch (FileNotFoundException fileNotFoundException) {
            string3 = MessageFormat.format(ERR_MSG_FILE_NOT_FOUND, string);
            throw new BemXmlException(string3, (Throwable)fileNotFoundException);
        }
        catch (SAXParseException sAXParseException) {
            File file = new File(this.dtdFilePathName);
            string3 = sAXParseException.getException() != null && sAXParseException.getException() instanceof IllegalArgumentException ? MessageFormat.format(ERR_MSG_ILLEGAL_ARGUMENT, sAXParseException.getMessage(), file.getName(), this.dtdRevision) : MessageFormat.format(ERR_MSG_SAX_PARSER_EXCEPTION, string, sAXParseException.getLineNumber() + "", "", "", sAXParseException.getMessage(), file.getName(), this.dtdRevision);
            throw new BemXmlException(string3, (Throwable)sAXParseException);
        }
        catch (SAXException sAXException) {
            String string4 = EMPTY_MSG;
            Object object2 = EMPTY_MSG;
            String string5 = EMPTY_MSG;
            if (this.lastParsedItem != null) {
                string4 = this.lastParsedItem.getName();
                object2 = this.lastParsedItem.getValue();
            }
            if (this.lastParsedService != null) {
                string5 = this.lastParsedService.getName();
            }
            File file = new File(this.dtdFilePathName);
            string3 = MessageFormat.format(ERR_MSG_SAX_EXCEPTION, string, string5, string4, object2, sAXException.getMessage(), file.getName(), this.dtdRevision);
            throw new BemXmlException(string3, (Throwable)sAXException);
        }
        catch (Exception exception) {
            String string6 = EMPTY_MSG;
            Object object3 = EMPTY_MSG;
            String string7 = EMPTY_MSG;
            if (this.lastParsedItem != null) {
                string6 = this.lastParsedItem.getName();
                object3 = this.lastParsedItem.getValue();
            }
            if (this.lastParsedService != null) {
                string7 = this.lastParsedService.getName();
            }
            File file = new File(this.dtdFilePathName);
            string3 = MessageFormat.format(ERR_MSG_UNKNOWN_ERROR, string, string7, string6, object3, exception.getMessage(), file.getName(), this.dtdRevision);
            throw new BemXmlException(string3, (Throwable)exception);
        }
        finally {
            this.serviceNames = null;
            this.lastParsedItem = null;
            this.lastParsedService = null;
            string = null;
            string3 = null;
        }
        this.consistencyChecker.checkConsistency();
        object = new ModifyConverter();
        ((ModifyConverter)object).convert(this.serviceValues);
        DeprecationConverter deprecationConverter = new DeprecationConverter(string2);
        deprecationConverter.convert(this.serviceValues);
        Nal.getLog().nalTraceReturn(this.getClass(), "parseXmlInput()");
        return this.serviceValues;
    }

    private static XMLReader getXMLReader() throws Exception {
        XMLReader xMLReader = null;
        if (RegressionTestInDesigntestUtils.getUseXercesSax2Parser()) {
            try {
                Class<?> clazz = Class.forName("org.apache.xerces.parsers.SAXParser");
                xMLReader = (XMLReader)clazz.newInstance();
                Nal.getLog().nalTrace(4, XmlFileHandler.class, "PARAM Parsing XML with org.apache.xerces.parsers.SAXParser");
                return xMLReader;
            }
            catch (ClassNotFoundException classNotFoundException) {
                Parser parser = ParserFactory.makeParser("com.microstar.xml.SAXDriver");
                xMLReader = new ParserAdapter(parser);
                xMLReader.setEntityResolver(new EntityResolver(){

                    public InputSource resolveEntity(String string, String string2) {
                        return new InputSource(new StringReader(""));
                    }
                });
                Nal.getLog().nalTrace(4, XmlFileHandler.class, "PARAM Parsing XML with com.microstar.xml.SAXDriver");
                return xMLReader;
            }
        }
        Class<?> clazz = Class.forName("javax.xml.parsers.SAXParserFactory");
        Method method = clazz.getMethod("newInstance", null);
        Object object = method.invoke((Object)null, (Object[])null);
        Method method2 = clazz.getMethod("setValidating", Boolean.TYPE);
        method2.invoke(object, Boolean.TRUE);
        Method method3 = clazz.getMethod("setNamespaceAware", Boolean.TYPE);
        method3.invoke(object, Boolean.TRUE);
        Method method4 = clazz.getMethod("newSAXParser", null);
        Object object2 = method4.invoke(object, (Object[])null);
        Class<?> clazz2 = Class.forName("javax.xml.parsers.SAXParser");
        Method method5 = clazz2.getMethod("getXMLReader", null);
        xMLReader = (XMLReader)method5.invoke(object2, (Object[])null);
        Nal.getLog().nalTrace(4, XmlFileHandler.class, "PARAM Parsing XML with javax.xml.parsers.SAXParserFactory");
        return xMLReader;
    }

    public void setDocumentLocator(Locator locator) {
        this.xmlDocumentLocator = locator;
    }

    private XmlSource getCurrentXmlSource() {
        int n = -1;
        if (this.xmlDocumentLocator != null) {
            n = this.xmlDocumentLocator.getLineNumber();
        }
        XmlSource xmlSource = new XmlSource(this.inputFileName, n);
        return xmlSource;
    }

    public void startDocument() throws SAXException {
        this.noOfFirstOAMatmAttributes = 0;
        this.positionConfigurationCounter = 0;
        this.hwGroupCounter = 0;
        ServiceCommon.clearElementCounters();
    }

    public void endDocument() throws SAXException {
        this.ipSyncRefCounter = 0;
        ServiceCommon.saveElementCounters();
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        try {
            String string5;
            if (this.haveGlobalSectoNumber(string4)) {
                this.globalElementSectorNumber = string5 = attributes.getValue("sectorNumber");
            }
            if (this.haveGlobalCellNumber(string4)) {
                this.globalElementCellNumber = string5 = attributes.getValue("cellNumber");
            }
            if (this.havaGlobalCabinetNumber(string4)) {
                this.globalElementCabinetNumber = string5 = attributes.getValue("cabinetNumber");
                String string6 = attributes.getValue("sharedCabinetIdentifier");
                String string7 = this.globalElementCabinetIdentifier = null == string6 ? "" : string6;
            }
            if (this.havaGlobalAddDuwBoard(string4)) {
                string5 = attributes.getValue("AddDuwBoardslot");
                this.consistencyChecker.addDuwBoard(string5);
            }
            this.extractCabinetNoPrefix(string4, attributes);
            this.checkElementType(string4, attributes);
        }
        catch (BemXmlException bemXmlException) {
            throw new SAXException(bemXmlException.getMessage(), bemXmlException);
        }
    }

    private boolean haveGlobalSectoNumber(String string) {
        return string.equals("AddSector") || string.equals("ModifySector") || string.equals("ModifyAntennaSystem") || string.equals("DeleteSector") || string.equals("AddRadioDot") || string.equals("DeleteRadioDot");
    }

    private boolean haveGlobalCellNumber(String string) {
        return string.equals("DeleteCell");
    }

    private boolean haveGlobalSlotNumber(String string) {
        return string.equals("AddEtBoard") || string.equals("AddIpEtBoard") || string.equals("AddAtmPort") || string.equals("AddPhysPathTerm");
    }

    private boolean spanOverMoreThanOneElement(String string) {
        return string.equals("AddCarrier") || string.equals("AddSector") || string.equals("ModifySector") || string.equals("ModifyAntennaSystem");
    }

    private boolean havaGlobalCabinetNumber(String string) {
        return string.equals("AddCabinet") || string.equals("DeleteCabinet") || string.equals("ModifyCabinet");
    }

    private boolean havaGlobalAddDuwBoard(String string) {
        return string.equals("AddDuwBoard");
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        String string4 = string2;
        if (string4.equals("")) {
            string4 = string3;
        }
        this.handleExpandAndModifyElements(string4, this.globalElementSectorNumber, this.globalElementCellNumber, this.globalElementEcbusNumber, this.currentService);
        this.handleExpandAndModifyCabinetElements(string4, this.globalElementCabinetNumber, this.globalElementCabinetIdentifier, this.currentService);
        if (this.haveGlobalSectoNumber(string4)) {
            this.globalElementSectorNumber = null;
        }
        if (this.haveGlobalCellNumber(string4)) {
            this.globalElementCellNumber = null;
        }
        if (this.haveGlobalSlotNumber(string4)) {
            this.globalEtbSlotNumber = null;
        }
        if (this.havaGlobalCabinetNumber(string4)) {
            this.globalElementCabinetNumber = null;
            this.globalElementCabinetIdentifier = null;
        }
        if (this.currentService != null && string4.equals(this.currentService.getName())) {
            this.addAttributesToServiceValue(this.currentService);
            this.currentService = null;
        }
        if (string4.equals("EthernetSwitchPort")) {
            this.subElementToEthernetSwitchPort = false;
        }
        if (string4.equals("Connection")) {
            this.subElementToConnection = false;
        }
        if (string4.equals("IubIpAccessHostEt") || string4.equals("OamIpHost")) {
            this.ipsecConfigurationPrefix = null;
            ServiceCommon.clearSubElementCouters();
        }
    }

    private void addAttributesToServiceValue(ServiceElement serviceElement) {
        String string = serviceElement.getName();
        if (this.spanOverMoreThanOneElement(string)) {
            Vector vector = this.serviceValues.getValues(string);
            Vector vector2 = serviceElement.getAttributes();
            if (vector != null) {
                vector2.addAll(vector);
            }
            this.serviceValues.addAttributes(string, vector2);
        } else {
            this.serviceValues.addAttributes(string, serviceElement.getAttributes());
        }
    }

    private void handleExpandAndModifyCabinetElements(String string, String string2, String string3, ServiceElement serviceElement) throws SAXException {
        XmlSource xmlSource = this.getCurrentXmlSource();
        if (string.equals("AddCabinet")) {
            if (this.consistencyChecker.addSameCabinetNumber(string2)) {
                throw new SAXException("add cabinet " + string2 + " has same value!");
            }
            String string4 = PrefixUtil.getCabinetPrefix(string2);
            ServiceNameValue serviceNameValue = new ServiceNameValue(serviceElement.getName(), string4, "cabinetNumber", string2, xmlSource);
            ServiceNameValue serviceNameValue2 = new ServiceNameValue(serviceElement.getName(), string4, "sharedCabinetIdentifier", string3, xmlSource);
            Vector<ServiceNameValue> vector = new Vector<ServiceNameValue>();
            vector.add(serviceNameValue);
            vector.add(serviceNameValue2);
            Vector vector2 = serviceElement.getAttributes();
            for (ServiceNameValue serviceNameValue3 : vector2) {
                ServiceNameValue serviceNameValue4 = this.addAttributesForCabinet(serviceElement.getName(), string4, serviceNameValue3);
                if (null == serviceNameValue4) continue;
                vector.add(serviceNameValue4);
            }
            serviceElement.addAttributes(vector);
            this.consistencyChecker.addedCabinet(string2);
        } else if (string.equals("ModifyCabinet")) {
            if (this.consistencyChecker.modifySameCabinetNumber(string2)) {
                throw new SAXException("modify cabinet " + string2 + " has same value!");
            }
            String string5 = PrefixUtil.getCabinetPrefix(string2);
            ServiceNameValue serviceNameValue = new ServiceNameValue(serviceElement.getName(), string5, "cabinetNumber", string2, xmlSource);
            Vector<ServiceNameValue> vector = new Vector<ServiceNameValue>();
            vector.add(serviceNameValue);
            Vector vector3 = serviceElement.getAttributes();
            for (ServiceNameValue serviceNameValue5 : vector3) {
                ServiceNameValue serviceNameValue6 = this.addAttributesForCabinet(serviceElement.getName(), string5, serviceNameValue5);
                if (null != serviceNameValue6) {
                    vector.add(serviceNameValue6);
                }
                if (serviceNameValue5.getName().indexOf("smokeDetector") > -1) {
                    vector.add(serviceNameValue5);
                    continue;
                }
                if (serviceNameValue5.getName().indexOf("climateSystem") <= -1) continue;
                vector.add(serviceNameValue5);
            }
            serviceElement.addAttributes(vector);
            this.consistencyChecker.modifiedCabinet(string2);
        } else if (string.equals("DeleteCabinet")) {
            if (this.consistencyChecker.deleteSameCabinetNumber(string2)) {
                throw new SAXException("delete cabinet " + string2 + " has same value!");
            }
            String string6 = PrefixUtil.getDeleteCabinetPrefix(string2);
            String string7 = "cabinetNumber";
            ServiceNameValue serviceNameValue = new ServiceNameValue(serviceElement.getName(), string6, string7, string2, xmlSource);
            Vector<ServiceNameValue> vector = new Vector<ServiceNameValue>();
            vector.add(serviceNameValue);
            serviceElement.addAttributes(vector);
            this.consistencyChecker.deletedCabinet(string2);
        }
    }

    private void handleExpandAndModifyElements(String string, String string2, String string3, String string4, ServiceElement serviceElement) throws SAXException {
        XmlSource xmlSource = this.getCurrentXmlSource();
        if (string.equals("DeleteSector")) {
            String string5 = "deleteSector";
            String string6 = MessageFormat.format("S{0}_", string2);
            String string7 = string2;
            ServiceNameValue serviceNameValue = new ServiceNameValue(serviceElement.getName(), string6, string5, string7, xmlSource);
            Vector<ServiceNameValue> vector = new Vector<ServiceNameValue>();
            vector.add(serviceNameValue);
            serviceElement.addAttributes(vector);
            this.consistencyChecker.deletedSector(string2);
        } else if (string.equals("AddSector")) {
            this.consistencyChecker.addedSector(string2);
        } else if (string.equals("ModifySector")) {
            this.consistencyChecker.modifiedSector(string2);
        } else if (string.equals("ModifyAntennaSystem")) {
            this.consistencyChecker.modifiedAntennaSystem(string2);
        } else if (string.equals("DeleteCell")) {
            String string8 = "deleteCell";
            String string9 = this.getCellPrefix(string2, string3);
            String string10 = string3;
            ServiceNameValue serviceNameValue = new ServiceNameValue(serviceElement.getName(), string9, string8, string10, xmlSource);
            Vector<ServiceNameValue> vector = new Vector<ServiceNameValue>();
            vector.add(serviceNameValue);
            serviceElement.addAttributes(vector);
        } else if (string.equals("EcBus") || string.equals("AddEcBus")) {
            this.consistencyChecker.addedEcbus(string4);
        } else if (string.equals("ModifyEcBus")) {
            this.consistencyChecker.modifiedEcbus(string4);
        }
    }

    public InputSource resolveEntity(String string, String string2) throws SAXException {
        InputStream inputStream = null;
        try {
            inputStream = this.newDtdInputStream(this.dtdFilePathName);
        }
        catch (Exception exception) {
            throw new SAXException("Dtd file could not be loaded: " + this.dtdFilePathName);
        }
        return new InputSource(inputStream);
    }

    public void warning(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void error(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    public void fatalError(SAXParseException sAXParseException) throws SAXException {
        throw sAXParseException;
    }

    private void checkElementType(String string, Attributes attributes) throws BemXmlException {
        Object object;
        Object object2;
        boolean bl = false;
        if (this.currentService != null && (object2 = ServiceCommon.getSubElements(this.currentService.getName())) != null) {
            object = ((Vector)object2).elements();
            while (object.hasMoreElements()) {
                String string2 = (String)object.nextElement();
                if (!string.equals(string2)) continue;
                boolean bl2 = ServiceCommon.isElementCountable(string);
                this.extractSubElementAttributes(string, attributes, bl2);
                bl = true;
            }
        }
        if (this.serviceNames != null && !bl) {
            object2 = this.serviceNames.elements();
            while (object2.hasMoreElements()) {
                object = (String)object2.nextElement();
                if (!string.equals(object)) continue;
                this.extractServiceAttributes((String)object, attributes);
                break;
            }
        }
    }

    private void extractSubElementAttributes(String string, Attributes attributes, boolean bl) throws BemXmlException {
        String string2 = "";
        string2 = this.getPrefix(attributes, bl, string);
        this.addExtraEtbSlotAttributeIfAppropriate(string, attributes, bl, string2);
        this.addExtraIpEtbSlotAttributeIfAppropriate(string, attributes, bl, string2);
        this.addExtraHsdpaAttribute(string, attributes, bl, string2);
        this.addExtraEulAttribute(string, attributes, bl, string2);
        this.addExtraTransportOptionAttribute(string, attributes, bl, string2);
        this.extractModificationTypeFromCascadedAretConfiguration(string, attributes);
        this.addExtraNtpServerIpAddressAttributeIfAppropriate(string, attributes);
        this.addExtraPtpServerAttributesIfAppropriate(string, attributes);
        this.addDeleteRadioDotServerAttributes(string, attributes, string2);
        this.loopTroughAllAttributes(string, attributes, string2);
    }

    private List extractDnsIpAddress(String string) {
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 0;
        String string2 = "";
        while (string.length() > 0) {
            n = (string = string.trim()).indexOf(",");
            if (n >= 0) {
                string2 = string.substring(0, n);
                string = string.substring(n + 1);
                string2 = string2.trim();
                string = string.trim();
            } else {
                string2 = string;
                string = "";
            }
            arrayList.add(string2);
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            if (((String)arrayList.get(i)).length() > 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            return null;
        }
        return arrayList;
    }

    private void loopTroughAllAttributes(String string, Attributes attributes, String string2) throws BemXmlException {
        boolean bl = false;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string3 = attributes.getLocalName(i);
            if (string3.equals("")) {
                string3 = attributes.getQName(i);
            }
            String string4 = this.getFilteredValue(string3, attributes.getValue(i));
            if (string.equals("NO_RET") && string3.equals("configureRet") && string4.equals("NO")) {
                this.currentSectorNumber = Integer.parseInt(string2.substring(1, 2));
                bl = true;
            }
            XmlSource xmlSource = this.getCurrentXmlSource();
            ServiceNameValue serviceNameValue = new ServiceNameValue(this.currentService.getName(), string2, string3, string4, xmlSource);
            if (this.filterCabinetNumbersvFromXml(this.currentService.getName(), string3)) continue;
            this.currentService.addAttribute(serviceNameValue);
            if (this.currentSectorNumber > 0 && string3.endsWith("typeOfRet") && bl) {
                for (int j = 2; j <= 3; ++j) {
                    serviceNameValue = new ServiceNameValue(this.currentService.getName(), string2, string3 + j, string4, xmlSource);
                    this.currentService.addAttribute(serviceNameValue);
                }
            }
            if (string.equals("DnsResolver") && string3.equals("dnsServerAddress")) {
                List list = this.extractDnsIpAddress(string4);
                if (list == null) {
                    throw new BemXmlException("Value(" + string4 + ") of " + string + "." + string3 + " is error." + "Correct format should be \"ip1\" or \"ip1,ip2\" or \"ip1,ip2,ip3\"");
                }
                if (list.size() > 3 || list.size() <= 0) {
                    throw new BemXmlException("Value(" + string4 + ") of " + string + "." + string3 + " is error." + "Correct format should be \"ip1\" or \"ip1,ip2\" or \"ip1,ip2,ip3\"");
                }
                for (int j = 1; j <= list.size(); ++j) {
                    serviceNameValue = new ServiceNameValue(this.currentService.getName(), string2, string3 + j, (String)list.get(j - 1), xmlSource);
                    this.currentService.addAttribute(serviceNameValue);
                }
            }
            this.lastParsedItem = serviceNameValue;
        }
    }

    private void extractModificationTypeFromCascadedAretConfiguration(String string, Attributes attributes) {
        if (string.equals("CascadedAretConfiguration")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (!attributes.getLocalName(i).equals("modificationType")) continue;
                this.AretConfigurationPrefix = attributes.getValue(i);
            }
        }
    }

    private void extractCabinetNoPrefix(String string, Attributes attributes) {
        if (string.equals("OptionalEquipmentConfiguration") || string.equals("Cabinet") || string.equals("ModifyPowerSystem") || string.equals("ModifyCabinet") || string.equals("AddCabinet")) {
            this.cabinetNoPrefix = attributes.getValue("cabinetNumber");
        }
    }

    private void addExtraNtpServerIpAddressAttributeIfAppropriate(String string, Attributes attributes) {
        if (string.equals("IpSyncRef")) {
            String string2 = MessageFormat.format("IPoverGigabitEthernet_{0}_", String.valueOf(this.ipSyncRefCounter + 6));
            String string3 = attributes.getValue("ntpServerIpAddress");
            XmlSource xmlSource = this.getCurrentXmlSource();
            ServiceNameValue serviceNameValue = new ServiceNameValue(this.currentService.getName(), string2, "ntpServerIpAddress", string3, xmlSource);
            this.currentService.addAttribute(serviceNameValue);
        }
    }

    private ServiceNameValue addAttributesForCabinet(String string, String string2, ServiceNameValue serviceNameValue) {
        XmlSource xmlSource = this.getCurrentXmlSource();
        String string3 = serviceNameValue.getValueAsString();
        ServiceNameValue serviceNameValue2 = null;
        if (serviceNameValue.getName().equals("smokeDetector")) {
            serviceNameValue2 = new ServiceNameValue(string, string2, "smokeDetector", string3, xmlSource);
        } else if (serviceNameValue.getName().equals("ecBusNumber")) {
            serviceNameValue2 = new ServiceNameValue(string, string2, "ecBusNumber", string3, xmlSource);
        } else if (serviceNameValue.getName().equals("sharedCabinetIdentifier")) {
            serviceNameValue2 = new ServiceNameValue(string, string2, "sharedCabinetIdentifier", string3, xmlSource);
        } else if (serviceNameValue.getName().equals("referredCabinetNumber")) {
            serviceNameValue2 = new ServiceNameValue(string, string2, "referredCabinetNumber", string3);
        } else if (serviceNameValue.getName().equals("cabinetType")) {
            serviceNameValue2 = new ServiceNameValue(string, string2, "cabinetType", string3, xmlSource);
        } else if (serviceNameValue.getName().equals(string2 + "climateSystem")) {
            serviceNameValue2 = new ServiceNameValue(string, string2, "climateSystem", string3, xmlSource);
        } else if (serviceNameValue.getName().equals(string2 + "climateRegulationSystem")) {
            serviceNameValue2 = new ServiceNameValue(string, string2, "climateRegulationSystem", string3, xmlSource);
        }
        return serviceNameValue2;
    }

    private void addExtraPtpServerAttributesIfAppropriate(String string, Attributes attributes) {
        if (string.equals("PacketFrequencySyncRef")) {
            String string2 = MessageFormat.format("IPoverGigabitEthernet_{0}_", String.valueOf(this.ipSyncRefCounter + 6));
            XmlSource xmlSource = this.getCurrentXmlSource();
            String string3 = "PTP";
            ServiceNameValue serviceNameValue = new ServiceNameValue(this.currentService.getName(), string2, "syncServerType", string3, xmlSource);
            this.currentService.addAttribute(serviceNameValue);
            String string4 = attributes.getValue("serverAddress");
            ServiceNameValue serviceNameValue2 = new ServiceNameValue(this.currentService.getName(), string2, "serverAddress", string4, xmlSource);
            this.currentService.addAttribute(serviceNameValue2);
            String string5 = attributes.getValue("ptpDomain");
            ServiceNameValue serviceNameValue3 = new ServiceNameValue(this.currentService.getName(), string2, "ptpDomain", string5, xmlSource);
            this.currentService.addAttribute(serviceNameValue3);
        }
    }

    private void addExtraEtbSlotAttributeIfAppropriate(String string, Attributes attributes, boolean bl, String string2) {
        if (string.equals("AtmPort") || string.equals("PhysPathTerm")) {
            XmlSource xmlSource = this.getCurrentXmlSource();
            ServiceNameValue serviceNameValue = new ServiceNameValue(this.currentService.getName(), string2, "etbSlot", this.globalEtbSlotNumber, xmlSource);
            this.currentService.addAttribute(serviceNameValue);
        }
    }

    private void addDeleteRadioDotServerAttributes(String string, Attributes attributes, String string2) {
        if (string.equals("RadioDot") || string.equals("RadioDotNo")) {
            XmlSource xmlSource = this.getCurrentXmlSource();
            if (this.currentService.getName().equalsIgnoreCase("AddRadioDot")) {
                ServiceNameValue serviceNameValue = new ServiceNameValue(this.currentService.getName(), string2, "AddRadioDot", "YES", xmlSource);
                this.currentService.addAttribute(serviceNameValue);
            } else if (this.currentService.getName().equalsIgnoreCase("DeleteRadioDot")) {
                ServiceNameValue serviceNameValue = new ServiceNameValue(this.currentService.getName(), string2, "DeleteRadioDot", "YES", xmlSource);
                this.currentService.addAttribute(serviceNameValue);
            }
        }
    }

    private void addExtraIpEtbSlotAttributeIfAppropriate(String string, Attributes attributes, boolean bl, String string2) {
        if (string.equals("EthernetSwitch")) {
            XmlSource xmlSource = this.getCurrentXmlSource();
            ServiceNameValue serviceNameValue = new ServiceNameValue(this.currentService.getName(), string2, "etxSlot", this.globalIpEtbSlotNumber, xmlSource);
            this.currentService.addAttribute(serviceNameValue);
        }
    }

    private void addExtraTransportOptionAttribute(String string, Attributes attributes, boolean bl, String string2) {
        XmlSource xmlSource = this.getCurrentXmlSource();
        if (string.equals("IPoverGigabitEthernet")) {
            ServiceNameValue serviceNameValue = new ServiceNameValue(this.currentService.getName(), string2, "IPoverGigabitEthernet_transportOption", IPV4, xmlSource);
            this.currentService.addAttribute(serviceNameValue);
        } else if (string.equals("Connection")) {
            ServiceNameValue serviceNameValue = new ServiceNameValue(this.currentService.getName(), "", "IPoverGigabitEthernet_transportOption", ATM, xmlSource);
            this.currentService.addAttribute(serviceNameValue);
        }
    }

    private void addExtraEulAttribute(String string, Attributes attributes, boolean bl, String string2) {
        String string3 = "";
        String string4 = "";
        if (string.equals("EulSlot")) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getLocalName(i).equals("numEulResources")) {
                    string4 = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getLocalName(i).equals("slot")) continue;
                string3 = attributes.getValue(i);
            }
            String string5 = MessageFormat.format("eulSlot{0}_", string3);
            XmlSource xmlSource = this.getCurrentXmlSource();
            ServiceNameValue serviceNameValue = new ServiceNameValue(this.currentService.getName(), string5, "numEulResources", string4, xmlSource);
            this.currentService.addAttribute(serviceNameValue);
        }
    }

    private void addExtraHsdpaAttribute(String string, Attributes attributes, boolean bl, String string2) {
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        if (string.equals("HsdpaSlot")) {
            ServiceNameValue serviceNameValue;
            for (int i = 0; i < attributes.getLength(); ++i) {
                if (attributes.getLocalName(i).equals("numHsCodeResources")) {
                    string4 = attributes.getValue(i);
                    continue;
                }
                if (attributes.getLocalName(i).equals("slot")) {
                    string3 = attributes.getValue(i);
                    continue;
                }
                if (attributes.getLocalName(i).equals("numHsCodeResources1stBBP")) {
                    string5 = attributes.getValue(i);
                    continue;
                }
                if (!attributes.getLocalName(i).equals("numHsCodeResources2ndBBP")) continue;
                string6 = attributes.getValue(i);
            }
            String string7 = MessageFormat.format("hsSlot{0}_", string3);
            XmlSource xmlSource = this.getCurrentXmlSource();
            if (string4 != null) {
                serviceNameValue = new ServiceNameValue(this.currentService.getName(), string7, "numHsCodeResources", string4, xmlSource);
                this.currentService.addAttribute(serviceNameValue);
            }
            if (string5 != null) {
                serviceNameValue = new ServiceNameValue(this.currentService.getName(), string7, "numHsCodeResources1stBBP", string5, xmlSource);
                this.currentService.addAttribute(serviceNameValue);
            }
            if (string6 != null) {
                serviceNameValue = new ServiceNameValue(this.currentService.getName(), string7, "numHsCodeResources2ndBBP", string6, xmlSource);
                this.currentService.addAttribute(serviceNameValue);
            }
        }
    }

    private void extractServiceAttributes(String string, Attributes attributes) throws BemXmlException {
        this.lastParsedService = this.currentService = new ServiceElement(string);
        Vector<ServiceNameValue> vector = new Vector<ServiceNameValue>();
        String string2 = this.getServiceElementPrefix(attributes, string);
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string3 = attributes.getLocalName(i);
            if (string3.equals("")) {
                string3 = attributes.getQName(i);
            }
            String string4 = attributes.getValue(i);
            XmlSource xmlSource = this.getCurrentXmlSource();
            if (this.filterCabinetNumbersvFromXml(this.currentService.getName(), string3)) continue;
            ServiceNameValue serviceNameValue = new ServiceNameValue(this.currentService.getName(), string2, string3, string4, xmlSource);
            vector.add(serviceNameValue);
            this.lastParsedItem = serviceNameValue;
        }
        this.currentService.addAttributes(vector);
    }

    private boolean filterCabinetNumbersvFromXml(String string, String string2) {
        return (string.equals("ModifyNoOfPsu") || string.equals("ModifyNoOfPdu") || string.equals("ModifyNoOfBfu") || string.equals("ModifyPowerSystem") || string.equals("ConfigPowerBattery") || string.equals("ModifyExternalAlarms") || string.equals("ModifyExternalControls") || string.equals("AddExternalAlarmControlUnit")) && string2.equals("cabinetNumber");
    }

    private InputStream newDtdInputStream(String string) throws Exception {
        Serializable serializable;
        String string2;
        InputStream inputStream = null;
        try {
            string2 = System.getProperty("os.name");
            if (string2.startsWith("OSE")) {
                serializable = XmlFileHandler.class.getResource(string);
                String string3 = serializable.getFile();
                string3 = URLDecoder.decode(string3, "UTF-8");
                int n = string3.indexOf(":");
                int n2 = string3.indexOf("!");
                string3 = string3.substring(n + 1, n2);
                Nal.getLog().nalTrace(4, this.getClass(), "Jar filename " + string3);
                File file = new File(string3);
                JarFile jarFile = new JarFile(file);
                String string4 = string.substring(1);
                ZipEntry zipEntry = jarFile.getEntry(string4);
                inputStream = jarFile.getInputStream(zipEntry);
                Nal.getLog().nalTrace(4, this.getClass(), "ZIP retStream " + inputStream.toString());
            } else {
                inputStream = XmlFileHandler.class.getResourceAsStream(string);
                Nal.getLog().nalTrace(6, this.getClass(), "retStream " + inputStream.toString());
            }
        }
        catch (Exception exception) {
            Nal.getLog().nalTrace(5, this.getClass(), " Exception when reading DTD file with : " + exception.toString());
            inputStream = null;
        }
        if (inputStream == null) {
            string2 = GitHelper.getGitPath() + "rbs/sw/bsmss_1/bem/bemnodemisc/bemnodecommon/src/";
            if (!RegressionTestInDesigntestUtils.getRegressionTest() && !this.useFlexibleDtdLocation) {
                System.out.println("Classloader could not load the DTD file. Attempting to read from VOB instead: " + string2 + string);
            }
            serializable = null;
            try {
                serializable = this.useFlexibleDtdLocation ? new File(string) : new File(string2 + string);
                inputStream = new FileInputStream((File)serializable);
            }
            catch (IOException iOException) {
                if (serializable != null) {
                    System.out.println("Could not read the DTD file from the VOB location:" + iOException.getMessage());
                }
                throw new Exception("Could not read the DTD file:");
            }
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String extractDtdRevision(String string) {
        String string2 = "!ATTLISTFormatrevision(";
        char c = ')';
        InputStreamReader inputStreamReader = null;
        try {
            inputStreamReader = new InputStreamReader(this.newDtdInputStream(string));
            int n = 0;
            boolean bl = false;
            StringBuffer stringBuffer = new StringBuffer();
            while (inputStreamReader.ready()) {
                char c2 = (char)inputStreamReader.read();
                if (Character.isWhitespace(c2)) continue;
                if (!bl) {
                    if (c2 == string2.charAt(n)) {
                        if (++n != string2.length()) continue;
                        bl = true;
                        continue;
                    }
                    n = 0;
                    continue;
                }
                if (c2 == c) {
                    inputStreamReader.close();
                    inputStreamReader = null;
                    String string3 = stringBuffer.toString();
                    return string3;
                }
                if (c2 == '|') {
                    stringBuffer.append(',');
                    continue;
                }
                stringBuffer.append(c2);
            }
        }
        catch (Exception exception) {
            System.out.println("Ignored exception when reading DTD revision:" + exception.getMessage());
        }
        finally {
            if (inputStreamReader != null) {
                try {
                    inputStreamReader.close();
                }
                catch (Exception exception) {
                    System.out.println("Ignored exception when reading DTD revision:" + exception.getMessage());
                }
            }
        }
        return "?";
    }

    public void reSetHandler() {
        Nal.getLog().nalTraceEnter(XmlFileHandler.class, "finalize()");
        theInstance = null;
        this.inputFileName = null;
        this.currentService = null;
        this.serviceNames = null;
        this.sectorCellPrefix = null;
        this.lastParsedItem = null;
        this.lastParsedService = null;
        this.radioDotPrefix = null;
    }

    private String getPrefix(Attributes attributes, boolean bl, String string) throws BemXmlException {
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        String string7 = "";
        if (string.equals("AddEtBoard")) {
            this.globalEtbSlotNumber = attributes.getValue("etbSlot");
            string2 = MessageFormat.format("AddEtBoard_Slot{0}_", this.globalEtbSlotNumber);
        } else if (string.equals("AddIpEtBoard")) {
            this.globalIpEtbSlotNumber = attributes.getValue("etxSlot");
            string2 = MessageFormat.format("AddIpEtBoard_Slot{0}_", this.globalIpEtbSlotNumber);
        } else {
            if (string.equals("BatteryChargingConfiguration")) {
                string2 = PrefixUtil.getCabinetPrefix(this.cabinetNoPrefix);
                return string2;
            }
            if (string.equals("ClimateSystem") || string.equals("ClimateRegulationSystem")) {
                string2 = "SwitchCommonSupportSystem".equals(this.lastParsedService.getName()) ? PrefixUtil.getCabinetPrefix(this.lastAlarmCab) : PrefixUtil.getCabinetPrefix(this.cabinetNoPrefix);
                return string2;
            }
            if (string.equals("PowerSupply")) {
                string2 = PrefixUtil.getFirstCabinetPrefix();
                return string2;
            }
            if (string.equals("EcPort")) {
                ++this.ecPortCounter;
                string2 = MessageFormat.format("EcPort{0}_", String.valueOf(this.ecPortCounter));
                return string2;
            }
        }
        if (bl) {
            int n = ServiceCommon.getCounterValueForElement(string);
            if (string.equals("NetworkSynch") && n > 8) {
                throw new BemXmlException(ERR_MSG_TOO_MANY_SYNCS_ERROR);
            }
            if (string.equals("IkeSaTf") && n > 6) {
                throw new BemXmlException(ERR_MSG_TOO_MANY_IKESATF_ERROR);
            }
            if (string.equals("ChildSaTf") && n > 11) {
                throw new BemXmlException(ERR_MSG_TOO_MANY_IPSECTUNNLE_CHILDSATF_ERROR);
            }
            String string8 = ServiceCommon.getLetterValueForElement(string);
            string2 = string8 + String.valueOf(n) + "_";
            if (string.equals("Aal2Path")) {
                this.userDataPrefix = string2;
            }
            string2 = this.handleSpecialCases(string, string2);
        } else {
            String string9;
            Object object;
            String string10;
            String string11;
            String string12;
            if (this.globalElementSectorNumber != null) {
                string12 = ServiceCommon.getLetterValueForAttribute("sectorNumber");
                this.sectorCellPrefix = string2 = string12 + this.globalElementSectorNumber + "_";
            }
            if (string.equals("Connection")) {
                this.globalEtbSlotNumber = attributes.getValue("etbSlot");
                this.subElementToConnection = true;
            }
            if (string.equals("NetworkSynch")) {
                string12 = attributes.getValue("synchType");
                string11 = attributes.getValue("synchPort");
                if (string12 != null && (string11.equals("7") || string11.equals("8")) && "PTP".equals(string12)) {
                    string10 = MessageFormat.format("IPoverGigabitEthernet_{0}_", string11);
                    object = this.getCurrentXmlSource();
                    string9 = "PTP";
                    ServiceNameValue serviceNameValue = new ServiceNameValue(this.currentService.getName(), string10, "syncServerType", string9, (Source)object);
                    this.currentService.addAttribute(serviceNameValue);
                }
            }
            if (string.equals("IubIpAccessHostEt")) {
                this.ipsecConfigurationPrefix = "Iub_";
            }
            if (string.equals("OamIpHost")) {
                this.ipsecConfigurationPrefix = "OamIpHost_";
            }
            if (string.equals("PositionCoordinates") || string.equals("RadioDot") || string.equals("RadioDotNo")) {
                string2 = this.radioDotPrefix;
            }
            for (int i = 0; i < attributes.getLength(); ++i) {
                string11 = attributes.getLocalName(i);
                if (string11.equals("")) {
                    string11 = attributes.getQName(i);
                }
                string10 = attributes.getValue(i);
                if (string11.equals("synchPriority")) {
                    object = ServiceCommon.getLetterValueForAttribute("synchPriority");
                    string2 = (String)object + string10 + "_";
                    break;
                }
                if (string11.equals("sequenceNumber")) {
                    object = attributes.getValue("sectorNumber");
                    string9 = attributes.getValue("sequenceNumber");
                    if (this.AretConfigurationPrefix != null) {
                        string2 = this.AretConfigurationPrefix + "_";
                    }
                    string2 = string2 + MessageFormat.format("S{0}_", object);
                    string2 = string2 + MessageFormat.format("SEQ{0}_", string9);
                    continue;
                }
                if (string11.equals("sectorNumber") && !string.equalsIgnoreCase("Alarm") && !string.equalsIgnoreCase("AretConfiguration")) {
                    object = ServiceCommon.getLetterValueForAttribute("sectorNumber");
                    this.sectorCellPrefix = string2 = (String)object + string10 + "_";
                    break;
                }
                if ((string11.equals("radioUnitNumber") || string11.equals("isSharedWithExternalMe")) && string.equalsIgnoreCase("RadioUnit")) {
                    object = MessageFormat.format("AUX{0}_", string10);
                    string2 = this.sectorCellPrefix + (String)object;
                    break;
                }
                if (string11.equals("ATM_TD{0}_userDataATMPcr")) {
                    string2 = this.userDataPrefix;
                    break;
                }
                if (string11.equals("branch")) {
                    object = attributes.getValue(string11);
                    this.sectorCellPrefix = string2 = string2 + (String)object + "_";
                    break;
                }
                if (string11.equals("cellNumber")) {
                    object = ServiceCommon.getLetterValueForAttribute("cellNumber");
                    if (this.sectorCellPrefix != null && !this.sectorCellPrefix.equals("")) {
                        string2 = this.sectorCellPrefix + (String)object + string10 + "_";
                        break;
                    }
                    string2 = (String)object + string10 + "_";
                    break;
                }
                if (string11.equals("frequencyPlane")) {
                    object = ServiceCommon.getLetterValueForAttribute("frequencyPlane");
                    if (this.sectorCellPrefix != null) {
                        string2 = this.sectorCellPrefix + (String)object + string10 + "_";
                        break;
                    }
                    string2 = string2 + (String)object + string10 + "_";
                    break;
                }
                if (string11.equals("portId")) {
                    if (string.equalsIgnoreCase("Alarm")) {
                        object = attributes.getValue("externalAlarmUnit");
                        object = null == object ? "Xalm" : object;
                        string2 = PrefixUtil.getCabinetPrefix(this.lastAlarmCab) + (String)object + "ExternalAlarm" + string10 + "_";
                        string7 = string10;
                        continue;
                    }
                    object = attributes.getValue("externalAlarmUnit");
                    object = null == object ? "Xalm" : object;
                    string2 = PrefixUtil.getCabinetPrefix(this.lastAlarmCab) + (String)object + "ControlPort" + string10 + "_";
                    break;
                }
                if (string11.equals("sectorNumber")) {
                    if (!string.equalsIgnoreCase("Alarm") || !((String)(object = attributes.getValue("externalAlarmUnit"))).equalsIgnoreCase("Rruw") && !((String)object).equalsIgnoreCase("Iru")) continue;
                    string3 = string10;
                    continue;
                }
                if (string11.equals("rruwPositionInSector")) {
                    if (!string.equalsIgnoreCase("Alarm")) continue;
                    string4 = string10;
                    continue;
                }
                if (string11.equals("name")) {
                    object = ServiceCommon.getLetterValueForAttribute("name");
                    string9 = "firstOAMatm";
                    if ("firstOAMatm".equals(string10)) {
                        ++this.noOfFirstOAMatmAttributes;
                        if (this.noOfFirstOAMatmAttributes > 1) {
                            throw new BemXmlException("There must not be more than one \"Connection\" element\n      with attribute name=firstOAMatm");
                        }
                    } else if ("secondOAMatm".equals(string10)) {
                        string9 = "secondOAMatm";
                    }
                    this.oamAtmvalue = string2 = (String)object + string9 + "_";
                    break;
                }
                if (string.equals("AddDuwBoard")) {
                    string2 = "AddDuwBoard";
                    continue;
                }
                if (string.equals("IPoverGigabitEthernet")) {
                    string2 = "IPoverGigabitEthernet_";
                    continue;
                }
                if (string.equals("OamIpHost")) {
                    string2 = "OamIpHost_";
                    continue;
                }
                if (string.equals("EthernetSwitch")) {
                    string2 = "EthernetSwitch";
                    continue;
                }
                if (string.equals("IpSyncRef")) {
                    ++this.ipSyncRefCounter;
                    string2 = MessageFormat.format("IPoverGigabitEthernet_{0}_", String.valueOf(this.ipSyncRefCounter));
                    continue;
                }
                if (string.equals("PacketFrequencySyncRef")) {
                    ++this.ipSyncRefCounter;
                    break;
                }
                if (string.startsWith("EthernetSwitchPort")) {
                    if (!string11.equals("portNo")) continue;
                    object = ServiceCommon.getLetterValueForElement("EthernetSwitchPort");
                    this.ethernetSwitchPortPrefix = string2 = (String)object + "_" + string10 + "_";
                    this.subElementToEthernetSwitchPort = true;
                    break;
                }
                if (string.startsWith("VlanMembership")) {
                    if (!"EthernetSwitchPort_{0}_VlanMembership_{1}_vid".endsWith(string11)) continue;
                    if (this.subElementToEthernetSwitchPort) {
                        string2 = this.ethernetSwitchPortPrefix + "VlanMembership_" + string10 + "_";
                        break;
                    }
                    object = "EthernetSwitch";
                    string2 = (String)object + "VlanMembership_" + string10 + "_";
                    break;
                }
                if (string.startsWith("LinkAggregationGroup")) {
                    if (!"linkAggregationGroup_{0}_lagId".endsWith(string11)) continue;
                    string2 = MessageFormat.format("linkAggregationGroup_{0}_", string10);
                    break;
                }
                if (string11.startsWith("radioIfType")) {
                    string6 = "radioIfType";
                    continue;
                }
                if (string11.startsWith("poolNumber")) {
                    string5 = attributes.getValue("poolNumber");
                    continue;
                }
                if (string.equals("IubIpAccessHostEt")) {
                    string2 = "Iub_";
                    continue;
                }
                if (string.equals("IpSec")) {
                    string2 = "IpSec_";
                    continue;
                }
                if (string.equals("IkePeer")) {
                    string2 = this.ipsecConfigurationPrefix + "IkePeer_";
                    continue;
                }
                if (string.equals("IpSecTunnel")) {
                    string2 = this.ipsecConfigurationPrefix + "IpSecTunnel_";
                    continue;
                }
                if (string11.equals("radioDotNumber")) {
                    string2 = this.radioDotPrefix = this.sectorCellPrefix + "RD" + string10 + "_";
                    continue;
                }
                if (string.equals("DnsResolver")) {
                    string2 = this.ipsecConfigurationPrefix + "IkePeer_DnsResolver_";
                    continue;
                }
                if (!string.equals("DhcpClientIdentifier")) continue;
                string2 = "OamIpHost_DhcpClientIdentifier_";
            }
            if (string5 != "" && string6 != "") {
                string2 = string2 + string5;
            }
            if (!string3.equals("") && !string4.equals("") && string2.indexOf("Rruw") > -1) {
                string2 = string2 + string3 + "_" + string4 + "_";
            }
            if (!string3.equals("") && !string7.equalsIgnoreCase("") && string2.indexOf("Iru") > -1) {
                string2 = string2 + string3 + "_" + string7 + "_";
            }
        }
        return string2;
    }

    private String handleSpecialCases(String string, String string2) {
        if (string.equals("Aal2Path")) {
            this.userDataPrefix = string2;
        } else if (string.equals("EthernetSwitchPort")) {
            this.subElementToEthernetSwitchPort = true;
        } else if (string.equals("VlanMembership")) {
            String string3;
            string2 = this.subElementToEthernetSwitchPort ? (string3 = this.ethernetSwitchPortPrefix + string2) : "EthernetSwitch" + string2;
        } else if (string.equals("AtmPort")) {
            if (this.subElementToConnection) {
                string2 = this.oamAtmvalue;
            }
        } else if (string.equals("IkeSaTf")) {
            string2 = this.ipsecConfigurationPrefix + string2;
        } else if (string.equals("ChildSaTf")) {
            string2 = this.ipsecConfigurationPrefix + string2;
        }
        return string2;
    }

    private String getServiceElementPrefix(Attributes attributes, String string) throws BemXmlException {
        String string2 = "";
        if (string.equals("OptionalEquipmentConfiguration")) {
            String string3 = attributes.getValue("cabinetNumber");
            string2 = PrefixUtil.getCabinetPrefix(string3);
        } else if (string.equals("ModifyNoOfPsu") || string.equals("ModifyNoOfPdu") || string.equals("ModifyNoOfBfu") || string.equals("ModifyPowerSystem")) {
            String string4 = attributes.getValue("cabinetNumber");
            string2 = PrefixUtil.getCabinetPrefix(string4);
        } else if (string.equals("SwitchCommonSupportSystem")) {
            this.lastAlarmCab = "1s";
            string2 = PrefixUtil.getCabinetPrefix(this.lastAlarmCab);
        } else if (string.equals("ModifyExternalAlarms") || string.equals("ModifyExternalControls") || string.equals("AddExternalAlarmControlUnit")) {
            String string5 = attributes.getValue("cabinetNumber");
            this.lastAlarmCab = string5 == null ? CABINET_ONE : string5;
            string2 = PrefixUtil.getCabinetPrefix(this.lastAlarmCab);
        } else {
            if (string.equals("ClimateSystem") || string.equals("ClimateRegulationSystem")) {
                string2 = PrefixUtil.getCabinetPrefix(CABINET_ONE);
                return string2;
            }
            if (string.equals("AddEtBoard")) {
                this.globalEtbSlotNumber = attributes.getValue("etbSlot");
                string2 = MessageFormat.format("AddEtBoard_Slot{0}_", this.globalEtbSlotNumber);
            } else if (string.equals("AddIpEtBoard")) {
                this.globalIpEtbSlotNumber = attributes.getValue("etxSlot");
                string2 = MessageFormat.format("AddIpEtBoard_Slot{0}_", this.globalIpEtbSlotNumber);
            } else if (string.equals("AddAtmPort")) {
                this.globalEtbSlotNumber = attributes.getValue("etbSlot");
                string2 = MessageFormat.format("AddAtmPort_Slot{0}_", this.globalEtbSlotNumber);
            } else if (string.equals("AddPhysPathTerm")) {
                this.globalEtbSlotNumber = attributes.getValue("etbSlot");
                string2 = MessageFormat.format("AddPhysPathTerm_Slot{0}_", this.globalEtbSlotNumber);
            } else if (string.equals("DeleteRaxBoard")) {
                String string6 = attributes.getValue("raxSlot");
                string2 = MessageFormat.format("DeleteRaxBoard_Slot{0}_", string6);
            } else if (string.equals("DeleteAtmPort")) {
                int n = ServiceCommon.getCounterValueForElement(string);
                String string7 = ServiceCommon.getLetterValueForElement(string);
                string2 = string7 + String.valueOf(n) + "_";
            } else if (string.equals("DeletePhysPathTerm")) {
                int n = ServiceCommon.getCounterValueForElement(string);
                String string8 = ServiceCommon.getLetterValueForElement(string);
                string2 = string8 + String.valueOf(n) + "_";
            } else if (string.equals("AddSector")) {
                String string9 = "S";
                string2 = string9 + this.globalElementSectorNumber + "_";
            } else if (string.equals("CabinetProductData")) {
                String string10;
                string2 = string10 = "";
            } else if (string.startsWith("IpIubTestConfiguration")) {
                string2 = "IpIubTestConfiguration_";
            } else if (string.startsWith("IubNpcTestConfiguration")) {
                string2 = "IubNpcTestConfiguration_";
            } else if (string.startsWith("AddDuwBoard")) {
                string2 = "AddDuwBoard";
            } else if (string.equals("EcPort")) {
                ++this.ecPortCounter;
                string2 = MessageFormat.format("EcPort{0}_", String.valueOf(this.ecPortCounter));
            } else if (string.equals("EcBus") || string.equals("AddEcBus")) {
                String string11;
                this.globalElementEcbusNumber = string11 = attributes.getValue("ecBusNumber");
                string2 = MessageFormat.format("EcBus{0}_", string11);
            } else if (string.equals("ModifyEcBus")) {
                String string12;
                this.globalElementEcbusNumber = string12 = attributes.getValue("ecBusNumber");
                string2 = MessageFormat.format("ModEcBus{0}_", string12);
            } else if (string.equals("DeleteCell")) {
                string2 = this.getCellPrefix(this.globalElementSectorNumber, this.globalElementCellNumber);
            } else if (string.equals("ModifyNetworkSynch")) {
                string2 = this.getPrefix(attributes, false, "NetworkSynch");
            } else if (string.equals("Cabinet")) {
                String string13 = attributes.getValue("cabinetNumber");
                string2 = PrefixUtil.getCabinetPrefix(string13);
            } else if (string.equals("ExternalAlarmConfiguration")) {
                this.lastAlarmCab = attributes.getValue("cabinetNumber") == null ? CABINET_ONE : attributes.getValue("cabinetNumber");
            } else if (string.equals("ExternalControlConfiguration")) {
                this.lastAlarmCab = attributes.getValue("cabinetNumber") == null ? CABINET_ONE : attributes.getValue("cabinetNumber");
            } else if (string.equals("ConfigPowerBattery")) {
                String string14 = attributes.getValue("cabinetNumber");
                string2 = PrefixUtil.getCabinetPrefix(string14);
            } else if (string.equals("HwGroupConfig")) {
                ++this.hwGroupCounter;
                string2 = MessageFormat.format("HwGroup{0}_", String.valueOf(this.hwGroupCounter));
            } else if (string.equals("PositionConfiguration")) {
                ++this.positionConfigurationCounter;
                string2 = MessageFormat.format("POS_CONFIG{0}_", String.valueOf(this.positionConfigurationCounter));
            }
        }
        return string2;
    }

    private String getCellPrefix(String string, String string2) {
        String string3 = "";
        String string4 = "S";
        String string5 = "C";
        string3 = string4 + string + "_" + string5 + string2 + "_";
        return string3;
    }

    private String getFilteredValue(String string, String string2) {
        int n;
        String string3 = string2;
        if (string.equals("synchSlot") && (n = string2.lastIndexOf(",")) > 1) {
            string3 = string2.substring(n + 1);
        }
        return string3;
    }

    public String charsCorrect(String string) {
        int n;
        int n2 = -1;
        boolean bl = false;
        for (n = 0; n < INCORRECT_CHARS.length(); ++n) {
            n2 = string.indexOf(INCORRECT_CHARS.charAt(n));
            if (n2 < 0) continue;
            bl = true;
            break;
        }
        if (bl) {
            return INCORRECT_CHARS.charAt(n) + "";
        }
        return null;
    }

    private static class ConsistencyChecker {
        private HashMap addedSectors = new HashMap();
        private HashMap modifiedSectors = new HashMap();
        private HashMap modifiedAntennaSystem = new HashMap();
        private HashMap deletedSectors = new HashMap();
        private HashMap addedCabinets = new HashMap();
        private HashMap modifiedCabinets = new HashMap();
        private HashMap deletedCabinets = new HashMap();
        private HashMap addedEcbus = new HashMap();
        private HashMap modifiedEcbus = new HashMap();
        private List addDuwBoards = new ArrayList();

        ConsistencyChecker() {
        }

        void addedSector(String string) {
            this.addedSectors.put(string, "AddSector");
        }

        void deletedSector(String string) {
            this.deletedSectors.put(string, "DeleteSector");
        }

        void modifiedSector(String string) {
            this.modifiedSectors.put(string, "ModifySector");
        }

        void modifiedAntennaSystem(String string) {
            this.modifiedAntennaSystem.put(string, "ModifyAntennaSystem");
        }

        void addedCabinet(String string) {
            this.addedCabinets.put(string, "AddCabinet");
        }

        void modifiedCabinet(String string) {
            this.modifiedCabinets.put(string, "ModifyCabinet");
        }

        void deletedCabinet(String string) {
            this.deletedCabinets.put(string, "DeleteCabinet");
        }

        boolean addSameCabinetNumber(String string) {
            return this.addedCabinets.containsKey(string);
        }

        boolean modifySameCabinetNumber(String string) {
            return this.modifiedCabinets.containsKey(string);
        }

        boolean deleteSameCabinetNumber(String string) {
            return this.deletedCabinets.containsKey(string);
        }

        void addedEcbus(String string) {
            this.addedEcbus.put(string, "addedEcbus");
        }

        void modifiedEcbus(String string) {
            this.modifiedEcbus.put(string, "modifiedEcbus");
        }

        void addDuwBoard(String string) {
            this.addDuwBoards.add(string);
        }

        void checkConsistency() throws BemXmlException {
            String string;
            Iterator iterator;
            Object object;
            Object object22;
            Set set = this.deletedSectors.keySet();
            for (Object object22 : set) {
                if (this.addedSectors.containsKey(object22)) {
                    throw new BemXmlException("It is not valid to have both DeleteSector and AddSector for sector " + (String)object22);
                }
                if (this.modifiedSectors.containsKey(object22)) {
                    throw new BemXmlException("It is not valid to have both DeleteSector and ModifySector for sector " + (String)object22);
                }
                if (!this.modifiedAntennaSystem.containsKey(object22)) continue;
                throw new BemXmlException("It is not valid to have both DeleteSector and ModifyAntennaSystem for sector " + (String)object22);
            }
            object22 = this.deletedCabinets.keySet();
            Iterator iterator2 = object22.iterator();
            while (iterator2.hasNext()) {
                object = (String)iterator2.next();
                if (this.addedCabinets.containsKey(object)) {
                    throw new BemXmlException("It is not valid to have both DeleteCabinet and AddCabinet for cabinet " + (String)object);
                }
                if (!this.modifiedCabinets.containsKey(object)) continue;
                throw new BemXmlException("It is not valid to have both DeleteCabinet and ModifyCabinet for cabinet " + (String)object);
            }
            object = this.modifiedCabinets.keySet();
            Iterator iterator3 = object.iterator();
            while (iterator3.hasNext()) {
                iterator = (String)iterator3.next();
                if (!this.addedCabinets.containsKey(iterator)) continue;
                throw new BemXmlException("It is not valid to have both ModifyCabinet and AddCabinet for cabinet " + (String)((Object)iterator));
            }
            iterator = this.modifiedEcbus.keySet().iterator();
            if (iterator.hasNext() && this.addedEcbus.containsKey(string = (String)iterator.next())) {
                throw new BemXmlException("It is not valid to have both AddEcBus and ModifyEcBus for EcBus " + string);
            }
            if (this.addDuwBoards.size() > 1) {
                throw new BemXmlException("It is not valid to add more than one duw!");
            }
        }
    }
}

