/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.nal.impl.backend;

import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalBackend;

public class NalNameValueBackend
extends NalBackend {
    private final String name;
    private final Object nalValue;

    public NalNameValueBackend(String string, Object object) {
        this.name = string;
        this.nalValue = NalBackend.wrapNativeObject(object);
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.nalValue;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("{");
        stringBuffer.append(this.name);
        stringBuffer.append(", ");
        this.formatValue(stringBuffer, this.nalValue);
        stringBuffer.append('}');
        String string = stringBuffer.toString();
        return string;
    }

    protected void formatValue(StringBuffer stringBuffer, Object object) {
        if (object == null) {
            stringBuffer.append("null");
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            stringBuffer.append("[");
            if (nArray.length > 0) {
                stringBuffer.append(String.valueOf(nArray[0]));
            }
            for (int i = 1; i < nArray.length; ++i) {
                stringBuffer.append(';');
                stringBuffer.append(String.valueOf(nArray[i]));
            }
            stringBuffer.append("]");
        } else if (object instanceof float[]) {
            float[] fArray = (float[])object;
            stringBuffer.append("[");
            if (fArray.length > 0) {
                stringBuffer.append(String.valueOf(fArray[0]));
            }
            for (int i = 1; i < fArray.length; ++i) {
                stringBuffer.append(';');
                stringBuffer.append(String.valueOf(fArray[i]));
            }
            stringBuffer.append("]");
        } else if (object instanceof Object[]) {
            Object[] objectArray = (Object[])object;
            stringBuffer.append("[");
            if (objectArray.length > 0) {
                this.formatValue(stringBuffer, objectArray[0]);
            }
            for (int i = 1; i < objectArray.length; ++i) {
                stringBuffer.append(';');
                this.formatValue(stringBuffer, objectArray[i]);
            }
            stringBuffer.append("]");
        } else {
            stringBuffer.append(object.toString());
        }
    }
}

