/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.script.impl.client;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.Date;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import se.ericsson.wcdma.rbs.bem.common.RbsEmPropertiesFileHandler;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.script.BemScriptUtil;

public class BemScriptUtilImpl
implements BemScriptUtil {
    private static RbsEmPropertiesFileHandler rbsEmProp = RbsEmPropertiesFileHandler.getInstance();
    private String outputDirectory = System.getProperty("user.home");
    private FileOutputStream procedureFileOutputStream;
    private PrintWriter procedurePrintWriter;
    private FileOutputStream stepFileOutputStream;
    private PrintWriter stepPrintWriter;
    private boolean procedureActive = false;
    private boolean stepActive = false;
    private static final String SYNTAX_FILE_HEADER = "//\n// File Name: {0}\n// Created:    {1}\n//\n\nECHO \"Executing file:  {0}\" \n\n";
    private static final String SYNTAX_COMMENT = "\n// {0}\n\n";
    private static final String SYNTAX_COMMAND = "{0}\n(\n{1})\n";
    private static final String SYNTAX_PARENT = "\tparent\t{0}\n";
    private static final String SYNTAX_MO = "\tmo\t{0}\n";
    private static final String SYNTAX_IDENTITY = "\tidentity\t\"{0}\"\n";
    private static final String SYNTAX_MOTYPE = "\tmoType\t{0}\n";
    private static final String SYNTAX_EXCEPTION = "\texception\tnone\n";
    private static final String SYNTAX_NROFATTRIBUTES = "\tnrOfAttributes\t{0}\n";
    private static final String SYNTAX_NROFPARAMETERS = "\tnrOfParameters\t{0}\n";
    private static final String SYNTAX_ACTIONNAME = "\tactionName\t{0}\n";
    private static final String SYNTAX_FILENAME = "\t\t{0}\n";
    private static final String SYNTAX_ATTRIBUTE = "\t{0}\t{1}\t{2}\n";
    private static final String SYNTAX_ATTRIBUTES = "\t\t{0}\t{1}\t{2}\n";
    private static final String SYNTAX_PARAMETER = "\t\t{0}\t{1}\n";
    private static final String SYNTAX_ATTRIBUTE_STRUCT_HEADER = "\t\t{0} Struct\n";
    private static final String SYNTAX_PARAMETER_STRUCT_HEADER = "\t\tStruct\n";
    private static final String SYNTAX_ATTRIBUTE_STRUCT_NROFELEMENTS = "\t\t\tnrOfElements {0}\n";
    private static final String SYNTAX_PARAMETER_STRUCT_NROFELEMENTS = "\t\t\tnrOfElements {0}\n";
    private static final String SYNTAX_ATTRIBUTE_STRUCT_ELEMENT = "\t\t\t\t{0} {1} {2}\n";
    private static final String SYNTAX_PARAMETER_STRUCT_ELEMENT = "\t\t\t\t{1} {2}\n";
    private static final String SYNTAX_ATTRIBUTE_ARRAY_HEADER = "\t\t{0} Array {1} {2}\n";
    private static final String SYNTAX_PARAMETER_ARRAY_HEADER = "\t\tArray {1} {2}\n";
    private static final String SYNTAX_ATTRIBUTE_ARRAY_VALUE = "\t\t\t{0}\n";
    private static final String SYNTAX_PARAMETER_ARRAY_VALUE = "\t\t\t{0}\n";
    private static final String SYNTAX_RETURNVALUE = "\treturnValue\tnone\n";
    private static final String COMMAND_CREATE = "CREATE";
    private static final String COMMAND_DELETE = "DELETE";
    private static final String COMMAND_SET = "SET";
    private static final String COMMAND_ACTION = "ACTION";
    private static final String COMMAND_CALL = "CALL";
    private static final String DATATYPE_BOOLEAN = "Boolean";
    private static final String DATATYPE_STRING = "String";
    private static final String DATATYPE_INTEGER = "Integer";
    private static final String DATATYPE_LONG = "Long";
    private static final String DATATYPE_REFERENCE = "Reference";
    private static final String DATATYPE_ARRAY = "Array";
    private static final String DATATYPE_STRUCT = "Struct";
    private static final String FILE_EXTENSION = ".mo";
    private int counter;

    public void scriptStartConfigurationProcedure(String string) {
        this.stopGenerating();
        boolean bl = false;
        String string2 = "SCRIPT_GEN";
        String string3 = rbsEmProp.getProperty(string2);
        if (string3 == null) {
            string3 = "OFF";
        }
        bl = !string3.equals("ON") && !string3.equals("on");
        string2 = "SCRIPT_GEN_OUTPUT_PATH";
        this.outputDirectory = rbsEmProp.getProperty(string2);
        if (this.outputDirectory == null) {
            this.outputDirectory = System.getProperty("user.home");
        }
        while (!bl) {
            JFileChooser jFileChooser = new JFileChooser(this.outputDirectory);
            jFileChooser.setDialogTitle("Script Generator: select output directory");
            jFileChooser.setFileSelectionMode(1);
            File file = new File(this.outputDirectory);
            jFileChooser.setSelectedFile(file);
            int n = jFileChooser.showDialog(null, "Select");
            if (n != 0) {
                this.stopGenerating();
                bl = true;
                continue;
            }
            try {
                this.outputDirectory = jFileChooser.getSelectedFile().getAbsolutePath();
                String string4 = this.outputDirectory + File.separator + string + FILE_EXTENSION;
                File file2 = new File(string4);
                this.procedureFileOutputStream = new FileOutputStream(string4);
                this.procedurePrintWriter = new PrintWriter(this.procedureFileOutputStream, true);
                Date date = new Date(System.currentTimeMillis());
                String string5 = this.formatLine(SYNTAX_FILE_HEADER, file2.getName(), date.toString());
                this.procedurePrintWriter.println(string5);
                bl = true;
                this.procedureActive = true;
                this.stepActive = false;
            }
            catch (IOException iOException) {
                int n2 = JOptionPane.showConfirmDialog(null, iOException.toString() + "\n\nThe directory could not be used for file output\n\nPress OK to select a new directory\npress Cancel to run the wizard without Script generation", "Invalid Directory", 2, 0);
                if (n2 != 2) continue;
                bl = true;
                this.stopGenerating();
            }
        }
    }

    public void scriptStartConfigurationProcedure(String string, PrintWriter printWriter) {
        this.stopGenerating();
        this.procedurePrintWriter = printWriter;
        Date date = new Date(System.currentTimeMillis());
        String string2 = "//\n// Part Name: " + string + "\n" + "// Created:    " + date + "\n" + "//\n\n" + "ECHO \"Executing part:  " + string + "\" \n\n";
        String string3 = this.formatLine(string2, string, date.toString());
        this.procedurePrintWriter.println(string3);
        this.procedureActive = true;
        this.stepActive = false;
    }

    public void scriptEndConfigurationProcedure() {
        this.stopGenerating();
    }

    public void scriptStartConfigurationStep(String string) {
        if (this.procedureActive) {
            try {
                if (string.equals("StartMainTransactionPhase")) {
                    ++this.counter;
                    string = string + this.counter;
                }
                String string2 = this.outputDirectory + File.separator + string + FILE_EXTENSION;
                File file = new File(string2);
                this.stepFileOutputStream = new FileOutputStream(string2);
                this.stepPrintWriter = new PrintWriter(this.stepFileOutputStream, true);
                Date date = new Date(System.currentTimeMillis());
                String string3 = this.formatLine(SYNTAX_FILE_HEADER, file.getName(), date.toString());
                this.stepPrintWriter.println(string3);
                String string4 = this.formatLine(SYNTAX_FILENAME, string + FILE_EXTENSION);
                String string5 = this.formatLine(SYNTAX_COMMAND, COMMAND_CALL, string4);
                this.procedurePrintWriter.println(string5);
                this.stepActive = true;
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.error(fileNotFoundException.toString() + "at scriptStartConfigurationStep()");
            }
        }
    }

    public void scriptStartConfigurationStep(String string, PrintWriter printWriter) {
        if (this.procedureActive) {
            this.stepPrintWriter = printWriter;
            Date date = new Date(System.currentTimeMillis());
            String string2 = "//\n// Part Name: " + string + "\n" + "// Created:    " + date + "\n" + "//\n\n" + "ECHO \"Executing part:  " + string + "\" \n\n";
            String string3 = this.formatLine(string2, string, date.toString());
            this.stepPrintWriter.println(string3);
            String string4 = this.formatLine(SYNTAX_FILENAME, string + FILE_EXTENSION);
            String string5 = this.formatLine(SYNTAX_COMMAND, COMMAND_CALL, string4);
            this.procedurePrintWriter.println(string5);
            this.stepActive = true;
        }
    }

    public void scriptEndConfigurationStep() {
        this.closeStepFile();
    }

    public boolean isActive() {
        return this.procedureActive && this.stepActive;
    }

    private void stopGenerating() {
        try {
            if (this.procedureFileOutputStream != null) {
                this.procedureFileOutputStream.close();
            }
            if (this.stepFileOutputStream != null) {
                this.stepFileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.procedureFileOutputStream = null;
        this.procedurePrintWriter = null;
        this.stepFileOutputStream = null;
        this.stepPrintWriter = null;
        this.procedureActive = false;
        this.stepActive = false;
    }

    private void closeStepFile() {
        try {
            if (this.stepFileOutputStream != null) {
                this.stepFileOutputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.stepFileOutputStream = null;
        this.stepPrintWriter = null;
        this.stepActive = false;
    }

    public void scriptIsExisting(BemMo bemMo) {
    }

    public void scriptCreate(BemMo bemMo) {
        if (this.isActive()) {
            String string = this.formatLine(SYNTAX_PARENT, this.formatDataValue(bemMo.getParent())) + this.formatLine(SYNTAX_IDENTITY, bemMo.getId()) + this.formatLine(SYNTAX_MOTYPE, bemMo.getType()) + this.formatLine(SYNTAX_EXCEPTION) + this.formatLine(SYNTAX_NROFATTRIBUTES, "0");
            this.writeCommand(COMMAND_CREATE, string);
        }
    }

    public void scriptCreate(BemMo bemMo, NalNameValue[] nalNameValueArray) {
        if (this.isActive()) {
            String string = this.formatLine(SYNTAX_PARENT, this.formatDataValue(bemMo.getParent())) + this.formatLine(SYNTAX_IDENTITY, bemMo.getId()) + this.formatLine(SYNTAX_MOTYPE, bemMo.getType()) + this.formatLine(SYNTAX_EXCEPTION) + this.formatLine(SYNTAX_NROFATTRIBUTES, "" + nalNameValueArray.length) + this.formatAttributes(nalNameValueArray);
            this.writeCommand(COMMAND_CREATE, string);
        }
    }

    public void scriptDelete(BemMo bemMo) {
        if (this.isActive()) {
            String string = this.formatLine(SYNTAX_MO, this.formatDataValue(bemMo) + this.formatLine(SYNTAX_EXCEPTION));
            this.writeCommand(COMMAND_DELETE, string);
        }
    }

    public void scriptAction(BemMo bemMo, String string, NalNameValue[] nalNameValueArray) {
        if (this.isActive()) {
            String string2 = this.formatLine(SYNTAX_ACTIONNAME, string) + this.formatLine(SYNTAX_MO, this.formatDataValue(bemMo)) + this.formatLine(SYNTAX_EXCEPTION) + this.formatLine(SYNTAX_NROFPARAMETERS, "" + nalNameValueArray.length) + this.formatParameters(nalNameValueArray) + this.formatLine(SYNTAX_RETURNVALUE);
            this.writeCommand(COMMAND_ACTION, string2);
        }
    }

    public void scriptAction(BemMo bemMo, String string, NalNameValue[] nalNameValueArray, NalTransaction nalTransaction) {
        if (this.isActive()) {
            this.scriptAction(bemMo, string, nalNameValueArray);
        }
    }

    public void scriptGetChildren(BemMo bemMo) {
    }

    public void scriptGetChildren(BemMo bemMo, int n, String string, String string2) {
    }

    public void scriptGetAttributes(BemMo bemMo, String[] stringArray) {
    }

    public void scriptGetAttribute(BemMo bemMo, String string) {
    }

    public void scriptSetAttribute(BemMo bemMo, String string, Object object) {
        if (this.isActive()) {
            String string2 = this.formatLine(SYNTAX_MO, this.formatDataValue(bemMo)) + this.formatLine(SYNTAX_EXCEPTION);
            String string3 = this.getDataTypeName(object);
            string2 = string3.equals(DATATYPE_ARRAY) ? string2 + this.formatArray(SYNTAX_ATTRIBUTE_ARRAY_HEADER, "\t\t\t{0}\n", string, object) : (string3.equals(DATATYPE_STRUCT) ? string2 + this.formatStruct(SYNTAX_ATTRIBUTE_STRUCT_HEADER, "\t\t\tnrOfElements {0}\n", SYNTAX_ATTRIBUTE_STRUCT_ELEMENT, string, (NalStruct)object) : string2 + this.formatLine(SYNTAX_ATTRIBUTE, string, this.getDataTypeName(object), this.formatDataValue(object)));
            this.writeCommand(COMMAND_SET, string2);
        }
    }

    public void scriptSetAttributes(BemMo bemMo, NalNameValue[] nalNameValueArray) {
        if (this.isActive() && nalNameValueArray != null) {
            for (int i = 0; i < nalNameValueArray.length; ++i) {
                String string = nalNameValueArray[i].getName();
                Object object = nalNameValueArray[i].getValue();
                this.scriptSetAttribute(bemMo, string, object);
            }
        }
    }

    public void scriptResult(BemMo bemMo, Object object) {
    }

    public void scriptBeginTransaction() {
    }

    public void scriptEndTransaction(boolean bl) {
    }

    public void scriptAddComment(String string) {
        if (this.isActive()) {
            this.writeComment(string);
        }
    }

    private String getDataTypeName(Object object) {
        if (object instanceof Boolean) {
            return DATATYPE_BOOLEAN;
        }
        if (object instanceof String) {
            return DATATYPE_STRING;
        }
        if (object instanceof Integer) {
            return DATATYPE_INTEGER;
        }
        if (object instanceof BemMo) {
            return DATATYPE_REFERENCE;
        }
        if (object instanceof NalStruct) {
            return DATATYPE_STRUCT;
        }
        if (object.getClass().isArray()) {
            return DATATYPE_ARRAY;
        }
        if (object instanceof Long) {
            return DATATYPE_LONG;
        }
        System.out.println("Unsupported data type: " + object.getClass().getName());
        throw new IllegalArgumentException(object.toString());
    }

    private String getArrayDataTypeName(Object object) {
        if (object instanceof boolean[]) {
            return DATATYPE_BOOLEAN;
        }
        if (object instanceof Boolean[]) {
            return DATATYPE_BOOLEAN;
        }
        if (object instanceof String[]) {
            return DATATYPE_STRING;
        }
        if (object instanceof Integer[]) {
            return DATATYPE_INTEGER;
        }
        if (object instanceof int[]) {
            return DATATYPE_INTEGER;
        }
        if (object instanceof BemMo[]) {
            return DATATYPE_REFERENCE;
        }
        if (object instanceof NalStruct[]) {
            return DATATYPE_STRUCT;
        }
        System.out.println("Unsupported array data type: " + object);
        throw new IllegalArgumentException(object.toString());
    }

    private Object[] convertToObjectArray(Object object) {
        if (object instanceof boolean[]) {
            boolean[] blArray = (boolean[])object;
            Object[] objectArray = new Boolean[blArray.length];
            for (int i = 0; i < blArray.length; ++i) {
                objectArray[i] = blArray[i];
            }
            return objectArray;
        }
        if (object instanceof int[]) {
            int[] nArray = (int[])object;
            Object[] objectArray = new Integer[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                objectArray[i] = nArray[i];
            }
            return objectArray;
        }
        if (object instanceof Object[]) {
            return (Object[])object;
        }
        System.out.println("Unsupported data type in array" + object);
        throw new IllegalArgumentException(object.toString());
    }

    private String formatDataValue(Object object) {
        if (object instanceof Boolean) {
            return object.toString();
        }
        if (object instanceof String) {
            return "\"" + object + "\"";
        }
        if (object instanceof Integer) {
            return object.toString();
        }
        if (object instanceof Long) {
            return object.toString();
        }
        if (object instanceof BemMo) {
            return "\"" + ((BemMo)object).getDN() + "\"";
        }
        if (object instanceof NalStruct) {
            String string = this.formatStruct("", "\t\t\tnrOfElements {0}\n", SYNTAX_ATTRIBUTE_STRUCT_ELEMENT, null, (NalStruct)object);
            return string;
        }
        System.out.println("Unsupported data type :" + object.getClass().getName() + " - " + object.toString());
        throw new IllegalArgumentException(object.toString());
    }

    private String formatArray(String string, String string2, String string3, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        Object[] objectArray = this.convertToObjectArray(object);
        String string4 = this.getArrayDataTypeName(objectArray);
        stringBuffer.append(this.formatLine(string, string3, string4, objectArray.length + ""));
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(this.formatLine(string2, this.formatDataValue(objectArray[i])));
        }
        return stringBuffer.toString();
    }

    private String formatStruct(String string, String string2, String string3, String string4, NalStruct nalStruct) {
        StringBuffer stringBuffer = new StringBuffer();
        NalNameValue[] nalNameValueArray = nalStruct.getNameValueArray();
        stringBuffer.append(this.formatLine(string, string4));
        stringBuffer.append(this.formatLine(string2, nalNameValueArray.length + ""));
        for (int i = 0; i < nalNameValueArray.length; ++i) {
            stringBuffer.append(this.formatLine(string3, nalNameValueArray[i].getName(), this.getDataTypeName(nalNameValueArray[i].getValue()), this.formatDataValue(nalNameValueArray[i].getValue())));
        }
        return stringBuffer.toString();
    }

    private String formatParameters(NalNameValue[] nalNameValueArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nalNameValueArray.length; ++i) {
            Object object;
            String string = this.getDataTypeName(nalNameValueArray[i].getValue());
            if (string.equals(DATATYPE_ARRAY)) {
                object = this.convertToObjectArray(nalNameValueArray[i].getValue());
                stringBuffer.append(this.formatArray(SYNTAX_PARAMETER_ARRAY_HEADER, "\t\t\t{0}\n", nalNameValueArray[i].getName(), object));
                continue;
            }
            if (string.equals(DATATYPE_STRUCT)) {
                object = (NalStruct)nalNameValueArray[i].getValue();
                stringBuffer.append(this.formatStruct(SYNTAX_PARAMETER_STRUCT_HEADER, "\t\t\tnrOfElements {0}\n", SYNTAX_PARAMETER_STRUCT_ELEMENT, null, (NalStruct)object));
                continue;
            }
            object = this.formatDataValue(nalNameValueArray[i].getValue());
            stringBuffer.append(this.formatLine(SYNTAX_PARAMETER, string, (String)object));
        }
        return stringBuffer.toString();
    }

    private String formatAttributes(NalNameValue[] nalNameValueArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nalNameValueArray.length; ++i) {
            Object object;
            String string = this.getDataTypeName(nalNameValueArray[i].getValue());
            if (string.equals(DATATYPE_ARRAY)) {
                object = this.convertToObjectArray(nalNameValueArray[i].getValue());
                stringBuffer.append(this.formatArray(SYNTAX_ATTRIBUTE_ARRAY_HEADER, "\t\t\t{0}\n", nalNameValueArray[i].getName(), object));
                continue;
            }
            if (string.equals(DATATYPE_STRUCT)) {
                object = (NalStruct)nalNameValueArray[i].getValue();
                stringBuffer.append(this.formatStruct(SYNTAX_ATTRIBUTE_STRUCT_HEADER, "\t\t\tnrOfElements {0}\n", SYNTAX_ATTRIBUTE_STRUCT_ELEMENT, nalNameValueArray[i].getName(), (NalStruct)object));
                continue;
            }
            object = this.formatDataValue(nalNameValueArray[i].getValue());
            Object[] objectArray = new Object[]{nalNameValueArray[i].getName(), string, object};
            stringBuffer.append(MessageFormat.format(SYNTAX_ATTRIBUTES, objectArray));
        }
        return stringBuffer.toString();
    }

    private String formatLine(String string) {
        return string;
    }

    private String formatLine(String string, String string2) {
        Object[] objectArray = new Object[]{string2};
        return MessageFormat.format(string, objectArray);
    }

    private String formatLine(String string, String string2, String string3) {
        Object[] objectArray = new Object[]{string2, string3};
        return MessageFormat.format(string, objectArray);
    }

    private String formatLine(String string, String string2, String string3, String string4) {
        Object[] objectArray = new Object[]{string2, string3, string4};
        return MessageFormat.format(string, objectArray);
    }

    private void writeComment(String string) {
        if (this.stepPrintWriter != null) {
            Object[] objectArray = new Object[]{string};
            this.stepPrintWriter.println(MessageFormat.format(SYNTAX_COMMENT, objectArray));
            if (this.stepPrintWriter.checkError()) {
                this.error("IO error at writeComment()");
            }
        }
    }

    private void writeCommand(String string, String string2) {
        if (this.stepPrintWriter != null) {
            Object[] objectArray = new Object[]{string, string2};
            this.stepPrintWriter.println(MessageFormat.format(SYNTAX_COMMAND, objectArray));
            if (this.stepPrintWriter.checkError()) {
                this.error("IO error at writeComment()");
            }
        }
    }

    private void error(String string) {
        JOptionPane.showConfirmDialog(null, string + "\n\nAborting Script Generation", "Error", -1, 0);
        this.stopGenerating();
    }
}

