/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.subcontrol;

import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.phase.Phase;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.util.SubInstaller;

public class UnInstallCIsPostController
implements SubInstaller {
    private int totalNumberOfProgressReports = 50;
    private Installer theInstaller = null;
    private String theName = null;
    private int myProgressReports = 0;
    private String theDescription = "Install according to choices";
    private static final String PREFIX_DESCRIPTION = "Currently handling ";
    private WizardCIModel model = null;
    private Rbs rbs = null;
    private Phase[] unInstallationPhases = null;

    public UnInstallCIsPostController(Installer installer, WizardCIModel wizardCIModel) {
        this.theInstaller = installer;
        this.theName = this.getClass().getName();
        this.model = wizardCIModel;
        this.rbs = this.model.getRbs();
        this.unInstallationPhases = this.rbs.getUninstallationPhases();
        int n = this.unInstallationPhases.length;
        this.myProgressReports = this.totalNumberOfProgressReports = n + 5;
    }

    public boolean install() throws BemException {
        this.theInstaller.reportProgress(this.theName, this.theDescription);
        --this.myProgressReports;
        if (this.theInstaller.isInterrupted()) {
            return false;
        }
        try {
            this.theDescription = "Reading resources to uninstall";
            this.theInstaller.reportProgress(this.theName, this.theDescription);
            --this.myProgressReports;
            List list = this.rbs.getRIsToUninstall();
            this.theDescription = "Starting uninstallation";
            this.theInstaller.reportProgress(this.theName, this.theDescription);
            --this.myProgressReports;
            for (Phase phase : this.unInstallationPhases) {
                String string = phase.getName();
                String string2 = this.removePhaseFromName(string);
                this.theDescription = PREFIX_DESCRIPTION + string2;
                this.theInstaller.reportProgress(this.theName, this.theDescription);
                --this.myProgressReports;
                String string3 = this.theDescription;
                for (ResourceItem resourceItem : list) {
                    this.theDescription = string3 + " " + resourceItem.getDisplayName();
                    resourceItem.uninstall(string);
                    if (!this.theInstaller.isInterrupted()) continue;
                    return false;
                }
            }
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException("Installing data on node", "", "", this.theDescription, exception);
            throw wizardException;
        }
        while (this.myProgressReports > 0) {
            this.theInstaller.reportProgress(this.theName, this.theDescription);
            --this.myProgressReports;
        }
        return true;
    }

    public int getTotalNoOfProgressReports() {
        return this.totalNumberOfProgressReports;
    }

    public String getTheName() {
        return this.theName;
    }

    public String getTheDescription() {
        return this.theDescription;
    }

    private String removePhaseFromName(String string) {
        String string2 = string;
        if (string.endsWith("Phase")) {
            int n = string.lastIndexOf("Phase");
            string2 = string.substring(0, n);
        }
        return string2;
    }
}

