/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ClimateRegulationSystem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ClimateSystem;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterCheckbox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComboBox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTable;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterViewer;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;

public class DataDuwView
extends BemWizardGuiView
implements CustomerParameterViewer {
    private static final int TABLE_COLUMNS = 3;
    private static final String[] COLUMN_NAMES = new String[]{"Sector", "Radio building block", "Line rate"};
    private Enumeration[] radioBuildingBlockParameters;
    private Enumeration[] lineRateParameters;
    private String[] rbsTypes;
    private String selectedRbsType;
    private JComboBox rbsTypesComboBox;
    private ActionListener rbsTypeListener;
    private TrueFalseCustomerParameter supportSystemControl;
    private CustomerParameterCheckbox sscCheckBox;
    private boolean supportSystemAvailable = false;
    private ClimateSystem configureClimateSystem;
    private CustomerParameterComboBox configureClimateSystemComboBox;
    private CustomerParameterPanel configureClimateSystemPanel;
    private ClimateRegulationSystem configureClimateRegulationSystem;
    private CustomerParameterComboBox configureClimateRegulationSystemComboBox;
    private CustomerParameterPanel configureClimateRegulationSystemPanel;
    private StringParameter productionDate;
    private StringParameter productName;
    private StringParameter productNumber;
    private StringParameter productRevision;
    private StringParameter serialNumber;
    private CustomerParameterTable sectorOptionstableTable;
    private int numberOfSectors;

    protected void init() {
        super.init();
    }

    public void setRadioBuildingBlock(Enumeration[] enumerationArray) {
        this.radioBuildingBlockParameters = enumerationArray;
    }

    public void setSectorSequence(Enumeration[] enumerationArray) {
    }

    public void setPrimaryPortId(Enumeration[] enumerationArray) {
    }

    public void setLineRate(Enumeration[] enumerationArray) {
        this.lineRateParameters = enumerationArray;
    }

    public void setConfigureClimateSystem(ClimateSystem climateSystem) {
        this.configureClimateSystem = climateSystem;
    }

    public void setConfigureClimateRegulationSystem(ClimateRegulationSystem climateRegulationSystem) {
        this.configureClimateRegulationSystem = climateRegulationSystem;
    }

    public void setCabinetProductData(StringParameter stringParameter, StringParameter stringParameter2, StringParameter stringParameter3, StringParameter stringParameter4, StringParameter stringParameter5) {
        this.productionDate = stringParameter;
        this.productName = stringParameter2;
        this.productNumber = stringParameter3;
        this.productRevision = stringParameter4;
        this.serialNumber = stringParameter5;
    }

    public void setSupportSystemAvailable(boolean bl) {
        this.supportSystemAvailable = bl;
    }

    public void setSupportSystemControl(TrueFalseCustomerParameter trueFalseCustomerParameter) {
        this.supportSystemControl = trueFalseCustomerParameter;
    }

    public void setNumberOfSectors(int n) {
        this.numberOfSectors = n;
    }

    public void setRbsTypes(String[] stringArray) {
        this.rbsTypes = stringArray;
    }

    public String getRbsType() {
        return (String)this.rbsTypesComboBox.getSelectedItem();
    }

    public void setRbsType(String string) {
        this.selectedRbsType = string;
        this.rbsTypesComboBox.setSelectedItem(this.selectedRbsType);
    }

    public void setRbsTypeListener(ActionListener actionListener) {
        this.rbsTypesComboBox.removeActionListener(this.rbsTypeListener);
        this.rbsTypeListener = actionListener;
        this.rbsTypesComboBox.addActionListener(this.rbsTypeListener);
    }

    public void removeRbsTypeListener() {
        if (this.rbsTypeListener != null) {
            this.rbsTypesComboBox.removeActionListener(this.rbsTypeListener);
        }
    }

    public String getGuiNameForCustomerParameter(String string) {
        String string2 = null;
        if (this.sectorOptionstableTable != null && this.sectorOptionstableTable.isParameterInTable(string)) {
            string2 = this.sectorOptionstableTable.getRowAndColumnName(string);
        }
        return string2;
    }

    public void setFocusOnCustomerParameterComponent(String string) {
        if (this.sectorOptionstableTable != null && this.sectorOptionstableTable.isParameterInTable(string)) {
            this.sectorOptionstableTable.setFocusOnCell(string);
        }
    }

    public void updateGui() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)this.createOtherOptionsPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)this.createCabinetProductDataPanel(), gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        jPanel.add((Component)this.createSectorOptionsPanel(), gridBagConstraints);
        gridBagConstraints.weighty = 100.0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        jPanel.add((Component)new JPanel(), gridBagConstraints);
        this.addMainPanel(jPanel);
    }

    private JPanel createCabinetProductDataPanel() {
        CustomerParameterPanel customerParameterPanel;
        CustomerParameterTextField customerParameterTextField;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Cabinet product data"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (this.productionDate != null) {
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            customerParameterTextField = new CustomerParameterTextField(this.productionDate);
            customerParameterTextField.setColumns(16);
            customerParameterPanel = new CustomerParameterPanel("Production date: ", customerParameterTextField);
            jPanel.add((Component)customerParameterPanel.getLabel(), gridBagConstraints);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)customerParameterPanel, gridBagConstraints);
        }
        if (this.productName != null) {
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            customerParameterTextField = new CustomerParameterTextField(this.productName);
            customerParameterTextField.setColumns(16);
            customerParameterPanel = new CustomerParameterPanel("Product name: ", customerParameterTextField);
            jPanel.add((Component)customerParameterPanel.getLabel(), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)customerParameterPanel, gridBagConstraints);
        }
        if (this.productNumber != null) {
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            customerParameterTextField = new CustomerParameterTextField(this.productNumber);
            customerParameterTextField.setColumns(16);
            customerParameterPanel = new CustomerParameterPanel("Product number: ", customerParameterTextField);
            jPanel.add((Component)customerParameterPanel.getLabel(), gridBagConstraints);
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)customerParameterPanel, gridBagConstraints);
        }
        if (this.productRevision != null) {
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            customerParameterTextField = new CustomerParameterTextField(this.productRevision);
            customerParameterTextField.setColumns(16);
            customerParameterPanel = new CustomerParameterPanel("Product revision: ", customerParameterTextField);
            jPanel.add((Component)customerParameterPanel.getLabel(), gridBagConstraints);
            gridBagConstraints.gridy = 3;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)customerParameterPanel, gridBagConstraints);
        }
        if (this.serialNumber != null) {
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 17;
            customerParameterTextField = new CustomerParameterTextField(this.serialNumber);
            customerParameterTextField.setColumns(16);
            customerParameterPanel = new CustomerParameterPanel("Serial number: ", customerParameterTextField);
            jPanel.add((Component)customerParameterPanel.getLabel(), gridBagConstraints);
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)customerParameterPanel, gridBagConstraints);
        }
        return jPanel;
    }

    private JPanel createOtherOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Other options"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel = new JLabel("RBS product name:   *");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        gridBagConstraints.gridx = 1;
        this.rbsTypesComboBox = new JComboBox<String>(this.rbsTypes);
        if (this.selectedRbsType != null) {
            this.setRbsType(this.selectedRbsType);
        }
        jPanel.add((Component)this.rbsTypesComboBox, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        if (this.supportSystemAvailable) {
            this.sscCheckBox = new CustomerParameterCheckbox("Support system control", this.supportSystemControl);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            jPanel.add((Component)this.sscCheckBox, gridBagConstraints);
        }
        if (this.configureClimateSystem != null) {
            gridBagConstraints.gridy = 3;
            this.configureClimateSystemComboBox = new CustomerParameterComboBox(this.configureClimateSystem);
            this.configureClimateSystemPanel = new CustomerParameterPanel("Climate system: ", this.configureClimateSystemComboBox);
            jPanel.add((Component)this.configureClimateSystemPanel, gridBagConstraints);
        }
        if (this.configureClimateRegulationSystem != null) {
            gridBagConstraints.gridy = 4;
            this.configureClimateRegulationSystemComboBox = new CustomerParameterComboBox(this.configureClimateRegulationSystem);
            this.configureClimateRegulationSystemPanel = new CustomerParameterPanel("Climate system type: ", this.configureClimateRegulationSystemComboBox);
            jPanel.add((Component)this.configureClimateRegulationSystemPanel, gridBagConstraints);
        }
        return jPanel;
    }

    private String[] getRowNames(int n) {
        String[] stringArray = new String[n];
        for (int i = 1; i <= n; ++i) {
            Integer n2 = i;
            stringArray[i - 1] = n2.toString();
        }
        return stringArray;
    }

    private JPanel createSectorOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Sector options"));
        Object[][] objectArray = new Enumeration[this.numberOfSectors][3];
        for (int i = 0; i < this.radioBuildingBlockParameters.length; ++i) {
            objectArray[i][0] = this.radioBuildingBlockParameters[i];
            objectArray[i][1] = this.lineRateParameters[i];
        }
        this.sectorOptionstableTable = new CustomerParameterTable(objectArray, this.getRowNames(this.numberOfSectors), COLUMN_NAMES);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 10.0;
        jPanel.add((Component)new JScrollPane(this.sectorOptionstableTable), gridBagConstraints);
        return jPanel;
    }
}

