/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.view;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.AbsoluteTimeSynchEnabledParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.GpsOutEnabledParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.GpsOutEnabledParameterOnSlot2;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ClimateRegulationSystem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ClimateSystem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioIfTypeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.custparam.CarrierAllocationModeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.custparam.DigitalBuildingBlockParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomHeaderRenderer;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterCheckbox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComboBox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTable;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterViewer;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;

public class DataFlexView
extends BemWizardGuiView
implements CustomerParameterViewer {
    private static final int TABLE_COLUMNS = 2;
    private static final String[] COLUMN_NAMES = new String[]{"Sector", "Radio Building Block"};
    private static final String[] RBS3_COLUMN_NAMES = new String[]{"Sector", "No. of Carriers", "Output power"};
    private static final String[] MAIN_REMOTE_COLUMN_NAMES = new String[]{"Sector", "Create Sector"};
    private static final int DUW_TABLE_COLUMNS = 4;
    private static final String[] DUW_COLUMN_NAMES = new String[]{"Sector", "Radio building block", "Line rate", "Unit type"};
    private static final int NO_OF_SECTORS_PER_BASE_BAND_POOL = 6;
    private static final int FIRST_SECTOR_IN_BB_POOL_2 = 7;
    private YesNoCustomerParameter redundantControlSystem;
    private TrueFalseCustomerParameter supportSystemControl;
    private CustomerParameterCheckbox atsCheckBox;
    private AbsoluteTimeSynchEnabledParameter absoluteTimeSynchParam = null;
    private GpsOutEnabledParameter gpsOutEnabled;
    private GpsOutEnabledParameterOnSlot2 gpsOutEnabledOnSlot2;
    private CustomerParameterCheckbox gpsOnSlot1CheckBox;
    private CustomerParameterCheckbox gpsOnSlot2CheckBox;
    private boolean supportSystemAvailable = false;
    private boolean isRbs6000 = false;
    private YesNoCustomerParameter[] createSectorParameters;
    private Enumeration[] radioBuildingBlockParameters;
    private Enumeration[] noOfCarriersParameters;
    private Enumeration[] outputPowerParameters;
    private Enumeration[] lineRateParameters;
    private Enumeration[] auUnitTypeParameters;
    private String[] rbsTypes;
    private String selectedRbsType;
    private JComboBox rbsTypesComboBox;
    private ActionListener rbsTypeListener;
    private ClimateSystem configureClimateSystem;
    private CustomerParameterComboBox configureClimateSystemComboBox;
    private CustomerParameterPanel configureClimateSystemPanel;
    private ClimateRegulationSystem configureClimateRegulationSystem;
    private CustomerParameterComboBox configureClimateRegulationSystemComboBox;
    private CustomerParameterPanel configureClimateRegulationSystemPanel;
    private DigitalBuildingBlockParameter digitalBuildingBlockParameter;
    private CustomerParameterComboBox dbbParameterComboBox;
    private CustomerParameterPanel dbbParameterPanel;
    private boolean choiceOfRadioIfTypeSupported = false;
    private RadioIfTypeParameter[] radioIfTypeParameters;
    private CustomerParameterComboBox[] radioIfTypeComboBoxes;
    private CustomerParameterPanel radioIfTypePanel;
    private CustomerParameterPanel radioIfTypePanel1;
    private CustomerParameterPanel radioIfTypePanel2;
    private ActionListener[] radioIfTypeListeners;
    private CustomerParameterTable sectorOptionstableTable;
    private CustomerParameterTable rbs3SectorsTable;
    private CustomerParameterTable mainRemoteSectorsTable;
    private CustomerParameterCheckbox checkBox;
    private CustomerParameterCheckbox sscCheckBox;
    private CarrierAllocationModeParameter carrierAllocationModeParam;
    private CustomerParameterComboBox carrierAllocationModeBoxes;
    private int numberOfSectors;

    protected void init() {
        super.init();
    }

    public void setRadioBuildingBlock(Enumeration[] enumerationArray) {
        this.radioBuildingBlockParameters = enumerationArray;
    }

    public void setLineRate(Enumeration[] enumerationArray) {
        this.lineRateParameters = enumerationArray;
    }

    public void setAuUnitType(Enumeration[] enumerationArray) {
        this.auUnitTypeParameters = enumerationArray;
    }

    public void setSectorSequence(Enumeration[] enumerationArray) {
    }

    public void setPrimaryPortId(Enumeration[] enumerationArray) {
    }

    public void setConfigureClimateSystem(ClimateSystem climateSystem) {
        this.configureClimateSystem = climateSystem;
    }

    public void setConfigureClimateRegulationSystem(ClimateRegulationSystem climateRegulationSystem) {
        this.configureClimateRegulationSystem = climateRegulationSystem;
    }

    public void setNoOfCarriers(Enumeration[] enumerationArray) {
        this.noOfCarriersParameters = enumerationArray;
    }

    public void setOutputPowers(Enumeration[] enumerationArray) {
        this.outputPowerParameters = enumerationArray;
    }

    public void setCreateSector(YesNoCustomerParameter[] yesNoCustomerParameterArray) {
        this.createSectorParameters = yesNoCustomerParameterArray;
    }

    public void setRedundantControlSystem(YesNoCustomerParameter yesNoCustomerParameter) {
        this.redundantControlSystem = yesNoCustomerParameter;
    }

    public void setSupportSystemAvailable(boolean bl) {
        this.supportSystemAvailable = bl;
    }

    public void setRbs6000(boolean bl) {
        this.isRbs6000 = bl;
    }

    public void setSupportSystemControl(TrueFalseCustomerParameter trueFalseCustomerParameter) {
        this.supportSystemControl = trueFalseCustomerParameter;
    }

    public void setAbsoluteTimeSynchronization(AbsoluteTimeSynchEnabledParameter absoluteTimeSynchEnabledParameter) {
        this.absoluteTimeSynchParam = absoluteTimeSynchEnabledParameter;
    }

    public void setNumberOfSectors(int n) {
        this.numberOfSectors = n;
    }

    public void setChoiceOfRadioIfTypeSupported(boolean bl) {
        this.choiceOfRadioIfTypeSupported = bl;
    }

    public void setGpsOutEnabled(GpsOutEnabledParameter gpsOutEnabledParameter) {
        this.gpsOutEnabled = gpsOutEnabledParameter;
    }

    public void setGpsOutEnabledOnSlot2(GpsOutEnabledParameterOnSlot2 gpsOutEnabledParameterOnSlot2) {
        this.gpsOutEnabledOnSlot2 = gpsOutEnabledParameterOnSlot2;
    }

    public void setDbbParameter(DigitalBuildingBlockParameter digitalBuildingBlockParameter) {
        this.digitalBuildingBlockParameter = digitalBuildingBlockParameter;
    }

    public void setRbsTypes(String[] stringArray) {
        this.rbsTypes = stringArray;
    }

    public String getRbsType() {
        return (String)this.rbsTypesComboBox.getSelectedItem();
    }

    private void setRbsType(String string) {
        this.rbsTypesComboBox.setSelectedItem(this.selectedRbsType);
    }

    public void setSelectedRbsType(String string) {
        this.selectedRbsType = string;
    }

    public void setInitialRbsType(final String string) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.selectedRbsType = string;
            this.rbsTypesComboBox.setSelectedItem(this.selectedRbsType);
        } else {
            Runnable runnable = new Runnable(){

                public void run() {
                    DataFlexView.this.selectedRbsType = string;
                    DataFlexView.this.rbsTypesComboBox.setSelectedItem(DataFlexView.this.selectedRbsType);
                }
            };
            try {
                SwingUtilities.invokeAndWait(runnable);
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }

    public void setRadioIfTypes(RadioIfTypeParameter[] radioIfTypeParameterArray) {
        this.radioIfTypeParameters = radioIfTypeParameterArray;
    }

    public void setCarrierAllocationMode(CarrierAllocationModeParameter carrierAllocationModeParameter) {
        this.carrierAllocationModeParam = carrierAllocationModeParameter;
    }

    public String[] getRadioIfTypes() {
        String[] stringArray = null;
        if (this.radioIfTypeComboBoxes == null) {
            return null;
        }
        stringArray = new String[this.radioIfTypeComboBoxes.length];
        for (int i = 0; i < this.radioIfTypeComboBoxes.length; ++i) {
            stringArray[i] = (String)this.radioIfTypeComboBoxes[i].getSelectedItem();
        }
        return stringArray;
    }

    public void setRbsTypeListener(ActionListener actionListener) {
        this.rbsTypesComboBox.removeActionListener(this.rbsTypeListener);
        this.rbsTypeListener = actionListener;
        this.rbsTypesComboBox.addActionListener(this.rbsTypeListener);
    }

    public void removeRbsTypeListener() {
        if (this.rbsTypeListener != null) {
            this.rbsTypesComboBox.removeActionListener(this.rbsTypeListener);
        }
    }

    public void createRadioIfTypeListeners(ActionListener[] actionListenerArray) {
        this.radioIfTypeListeners = actionListenerArray;
    }

    public void setRadioIfTypeListener(ActionListener actionListener, int n) {
        if (this.radioIfTypeComboBoxes != null && this.radioIfTypeListeners != null && this.radioIfTypeComboBoxes.length >= n && this.radioIfTypeComboBoxes[n - 1] != null && this.radioIfTypeListeners.length >= n) {
            this.radioIfTypeComboBoxes[n - 1].removeActionListener(this.radioIfTypeListeners[n - 1]);
            this.radioIfTypeListeners[n - 1] = actionListener;
            this.radioIfTypeComboBoxes[n - 1].addActionListener(this.radioIfTypeListeners[n - 1]);
        }
    }

    public void removeRadioIfTypeListeners() {
        if (this.radioIfTypeListeners != null && this.radioIfTypeComboBoxes != null) {
            for (int i = 0; i < this.radioIfTypeComboBoxes.length && i < this.radioIfTypeListeners.length; ++i) {
                if (this.radioIfTypeComboBoxes[i] == null || this.radioIfTypeListeners[i] == null) continue;
                this.radioIfTypeComboBoxes[i].removeActionListener(this.radioIfTypeListeners[i]);
            }
        }
    }

    public String getGuiNameForCustomerParameter(String string) {
        String string2 = null;
        if (this.redundantControlSystem != null && this.redundantControlSystem.getName().equals(string)) {
            string2 = this.checkBox.getText();
        } else if (this.sectorOptionstableTable != null && this.sectorOptionstableTable.isParameterInTable(string)) {
            string2 = this.sectorOptionstableTable.getRowAndColumnName(string);
        } else if (this.rbs3SectorsTable != null && this.rbs3SectorsTable.isParameterInTable(string)) {
            string2 = this.rbs3SectorsTable.getRowAndColumnName(string);
        }
        return string2;
    }

    public void setFocusOnCustomerParameterComponent(String string) {
        if (this.redundantControlSystem != null && this.redundantControlSystem.getName().equals(string)) {
            this.checkBox.requestFocus();
        } else if (this.sectorOptionstableTable != null && this.sectorOptionstableTable.isParameterInTable(string)) {
            this.sectorOptionstableTable.setFocusOnCell(string);
        } else if (this.rbs3SectorsTable != null && this.rbs3SectorsTable.isParameterInTable(string)) {
            this.rbs3SectorsTable.setFocusOnCell(string);
        }
    }

    public void updateGui() {
        try {
            JPanel jPanel = new JPanel(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            jPanel.add((Component)this.createOtherOptionsPanel(), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            if (this.isDuwSectors()) {
                if (this.getNumberOfRows() > 0) {
                    jPanel.add((Component)this.createDuwSectorOptionsPanel(), gridBagConstraints);
                }
            } else if (this.radioIfTypeParameters.length == 2 && (!DuwUtil.hasDuw() || this.radioIfTypeParameters[1].getValue().equals("DUI_O"))) {
                jPanel.add((Component)this.createExpandedSectorOptionsPanel(), gridBagConstraints);
            } else if (this.isMainRemoteSectors()) {
                jPanel.add((Component)this.createMainRemoteSectorOptionsPanel(), gridBagConstraints);
            } else if (this.isRbs3Sectors() && !this.isMainRemoteSectors()) {
                jPanel.add((Component)this.createRbs3SectorOptionsPanel(), gridBagConstraints);
            } else {
                jPanel.add((Component)this.createSectorOptionsPanel(), gridBagConstraints);
            }
            gridBagConstraints.fill = 3;
            gridBagConstraints.weighty = 100.0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.fill = 1;
            jPanel.add((Component)new JPanel(), gridBagConstraints);
            this.addMainPanel(jPanel);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private JPanel createOtherOptionsPanel() throws BemException {
        JLabel jLabel;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Other options"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JLabel jLabel2 = new JLabel("RBS product name:   *");
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jLabel2, gridBagConstraints);
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        gridBagConstraints.gridx = 1;
        this.rbsTypesComboBox = new JComboBox<String>(this.rbsTypes);
        if (this.selectedRbsType != null) {
            this.setRbsType(this.selectedRbsType);
        }
        jPanel.add((Component)this.rbsTypesComboBox, gridBagConstraints);
        if (this.redundantControlSystem != null) {
            this.checkBox = new CustomerParameterCheckbox("Redundant control system", this.redundantControlSystem);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            jPanel.add((Component)this.checkBox, gridBagConstraints);
        }
        if (this.supportSystemAvailable) {
            this.sscCheckBox = new CustomerParameterCheckbox("Support system control", this.supportSystemControl);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            jPanel.add((Component)this.sscCheckBox, gridBagConstraints);
            if (DuwUtil.hasDuw() && this.isRbs6000) {
                this.atsCheckBox = new CustomerParameterCheckbox("Absolute time synch enabled", this.absoluteTimeSynchParam);
                gridBagConstraints.anchor = 10;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                jPanel.add((Component)this.atsCheckBox, gridBagConstraints);
                jLabel = new JLabel("GPS out enabled:");
                gridBagConstraints.anchor = 17;
                gridBagConstraints.insets = new Insets(0, 5, 0, 0);
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 3;
                jPanel.add((Component)jLabel, gridBagConstraints);
                this.gpsOnSlot1CheckBox = new CustomerParameterCheckbox("DUW on slot 1", this.gpsOutEnabled);
                gridBagConstraints.anchor = 17;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.gridx = 1;
                gridBagConstraints.insets = new Insets(0, 0, 0, 5);
                jPanel.add((Component)this.gpsOnSlot1CheckBox, gridBagConstraints);
                if (DuwUtil.hasDualDuws()) {
                    this.gpsOnSlot2CheckBox = new CustomerParameterCheckbox("DUW on slot 2", this.gpsOutEnabledOnSlot2);
                    gridBagConstraints.anchor = 10;
                    gridBagConstraints.gridy = 3;
                    gridBagConstraints.gridx = 1;
                    gridBagConstraints.insets = new Insets(0, 0, 0, 5);
                    jPanel.add((Component)this.gpsOnSlot2CheckBox, gridBagConstraints);
                }
            }
        }
        if (this.configureClimateSystem != null) {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.configureClimateSystemComboBox = new CustomerParameterComboBox(this.configureClimateSystem);
            this.configureClimateSystemPanel = new CustomerParameterPanel("Climate system: ", this.configureClimateSystemComboBox);
            jPanel.add((Component)this.configureClimateSystemPanel, gridBagConstraints);
        }
        if (this.configureClimateRegulationSystem != null) {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 5;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.configureClimateRegulationSystemComboBox = new CustomerParameterComboBox(this.configureClimateRegulationSystem);
            this.configureClimateRegulationSystemPanel = new CustomerParameterPanel("Climate regulation system: ", this.configureClimateRegulationSystemComboBox);
            jPanel.add((Component)this.configureClimateRegulationSystemPanel, gridBagConstraints);
        }
        if (DuwUtil.hasDualDuws() && this.isRbs6000) {
            gridBagConstraints.anchor = 17;
            gridBagConstraints.gridy = 6;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.insets = new Insets(5, 5, 5, 5);
            this.dbbParameterComboBox = new CustomerParameterComboBox(this.digitalBuildingBlockParameter);
            this.dbbParameterPanel = new CustomerParameterPanel("Digital building block: ", this.dbbParameterComboBox);
            jPanel.add((Component)this.dbbParameterPanel, gridBagConstraints);
        }
        if (this.choiceOfRadioIfTypeSupported) {
            if (this.radioIfTypeParameters != null && this.radioIfTypeParameters.length == 1 && !DuwUtil.hasDuw()) {
                gridBagConstraints.gridy = 6;
                this.radioIfTypeComboBoxes = new CustomerParameterComboBox[1];
                this.radioIfTypeComboBoxes[0] = new CustomerParameterComboBox(this.radioIfTypeParameters[0]);
                this.radioIfTypePanel = new CustomerParameterPanel("Radio Interface Type: ", this.radioIfTypeComboBoxes[0]);
                jPanel.add((Component)this.radioIfTypePanel, gridBagConstraints);
            } else if (this.radioIfTypeParameters != null && this.radioIfTypeParameters.length == 2 && !DuwUtil.hasDuw()) {
                gridBagConstraints.gridy = 6;
                this.radioIfTypeComboBoxes = new CustomerParameterComboBox[2];
                this.radioIfTypeComboBoxes[0] = new CustomerParameterComboBox(this.radioIfTypeParameters[0]);
                this.radioIfTypePanel1 = new CustomerParameterPanel("Radio Interface Type Base Band Pool 1: ", this.radioIfTypeComboBoxes[0]);
                jPanel.add((Component)this.radioIfTypePanel1, gridBagConstraints);
                gridBagConstraints.gridy = 7;
                this.radioIfTypeComboBoxes[1] = new CustomerParameterComboBox(this.radioIfTypeParameters[1]);
                this.radioIfTypePanel2 = new CustomerParameterPanel("Radio Interface Type Base Band Pool 2: ", this.radioIfTypeComboBoxes[1]);
                jPanel.add((Component)this.radioIfTypePanel2, gridBagConstraints);
            } else if (this.radioIfTypeParameters != null && this.radioIfTypeParameters.length == 2 && DuwUtil.hasDualDuws()) {
                jLabel = new JLabel("Radio Interface Type Base Band Pool2:  *");
                gridBagConstraints.gridx = 0;
                gridBagConstraints.gridy = 6;
                jPanel.add((Component)jLabel, gridBagConstraints);
                gridBagConstraints.gridx = 1;
                this.radioIfTypeComboBoxes = new CustomerParameterComboBox[2];
                this.radioIfTypeComboBoxes[0] = new CustomerParameterComboBox(this.radioIfTypeParameters[0]);
                this.radioIfTypeComboBoxes[1] = new CustomerParameterComboBox(this.radioIfTypeParameters[1]);
                jPanel.add((Component)this.radioIfTypeComboBoxes[1], gridBagConstraints);
            }
        }
        return jPanel;
    }

    private boolean isRbs3Sectors() {
        return this.outputPowerParameters != null && this.outputPowerParameters[0] != null;
    }

    private boolean isMainRemoteSectors() {
        boolean bl = false;
        if (this.radioIfTypeParameters != null && this.radioIfTypeParameters[0] != null) {
            String string = this.radioIfTypeParameters[0].getValue();
            if (string.equals("OBIF")) {
                bl = true;
            }
        } else if (this.createSectorParameters != null && this.createSectorParameters[0] != null) {
            bl = true;
        }
        return bl;
    }

    private boolean isObifSectors(RadioIfTypeParameter radioIfTypeParameter) {
        String string;
        boolean bl = false;
        if (radioIfTypeParameter != null && (string = radioIfTypeParameter.getValue()).equals("OBIF")) {
            bl = true;
        }
        return bl;
    }

    private boolean isDuiOpticalSectors(RadioIfTypeParameter radioIfTypeParameter) {
        String string;
        boolean bl = false;
        if (radioIfTypeParameter != null && (string = radioIfTypeParameter.getValue()).equals("DUI_O")) {
            bl = true;
        }
        return bl;
    }

    private boolean isDuwSectors() {
        return this.lineRateParameters != null && this.lineRateParameters[0] != null;
    }

    private String[] getRowNames(int n) {
        String[] stringArray = new String[n];
        for (int i = 1; i <= n; ++i) {
            Integer n2 = i;
            stringArray[i - 1] = n2.toString();
        }
        return stringArray;
    }

    private String[] getRowNamesForObifInPool2(int n) {
        String[] stringArray = new String[6];
        for (int i = 0; i < 6; ++i) {
            Integer n2 = n + i;
            stringArray[i] = n2.toString();
        }
        return stringArray;
    }

    private JPanel createMainRemoteSectorOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Sector options"));
        Object[][] objectArray = new Enumeration[this.numberOfSectors][2];
        for (int i = 0; i < this.createSectorParameters.length; ++i) {
            objectArray[i][0] = this.createSectorParameters[i];
        }
        this.mainRemoteSectorsTable = new CustomerParameterTable(objectArray, this.getRowNames(this.numberOfSectors), MAIN_REMOTE_COLUMN_NAMES);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = -1;
        jPanel.add((Component)new JScrollPane(this.mainRemoteSectorsTable), gridBagConstraints);
        return jPanel;
    }

    private JPanel createRbs3SectorOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Sector options"));
        Object[][] objectArray = new Enumeration[this.numberOfSectors][2];
        for (int i = 0; i < this.noOfCarriersParameters.length; ++i) {
            objectArray[i][0] = this.noOfCarriersParameters[i];
            objectArray[i][1] = this.outputPowerParameters[i];
        }
        this.rbs3SectorsTable = new CustomerParameterTable(objectArray, this.getRowNames(this.numberOfSectors), RBS3_COLUMN_NAMES);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridy = -1;
        jPanel.add((Component)new JScrollPane(this.rbs3SectorsTable), gridBagConstraints);
        return jPanel;
    }

    private JPanel createSectorOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Sector options"));
        Object[][] objectArray = new Enumeration[this.numberOfSectors][2];
        for (int i = 0; i < this.radioBuildingBlockParameters.length; ++i) {
            objectArray[i][0] = this.radioBuildingBlockParameters[i];
        }
        this.sectorOptionstableTable = new CustomerParameterTable(objectArray, this.getRowNames(this.numberOfSectors), COLUMN_NAMES);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 10.0;
        jPanel.add((Component)new JScrollPane(this.sectorOptionstableTable), gridBagConstraints);
        if (this.carrierAllocationModeParam != null) {
            gridBagConstraints.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints.fill = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)this.createCarrierAllocationModePanel(), gridBagConstraints);
        }
        return jPanel;
    }

    private JPanel createCarrierAllocationModePanel() {
        this.carrierAllocationModeBoxes = new CustomerParameterComboBox(this.carrierAllocationModeParam);
        return new CustomerParameterPanel("Carrier Allocation Mode", this.carrierAllocationModeBoxes);
    }

    private JPanel createExpandedSectorOptionsPanel() {
        boolean bl = false;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Sector options"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = this.numberOfSectors;
        if (this.numberOfSectors > 6) {
            n = 6;
        }
        for (int i = 0; i < this.radioIfTypeParameters.length; ++i) {
            int n2;
            Object[][] objectArray;
            if (this.radioIfTypeParameters[i] != null && (this.isObifSectors(this.radioIfTypeParameters[i]) || this.isDuiOpticalSectors(this.radioIfTypeParameters[i])) && i == 1) {
                objectArray = new Enumeration[n][2];
                bl = true;
                for (n2 = 0; n2 < n && n2 < this.createSectorParameters.length; ++n2) {
                    objectArray[n2][0] = this.createSectorParameters[n2 + 6];
                }
                this.mainRemoteSectorsTable = new CustomerParameterTable(objectArray, this.getRowNamesForObifInPool2(7), MAIN_REMOTE_COLUMN_NAMES);
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 10.0;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.gridy = -1;
                jPanel.add((Component)new JScrollPane(this.mainRemoteSectorsTable), gridBagConstraints);
                continue;
            }
            if (this.radioIfTypeParameters[i] != null && this.isObifSectors(this.radioIfTypeParameters[i]) && i == 0) {
                objectArray = new Enumeration[n][2];
                for (n2 = 0; n2 < this.createSectorParameters.length; ++n2) {
                    objectArray[n2][0] = this.createSectorParameters[n2];
                }
                this.mainRemoteSectorsTable = new CustomerParameterTable(objectArray, this.getRowNames(n), MAIN_REMOTE_COLUMN_NAMES);
                gridBagConstraints.gridwidth = 2;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.weightx = 10.0;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                gridBagConstraints.gridy = -1;
                jPanel.add((Component)new JScrollPane(this.mainRemoteSectorsTable), gridBagConstraints);
                continue;
            }
            if (i != 0) continue;
            objectArray = new Enumeration[n][2];
            for (n2 = 0; n2 < n; ++n2) {
                objectArray[n2][0] = this.radioBuildingBlockParameters[n2];
            }
            this.sectorOptionstableTable = new CustomerParameterTable(objectArray, this.getRowNames(n), COLUMN_NAMES);
            gridBagConstraints.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.gridy = -1;
            jPanel.add((Component)new JScrollPane(this.sectorOptionstableTable), gridBagConstraints);
        }
        if (!bl) {
            gridBagConstraints.fill = 0;
            gridBagConstraints.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.anchor = 21;
            gridBagConstraints.gridx = 0;
            if (this.carrierAllocationModeParam != null) {
                jPanel.add((Component)this.createCarrierAllocationModePanel(), gridBagConstraints);
            }
        }
        return jPanel;
    }

    private JPanel createDuwSectorOptionsPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        int n = this.getNumberOfRows();
        jPanel.setBorder(new TitledBorder("Sector options"));
        Object[][] objectArray = new Enumeration[n][4];
        for (int i = 0; i < n; ++i) {
            objectArray[i][0] = this.radioBuildingBlockParameters[i];
            objectArray[i][1] = this.lineRateParameters[i];
            objectArray[i][2] = this.auUnitTypeParameters[i];
        }
        this.sectorOptionstableTable = new CustomerParameterTable(objectArray, this.getRowNames(n), DUW_COLUMN_NAMES);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 10.0;
        TableColumnModel tableColumnModel = this.sectorOptionstableTable.getTableHeader().getColumnModel();
        int n2 = this.sectorOptionstableTable.getRowHeight();
        for (int i = 0; i < tableColumnModel.getColumnCount(); ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            String string = "Line rate";
            String string2 = "";
            string2 = (String)tableColumn.getHeaderValue();
            CustomHeaderRenderer customHeaderRenderer = new CustomHeaderRenderer();
            if (string2.equals(string)) {
                customHeaderRenderer.setToolTipText("BEM_CABINET_LINE_RATE");
            }
            tableColumn.setHeaderRenderer(customHeaderRenderer);
            customHeaderRenderer.setPreferredSize(new Dimension(this.getWidth(), n2));
        }
        jPanel.add((Component)new JScrollPane(this.sectorOptionstableTable), gridBagConstraints);
        return jPanel;
    }

    private int getNumberOfRows() {
        int n = 0;
        for (int i = 0; i < this.radioBuildingBlockParameters.length; ++i) {
            EnumeratedRange enumeratedRange = (EnumeratedRange)this.radioBuildingBlockParameters[i].getEnabledValueRange();
            List list = enumeratedRange.getRangeValues();
            if (list.size() == 0 || list.size() == 1 && list.get(0).equals("")) continue;
            ++n;
        }
        return n;
    }
}

