/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.EthernetSwitchCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EthernetSwitchProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class VlanMembershipManager
extends CustomerParameterImpl {
    private Rbs rbs;
    private String pseudoName;
    private String value = "";
    private List cpObjectList = new ArrayList();
    private EthernetSwitchProvider ethernetSwitchProvider;

    public VlanMembershipManager(String string) {
        super(string, new StringRange(0, 1000));
    }

    public VlanMembershipManager(Rbs rbs, String string) throws BemException {
        super(string, new StringRange(0, 1000));
        this.rbs = rbs;
        this.pseudoName = string;
        this.ethernetSwitchProvider = (EthernetSwitchProvider)((Object)rbs.getConfigItem("EthernetSwitchCI"));
        this.buildGuiCustomerParameter();
    }

    public boolean vlanMembershipCounterReachedLimit() {
        EthernetSwitchCI ethernetSwitchCI = (EthernetSwitchCI)this.rbs.getConfigItem("EthernetSwitchCI");
        boolean bl = false;
        bl = ethernetSwitchCI.vlanMemberShipCounterReachedLimit(this.pseudoName);
        return bl;
    }

    public String getValue() {
        return this.value;
    }

    public List getCustomerParameterObjects() {
        return this.cpObjectList;
    }

    public void createCICustomerParamater(String string, String string2, String string3) throws BemException {
        String string4 = string2.toUpperCase();
        this.ethernetSwitchProvider.createCP(this.pseudoName + "_" + string + "_vid", string);
        this.ethernetSwitchProvider.createCP(this.pseudoName + "_" + string + "_egressUntag", string4);
        this.ethernetSwitchProvider.createCP(this.pseudoName + "_" + string + "_action", string3);
        this.buildGuiCustomerParameter();
    }

    public void buildGuiCustomerParameter() throws BemException {
        this.cpObjectList = new ArrayList();
        this.value = "";
        if (this.pseudoName.equals("EthernetSwitchVlanMembership")) {
            ArrayList arrayList = this.rbs.getCustomerParameterPseudoName(this.pseudoName);
            Collections.sort(arrayList);
            Iterator iterator = arrayList.iterator();
            CustomerParameter customerParameter = null;
            CustomerParameter customerParameter2 = null;
            CustomerParameter customerParameter3 = null;
            boolean bl = false;
            while (iterator.hasNext()) {
                customerParameter = this.rbs.getCustomerParameterObject((String)iterator.next());
                bl = customerParameter.getValue().equals("DELETE");
                if (iterator.hasNext()) {
                    customerParameter2 = this.rbs.getCustomerParameterObject((String)iterator.next());
                }
                if (iterator.hasNext()) {
                    customerParameter3 = this.rbs.getCustomerParameterObject((String)iterator.next());
                }
                if (bl) continue;
                this.cpObjectList.add(customerParameter2);
                this.cpObjectList.add(customerParameter3);
                this.value = this.value + "[" + customerParameter3.getValue().toLowerCase() + "," + customerParameter2.getValue().toLowerCase() + "]";
                if (!iterator.hasNext()) continue;
                this.value = this.value + ",";
            }
        } else {
            for (int i = 1; i <= 7; ++i) {
                if (!this.pseudoName.equals(MessageFormat.format("EthernetSwitchPort_{0}_VlanMembership", i))) continue;
                ArrayList arrayList = this.rbs.getCustomerParameterPseudoName(this.pseudoName);
                Collections.sort(arrayList);
                Iterator iterator = arrayList.iterator();
                CustomerParameter customerParameter = null;
                CustomerParameter customerParameter4 = null;
                CustomerParameter customerParameter5 = null;
                boolean bl = false;
                while (iterator.hasNext()) {
                    customerParameter = this.rbs.getCustomerParameterObject((String)iterator.next());
                    bl = customerParameter.getValue().equals("DELETE");
                    if (iterator.hasNext()) {
                        customerParameter4 = this.rbs.getCustomerParameterObject((String)iterator.next());
                    }
                    if (iterator.hasNext()) {
                        customerParameter5 = this.rbs.getCustomerParameterObject((String)iterator.next());
                    }
                    if (bl) continue;
                    this.cpObjectList.add(customerParameter4);
                    this.cpObjectList.add(customerParameter5);
                    this.value = this.value + "[" + customerParameter5.getValue().toLowerCase() + "," + customerParameter4.getValue().toLowerCase() + "]";
                    if (!iterator.hasNext()) continue;
                    this.value = this.value + ",";
                }
                break;
            }
        }
    }
}

