/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.table.TableCellEditor;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterCheckbox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTable;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control.LagEditorRenderer;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control.LagManager;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control.VlanMembershipEditorRenderer;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control.VlanMembershipManager;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.EthernetSwitchViewer;

public class EthernetSwitchView
extends BemWizardGuiView
implements EthernetSwitchViewer {
    private JPanel ethernetSwitchPanel;
    private JPanel ethernetSwitchPortPanel;

    protected void init() {
        try {
            super.init();
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        this.initPanels();
    }

    private void initPanels() throws Exception {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        this.addMainPanel(jPanel);
        this.ethernetSwitchPanel = new JPanel();
        this.ethernetSwitchPanel.setLayout(new GridBagLayout());
        this.ethernetSwitchPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "NCONF_OAM_ETHERNETSWITCH_PANEL"));
        this.ethernetSwitchPortPanel = new JPanel();
        this.ethernetSwitchPortPanel.setLayout(new GridBagLayout());
        this.ethernetSwitchPortPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "NCONF_OAM_SWITCH_PORT_PANEL"));
        jPanel.add((Component)this.ethernetSwitchPanel, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
        jPanel.add((Component)this.ethernetSwitchPortPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0));
    }

    protected String getSubHeading() {
        return WizardLanguageHelp.getTranslation("NCONF_OAM_ETHERNET_HEADING");
    }

    public void setFocusOnCustomerParameterComponent(String string) {
    }

    public String getGuiNameForCustomerParameter(String string) {
        return "";
    }

    public void setCustomerParameters(CustomerParameter[] customerParameterArray) {
        for (CustomerParameter customerParameter : customerParameterArray) {
            String string = customerParameter.getName();
            if (!string.equals("EthernetSwitchvlan")) continue;
            CustomerParameterCheckbox customerParameterCheckbox = new CustomerParameterCheckbox("Enable VLAN", (TrueFalseCustomerParameter)customerParameter);
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 18;
            gridBagConstraints.gridy = 0;
            this.ethernetSwitchPanel.add((Component)customerParameterCheckbox, gridBagConstraints);
        }
    }

    public void setEthernetSwitchTableParameters(Object[][] objectArray, String[] stringArray) {
        Serializable serializable;
        Object object;
        CustomerParameterTable customerParameterTable = new CustomerParameterTable(objectArray, stringArray);
        customerParameterTable.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        try {
            object = new VlanMembershipManager("name");
            serializable = new VlanMembershipEditorRenderer((CustomerParameter)object);
            customerParameterTable.registerCellEditor(VlanMembershipManager.class.getName(), (TableCellEditor)((Object)serializable));
            object = new LagManager("name");
            serializable = new LagEditorRenderer((CustomerParameter)object);
            customerParameterTable.registerCellEditor(LagManager.class.getName(), (TableCellEditor)((Object)serializable));
        }
        catch (Exception exception) {
            BemLog.log(6, this.getClass().toString(), exception);
        }
        object = new JScrollPane(customerParameterTable);
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 1;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).ipadx = 1;
        ((GridBagConstraints)serializable).ipady = 1;
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        this.ethernetSwitchPanel.add((Component)object, serializable);
    }

    public void setEthernetSwitchPortTableParameters(Object[][] objectArray, String[] stringArray, String[] stringArray2) {
        Serializable serializable;
        Object object;
        CustomerParameterTable customerParameterTable = new CustomerParameterTable(objectArray, stringArray, stringArray2);
        customerParameterTable.putClientProperty("LANGUAGE_CONTROLLED", "NT");
        try {
            object = new VlanMembershipManager("name");
            serializable = new VlanMembershipEditorRenderer((CustomerParameter)object);
            customerParameterTable.registerCellEditor(VlanMembershipManager.class.getName(), (TableCellEditor)((Object)serializable));
        }
        catch (Exception exception) {
            BemLog.log(6, this.getClass().toString(), exception);
        }
        object = new JScrollPane(customerParameterTable);
        serializable = new GridBagConstraints();
        ((GridBagConstraints)serializable).gridx = 0;
        ((GridBagConstraints)serializable).gridy = 2;
        ((GridBagConstraints)serializable).gridwidth = 1;
        ((GridBagConstraints)serializable).gridheight = 1;
        ((GridBagConstraints)serializable).fill = 1;
        ((GridBagConstraints)serializable).ipadx = 1;
        ((GridBagConstraints)serializable).ipady = 1;
        ((GridBagConstraints)serializable).insets = new Insets(0, 0, 0, 0);
        ((GridBagConstraints)serializable).anchor = 18;
        ((GridBagConstraints)serializable).weightx = 1.0;
        ((GridBagConstraints)serializable).weighty = 1.0;
        this.ethernetSwitchPortPanel.add((Component)object, serializable);
    }
}

