/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CellAndCarrierProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.AIRUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceCommon;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.AntennaCablesViewer;

public class AntennaCablesController
extends BemWizardGuiController {
    private AntennaCablesViewer myView;
    private WizardCIModel wizardCiModel;
    private Rbs rbs = null;
    private final List customerParameterNames = new ArrayList();
    private int[] activeSectors;
    private int[][] sectorAntennaState;
    private AntennaCablesConfigurationListener textFieldListener;
    public static final int MANDATORY_INPUT = 0;
    public static final int OPTIONAL_INPUT = 1;
    public static final int CONFIGUTED_INPUT = 2;
    public static final int NA_INPUT = 3;
    public static final int INCORRECT_INPUT = 4;
    public static final String[] attrNames = new String[]{"dlFeederAttenuationBranch", "ulFeederAttenuationBranch", "dlFeederDelayBranch", "ulFeederDelayBranch"};

    protected void init() {
        this.myView = (AntennaCablesViewer)((Object)this.getView());
        this.myView.setController(this);
        this.wizardHelp = WizardHelp.getTheInstance();
        this.wizardCiModel = SiteCIModel.getInstance();
        this.setWindowTitle();
    }

    protected void beforeVisible() {
        try {
            this.rbs = this.wizardCiModel.getRbs();
            RadioEquipmentProvider[] radioEquipmentProviderArray = new RadioEquipmentProvider[2];
            int[][] nArrayArray = new int[2][];
            int n = 0;
            for (int i = 0; i < radioEquipmentProviderArray.length && (this.rbs.isPantherHybridRbs() || i != 1); ++i) {
                if (i == 1) {
                    n = 1;
                }
                radioEquipmentProviderArray[i] = (RadioEquipmentProvider)this.rbs.getProvider(RadioEquipmentProvider.class, n);
                nArrayArray[i] = radioEquipmentProviderArray[i].getEquippedSectors();
            }
            int[] nArray = WizardHelp.mergeIntArray(nArrayArray[0], nArrayArray[1]);
            this.myView.initiateMainPanel();
            this.activeSectors = nArray;
            int n2 = this.activeSectors.length;
            this.sectorAntennaState = new int[n2][ServiceCommon.BRANCH_NAMES.length];
            this.myView.arrangeOverviewTable(nArray);
            this.myView.setListenerForAntennaFeederCablesOverviewTable(new AntennaFeederCablesOverviewListener());
            this.myView.arrangeAntennaCablesConfigTable();
            this.checkInputValidation();
            this.updateParamListForCheckConsistency();
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException("AntennaCablesController", "beforeVisible()", null, "Setting up window for input", exception);
            super.displayError(wizardException);
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format("Site Equipment Configuration page {0}({1})", string2, string3));
    }

    public int getSectorNumber(int n) {
        if (n >= 0) {
            return this.activeSectors[n];
        }
        return n;
    }

    public void checkInputValidation() {
        for (int i = 1; i <= this.activeSectors.length; ++i) {
            int n = this.activeSectors[i - 1];
            String string = String.valueOf(n);
            int n2 = 0;
            if (this.rbs.isPantherHybridRbs() && n >= 7) {
                n2 = 1;
            }
            try {
                int n3;
                for (int j = n3 = this.rbs.getAntennaSystemProvider(n2).getNumOfSupportedAntennaBranches(n); j < ServiceCommon.BRANCH_NAMES.length; ++j) {
                    this.changeTableCellStatus(i - 1, j, 3);
                }
                String string2 = MessageFormat.format("S{0}_", string);
                for (int j = 0; j < n3; ++j) {
                    boolean bl = false;
                    boolean bl2 = false;
                    boolean bl3 = false;
                    int n4 = 0;
                    while (true) {
                        if (n4 >= attrNames.length) break;
                        String string3 = string2 + attrNames[n4] + ServiceCommon.BRANCH_NAMES[j];
                        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string3);
                        if (customerParameter.getAccessLevel() == 1) {
                            this.changeTableCellStatus(i - 1, j, 3);
                        } else if (AIRUtil.getInstance(this.rbs).isAir4SectorAntenna(n, false) && !customerParameter.getValue().equals("") && !customerParameter.getValue().equals("##UNDEFINED")) {
                            bl3 = true;
                        } else if (!(customerParameter.isDefault() || customerParameter.getValue().equals("") || customerParameter.getValue().equals("##UNDEFINED"))) {
                            if (!customerParameter.isValidValue()) {
                                bl = true;
                                break;
                            }
                            bl2 = true;
                        }
                        ++n4;
                    }
                    if (bl) {
                        this.sectorAntennaState[i - 1][j] = 4;
                        continue;
                    }
                    if (!bl2 && !bl3) continue;
                    this.sectorAntennaState[i - 1][j] = 2;
                }
                continue;
            }
            catch (BemException bemException) {
                BemLog.exceptionRaised(bemException);
            }
        }
    }

    protected void updateParamListForCheckConsistency() {
        for (int i = 0; i < this.activeSectors.length; ++i) {
            int n = this.activeSectors[i];
            String string = MessageFormat.format("S{0}_", n);
            for (int j = 0; j < ServiceCommon.BRANCH_NAMES.length; ++j) {
                if (this.sectorAntennaState[i][j] == 3) continue;
                for (int k = 0; k < attrNames.length; ++k) {
                    String string2 = string + attrNames[k] + ServiceCommon.BRANCH_NAMES[j];
                    this.customerParameterNames.add(string2);
                }
            }
        }
    }

    public CustomerParameter getCP(String string) {
        CustomerParameter customerParameter = null;
        try {
            customerParameter = this.rbs.getCustomerParameterObject(string);
            if (customerParameter.getAccessLevel() != 1) {
                this.customerParameterNames.add(string);
            }
        }
        catch (BemException bemException) {
            BemLog.exceptionRaised(bemException);
        }
        return customerParameter;
    }

    public int[] getActiveSectors() {
        return this.activeSectors;
    }

    public int[][] getSectorAntennaState() {
        return this.sectorAntennaState;
    }

    public void changeTableCellStatus(int n, int n2, int n3) {
        this.sectorAntennaState[n][n2] = n3;
    }

    public AntennaCablesConfigurationListener getTextFieldListener() {
        if (this.textFieldListener == null) {
            this.textFieldListener = new AntennaCablesConfigurationListener();
        }
        return this.textFieldListener;
    }

    protected boolean next() {
        boolean bl = true;
        try {
            this.myView.editingStopped();
            this.checkInputValidation();
            this.rbs.checkConsistency("AntennaSystemCI", this.customerParameterNames);
        }
        catch (CustomerParameterException customerParameterException) {
            CustomerParameter customerParameter = customerParameterException.getParameter();
            String string = customerParameter.getName();
            String string2 = this.myView.getGuiNameForBranchCustomerParameter(string);
            this.displayErrorMessage(string2 + "\n" + customerParameterException.getReason());
            bl = false;
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.currentClassName, "next()", null, "verifying user input for scrolling", exception);
            this.displayError(wizardException);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        this.customerParameterNames.clear();
        return true;
    }

    public boolean isSingleBand(int n) {
        boolean bl = false;
        try {
            CellAndCarrierProvider cellAndCarrierProvider = this.rbs.getCellAndCarrierProvider();
            bl = cellAndCarrierProvider.isSingleBand(n);
        }
        catch (BemException bemException) {
            WizardException wizardException = new WizardException("get cellAndCarrierCI error!", (Throwable)bemException);
            this.displayError(wizardException);
        }
        return bl;
    }

    public String getSingleBandCp(int n) {
        String string = "";
        try {
            CellAndCarrierProvider cellAndCarrierProvider = this.rbs.getCellAndCarrierProvider();
            string = cellAndCarrierProvider.getSingleBandCpName(n);
        }
        catch (BemException bemException) {
            WizardException wizardException = new WizardException("get cellAndCarrierCI error!.", (Throwable)bemException);
            this.displayError(wizardException);
        }
        return string;
    }

    private class AntennaCablesConfigurationListener
    implements CustomerParameterListener {
        private AntennaCablesConfigurationListener() {
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged() && !customerParameter.isDefault()) {
                int n = AntennaCablesController.this.myView.getSelectedColumn() - 1;
                int n2 = AntennaCablesController.this.myView.getSelectedRow();
                if (customerParameter.isValidValue()) {
                    AntennaCablesController.this.changeTableCellStatus(n, n2, 2);
                } else {
                    AntennaCablesController.this.changeTableCellStatus(n, n2, 4);
                }
            }
        }
    }

    private class AntennaFeederCablesOverviewListener
    implements ListSelectionListener {
        private AntennaFeederCablesOverviewListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            AntennaCablesController.this.myView.updateSelectedCell();
            AntennaCablesController.this.myView.arrangeAntennaCablesConfigTable();
        }
    }
}

