/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.site.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.AbsoluteTimeSynchEnabledParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.GpsOutEnabledParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.GpsOutEnabledParameterOnSlot2;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.FanSpeedSupervisionParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.SmokeDetectorParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.PowerSupplyProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioIfTypeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.model.SiteCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.site.view.OptionalEquipmentViewer;

public class OptionalEquipmentController
extends BemWizardGuiController {
    private OptionalEquipmentViewer myView = null;
    private WizardCIModel wizardCiModel;
    private final List externalAlarmParameterNames = new ArrayList();
    private final List powerSupplyParameterNames = new ArrayList();
    private Enumeration chargingModeParameter = null;
    private YesNoCustomerParameter configureBatteryBackup = null;
    private boolean isPowerSupported;
    private boolean isPSFanSupported;
    private boolean isAlarmSupported;
    boolean isCommonRbs = false;
    private static final String CAUSE_CABINET = "Cabinet Equipment Wizard has not been executed!";
    private final List customerParameterNames = new ArrayList();

    protected void init() {
        this.myView = (OptionalEquipmentViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.wizardCiModel = SiteCIModel.getInstance();
        this.setWindowTitle();
    }

    protected void afterVisible() {
        try {
            Rbs rbs = this.wizardCiModel.getRbs();
            PowerSupplyProvider powerSupplyProvider = (PowerSupplyProvider)((Object)rbs.getConfigItem("PowerSystemCI"));
            this.isCommonRbs = false;
            this.customerParameterNames.clear();
            if (powerSupplyProvider != null) {
                this.isCommonRbs = powerSupplyProvider.isSupportSystemAvailable();
            }
            this.isAlarmSupported = rbs.isConfigurationItemSupported("AlarmCI");
            if (this.isAlarmSupported) {
                if (!this.isCommonRbs) {
                    this.handleXalm(rbs);
                } else {
                    this.handleSau(rbs);
                }
            }
            this.isPowerSupported = rbs.isConfigurationItemSupported("PowerSystemCI");
            if (this.isPowerSupported) {
                if (RbsInfo.RBS_3202.NAME.equals(rbs.getRbsType())) {
                    this.isPSFanSupported = true;
                }
                this.handlePowerSupply(rbs);
            }
            if (this.isCommonRbs && DuwUtil.hasDuw() && rbs.getRbsData().isRbs6000()) {
                this.handleAbsoluteTimeSynchEnabled(rbs);
                this.handleGpsOutEnabled(rbs);
            }
            if (rbs.getRbsData().isRbs6000() && this.isPowerSupported) {
                this.handleSmokeDetector(rbs);
            }
            this.checkSectorOptions();
        }
        catch (Exception exception) {
            BemLog.exceptionRaised("Error has occured", exception);
            this.displayError(exception);
        }
    }

    private void handleXalm(Rbs rbs) throws Exception {
        YesNoCustomerParameter yesNoCustomerParameter = (YesNoCustomerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "configureXalm");
        this.myView.setSupportSystemControlParameters(null, yesNoCustomerParameter);
        this.externalAlarmParameterNames.add(yesNoCustomerParameter.getName());
    }

    private void handleSau(Rbs rbs) throws Exception {
        YesNoCustomerParameter yesNoCustomerParameter = (YesNoCustomerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "configureSau");
        TrueFalseCustomerParameter trueFalseCustomerParameter = null;
        if (rbs.isParameterSupported("supportSystemControl")) {
            trueFalseCustomerParameter = (TrueFalseCustomerParameter)rbs.getCustomerParameterObject("supportSystemControl");
            this.powerSupplyParameterNames.add(trueFalseCustomerParameter.getName());
        }
        this.myView.setSupportSystemControlParameters(trueFalseCustomerParameter, yesNoCustomerParameter);
        this.externalAlarmParameterNames.add(yesNoCustomerParameter.getName());
    }

    private void handleAbsoluteTimeSynchEnabled(Rbs rbs) throws Exception {
        AbsoluteTimeSynchEnabledParameter absoluteTimeSynchEnabledParameter = (AbsoluteTimeSynchEnabledParameter)rbs.getCustomerParameterObject("absoluteTimeSynchEnabled");
        this.myView.setAbsoluteTimeSynchEnabled(absoluteTimeSynchEnabledParameter);
        this.customerParameterNames.add("absoluteTimeSynchEnabled");
    }

    private void handleGpsOutEnabled(Rbs rbs) throws Exception {
        GpsOutEnabledParameter gpsOutEnabledParameter = (GpsOutEnabledParameter)rbs.getCustomerParameterObject("gpsOutEnabled");
        this.myView.setGpsOutEnabled(gpsOutEnabledParameter);
        this.customerParameterNames.add("gpsOutEnabled");
        if (DuwUtil.hasDualDuws()) {
            GpsOutEnabledParameterOnSlot2 gpsOutEnabledParameterOnSlot2 = (GpsOutEnabledParameterOnSlot2)rbs.getCustomerParameterObject("gpsOutEnabledOnSlot2");
            this.myView.setGpsOutEnabledOnSlot2(gpsOutEnabledParameterOnSlot2);
            this.customerParameterNames.add("gpsOutEnabledOnSlot2");
        }
    }

    private void handleSmokeDetector(Rbs rbs) throws Exception {
        SmokeDetectorParameter smokeDetectorParameter = (SmokeDetectorParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "smokeDetector");
        this.myView.setSmokeDetector(smokeDetectorParameter);
        this.customerParameterNames.add("smokeDetector");
    }

    private void handlePowerSupply(Rbs rbs) throws Exception {
        YesNoCustomerParameter yesNoCustomerParameter = null;
        IntegerParameter integerParameter = null;
        FanSpeedSupervisionParameter fanSpeedSupervisionParameter = null;
        IntegerParameter integerParameter2 = null;
        IntegerParameter integerParameter3 = null;
        IntegerParameter integerParameter4 = null;
        YesNoCustomerParameter yesNoCustomerParameter2 = null;
        Enumeration enumeration = null;
        StringParameter stringParameter = null;
        TrueFalseCustomerParameter trueFalseCustomerParameter = null;
        Enumeration enumeration2 = null;
        IntegerParameter integerParameter5 = null;
        IntegerParameter integerParameter6 = null;
        IntegerParameter integerParameter7 = null;
        StringParameter stringParameter2 = null;
        YesNoCustomerParameter[] yesNoCustomerParameterArray = null;
        yesNoCustomerParameter = (YesNoCustomerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "configurePowerSupply");
        this.powerSupplyParameterNames.add(yesNoCustomerParameter.getName());
        integerParameter = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "noOfPsu");
        this.powerSupplyParameterNames.add(integerParameter.getName());
        this.configureBatteryBackup = (YesNoCustomerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "configureBatteryBackup");
        this.powerSupplyParameterNames.add(this.configureBatteryBackup.getName());
        if (this.isPSFanSupported) {
            yesNoCustomerParameter2 = (YesNoCustomerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "configurePowerShelfFan");
            this.powerSupplyParameterNames.add(yesNoCustomerParameter2.getName());
        }
        if (this.isCommonRbs) {
            integerParameter2 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "noOfPdu");
            this.powerSupplyParameterNames.add(integerParameter2.getName());
            if (DuwUtil.hasDuw()) {
                fanSpeedSupervisionParameter = (FanSpeedSupervisionParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "fanSpeedSupervision");
                this.powerSupplyParameterNames.add(fanSpeedSupervisionParameter.getName());
            }
            enumeration = (Enumeration)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "batteryType");
            this.powerSupplyParameterNames.add(enumeration.getName());
            stringParameter = (StringParameter)rbs.getCustomerParameterServerObject(PrefixUtil.getFirstCabinetPrefix() + "batteryInstallationDate");
            this.powerSupplyParameterNames.add(stringParameter.getName());
            integerParameter3 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "noOfBfu");
            this.powerSupplyParameterNames.add(integerParameter3.getName());
            trueFalseCustomerParameter = (TrueFalseCustomerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "sharedBattery");
            this.powerSupplyParameterNames.add(trueFalseCustomerParameter.getName());
            this.chargingModeParameter = (Enumeration)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "chargingMode");
            this.powerSupplyParameterNames.add(this.chargingModeParameter.getName());
            enumeration2 = (Enumeration)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "testMode");
            this.powerSupplyParameterNames.add(enumeration2.getName());
            integerParameter5 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "minimumStateOfHealth");
            this.powerSupplyParameterNames.add(integerParameter5.getName());
            integerParameter6 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "minimumBackupTime");
            this.powerSupplyParameterNames.add(integerParameter6.getName());
            integerParameter7 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "testStartDay");
            this.powerSupplyParameterNames.add(integerParameter7.getName());
            stringParameter2 = (StringParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "testStartTime");
            this.powerSupplyParameterNames.add(stringParameter2.getName());
            yesNoCustomerParameterArray = new YesNoCustomerParameter[12];
            for (int i = 0; i < 12; ++i) {
                int n = i + 1;
                yesNoCustomerParameterArray[i] = (YesNoCustomerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "testStartMonths" + n);
                this.powerSupplyParameterNames.add(yesNoCustomerParameterArray[i].getName());
            }
        } else {
            integerParameter4 = (IntegerParameter)rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "batteryCapacity");
            this.powerSupplyParameterNames.add(integerParameter4.getName());
        }
        this.myView.setPowerSupplyParameters(yesNoCustomerParameter, integerParameter, integerParameter2, fanSpeedSupervisionParameter, integerParameter3, this.configureBatteryBackup, enumeration, stringParameter, integerParameter4, yesNoCustomerParameter2, trueFalseCustomerParameter, this.chargingModeParameter, enumeration2, integerParameter5, integerParameter6, integerParameter7, stringParameter2, yesNoCustomerParameterArray);
    }

    private void checkSectorOptions() {
        try {
            Object object;
            Rbs rbs = this.wizardCiModel.getRbs();
            boolean bl = false;
            if (rbs.isPantherHybridRbs()) {
                bl = true;
            } else {
                object = rbs.getRadioEquipmentProvider();
                bl = object.mainRemoteRbs();
            }
            object = "";
            String string = "";
            String string2 = "1radioIfType";
            if (rbs.isParameterSupported(string2)) {
                object = ((RadioIfTypeParameter)rbs.getCustomerParameterObject(string2)).getValue();
            }
            if (rbs.isParameterSupported(string2 = "2radioIfType")) {
                string = ((RadioIfTypeParameter)rbs.getCustomerParameterObject(string2)).getValue();
            }
            if (!bl || bl && ((String)object).equals("RUIF") && string == "" || ((String)object).equals("RUIF") && string.equals("RUIF")) {
                this.wizardHelp.excludeSlides("SectorOptionsController", "SectorOptionsController");
            } else if (!bl) {
                WizardException wizardException = new WizardException(CAUSE_CABINET);
                this.displayError(wizardException);
            }
        }
        catch (Exception exception) {
            this.displayError(exception);
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format("Site Equipment Configuration page {0}({1})", string2, string3));
    }

    protected boolean next() {
        boolean bl = true;
        try {
            Rbs rbs = this.wizardCiModel.getRbs();
            if (this.isAlarmSupported) {
                rbs.checkConsistency("AlarmCI", this.externalAlarmParameterNames);
            }
            if (this.isPowerSupported) {
                rbs.checkConsistency("PowerSystemCI", this.powerSupplyParameterNames);
            }
            if (this.isCommonRbs && DuwUtil.hasDuw() && rbs.getRbsData().isRbs6000()) {
                rbs.checkConsistency("CabinetBasicCI", this.customerParameterNames);
            }
            if (this.configureBatteryBackup == null || !this.configureBatteryBackup.getBooleanValue() || this.chargingModeParameter == null || this.chargingModeParameter.getValueMom().equals(0)) {
                this.wizardHelp.excludeSlide("BatteryChargingController");
            } else {
                this.wizardHelp.addSlides("OptionalEquipmentController", "BatteryChargingController");
            }
        }
        catch (Exception exception) {
            this.displayNextError(this.myView, exception);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        return true;
    }
}

