/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import se.ericsson.wcdma.support.gui.EmasGuilibMediator;

public class EmasProgressMonitor {
    private EmasProgressMonitor roots;
    private JDialog dialogs;
    private JOptionPane panes;
    private JProgressBar bar;
    private JLabel notesLabel;
    private final Component parent;
    private String notes;
    private final Object title;
    private final Object message;
    private final long T0;
    private int millisDecideToPopup = 500;
    private int millisToPopup = 2000;
    private int minValue;
    private int maxValue;
    private int last;
    private int delta;
    private static final Vector openProgressMonitors = new Vector();

    public EmasProgressMonitor(Component component, Object object, Object object2, String string, int n, int n2) {
        this(component, object, object2, string, n, n2, null);
    }

    private EmasProgressMonitor(Component component, Object object, Object object2, String string, int n, int n2, EmasProgressMonitor emasProgressMonitor) {
        this.minValue = n;
        this.maxValue = n2;
        this.parent = component;
        this.delta = (n2 - n) / 100;
        if (this.delta < 1) {
            this.delta = 1;
        }
        this.title = object;
        this.message = object2;
        this.notes = string;
        if (emasProgressMonitor != null) {
            this.roots = emasProgressMonitor.roots != null ? emasProgressMonitor.roots : emasProgressMonitor;
            this.T0 = this.roots.T0;
            this.dialogs = this.roots.dialogs;
        } else {
            this.T0 = System.currentTimeMillis();
        }
        openProgressMonitors.add(this);
    }

    public void setProgress(int n) {
        if (n >= this.maxValue) {
            this.close();
        } else if (n >= this.last + this.delta) {
            this.last = n;
            if (this.bar != null) {
                this.bar.setValue(n);
                this.repaintImmediately();
            } else {
                int n2;
                long l = System.currentTimeMillis();
                long l2 = (int)(l - this.T0);
                if (l2 >= (long)this.millisDecideToPopup && (n2 = n > this.minValue ? (int)(l2 * (long)(this.maxValue - this.minValue) / (long)(n - this.minValue)) : this.millisToPopup) >= this.millisToPopup) {
                    this.bar = new JProgressBar();
                    this.bar.setMinimum(this.minValue);
                    this.bar.setMaximum(this.maxValue);
                    this.bar.setValue(n);
                    if (this.notes != null) {
                        this.notesLabel = new JLabel(this.notes);
                    }
                    this.panes = new ProgressOptionPane(new Object[]{this.message, this.notesLabel, this.bar});
                    this.dialogs = this.panes.createDialog(this.parent, this.title.toString());
                    this.dialogs.show();
                    this.repaintImmediately();
                }
            }
        }
    }

    private void repaintImmediately() {
        Container container = this.dialogs.getContentPane();
        if (container instanceof JComponent) {
            if (SwingUtilities.isEventDispatchThread()) {
                container.paintAll(container.getGraphics());
            } else {
                container.repaint();
            }
        } else {
            container.repaint(0, 0, container.getWidth(), container.getHeight());
        }
    }

    public void close() {
        if (this.dialogs != null) {
            this.dialogs.setVisible(false);
            this.dialogs.dispose();
            this.dialogs = null;
            this.panes = null;
            this.bar = null;
        }
        openProgressMonitors.remove(this);
    }

    public static void closeAllOpenProgressMonitors() {
        for (int i = 0; i < openProgressMonitors.size(); ++i) {
            EmasProgressMonitor emasProgressMonitor = (EmasProgressMonitor)openProgressMonitors.get(i);
            emasProgressMonitor.close();
        }
        openProgressMonitors.clear();
    }

    public int getMinimum() {
        return this.minValue;
    }

    public void setMinimum(int n) {
        this.minValue = n;
    }

    public int getMaximum() {
        return this.maxValue;
    }

    public void setMaximum(int n) {
        this.maxValue = n;
    }

    public void setMillisToDecideToPopup(int n) {
        this.millisDecideToPopup = n;
    }

    public int getMillisToDecideToPopup() {
        return this.millisDecideToPopup;
    }

    public void setMillisToPopup(int n) {
        this.millisToPopup = n;
    }

    public int getMillisToPopup() {
        return this.millisToPopup;
    }

    public void setNote(String string) {
        this.notes = string;
        if (this.notesLabel != null) {
            this.notesLabel.setText(string);
            this.repaintImmediately();
        }
    }

    public String getNote() {
        return this.notes;
    }

    public void resetProgressBar() {
        this.bar.setValue(this.minValue);
        this.last = this.minValue;
    }

    private static class ProgressOptionPane
    extends JOptionPane {
        ProgressOptionPane(Object object) {
            super(object, 1, -1, null, new Object[]{new JPanel()}, null);
        }

        public int getMaxCharactersPerLineCount() {
            return 60;
        }

        public JDialog createDialog(Component component, String string) {
            if (null == component) {
                component = EmasGuilibMediator.getReference().getMainWindowReference();
            }
            Frame frame = JOptionPane.getFrameForComponent(component);
            final JDialog jDialog = new JDialog(frame, string, false);
            Container container = jDialog.getContentPane();
            container.setLayout(new BorderLayout());
            container.add((Component)this, "Center");
            jDialog.pack();
            jDialog.setLocationRelativeTo(component);
            jDialog.addWindowListener(new WindowAdapter(){
                boolean getFocus = false;

                public void windowClosing(WindowEvent windowEvent) {
                    ProgressOptionPane.this.setValue(null);
                }

                public void windowActivated(WindowEvent windowEvent) {
                    if (!this.getFocus) {
                        ProgressOptionPane.this.selectInitialValue();
                        this.getFocus = true;
                    }
                }
            });
            this.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (jDialog.isVisible() && propertyChangeEvent.getSource() == ProgressOptionPane.this && (propertyChangeEvent.getPropertyName().equals("value") || propertyChangeEvent.getPropertyName().equals("inputValue"))) {
                        jDialog.setVisible(false);
                        jDialog.dispose();
                    }
                }
            });
            return jDialog;
        }
    }
}

