/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.comp;

import java.awt.Component;
import java.awt.Container;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;

public class ComponentToolkit {
    private ComponentToolkit() {
    }

    public static void makeSearchable(JComboBox jComboBox) {
        jComboBox.setKeySelectionManager(new ComboBoxKeySelectionManager(jComboBox));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Component getFocusOwner(Container container) {
        Object object = container.getTreeLock();
        synchronized (object) {
            Component component = ComponentToolkit.getFocusOwnerImpl(container);
            Log.trace("getFocusOwner: " + component);
            return component;
        }
    }

    private static Component getFocusOwnerImpl(Container container) {
        Component component = null;
        if (container.hasFocus()) {
            component = container;
        } else {
            Component[] componentArray = container.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                Component component2 = componentArray[i];
                if (component2.hasFocus()) {
                    component = component2;
                    break;
                }
                if (component2 instanceof Container && (component = ComponentToolkit.getFocusOwner((Container)component2)) != null) break;
            }
        }
        return component;
    }

    public static void setEnabled(boolean bl, Component component) {
        component.setEnabled(bl);
        if (component instanceof Container) {
            ComponentToolkit.setEnabled(bl, ((Container)component).getComponents());
        }
        if (component instanceof JMenu) {
            ComponentToolkit.setEnabled(bl, ((JMenu)component).getMenuComponents());
        }
    }

    private static void setEnabled(boolean bl, Component[] componentArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            ComponentToolkit.setEnabled(bl, componentArray[i]);
        }
    }

    public static void updateLookAndFeel(Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).updateUI();
        }
        if (component instanceof Container) {
            ComponentToolkit.updateLookAndFeel(((Container)component).getComponents());
        }
        if (component instanceof JMenu) {
            ComponentToolkit.updateLookAndFeel(((JMenu)component).getMenuComponents());
        }
    }

    private static void updateLookAndFeel(Component[] componentArray) {
        for (int i = 0; i < componentArray.length; ++i) {
            ComponentToolkit.updateLookAndFeel(componentArray[i]);
        }
    }

    public static String getDateFormat(Date date, Locale locale) {
        DateFormat dateFormat = DateFormat.getDateInstance(1, locale);
        return dateFormat.format(date);
    }

    public static String getTimeFormat(Date date, Locale locale) {
        DateFormat dateFormat = DateFormat.getTimeInstance(2, locale);
        return dateFormat.format(date);
    }

    public static String getDateTimeFormat(Date date, Locale locale) {
        DateFormat dateFormat = DateFormat.getDateTimeInstance(1, 2, locale);
        return dateFormat.format(date);
    }

    private static class ComboBoxKeySelectionManager
    implements JComboBox.KeySelectionManager {
        private String searchKey = "";
        private long lastPressed = new Date().getTime();
        private JComboBox aBox;

        protected ComboBoxKeySelectionManager(JComboBox jComboBox) {
            this.aBox = jComboBox;
        }

        public int selectionForKey(char c, ComboBoxModel comboBoxModel) {
            this.aBox.showPopup();
            long l = new Date().getTime();
            if (this.isValidKey(c)) {
                this.searchKey = l - this.lastPressed > 1000L ? new Character(Character.toLowerCase(c)).toString() : this.searchKey + Character.toLowerCase(c);
            }
            this.lastPressed = l;
            for (int i = 0; i < comboBoxModel.getSize(); ++i) {
                Object e = comboBoxModel.getElementAt(i);
                if (!e.toString().toLowerCase().startsWith(this.searchKey)) continue;
                return i;
            }
            return -1;
        }

        private boolean isValidKey(char c) {
            return !Character.isISOControl(c) && Character.getType(c) != 0;
        }
    }
}

