/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.comp;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.text.NumberFormat;
import java.util.Hashtable;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalLogBackend;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.nex.NalLogNex;

public class Log {
    public static final int MIN_LOG_LEVEL = 0;
    public static final int MAX_LOG_LEVEL = 7;
    public static final int ERROR = 1;
    public static final int WARNING = 2;
    public static final int NOTIFY = 3;
    public static final int PARAM = 4;
    public static final int TRACE_FLOW = 5;
    public static final int TRACE = 6;
    static final String[] LOG_LEVEL_KEYS = new String[]{"GSL_MIN_LOG_LEVEL", "GSL_ERROR", "GSL_WARNING", "GSL_NOTIFY", "GSL_PARAM", "GSL_TRACE_FLOW", "GSL_TRACE", "GSL_MAX_LOG_LEVEL"};
    static final int[] LOG_LEVEL_VALUES = new int[]{0, 1, 2, 3, 4, 5, 6, 7};
    private static int logCount = 0;
    private static boolean lineNumberInfo = true;
    private static ByteArrayOutputStream exceptionStream = new ByteArrayOutputStream(1200);
    private static PrintWriter exceptionWriter = new PrintWriter(exceptionStream, true);
    private static Hashtable currentMeasurements = new Hashtable(10);
    private static boolean measurementInfoOn = false;
    private static boolean garbageCollectAtMeasure = false;
    public static final String LOGGER_NAME_EMSERV = "se.ericsson.wcdma.support";
    private static final Logger logger = Logger.getLogger("se.ericsson.wcdma.support");

    private Log() {
    }

    public static void assertion(boolean bl, String string) {
        if (!bl) {
            throw new RuntimeException("Assertion failed: " + string);
        }
    }

    public static final void traceFlow() {
        if (!logger.isLoggable(Level.FINER)) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(logCount++).append(" TRACE_FLOW ").append(Log.getLineNumber(Log.getStackTrace(new Throwable())));
        logger.log(Level.FINER, stringBuffer.toString());
    }

    public static final void trace(String string) {
        if (!logger.isLoggable(Level.FINEST)) {
            return;
        }
        Log.log(Level.FINEST, "TRACE", string, null);
    }

    public static final void logNotify(String string) {
        if (!logger.isLoggable(Level.INFO)) {
            return;
        }
        Log.log(Level.INFO, "NOTIFY", string, null);
    }

    public static final void logWarning(String string) {
        if (!logger.isLoggable(Level.WARNING)) {
            return;
        }
        Log.log(Level.WARNING, "WARNING", string, null);
    }

    public static final void logWarning(String string, Throwable throwable) {
        if (!logger.isLoggable(Level.WARNING)) {
            return;
        }
        Log.log(Level.WARNING, "WARNING", string, throwable);
    }

    public static final void logError(String string) {
        if (!logger.isLoggable(Level.SEVERE)) {
            return;
        }
        Log.log(Level.SEVERE, "ERROR", string, null);
    }

    public static final void logError(String string, Throwable throwable) {
        if (!logger.isLoggable(Level.SEVERE)) {
            return;
        }
        Log.log(Level.SEVERE, "ERROR", string, throwable);
    }

    public static final void log(int n, String string) {
        Level level = NalLogNex.toLoggerLevel(n);
        if (!logger.isLoggable(level)) {
            return;
        }
        Log.log(level, null, string, null);
    }

    public static final void log(int n, String string, Throwable throwable) {
        Level level = NalLogNex.toLoggerLevel(n);
        if (!logger.isLoggable(level)) {
            return;
        }
        Log.log(level, null, string, throwable);
    }

    private static final void log(int n, String string, String string2, Throwable throwable) {
        Level level = NalLogNex.toLoggerLevel(n);
        if (!logger.isLoggable(level)) {
            return;
        }
        Log.log(level, string, string2, throwable);
    }

    private static final void log(Level level, String string, String string2, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(logCount++).append(" ");
        if (string != null) {
            stringBuffer.append(string).append(" ");
        }
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if (lineNumberInfo) {
            stringBuffer.append(" AT LINE: ").append(NalLogBackend.getAtLine());
        }
        stringBuffer.append(NalLogNex.NEW_LINE);
        if (throwable != null) {
            stringBuffer.append("Exception: " + throwable);
            stringBuffer.append(NalLogNex.NEW_LINE);
            stringBuffer.append(Log.getStackTrace(throwable));
            stringBuffer.append(NalLogNex.NEW_LINE);
            if (throwable instanceof InvocationTargetException) {
                Throwable throwable2 = ((InvocationTargetException)throwable).getTargetException();
                stringBuffer.append("Target Exception: " + throwable2);
                stringBuffer.append(NalLogNex.NEW_LINE);
                stringBuffer.append(Log.getStackTrace(throwable2));
                stringBuffer.append(NalLogNex.NEW_LINE);
            }
        }
        logger.log(level, stringBuffer.toString());
    }

    public static void setMeasurementInfoOn(boolean bl) {
        measurementInfoOn = bl;
        Log.trace("measurementInfoOn was set to: " + measurementInfoOn);
    }

    public static void measure(Object object, boolean bl) {
        Log.measure(object, bl, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void measure(Object object, boolean bl, String string) {
        if (!measurementInfoOn) return;
        Class<Measurement> clazz = Measurement.class;
        synchronized (Measurement.class) {
            Stack<Measurement> stack = (Stack<Measurement>)currentMeasurements.get(object);
            if (bl) {
                if (stack == null) {
                    stack = new Stack<Measurement>();
                    currentMeasurements.put(object, stack);
                }
                Measurement measurement = new Measurement(object, string);
                measurement.setMeasureTime(true);
                measurement.setMeasureMemory(false);
                stack.push(measurement);
            } else if (stack == null || stack.isEmpty()) {
                Log.logWarning("Can't stop measurement before it has started.");
            } else {
                int n;
                Measurement measurement = (Measurement)stack.pop();
                measurement.stop();
                if (string != null) {
                    measurement.setMessage(string);
                }
                if ((n = stack.size()) > 0) {
                    measurement.setCount(n + 1);
                }
                Log.log(3, "MEASUREMENT", measurement.toString(), null);
                if (!stack.isEmpty()) return;
                currentMeasurements.remove(object);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    private static final String getLineNumber(String string) {
        int n = string.lastIndexOf("guilib.comp.Log.log(");
        if (n == -1) {
            return null;
        }
        n = string.indexOf("at ", n + 1);
        if ((n = string.indexOf("at ", n + 1)) == -1) {
            return null;
        }
        int n2 = string.indexOf(NalLogNex.FIRST_NEW_LINE_CHAR, n + 1);
        String string2 = string.substring(n + 3, n2);
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getStackTrace(Throwable throwable) {
        ByteArrayOutputStream byteArrayOutputStream = exceptionStream;
        synchronized (byteArrayOutputStream) {
            exceptionStream.reset();
            throwable.printStackTrace(exceptionWriter);
            return exceptionStream.toString();
        }
    }

    private static class Measurement {
        private long startTime;
        private long stopTime;
        private Object src;
        private String msg = "";
        private long allocatedMemory;
        private long allocatedMemoryAfterGC;
        private static NumberFormat numberFormatter;
        private boolean measureTimeFlag = false;
        private boolean measureMemoryFlag = false;

        public Measurement(Object object) {
            this(object, "");
        }

        public Measurement(Object object, String string) {
            this.src = object;
            this.setMessage(string);
            if (numberFormatter == null) {
                numberFormatter = NumberFormat.getInstance();
                numberFormatter.setMaximumFractionDigits(1);
                numberFormatter.setGroupingUsed(false);
            }
            this.startTime = System.currentTimeMillis();
        }

        public Object getSrc() {
            return this.src;
        }

        public void setMessage(String string) {
            this.msg = string == null ? "" : string;
        }

        public String getMessage() {
            return this.msg;
        }

        public void setCount(int n) {
        }

        public boolean isMeasureTime() {
            return this.measureTimeFlag;
        }

        public void setMeasureTime(boolean bl) {
            this.measureTimeFlag = bl;
        }

        public boolean isMeasureMemory() {
            return this.measureMemoryFlag;
        }

        public void setMeasureMemory(boolean bl) {
            this.measureMemoryFlag = bl;
        }

        public long getDifference() {
            long l = this.stopTime == 0L ? System.currentTimeMillis() : this.stopTime;
            long l2 = l - this.startTime;
            return l2;
        }

        public long getAllocatedMemory() {
            long l = this.allocatedMemory;
            if (this.allocatedMemory == 0L) {
                l = this.calculateAllocatedMemory();
            }
            return l;
        }

        public long getAllocatedMemoryAfterGarbageCollect() {
            long l = this.allocatedMemoryAfterGC;
            if (this.allocatedMemoryAfterGC == 0L) {
                Thread.yield();
                l = this.calculateAllocatedMemory();
            }
            return l;
        }

        private long calculateAllocatedMemory() {
            Runtime runtime = Runtime.getRuntime();
            return runtime.totalMemory() - runtime.freeMemory();
        }

        public void stop() {
            if (this.measureTimeFlag) {
                this.stopTime = System.currentTimeMillis();
            }
            if (this.measureMemoryFlag) {
                this.allocatedMemory = this.getAllocatedMemory();
                if (garbageCollectAtMeasure) {
                    this.allocatedMemoryAfterGC = this.getAllocatedMemoryAfterGarbageCollect();
                }
            }
        }

        public String toString() {
            String string = this.msg;
            if (this.measureTimeFlag) {
                string = string + " : " + this.getDifference() + " ms ";
            }
            if (this.measureMemoryFlag) {
                long l = this.getAllocatedMemory();
                double d = (double)l / 1000.0;
                String string2 = numberFormatter.format(d);
                String string3 = "";
                if (garbageCollectAtMeasure) {
                    l = this.getAllocatedMemoryAfterGarbageCollect();
                    d = (double)l / 1000.0;
                    string3 = " (" + numberFormatter.format(d) + ")";
                }
                string = string + " : " + string2 + string3 + " kB";
            }
            return string;
        }
    }
}

