/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JPanel;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractComponentController;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractComponentView;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractView;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationManager;
import se.ericsson.wcdma.support.gui.guilib.infra.ComponentPresenter;
import se.ericsson.wcdma.support.gui.guilib.infra.Resources;

public abstract class AbstractComponent
extends JPanel
implements Resources {
    private Properties environment;
    private AbstractPresenter presenter;

    public AbstractComponent() {
        this.setLayout(new BorderLayout());
    }

    public abstract Class getComponentViewClass();

    public abstract Class getComponentControllerClass();

    public abstract String getLanguageBundleName();

    public abstract String getEnvironmentBundleName();

    public abstract String getToolTipBundleName();

    public String getHelpBundleName() {
        return null;
    }

    protected AbstractComponentController getController() {
        return (AbstractComponentController)this.presenter.getController();
    }

    public Properties getEnvironment() {
        return this.environment;
    }

    public ResourceBundle getLanguageBundle() {
        return this.presenter.getLanguageManager().getLanguageBundle();
    }

    AbstractPresenter getPresenter() {
        return this.presenter;
    }

    public ResourceBundle getToolTipBundle() {
        return this.presenter.getLanguageManager().getToolTipBundle();
    }

    protected AbstractComponentView getView() {
        return (AbstractComponentView)this.presenter.getView();
    }

    void init() {
        Container container = this.getParent();
        while (!(container instanceof AbstractView)) {
            container = container.getParent();
        }
        AbstractView abstractView = (AbstractView)container;
        AbstractApplication abstractApplication = abstractView.getPresenter().getApplication();
        this.environment = new Properties(abstractApplication.getEnvironment());
        String string = this.getEnvironmentBundleName();
        if (string != null && !string.equals("")) {
            ApplicationManager.loadBundle(string, abstractApplication.getLocale(), this.environment);
        }
        this.presenter = AbstractPresenter.createPresenter(abstractView.getPresenter(), abstractView.getPresenter().getApplication(), ComponentPresenter.class, this.getComponentViewClass(), this.getComponentControllerClass(), this);
    }

    void setPresenter(AbstractPresenter abstractPresenter) {
        this.presenter = abstractPresenter;
    }

    void updateLocale(Locale locale) {
        this.presenter.updateLocale(locale);
    }

    public void setEnabled(boolean bl, boolean bl2) {
        this.setEnabled(bl);
        if (bl2) {
            this.enableChildComponents(this, bl);
        }
    }

    private void enableChildComponents(Component component, boolean bl) {
        component.setEnabled(bl);
        if (component instanceof Container) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                this.enableChildComponents(componentArray[i], bl);
            }
        }
    }
}

