/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.support.gui.guilib.infra;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.swing.ImageIcon;
import se.ericsson.cello.emt.helpservice.HelpServiceI;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.app.BemLaunchable;
import se.ericsson.wcdma.rbs.bem.common.gui.app.LaunchProperties;
import se.ericsson.wcdma.rbs.bem.common.gui.app.LaunchProperty;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationController;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationDefaultView;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationPresenter;
import se.ericsson.wcdma.support.gui.resources.ImageConstant;

public class ApplicationDefaultController
extends AbstractApplicationController {
    private ApplicationDefaultView view;
    private ExitAction exitAction = null;
    private CloseAction closeAction = null;
    private LogOptionsAction logOptionsAction = new LogOptionsAction();
    private AboutAction aboutAction = new AboutAction();
    private UsingHelpAction howToAction = new UsingHelpAction();
    private HelpServiceI myHelpService;

    protected void init() {
        this.view = ((ApplicationPresenter)this.getPresenter()).getMenuToolBarHandler().getApplicationDefaultView();
        if (this.view.exitMenuItem != null) {
            this.exitAction = new ExitAction();
            this.view.exitMenuItem.addActionListener(this.exitAction);
        }
        if (this.view.closeMenuItem != null) {
            this.closeAction = new CloseAction();
            this.view.closeMenuItem.addActionListener(this.closeAction);
        }
        if (this.view.logOptionsMenuItem != null) {
            this.view.logOptionsMenuItem.addActionListener(this.logOptionsAction);
        }
        this.view.aboutMenuItem.addActionListener(this.aboutAction);
        this.view.howToHelpMenuItem.addActionListener(this.howToAction);
    }

    protected void stop() {
        if (this.closeAction != null) {
            this.view.closeMenuItem.removeActionListener(this.closeAction);
        }
        if (this.exitAction != null) {
            this.view.exitMenuItem.removeActionListener(this.exitAction);
        }
        if (this.view.logOptionsMenuItem != null) {
            this.view.logOptionsMenuItem.removeActionListener(this.logOptionsAction);
        }
        this.view.aboutMenuItem.removeActionListener(this.aboutAction);
        this.view = null;
    }

    private HelpServiceI getHelpService(final LauncherInterface launcherInterface, final BemLaunchable bemLaunchable) {
        if (null != this.myHelpService) {
            return this.myHelpService;
        }
        final Properties properties = bemLaunchable.getArguments().getSupersedingProperties();
        final String string = bemLaunchable.getArguments().getProperty(LaunchProperty.HELPSERVICE_CONFIG);
        properties.setProperty("HELPSERVICE_INIT", "TRUE");
        PrivilegedExceptionAction<Launchable> privilegedExceptionAction = new PrivilegedExceptionAction<Launchable>(){

            @Override
            public Launchable run() throws LauncherException {
                return launcherInterface.runResource(string, bemLaunchable.getHostname(), properties, (Launchable)bemLaunchable);
            }
        };
        Callable<Object> callable = Executors.callable(privilegedExceptionAction);
        ExecutorService executorService = Executors.newSingleThreadExecutor();
        Future<Object> future = executorService.submit(callable);
        try {
            Object object = future.get();
            executorService.shutdown();
            this.myHelpService = (HelpServiceI)object;
        }
        catch (Exception exception) {
            BemException bemException = new BemException("Help Service problem.\nIt will not be possible to open any help information", (Throwable)exception);
            this.getEasyPopUp().displayError(bemException);
        }
        return this.myHelpService;
    }

    private class AboutAction
    implements ActionListener {
        private AboutAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            BemLaunchable bemLaunchable = ApplicationDefaultController.this.getApplication().getBemLaunchable();
            String string = bemLaunchable.getApplName();
            String string2 = "2009";
            ImageIcon imageIcon = null;
            if (string.indexOf("Modify") > -1) {
                imageIcon = ImageConstant.MODIFY_LARGE.getImageIcon();
                string2 = "2003-2009";
            } else if (string.indexOf("Integrate") > -1) {
                imageIcon = ImageConstant.INTEGRATE_LARGE.getImageIcon();
                string2 = "2007-2009";
            }
            LauncherInterface launcherInterface = bemLaunchable.getLauncher();
            ArrayList arrayList = null;
            try {
                arrayList = launcherInterface.getConfigurationFiles((Launchable)bemLaunchable);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                arrayList = new ArrayList();
                Nal.getLog().nalTraceError(ApplicationDefaultController.class, "Exception when getting config file info from the launcher. Probably  due to executing in demo BEM", unsupportedOperationException);
            }
            HelpServiceI helpServiceI = ApplicationDefaultController.this.getHelpService(launcherInterface, bemLaunchable);
            if (null != helpServiceI) {
                helpServiceI.displayAbout(string, arrayList, ApplicationDefaultController.this.getPresenter().getJFrame(), imageIcon, null, string2, null);
            }
        }
    }

    private class UsingHelpAction
    implements ActionListener {
        private UsingHelpAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            HelpServiceI helpServiceI = ApplicationDefaultController.this.getHelpService(ApplicationDefaultController.this.getApplication().getBemLaunchable().getLauncher(), ApplicationDefaultController.this.getApplication().getBemLaunchable());
            if (null != helpServiceI) {
                helpServiceI.displayUsingHelp(ApplicationDefaultController.this.getApplication().getJFrame());
            }
        }
    }

    private class ExitAction
    implements ActionListener {
        private ExitAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ApplicationDefaultController.this.getApplicationManager().stopApplicationManager();
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ApplicationDefaultController.this.getApplicationManager().stopApplication(ApplicationDefaultController.this.getApplication());
        }
    }

    private class LogOptionsAction
    implements ActionListener {
        private static final String EMTRACELOGCFG_XML = "/cello/emas/emtracelogcfg.xml";

        private LogOptionsAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                BemLaunchable bemLaunchable = ApplicationDefaultController.this.getApplication().getBemLaunchable();
                LauncherInterface launcherInterface = bemLaunchable.getLauncher();
                String string = bemLaunchable.getHostname();
                LaunchProperties launchProperties = bemLaunchable.getArguments();
                launcherInterface.runResource(EMTRACELOGCFG_XML, string, launchProperties.getCopy(), (Launchable)bemLaunchable);
            }
            catch (Exception exception) {
                Log.logError("Failed launching LogServicesTool!", exception);
            }
        }
    }
}

