/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.configirpimpl;

import BasicConfig.MOAttrValue;
import BasicConfig.NameValue;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import se.ericsson.cello.configirpimpl.AnyMapping;
import se.ericsson.cello.configirpimpl.MoRefMgr;
import se.ericsson.cello.configirpimpl.NoSuchActionException;
import se.ericsson.cello.configirpimpl.ParameterErrorException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoRepository;
import se.ericsson.cello.moframework.SoftwareErrorException;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;

public class DynMoAccess {
    private static DynMoAccess theOneAndOnly;

    public static synchronized DynMoAccess instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new DynMoAccess();
        }
        return theOneAndOnly;
    }

    private DynMoAccess() {
        MoRepository.instance();
    }

    public void setAttributes(ManagedObject managedObject, NameValue[] nameValueArray, Coordinator coordinator) throws MoAccessException {
        Assert.cppAssert((Object)managedObject);
        String[] stringArray = new String[nameValueArray.length];
        Object[] objectArray = new Object[nameValueArray.length];
        for (int i = 0; i < nameValueArray.length; ++i) {
            stringArray[i] = nameValueArray[i].name;
            objectArray[i] = AnyMapping.any2object(nameValueArray[i].value);
        }
        managedObject.setAttributes(stringArray, objectArray, coordinator);
    }

    public void setAttributes(MoIterator moIterator, NameValue[] nameValueArray, Coordinator coordinator) throws MoAccessException {
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject = moIterator.nextMo();
            this.setAttributes(managedObject, nameValueArray, coordinator);
        }
    }

    public MOAttrValue[] getAttributes(MoIterator moIterator, String[] stringArray, Coordinator coordinator) throws MoAccessException {
        MOAttrValue[] mOAttrValueArray = new MOAttrValue[moIterator.size()];
        for (int i = 0; i < moIterator.size(); ++i) {
            ManagedObject managedObject = moIterator.nextMo();
            Object[] objectArray = managedObject.getAttributes(stringArray, coordinator);
            mOAttrValueArray[i] = new MOAttrValue();
            mOAttrValueArray[i].attrValues = new Any[stringArray.length];
            mOAttrValueArray[i].mo = MoRefMgr.createMoRef(managedObject);
            for (int j = 0; j < stringArray.length; ++j) {
                mOAttrValueArray[i].attrValues[j] = AnyMapping.object2any(objectArray[j]);
            }
        }
        return mOAttrValueArray;
    }

    public Any invokeAction(ManagedObject managedObject, String string, NameValue[] nameValueArray, Coordinator coordinator) throws MoAccessException {
        try {
            Method method = this.findMethod(managedObject, "action" + string);
            if (method == null) {
                throw new NoSuchActionException(string, managedObject.getType());
            }
            Object[] objectArray = new Object[nameValueArray.length + 1];
            Object[] objectArray2 = new Object[nameValueArray.length];
            for (int i = 0; i < nameValueArray.length; ++i) {
                objectArray[i] = AnyMapping.any2object(nameValueArray[i].value);
                objectArray2[i] = objectArray[i];
            }
            objectArray[nameValueArray.length] = coordinator;
            Object object = method.invoke((Object)managedObject, objectArray);
            if (object == null) {
                Class<?> clazz = method.getReturnType();
                if (clazz.equals(Void.TYPE)) {
                    ORB oRB = CelloOrb.instance().getOrb();
                    TypeCode typeCode = oRB.get_primitive_tc(TCKind.tk_void);
                    Any any = CelloOrb.instance().create_any();
                    any.type(typeCode);
                    return any;
                }
                if (!ManagedObject.class.isAssignableFrom(clazz)) {
                    Assert.cppAssert((boolean)false, (String)"Ony action methods that returns an MO (or void) are allowed to return null");
                    return null;
                }
            }
            return AnyMapping.object2any(object);
        }
        catch (InvocationTargetException invocationTargetException) {
            if (invocationTargetException.getTargetException() instanceof MoAccessException) {
                throw (MoAccessException)invocationTargetException.getTargetException();
            }
            MessageLog.traceError(this.getClass(), (String)"invoke action exception:", (Throwable)invocationTargetException.getTargetException());
            throw new SoftwareErrorException(invocationTargetException.getTargetException());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new ParameterErrorException();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new NoSuchActionException(string, managedObject.getType());
        }
    }

    private Method findMethod(Object object, String string) {
        Class<?> clazz = object.getClass();
        Method[] methodArray = clazz.getMethods();
        Object var5_5 = null;
        for (int i = 0; i < methodArray.length; ++i) {
            if (!methodArray[i].getName().equalsIgnoreCase(string)) continue;
            return methodArray[i];
        }
        return null;
    }
}

