/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework;

import java.security.Principal;
import se.ericsson.cello.moframework.NoPermissionException;
import se.ericsson.cello.support.corba.CelloOrb;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.vls.VLS;
import se.ericsson.cello.vls.VLSException;

public class AccessControlHelper {
    private static CelloOrb celloOrb = CelloOrb.instance();
    private static final String REP_ID = "IDL:ConfigExtended/ConfigurationExtended:1.0";
    private static final String METHOD = "basic_set_MO";

    public static void performAccessControl() throws NoPermissionException {
        if (celloOrb.securityActivated()) {
            String string = null;
            String string2 = null;
            Principal principal = celloOrb.getCurrent().getActingPrincipal();
            if (principal == null) {
                MessageLog.info((Class)AccessControlHelper.class, (String)"No acting principal");
                throw new NoPermissionException("No acting principal");
            }
            if (((Object)principal).equals(celloOrb.getCurrent().getLocalPrincipal())) {
                return;
            }
            try {
                string = celloOrb.getCurrent().getUniqueID(principal);
                if (string == null) {
                    string2 = principal.getName();
                    if (string2 == null) {
                        MessageLog.info((Class)AccessControlHelper.class, (String)"Both userName and userDN are null");
                        throw new NoPermissionException("Both userName and userDN are null");
                    }
                    if (!VLS.instance().isAuthorized(null, string2, REP_ID, METHOD)) {
                        throw new NoPermissionException("Access denied");
                    }
                } else if (!VLS.instance().isAuthorized(string, null, REP_ID, METHOD)) {
                    throw new NoPermissionException("Access denied");
                }
            }
            catch (VLSException vLSException) {
                throw new NoPermissionException(vLSException.toString());
            }
        }
    }
}

