/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework;

import se.ericsson.cello.moframework.Mib;
import se.ericsson.cello.moframework.internal.MibDecorated;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;

public class MibMgr {
    private Mib theMib = null;
    private static MibMgr theOneAndOnly;

    public static synchronized MibMgr instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new MibMgr();
        }
        return theOneAndOnly;
    }

    private MibMgr() {
    }

    public void registerMib(Mib mib) {
        Assert.cppAssert((Object)mib, (String)"Try to registerMib failed, MIB == null");
        if (this.theMib == null) {
            this.theMib = new MibDecorated(mib);
        } else {
            MessageLog.info((Class)MibMgr.class, (String)"Try to registerMib failed, MIB already registered");
        }
    }

    public Mib getMib() {
        return this.theMib;
    }

    public int getMibId() {
        return 1;
    }
}

