/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework;

import BasicConfig.NotAccepted;
import BasicConfig.NotDefined;
import com.metamata.parse.ParseException;
import java.io.BufferedReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import se.ericsson.cello.csfilter.FilterParser;
import se.ericsson.cello.csfilter.FilterPredicate;
import se.ericsson.cello.csnotification.NotificationReporter;
import se.ericsson.cello.moframework.FilterSyntaxException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.Mib;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoFilter;
import se.ericsson.cello.moframework.MoHasChildrenException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.moframework.MoIteratorImpl;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.MoReferenceHandler;
import se.ericsson.cello.moframework.MoTypeHandler;
import se.ericsson.cello.moframework.ParentAlreadyLockedException;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;

public class MoRepository {
    private Map myAllNodes;
    private boolean myIsResolved = true;
    private MoReferenceHandler myRefHandler;
    private MoTypeHandler myTypeHandler;
    private Map rollbackList = new HashMap();
    private static MoRepository theOneAndOnly;
    private Map lockedMOs = new HashMap();
    private boolean recovery = false;
    static /* synthetic */ Class class$se$ericsson$cello$moframework$MoRepository;

    public static synchronized MoRepository instance() {
        if (theOneAndOnly == null) {
            theOneAndOnly = new MoRepository();
        }
        return theOneAndOnly;
    }

    private MoRepository() {
        this.myAllNodes = new HashMap(89);
        this.myRefHandler = new MoReferenceHandler();
        this.myTypeHandler = new MoTypeHandler();
    }

    public synchronized void setRecoveryPhase(boolean bl) {
        this.recovery = bl;
    }

    synchronized void registerMo(ManagedObject managedObject, Coordinator coordinator) throws MoNameAlreadyTakenException {
        ManagedObject managedObject2 = null;
        String string = managedObject.getLocalDistinguishedName();
        if (this.lookup(string) != null) {
            throw new MoNameAlreadyTakenException(string);
        }
        managedObject2 = this.myAllNodes.put(string, managedObject);
        this.myRefHandler.register(managedObject);
        this.myTypeHandler.register(managedObject);
        ManagedObject managedObject3 = managedObject.getParent();
        if (managedObject3 != null) {
            managedObject3.addChild(managedObject);
        }
        if (coordinator != null) {
            MessageLog.trace((int)5, this.getClass(), (String)("registerMo: " + managedObject.getLocalDistinguishedName() + " hash=" + managedObject.hashCode()));
            new TxResource(coordinator, managedObject, true, managedObject2);
        } else {
            managedObject.setCreated(true);
            String string2 = "";
            Mib mib = MibMgr.instance().getMib();
            if (mib != null) {
                string2 = mib.getMibPrefix();
            }
            if (!this.recovery) {
                NotificationReporter.pushMoCreated(managedObject.getLocalDistinguishedName(), string2, managedObject.getType(), managedObject.getId(), null);
            }
        }
    }

    synchronized void deregisterMo(ManagedObject managedObject, Coordinator coordinator) throws MoHasChildrenException, ParentAlreadyLockedException {
        MoIterator moIterator = managedObject.getChildren();
        while (moIterator.hasMoreElements()) {
            ManagedObject managedObject2 = moIterator.nextMo();
            if (managedObject2.isRemoved()) continue;
            throw new MoHasChildrenException(managedObject);
        }
        if (coordinator != null) {
            MessageLog.trace((int)5, this.getClass(), (String)("deregisterMo: " + managedObject.getLocalDistinguishedName() + " hash = " + managedObject.hashCode()));
            this.lockParent(managedObject, coordinator);
            new TxResource(coordinator, managedObject, false, null);
        } else {
            this.removeElement(managedObject);
            if (!this.recovery) {
                NotificationReporter.pushMoDeleted(managedObject.getLocalDistinguishedName(), managedObject.getNamePrefix(), managedObject.getType(), managedObject.getId(), null);
            }
        }
    }

    private synchronized void removeElement(ManagedObject managedObject) {
        if (managedObject == this.myAllNodes.get(managedObject.getLocalDistinguishedName())) {
            this.myAllNodes.remove(managedObject.getLocalDistinguishedName());
        }
        this.myRefHandler.deregister(managedObject);
        this.myTypeHandler.deregister(managedObject);
        ManagedObject managedObject2 = managedObject.getParent();
        if (managedObject2 != null) {
            managedObject2.removeChild(managedObject);
        }
        managedObject.setRemoved(true);
        managedObject.setParent(null);
    }

    public synchronized ManagedObject lookup(String string) {
        ManagedObject managedObject = (ManagedObject)this.myAllNodes.get(string);
        if (managedObject != null && managedObject.isRemoved()) {
            return null;
        }
        return managedObject;
    }

    public synchronized ManagedObject lookup(String string, boolean bl) {
        ManagedObject managedObject = (ManagedObject)this.myAllNodes.get(string);
        if (managedObject != null && managedObject.isRemoved() && !bl) {
            return null;
        }
        return managedObject;
    }

    public synchronized ManagedObject lookup(int n) {
        ManagedObject managedObject = this.myRefHandler.lookup(n);
        if (managedObject != null && managedObject.isRemoved()) {
            return null;
        }
        return managedObject;
    }

    public synchronized MoIterator lookupType(String string) {
        return this.myTypeHandler.lookup(string);
    }

    private boolean tryResolve(ManagedObject managedObject) {
        Assert.cppAssert((!managedObject.isResolved() ? 1 : 0) != 0);
        ManagedObject managedObject2 = this.lookup(MoRepository.calculateParentDistinguishedName(managedObject));
        if (managedObject2 != null) {
            managedObject2.addChild(managedObject);
            managedObject.setParent(managedObject2);
            return true;
        }
        return false;
    }

    public synchronized boolean resolveAllNodes() {
        this.myIsResolved = true;
        Iterator iterator = this.myAllNodes.values().iterator();
        while (iterator.hasNext()) {
            ManagedObject managedObject = (ManagedObject)iterator.next();
            if (managedObject.isResolved() || this.tryResolve(managedObject)) continue;
            MessageLog.traceError((Class)(class$se$ericsson$cello$moframework$MoRepository == null ? MoRepository.class$("se.ericsson.cello.moframework.MoRepository") : class$se$ericsson$cello$moframework$MoRepository), (String)("Failed to resolve " + managedObject.getLocalDistinguishedName()));
            this.myIsResolved = false;
        }
        return this.myIsResolved;
    }

    private static String calculateParentDistinguishedName(ManagedObject managedObject) {
        Assert.cppAssert((!managedObject.isRoot() ? 1 : 0) != 0);
        if (managedObject.getParent() != null) {
            return managedObject.getParent().getLocalDistinguishedName();
        }
        String string = managedObject.getLocalDistinguishedName();
        int n = string.lastIndexOf(",");
        if (n > 0) {
            String string2 = string.substring(0, n);
            return string2;
        }
        Assert.cppAssert((boolean)false, (String)("DN :" + managedObject.getLocalDistinguishedName()));
        return null;
    }

    public MoIterator select(ManagedObject managedObject, int n, MoFilter moFilter) {
        LinkedList linkedList = new LinkedList();
        if (n == -1) {
            n = 100000;
        }
        this.selectRecursive(managedObject, n, 0, moFilter, linkedList);
        return new MoIteratorImpl(linkedList);
    }

    private void selectRecursive(ManagedObject managedObject, int n, int n2, MoFilter moFilter, List list) {
        if (moFilter == null || moFilter.accept(managedObject)) {
            list.add(managedObject);
        }
        if (n > n2) {
            MoIterator moIterator = managedObject.getChildren();
            ++n2;
            while (moIterator.hasMoreElements()) {
                this.selectRecursive(moIterator.nextMo(), n, n2, moFilter, list);
            }
        }
    }

    public MoIterator select(ManagedObject managedObject, int n, Coordinator coordinator, String string, String string2) throws FilterSyntaxException {
        MessageLog.trace((int)5, this.getClass(), (String)("Filter constraint:" + string2));
        LinkedList<ManagedObject> linkedList = new LinkedList<ManagedObject>();
        if (string == null) {
            string = "";
        }
        if (n == -1) {
            n = 100000;
        }
        if (!string.equals("") && (string2 == null || string2.trim().equals(""))) {
            MoIterator moIterator = this.lookupType(string);
            if (moIterator != null) {
                while (moIterator.hasMoreElements()) {
                    ManagedObject managedObject2 = moIterator.nextMo();
                    if (!this.isMoInSubtree(managedObject2, managedObject, n)) continue;
                    linkedList.add(managedObject2);
                }
            }
        } else if (string2 != null && !string2.trim().equals("")) {
            try {
                FilterParser filterParser = new FilterParser(new BufferedReader(new StringReader(string2)));
                FilterPredicate filterPredicate = filterParser.transformToPredicate();
                this.selectRecursive(managedObject, n, 0, coordinator, string, filterPredicate, linkedList);
            }
            catch (ParseException parseException) {
                throw new FilterSyntaxException("Filter Syntax exception: " + parseException);
            }
        } else {
            FilterPredicate filterPredicate = null;
            this.selectRecursive(managedObject, n, 0, coordinator, string, filterPredicate, linkedList);
        }
        return new MoIteratorImpl(linkedList);
    }

    public int getNumberOfRegisteredInstances() {
        return this.myAllNodes.keySet().size();
    }

    private void selectRecursive(ManagedObject managedObject, int n, int n2, Coordinator coordinator, String string, FilterPredicate filterPredicate, List list) throws FilterSyntaxException {
        if (filterPredicate == null) {
            if (string.trim().equals("") || string.trim().equalsIgnoreCase(managedObject.getType())) {
                list.add(managedObject);
            }
        } else {
            try {
                if (filterPredicate.match(string, managedObject, coordinator)) {
                    list.add(managedObject);
                }
            }
            catch (NotAccepted notAccepted) {
                Assert.cppAssert((boolean)false, (String)("NotAccepted: " + notAccepted.toString()));
            }
            catch (NotDefined notDefined) {
                Assert.cppAssert((boolean)false, (String)("NotDefined: " + notDefined.toString()));
            }
        }
        if (n > n2) {
            MoIterator moIterator = managedObject.getChildren();
            ++n2;
            while (moIterator.hasMoreElements()) {
                ManagedObject managedObject2 = moIterator.nextMo();
                this.selectRecursive(managedObject2, n, n2, coordinator, string, filterPredicate, list);
            }
        }
    }

    private void lockParent(ManagedObject managedObject, Coordinator coordinator) throws ParentAlreadyLockedException {
        Assert.cppAssert((Object)managedObject.getParent(), (String)("The MO root can not be removed " + managedObject));
        String string = managedObject.getParent().getLocalDistinguishedName();
        String string2 = managedObject.getLocalDistinguishedName();
        Coordinator coordinator2 = (Coordinator)this.lockedMOs.get(string);
        Coordinator coordinator3 = (Coordinator)this.lockedMOs.get(string2);
        if (coordinator2 != null) {
            if (!coordinator.isSameTransaction(coordinator2)) {
                throw new ParentAlreadyLockedException(managedObject);
            }
        } else if (coordinator3 != null) {
            if (!coordinator.isSameTransaction(coordinator3)) {
                throw new ParentAlreadyLockedException(managedObject);
            }
        } else {
            this.lockedMOs.put(string, coordinator);
        }
    }

    private void unlockParent(ManagedObject managedObject) {
        String string = managedObject.getParent() != null ? managedObject.getParent().getLocalDistinguishedName() : MoRepository.calculateParentDistinguishedName(managedObject);
        this.lockedMOs.remove(string);
    }

    private boolean isMoInSubtree(ManagedObject managedObject, ManagedObject managedObject2, int n) {
        boolean bl = false;
        if (managedObject.getLocalDistinguishedName().startsWith(managedObject2.getLocalDistinguishedName() + ",")) {
            boolean bl2 = true;
            int n2 = 0;
            int n3 = managedObject2.getLocalDistinguishedName().length();
            while (bl2) {
                n3 = managedObject.getLocalDistinguishedName().indexOf(",", n3);
                if (n3 != -1) {
                    ++n2;
                    ++n3;
                    continue;
                }
                if (n >= n2) {
                    bl = true;
                }
                bl2 = false;
            }
        } else if (managedObject.getLocalDistinguishedName().equals(managedObject2.getLocalDistinguishedName())) {
            bl = true;
        }
        return bl;
    }

    private class TxResource
    implements Resource {
        private ManagedObject myNode;
        private boolean myIsNodeAdded;
        private Coordinator myTransaction;

        public TxResource(Coordinator coordinator, ManagedObject managedObject, boolean bl, ManagedObject managedObject2) {
            Assert.cppAssert((Object)coordinator);
            this.myTransaction = coordinator;
            this.myNode = managedObject;
            this.myIsNodeAdded = bl;
            if (!this.myIsNodeAdded) {
                managedObject.setRemoved(true);
            } else {
                this.prepareRollback(this.myNode.getLocalDistinguishedName(), managedObject2);
            }
            try {
                coordinator.registerResource((Resource)this);
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                this.rollback();
            }
        }

        private void prepareRollback(String string, ManagedObject managedObject) {
            if (!MoRepository.this.rollbackList.containsKey(string)) {
                if (managedObject != null) {
                    MoRepository.this.rollbackList.put(string, managedObject);
                } else {
                    MoRepository.this.rollbackList.put(string, new int[0]);
                }
            }
        }

        public void commit() {
            MessageLog.trace((int)5, this.getClass(), (String)("commit added= " + this.myIsNodeAdded + " " + this.myNode.getLocalDistinguishedName() + " hash=" + this.myNode.hashCode()));
            if (this.myIsNodeAdded) {
                NotificationReporter.pushMoCreated(this.myNode.getLocalDistinguishedName(), this.myNode.getNamePrefix(), this.myNode.getType(), this.myNode.getId(), this.myTransaction);
                MoRepository.this.rollbackList.remove(this.myNode.getLocalDistinguishedName());
                this.myNode.setCreated(true);
            } else {
                NotificationReporter.pushMoDeleted(this.myNode.getLocalDistinguishedName(), this.myNode.getNamePrefix(), this.myNode.getType(), this.myNode.getId(), this.myTransaction);
                MoRepository.this.unlockParent(this.myNode);
                MoRepository.this.removeElement(this.myNode);
                this.myNode.setRemoved(true);
            }
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
            MessageLog.trace((int)5, this.getClass(), (String)("rollback added= " + this.myIsNodeAdded + " " + this.myNode.getLocalDistinguishedName() + " hash=" + this.myNode.hashCode()));
            if (this.myIsNodeAdded) {
                MoRepository.this.removeElement(this.myNode);
                this.myNode.setRemoved(true);
                if (MoRepository.this.rollbackList.containsKey(this.myNode.getLocalDistinguishedName())) {
                    Object v = MoRepository.this.rollbackList.get(this.myNode.getLocalDistinguishedName());
                    if (v instanceof ManagedObject) {
                        MessageLog.trace((int)5, this.getClass(), (String)("restore from rollbackList " + ((ManagedObject)v).getLocalDistinguishedName() + " hash=" + v.hashCode()));
                        MessageLog.trace((int)5, this.getClass(), (String)("isRemoved/isCreated=" + ((ManagedObject)v).isRemoved() + "/" + ((ManagedObject)v).isCreated()));
                        MoRepository.this.myAllNodes.put(this.myNode.getLocalDistinguishedName(), (ManagedObject)v);
                    }
                    MoRepository.this.rollbackList.remove(this.myNode.getLocalDistinguishedName());
                }
            } else {
                MoRepository.this.unlockParent(this.myNode);
                this.myNode.setRemoved(false);
            }
        }
    }
}

