/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Vector;
import se.ericsson.cello.moframework.Attribute;
import se.ericsson.cello.moframework.BooleanAttribute;
import se.ericsson.cello.moframework.FloatAttribute;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.LongAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.ReferenceAttribute;
import se.ericsson.cello.moframework.SequenceDiffInfo;
import se.ericsson.cello.moframework.StringAttribute;
import se.ericsson.cello.moframework.StringRepository;
import se.ericsson.cello.moframework.StructAttribute;
import se.ericsson.cello.moframework.stringhandlers.SequenceStringHandler;
import se.ericsson.cello.recovery.AttributeLookUp;
import se.ericsson.cello.recovery.AttributeLookupFactory;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.transaction.Coordinator;

public class SequenceAttribute
extends Attribute
implements Serializable {
    static final long serialVersionUID = 8501275921934577630L;
    private Vector myValue;
    private transient Vector myValueBackup = null;
    private transient Class myElementClass = null;
    private transient boolean isModified = false;

    public SequenceAttribute(String string, boolean bl) {
        super(string, bl);
        this.myValue = new Vector();
    }

    public SequenceAttribute(String string, String string2) {
        super(string, string2.charAt(1));
        AttributeLookUp attributeLookUp = AttributeLookupFactory.instance();
        StringRepository.instance();
        this.myValue = new Vector();
        SequenceStringHandler sequenceStringHandler = new SequenceStringHandler(string2.substring(2));
        int n = Integer.parseInt(sequenceStringHandler.nextSubstring());
        String string3 = sequenceStringHandler.nextSubstring();
        for (int i = 0; i < n; ++i) {
            String string4;
            char c;
            if (!string3.equalsIgnoreCase("")) {
                string3 = attributeLookUp.lookup(Integer.parseInt(string3));
            }
            if ((c = (string4 = StringRepository.fixString(sequenceStringHandler.nextSubstring())).charAt(0)) == 's') {
                this.addElement(new StringAttribute(string3, string4));
            } else if (c == 'i') {
                this.addElement(new IntegerAttribute(string3, string4));
            } else if (c == 'l') {
                this.addElement(new LongAttribute(string3, string4));
            } else if (c == 'b') {
                this.addElement(new BooleanAttribute(string3, string4));
            } else if (c == 'f') {
                this.addElement(new FloatAttribute(string3, string4));
            } else if (c == 'r') {
                this.addElement(new ReferenceAttribute(string3, string4));
            } else if (c == 't') {
                this.addElement(new StructAttribute(string3, string4));
            }
            string3 = StringRepository.fixString(sequenceStringHandler.nextSubstring());
        }
    }

    public synchronized Attribute[] getValue(Coordinator coordinator) {
        if (coordinator == null && this.myValueBackup != null) {
            Object[] objectArray = new Attribute[this.myValueBackup.size()];
            this.myValueBackup.copyInto(objectArray);
            return objectArray;
        }
        Object[] objectArray = new Attribute[this.myValue.size()];
        this.myValue.copyInto(objectArray);
        return objectArray;
    }

    public synchronized void setValue(Attribute[] attributeArray) {
        Assert.cppAssert((Object)attributeArray);
        this.myValue.removeAllElements();
        for (int i = 0; i < attributeArray.length; ++i) {
            this.myValue.addElement(attributeArray[i]);
        }
        if (this.myValueBackup != null && (this.myValueBackup.size() != 0 || attributeArray.length != 0)) {
            this.isModified = true;
        }
        this.determineArrayType();
    }

    public void setNotificationType(int n) {
        if (this.myNotificationType == 0) {
            return;
        }
        if (n == 3) {
            this.myNotificationType = n;
        } else {
            super.setNotificationType(n);
        }
    }

    public synchronized void addElement(Attribute attribute) {
        Assert.cppAssert((Object)attribute, (String)("Element in SequenceAttribute: " + this.getName() + " is null."));
        this.myValue.addElement(attribute);
        if (this.myValueBackup != null) {
            this.isModified = true;
        }
        this.determineArrayType();
    }

    public synchronized boolean removeElement(Attribute attribute) {
        if (this.myValueBackup != null) {
            this.isModified = true;
        }
        return this.myValue.removeElement(attribute);
    }

    public synchronized boolean isEmpty() {
        return this.myValue.isEmpty();
    }

    public synchronized Enumeration elements() {
        return this.myValue.elements();
    }

    public synchronized int size() {
        return this.myValue.size();
    }

    synchronized void startTransaction() {
        this.myValueBackup = (Vector)this.myValue.clone();
        Enumeration enumeration = this.myValue.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            attribute.startTransaction();
        }
    }

    synchronized void commit() {
        this.myValueBackup = null;
        this.isModified = false;
        Enumeration enumeration = this.myValue.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            attribute.commit();
        }
    }

    synchronized void rollback() {
        this.myValue = this.myValueBackup;
        this.myValueBackup = null;
        this.isModified = false;
        if (this.myValue == null) {
            this.myValue = new Vector();
        }
        Enumeration enumeration = this.myValue.elements();
        while (enumeration.hasMoreElements()) {
            Attribute attribute = (Attribute)enumeration.nextElement();
            attribute.rollback();
        }
    }

    public SequenceDiffInfo getSequenceDiffInfo(Coordinator coordinator) {
        Attribute attribute;
        boolean bl;
        int n;
        SequenceDiffInfo sequenceDiffInfo = new SequenceDiffInfo(this.getValueAsObject(coordinator));
        if (this.myValueBackup == null) {
            return sequenceDiffInfo;
        }
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (n = 0; n < this.myValueBackup.size(); ++n) {
            bl = false;
            attribute = (Attribute)this.myValueBackup.get(n);
            try {
                for (int i = 0; i < this.myValue.size(); ++i) {
                    if (hashSet.contains(new Integer(i)) || !attribute.equal((Attribute)this.myValue.get(i), coordinator)) continue;
                    bl = true;
                    hashSet.add(new Integer(i));
                    break;
                }
                if (bl) continue;
                sequenceDiffInfo.addRemoved(attribute.getBackUpValueAsObject(coordinator));
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                sequenceDiffInfo.addRemoved(attribute.getBackUpValueAsObject(coordinator));
            }
        }
        for (n = 0; n < this.myValue.size(); ++n) {
            bl = false;
            if (hashSet.contains(new Integer(n))) continue;
            attribute = (Attribute)this.myValue.get(n);
            try {
                for (int i = 0; i < this.myValueBackup.size(); ++i) {
                    if (!attribute.equal((Attribute)this.myValueBackup.get(i), coordinator)) continue;
                    bl = true;
                    break;
                }
                if (bl) continue;
                sequenceDiffInfo.addAdded(attribute.getValueAsObject(coordinator));
                continue;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                sequenceDiffInfo.addAdded(attribute.getValueAsObject(coordinator));
            }
        }
        return sequenceDiffInfo;
    }

    Object getValueAsObject(Coordinator coordinator) {
        Object[] objectArray = null;
        if (this.myElementClass != null) {
            objectArray = (Object[])Array.newInstance(this.myElementClass, this.myValue.size());
            for (int i = 0; i < this.myValue.size(); ++i) {
                Object object;
                Attribute attribute = (Attribute)this.myValue.elementAt(i);
                objectArray[i] = object = attribute.getValueAsObject(coordinator);
            }
        }
        return objectArray;
    }

    boolean isModified() {
        return this.isModified;
    }

    private void determineArrayType() {
        if (this.myElementClass == null) {
            if (this.myValue.size() != 0) {
                Attribute attribute = (Attribute)this.myValue.elementAt(0);
                Object object = attribute.getValueAsObject(null);
                if (object == null) {
                    this.myElementClass = ManagedObject.class;
                } else {
                    this.myElementClass = object.getClass();
                    if (object instanceof ManagedObject) {
                        this.myElementClass = ManagedObject.class;
                    }
                }
            } else if (this.myValueBackup != null && this.myValueBackup.size() != 0) {
                Attribute attribute = (Attribute)this.myValueBackup.elementAt(0);
                Object object = attribute.getValueAsObject(null);
                if (object == null) {
                    this.myElementClass = ManagedObject.class;
                } else {
                    this.myElementClass = object.getClass();
                    if (object instanceof ManagedObject) {
                        this.myElementClass = ManagedObject.class;
                    }
                }
            }
        }
    }

    public String buildString() {
        AttributeLookUp attributeLookUp = AttributeLookupFactory.instance();
        String string = this.getName();
        if (!string.equalsIgnoreCase("")) {
            string = "" + attributeLookUp.lookup(string);
        }
        return string + this.buildValueString();
    }

    String buildValueString() {
        StringBuffer stringBuffer = new StringBuffer(64);
        if (this.getNotificationType() != 0) {
            stringBuffer.append("T");
        } else {
            stringBuffer.append("F");
        }
        stringBuffer.append(this.size());
        stringBuffer.append("|");
        for (int i = 0; i < this.myValue.size(); ++i) {
            Attribute attribute = (Attribute)this.myValue.elementAt(i);
            stringBuffer.append(attribute.buildValueString());
            stringBuffer.append("|");
        }
        return "^q" + stringBuffer.toString().replace('^', '|');
    }
}

