/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.moframework.internal;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import se.ericsson.cello.csnotification.NotificationReporter;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.NotificationSender;
import se.ericsson.cello.moframework.SequenceDiffInfo;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;

public class NotificationCollector
implements Resource {
    private Map moAttributeMap = new HashMap();
    private Coordinator currentTransaction;
    private NotificationSender notificationSender;

    public NotificationCollector(Coordinator coordinator, NotificationSender notificationSender) {
        this.currentTransaction = coordinator;
        this.notificationSender = notificationSender;
        try {
            this.currentTransaction.registerResource((Resource)this);
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            MessageLog.traceError(this.getClass(), (String)"InactiveTransactionException: ", (Throwable)inactiveTransactionException);
        }
    }

    public void collect(ManagedObject managedObject, String[] stringArray, Object[] objectArray) {
        Attributes attributes = (Attributes)this.moAttributeMap.get(managedObject);
        if (attributes == null) {
            attributes = new Attributes();
            this.moAttributeMap.put(managedObject, attributes);
        }
        if (objectArray instanceof SequenceDiffInfo[]) {
            attributes.addSequenceDeltaAttributes(stringArray, (SequenceDiffInfo[])objectArray);
        } else {
            attributes.addAVCAttributes(stringArray, objectArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() {
        try {
            this.pushNotification();
        }
        catch (Exception exception) {
            MessageLog.info((Class)NotificationCollector.class, (String)("No notification was pushed " + exception.toString()));
        }
        finally {
            this.moAttributeMap.clear();
            this.notificationSender.deregisterCollector(this.currentTransaction);
        }
    }

    public boolean prepare() {
        return true;
    }

    public void rollback() {
        this.moAttributeMap.clear();
        this.notificationSender.deregisterCollector(this.currentTransaction);
    }

    private void pushNotification() {
        Iterator iterator = this.moAttributeMap.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            ManagedObject managedObject = (ManagedObject)entry.getKey();
            Attributes attributes = (Attributes)this.moAttributeMap.get(managedObject);
            this.pushAVCNotification(managedObject, attributes);
            this.pushSequenceDeltaNotification(managedObject, attributes);
        }
    }

    private void pushSequenceDeltaNotification(ManagedObject managedObject, Attributes attributes) {
        Map map = attributes.getSequenceDeltaAttributes();
        int n = map.size();
        if (n > 0) {
            String[] stringArray = map.keySet().toArray(new String[n]);
            SequenceDiffInfo[] sequenceDiffInfoArray = map.values().toArray(new SequenceDiffInfo[n]);
            NotificationReporter.pushSequenceDeltaNotification(managedObject.getLocalDistinguishedName(), MibMgr.instance().getMib().getMibPrefix(), managedObject.getType(), managedObject.getId(), stringArray, sequenceDiffInfoArray, this.currentTransaction);
        }
    }

    private void pushAVCNotification(ManagedObject managedObject, Attributes attributes) {
        Map map = attributes.getAVCAttributes();
        if (map.size() > 0) {
            String[] stringArray = map.keySet().toArray(new String[map.size()]);
            Object[] objectArray = map.values().toArray(new Object[map.size()]);
            MessageLog.trace((int)5, this.getClass(), (String)("AVC Notification reporting " + stringArray.length + " changed attributes for " + managedObject.getLocalDistinguishedName()));
            NotificationReporter.pushAVC(managedObject.getLocalDistinguishedName(), MibMgr.instance().getMib().getMibPrefix(), managedObject.getType(), managedObject.getId(), stringArray, objectArray, this.currentTransaction);
        }
    }

    public Map getAVCAttributes(ManagedObject managedObject) {
        Attributes attributes = (Attributes)this.moAttributeMap.get(managedObject);
        return attributes.getAVCAttributes();
    }

    private static class Attributes {
        private Map attributesAVCMap = new HashMap();
        private Map attributeNameSequenceDeltaInfo = new HashMap();

        public Map getSequenceDeltaAttributes() {
            return this.attributeNameSequenceDeltaInfo;
        }

        public void addSequenceDeltaAttributes(String[] stringArray, SequenceDiffInfo[] sequenceDiffInfoArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.attributeNameSequenceDeltaInfo.put(stringArray[i], sequenceDiffInfoArray[i]);
            }
        }

        public void addAVCAttributes(String[] stringArray, Object[] objectArray) {
            for (int i = 0; i < stringArray.length; ++i) {
                this.attributesAVCMap.put(stringArray[i], objectArray[i]);
            }
        }

        public Map getAVCAttributes() {
            return this.attributesAVCMap;
        }
    }
}

