/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.notification;

import CelloNotificationIRPExtension.SpecificProblemMOPair;
import java.io.Serializable;
import se.ericsson.cello.moframework.MibMgr;

public class Filter
implements Serializable {
    private short severity;
    private String[] specProblemList;
    private SpecProblemMOPair[] specProblemMOPairList;
    private static final int FILTER_LIMIT = 10;
    static final long serialVersionUID = 1L;

    public Filter(CelloNotificationIRPExtension.Filter filter) throws EmptyFilterException, FilterSizeException, FilterSeverityException {
        this.checkIfEmpty(filter.severity, filter.spec_problem_list, filter.spec_problem_mo_pair_list);
        this.checkSeverity(filter.severity);
        this.checkSize(filter.spec_problem_list, filter.spec_problem_mo_pair_list);
        this.severity = filter.severity;
        this.specProblemList = filter.spec_problem_list;
        this.specProblemMOPairList = new SpecProblemMOPair[filter.spec_problem_mo_pair_list.length];
        for (int i = 0; i < this.specProblemMOPairList.length; ++i) {
            this.specProblemMOPairList[i] = new SpecProblemMOPair(filter.spec_problem_mo_pair_list[i].specific_problem, this.getLDN(filter.spec_problem_mo_pair_list[i].mo_name));
        }
    }

    public short getSeverity() {
        return this.severity;
    }

    public String[] getSpecficProblem() {
        return this.specProblemList;
    }

    public SpecificProblemMOPair[] getSpecificProblemMOPair() {
        SpecificProblemMOPair[] specificProblemMOPairArray = new SpecificProblemMOPair[this.specProblemMOPairList.length];
        for (int i = 0; i < this.specProblemMOPairList.length; ++i) {
            specificProblemMOPairArray[i] = new SpecificProblemMOPair(this.specProblemMOPairList[i].getSpecProblem(), this.specProblemMOPairList[i].getMoLdn());
        }
        return specificProblemMOPairArray;
    }

    public boolean match(short s, String string, String string2) {
        int n;
        if (this.severity != 0 && this.severity <= s) {
            return true;
        }
        for (n = 0; n < this.specProblemList.length; ++n) {
            if (!string.equals(this.specProblemList[n])) continue;
            return true;
        }
        for (n = 0; n < this.specProblemMOPairList.length; ++n) {
            if (!string.equals(this.specProblemMOPairList[n].getSpecProblem()) || !string2.equals(this.specProblemMOPairList[n].getMoLdn())) continue;
            return true;
        }
        return false;
    }

    private void checkIfEmpty(short s, String[] stringArray, SpecificProblemMOPair[] specificProblemMOPairArray) throws EmptyFilterException {
        if (s == 0 && stringArray.length == 0 && specificProblemMOPairArray.length == 0) {
            throw new EmptyFilterException();
        }
    }

    private void checkSize(String[] stringArray, SpecificProblemMOPair[] specificProblemMOPairArray) throws FilterSizeException {
        if (stringArray.length > 10 || specificProblemMOPairArray.length > 10) {
            throw new FilterSizeException();
        }
    }

    private void checkSeverity(short s) throws FilterSeverityException {
        if (s < 0 || s > 5) {
            throw new FilterSeverityException();
        }
    }

    private String getLDN(String string) {
        String string2 = MibMgr.instance().getMib().getRootMo().getLocalDistinguishedName();
        String string3 = string;
        int n = string.indexOf(string2);
        if (n != -1) {
            string3 = string.substring(n);
        }
        return string3;
    }

    private final class SpecProblemMOPair
    implements Serializable {
        static final long serialVersionUID = 1L;
        private String specProblem;
        private String moLDN;

        private SpecProblemMOPair(String string, String string2) {
            this.specProblem = string;
            this.moLDN = string2;
        }

        String getSpecProblem() {
            return this.specProblem;
        }

        String getMoLdn() {
            return this.moLDN;
        }
    }

    public class EmptyFilterException
    extends Exception {
        EmptyFilterException() {
        }
    }

    public class FilterSeverityException
    extends Exception {
        FilterSeverityException() {
        }
    }

    public class FilterSizeException
    extends Exception {
        FilterSizeException() {
        }
    }
}

