/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.pms.generic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedList;
import se.ericsson.cello.persistence.DbAccessException;
import se.ericsson.cello.persistence.DbWrapper;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.MonitoringTask;
import se.ericsson.cello.pms.generic.MonitoringTaskInfo;
import se.ericsson.cello.pms.generic.MonitoringTaskMgr;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.pms.generic.ScannerId;
import se.ericsson.cello.pms.generic.TransactionHelper;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;

class ScannerPersistence {
    private static ScannerPersistence theInstance = new ScannerPersistence();
    private static final String TABLE_NAME = "scannerdata";
    private static final int MAX_SIZE_SCANNER_INFO = 1000000;
    private DbWrapper database = null;
    static final int ACTIVE = 1;
    static final int SUSPENDED = 0;
    static final int SYSTEM_SUSPENDED = 2;

    private ScannerPersistence() {
        try {
            this.database = new DbWrapper(TABLE_NAME);
        }
        catch (DbAccessException dbAccessException) {
            MessageLog.traceError((Class)ScannerPersistence.class, (String)"Cannot create a new DbWrapper in ScannerPersistence constructor.", (Throwable)dbAccessException);
            throw new RuntimeException("Cannot create a new DbWrapper in ScannerPersistence constructor due to " + dbAccessException.toString());
        }
    }

    boolean insert(int n, Object object, Coordinator coordinator) throws OverloadException {
        try {
            this.database.createRow(coordinator.getTransactionID(), n);
        }
        catch (DbAccessException dbAccessException) {
            MessageLog.traceError((Class)ScannerPersistence.class, (String)"Storing performance monitoring information in database failed.", (Throwable)dbAccessException);
            return false;
        }
        return this.update(n, object, coordinator);
    }

    boolean update(int n, Object object, Coordinator coordinator) throws OverloadException {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(this.createDBRecord(((MonitoringTask)object).getTaskInfo()));
            this.database.updateRow(coordinator.getTransactionID(), n, byteArrayOutputStream.toByteArray());
        }
        catch (OverloadException overloadException) {
            throw overloadException;
        }
        catch (Exception exception) {
            MessageLog.traceError((Class)ScannerPersistence.class, (String)"Storing performance monitoring information in database failed.", (Throwable)exception);
            return false;
        }
        return true;
    }

    boolean remove(int n, Coordinator coordinator) {
        try {
            this.database.deleteRow(coordinator.getTransactionID(), n);
        }
        catch (DbAccessException dbAccessException) {
            MessageLog.traceError((Class)ScannerPersistence.class, (String)"Deleting performance monitoring information from database failed.", (Throwable)dbAccessException);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    boolean loadScanners() {
        byte[] byArray = null;
        ObjectInputStream objectInputStream = null;
        LinkedList linkedList = new LinkedList();
        try {
            int n;
            this.database.connectToDatabase();
            int[] nArray = this.database.retrieveAllPrimaryKeys();
            for (n = 0; n < nArray.length; ++n) {
                byArray = this.database.retrieveRow(nArray[n]);
                objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byArray));
                String string = (String)objectInputStream.readObject();
                this.init(string, linkedList);
            }
            if (linkedList.size() > 0) {
                Control control = null;
                control = TransactionHelper.create();
                for (int i = 0; i < linkedList.size(); ++i) {
                    int n2 = (Integer)linkedList.get(i);
                    this.remove(n2, control.getCoordinator());
                    MessageLog.info(this.getClass(), (String)("Performance monitoring (id " + n2 + ") deleted due to recovery failure."));
                }
                TransactionHelper.commit(control);
            }
            n = 1;
            return n != 0;
        }
        catch (DbAccessException dbAccessException) {
            MessageLog.traceError((Class)ScannerPersistence.class, (String)"Load scanners failed", (Throwable)dbAccessException);
            boolean bl = false;
            return bl;
        }
        catch (IOException iOException) {
            MessageLog.traceError((Class)ScannerPersistence.class, (String)"Deserialization failed when reading performance monitoring information from DB.", (Throwable)iOException);
            boolean bl = false;
            return bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            MessageLog.traceError((Class)ScannerPersistence.class, (String)"Deserialization failed when reading performance monitoring information from DB.", (Throwable)classNotFoundException);
            boolean bl = false;
            return bl;
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            try {
                this.database.disconnectFromDatabase();
            }
            catch (DbAccessException dbAccessException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getHighestPrimaryKey() {
        try {
            this.database.connectToDatabase();
            int[] nArray = this.database.retrieveAllPrimaryKeys();
            int n = ScannerPersistence.max(nArray);
            return n;
        }
        catch (DbAccessException dbAccessException) {
            MessageLog.traceError((Class)ScannerPersistence.class, (String)"Failed retrieving the highest primary key.", (Throwable)dbAccessException);
            int n = 0;
            return n;
        }
        finally {
            try {
                this.database.disconnectFromDatabase();
            }
            catch (DbAccessException dbAccessException) {}
        }
    }

    private static int max(int[] nArray) {
        if (nArray.length == 0) {
            return 0;
        }
        int n = nArray[0];
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] <= n) continue;
            n = nArray[i];
        }
        return n;
    }

    private void init(String string, LinkedList linkedList) {
        MonitoringTaskInfo monitoringTaskInfo = this.createMonitoringTaskInfo(string);
        if (monitoringTaskInfo == null) {
            MessageLog.info(this.getClass(), (String)"Error when loading performance monitoring.");
            return;
        }
        try {
            MonitoringTaskMgr.instance().recoverMonitoringTask(monitoringTaskInfo);
        }
        catch (MonitoringTaskMgr.RecoveryException recoveryException) {
            linkedList.add(new Integer(monitoringTaskInfo.getId().intValue()));
        }
    }

    private MonitoringTaskInfo createMonitoringTaskInfo(String string) {
        MonitoringStringHandler monitoringStringHandler = new MonitoringStringHandler(string);
        try {
            int n;
            ObservationObject[] observationObjectArray;
            int n2;
            PerformanceMonitoringState performanceMonitoringState;
            ScannerId scannerId = new ScannerId(Integer.parseInt(monitoringStringHandler.nextSubstring()));
            String string2 = monitoringStringHandler.nextSubstring();
            boolean bl = false;
            switch (Integer.parseInt(monitoringStringHandler.nextSubstring())) {
                case 1: {
                    performanceMonitoringState = PerformanceMonitoringState.ACTIVE;
                    MessageLog.trace((int)8, this.getClass(), (String)("DB state is active (" + scannerId + ")"));
                    break;
                }
                case 2: {
                    bl = true;
                    MessageLog.trace((int)8, this.getClass(), (String)("DB state is suspended due to upgrade (" + scannerId + ")"));
                }
                default: {
                    performanceMonitoringState = PerformanceMonitoringState.SUSPENDED;
                    MessageLog.trace((int)8, this.getClass(), (String)("DB state is suspended (" + scannerId + ")"));
                }
            }
            GranularityPeriod granularityPeriod = GranularityPeriod.convertFromSeconds(Integer.parseInt(monitoringStringHandler.nextSubstring()));
            int n3 = Integer.parseInt(monitoringStringHandler.nextSubstring());
            ObservationClass[] observationClassArray = new ObservationClass[n3];
            for (n2 = 0; n2 < n3; ++n2) {
                observationObjectArray = monitoringStringHandler.nextSubstring();
                n = Integer.parseInt(monitoringStringHandler.nextSubstring());
                String[] stringArray = new String[n];
                for (int i = 0; i < n; ++i) {
                    stringArray[i] = monitoringStringHandler.nextSubstring();
                }
                observationClassArray[n2] = new ObservationClass((String)observationObjectArray, stringArray);
            }
            n2 = Integer.parseInt(monitoringStringHandler.nextSubstring());
            observationObjectArray = new ObservationObject[n2];
            for (n = 0; n < n2; ++n) {
                int n4;
                int n5 = Integer.parseInt(monitoringStringHandler.nextSubstring());
                String[] stringArray = new String[n5];
                for (n4 = 0; n4 < n5; ++n4) {
                    stringArray[n4] = monitoringStringHandler.nextSubstring();
                }
                n4 = Integer.parseInt(monitoringStringHandler.nextSubstring());
                String[] stringArray2 = new String[n4];
                for (int i = 0; i < n4; ++i) {
                    stringArray2[i] = monitoringStringHandler.nextSubstring();
                }
                observationObjectArray[n] = new ObservationObject(stringArray2, stringArray);
            }
            return new MonitoringTaskInfo(scannerId, string2, performanceMonitoringState, observationClassArray, observationObjectArray, granularityPeriod, granularityPeriod, bl);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String createDBRecord(MonitoringTaskInfo monitoringTaskInfo) throws OverloadException {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(monitoringTaskInfo.getId().intValue());
        stringBuffer.append("^" + monitoringTaskInfo.getName());
        stringBuffer.append("^");
        if (monitoringTaskInfo.getState().value() == 0) {
            stringBuffer.append(1);
        } else if (monitoringTaskInfo.isSystemSuspended()) {
            stringBuffer.append(2);
        } else {
            stringBuffer.append(0);
        }
        stringBuffer.append("^" + monitoringTaskInfo.getGranularityPeriodInSeconds());
        ObservationClass[] observationClassArray = monitoringTaskInfo.getObservationClassList();
        stringBuffer.append("^" + observationClassArray.length);
        for (int i = 0; i < observationClassArray.length; ++i) {
            stringBuffer.append("^" + observationClassArray[i].object_class_name);
            stringBuffer.append("^" + observationClassArray[i].class_attribute_list.length);
            for (n = 0; n < observationClassArray[i].class_attribute_list.length; ++n) {
                stringBuffer.append("^" + observationClassArray[i].class_attribute_list[n]);
            }
        }
        ObservationObject[] observationObjectArray = monitoringTaskInfo.getObservationObjectList();
        stringBuffer.append("^" + observationObjectArray.length);
        for (n = 0; n < observationObjectArray.length; ++n) {
            int n2;
            stringBuffer.append("^" + observationObjectArray[n].instance_attribute_list.length);
            for (n2 = 0; n2 < observationObjectArray[n].instance_attribute_list.length; ++n2) {
                stringBuffer.append("^" + observationObjectArray[n].instance_attribute_list[n2]);
            }
            stringBuffer.append("^" + observationObjectArray[n].instance_list.length);
            for (n2 = 0; n2 < observationObjectArray[n].instance_list.length; ++n2) {
                stringBuffer.append("^" + observationObjectArray[n].instance_list[n2]);
            }
        }
        String string = stringBuffer.toString();
        if (string.getBytes().length > 1000000) {
            MessageLog.info(this.getClass(), (String)"The Performance Monitoring info has exceeded its maximium size for database storage.");
            throw new OverloadException();
        }
        return string;
    }

    static ScannerPersistence instance() {
        return theInstance;
    }

    private class MonitoringStringHandler {
        private String str;
        private int index = 0;
        private boolean eos = false;

        MonitoringStringHandler(String string) {
            this.str = string;
        }

        public String nextSubstring() {
            if (this.eos) {
                return null;
            }
            int n = this.str.indexOf(94, this.index) + 1;
            if (n == 0) {
                this.eos = true;
                return this.str.substring(this.index);
            }
            int n2 = this.index;
            this.index = n;
            if (n2 == this.index - 1) {
                return "";
            }
            return this.str.substring(n2, this.index - 1);
        }
    }
}

