/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.cello.recovery;

import java.util.Enumeration;
import java.util.Hashtable;
import se.ericsson.cello.mopersistence.MoAttributeStorage;
import se.ericsson.cello.persistence.DbAccessException;
import se.ericsson.cello.recovery.AttributeLookUp;
import se.ericsson.cello.support.debug.Assert;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Control;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.TransactionRolledBackException;
import se.ericsson.cello.transaction.TransactionServiceImpl;

public class AttributeLookupImpl
implements AttributeLookUp {
    private int nextKey;
    boolean isCleaned = false;
    private Hashtable keyFromName = new Hashtable();
    private Hashtable nameFromKey = new Hashtable();
    private Hashtable keysToRemove = null;

    public synchronized void clean() {
        if (this.keysToRemove.size() > 0) {
            try {
                Control control = AttributeLookupImpl.createTransaction();
                MoAttributeStorage moAttributeStorage = MoAttributeStorage.instance();
                Enumeration enumeration = this.keysToRemove.keys();
                while (enumeration.hasMoreElements()) {
                    int n = (Integer)enumeration.nextElement();
                    moAttributeStorage.deleteRow(control.getCoordinator().getTransactionID(), n);
                    this.keyFromName.remove(this.nameFromKey.get(new Integer(n)));
                    this.nameFromKey.remove(new Integer(n));
                }
                control.getTerminator().commit();
            }
            catch (DbAccessException dbAccessException) {
                Assert.cppAssert((boolean)false, (String)("MoAttributeLookup clean() exception :" + (Object)((Object)dbAccessException)));
            }
            catch (TransactionRolledBackException transactionRolledBackException) {
                Assert.cppAssert((boolean)false, (String)("MoAttributeLookup clean() exception :" + (Object)((Object)transactionRolledBackException)));
            }
            catch (InactiveTransactionException inactiveTransactionException) {
                Assert.cppAssert((boolean)false, (String)("MoAttributeLookup clean() exception :" + (Object)((Object)inactiveTransactionException)));
            }
        }
        this.isCleaned = true;
        this.keysToRemove = null;
    }

    public synchronized String lookup(int n) {
        String string = (String)this.nameFromKey.get(new Integer(n));
        Assert.cppAssert((Object)string, (String)"MoAttributeLookup.lookup moAttribute");
        if (!this.isCleaned) {
            this.keysToRemove.remove(new Integer(n));
        }
        return string;
    }

    public synchronized int lookup(String string) {
        Assert.cppAssert((Object)string, (String)"MoAttributeLookup.lookup moAttributeName");
        Integer n = (Integer)this.keyFromName.get(string);
        if (n != null) {
            if (!this.isCleaned && this.keysToRemove != null) {
                this.keysToRemove.remove(n);
            }
            return n;
        }
        int n2 = this.createNewEntry(string);
        this.keyFromName.put(string, new Integer(n2));
        this.nameFromKey.put(new Integer(n2), string);
        return n2;
    }

    protected AttributeLookupImpl() {
        MoAttributeStorage moAttributeStorage = null;
        int[] nArray = null;
        try {
            moAttributeStorage = MoAttributeStorage.instance();
            moAttributeStorage.connectToDatabase();
            nArray = moAttributeStorage.retrieveAllPrimaryKeys();
            for (int i = 0; i < nArray.length; ++i) {
                String string = moAttributeStorage.retrieveRow(nArray[i]);
                this.keyFromName.put(string, new Integer(nArray[i]));
                this.nameFromKey.put(new Integer(nArray[i]), string);
                if (this.nextKey >= nArray[i]) continue;
                this.nextKey = nArray[i];
            }
            moAttributeStorage.disconnectFromDatabase();
            this.keysToRemove = (Hashtable)this.nameFromKey.clone();
        }
        catch (DbAccessException dbAccessException) {
            Assert.cppAssert((boolean)false, (String)("MoAttributeLookup MoAttributeLookup() exception :" + (Object)((Object)dbAccessException)));
        }
    }

    private int createNewEntry(String string) {
        int n = ++this.nextKey;
        try {
            Control control = AttributeLookupImpl.createTransaction();
            MoAttributeStorage moAttributeStorage = MoAttributeStorage.instance();
            moAttributeStorage.createRow(control.getCoordinator().getTransactionID(), n, string);
            control.getTerminator().commit();
        }
        catch (DbAccessException dbAccessException) {
            Assert.cppAssert((boolean)false, (String)("MoAttributeLookup createNewEntry() exception :" + (Object)((Object)dbAccessException)));
        }
        catch (TransactionRolledBackException transactionRolledBackException) {
            Assert.cppAssert((boolean)false, (String)("MoAttributeLookup createNewEntry() exception :" + (Object)((Object)transactionRolledBackException)));
        }
        catch (InactiveTransactionException inactiveTransactionException) {
            Assert.cppAssert((boolean)false, (String)("MoAttributeLookup createNewEntry() exception :" + (Object)((Object)inactiveTransactionException)));
        }
        return n;
    }

    private static Control createTransaction() throws TransactionRolledBackException, InactiveTransactionException {
        Control control = TransactionServiceImpl.instance().getTransactionFactory().create(600);
        Coordinator coordinator = control.getCoordinator();
        MessageLog.trace((int)5, (Class)AttributeLookupImpl.class, (String)("Cello_OMS txId = " + coordinator.getTransactionID() + ", timeout = 600 sec"));
        return control;
    }
}

